package tracking

import (
	"analytics/clickConnect"
	"context"
	"fmt"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Data_bkt_viewImp struct {
	Date_time          proto.ColDateTime
	Request_id         proto.ColUUID
	Publisher_id       proto.ColUUID
	Adunit_id          proto.ColUUID
	Provider_id        proto.ColUUID
	Adsource_id        proto.ColUUID
	Tag_temp_id        proto.ColUUID
	Tag_id             proto.ColUUID
	Provider_src_id    proto.ColUUID
	Viewable_imp_count proto.ColInt8
}

func Viewable_insert(Client *ch.Client, viewable_imp *Data_bkt_viewImp) error {

	ctx := context.Background()

	input := proto.Input{
		{Name: "date_time", Data: viewable_imp.Date_time},
		{Name: "request_id", Data: &viewable_imp.Request_id},
		{Name: "publisher_id", Data: &viewable_imp.Publisher_id},
		{Name: "adunit_id", Data: &viewable_imp.Adunit_id},
		{Name: "provider_id", Data: &viewable_imp.Provider_id},
		{Name: "adsource_id", Data: &viewable_imp.Adsource_id},
		{Name: "tag_temp_id", Data: &viewable_imp.Tag_temp_id},
		{Name: "tag_id", Data: &viewable_imp.Tag_id},
		{Name: "provider_src_id", Data: &viewable_imp.Provider_src_id},
		{Name: "view_count", Data: &viewable_imp.Viewable_imp_count},
	}

	Client = clickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("am_data_bkt_v"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		fmt.Println(err4)
	}

	return nil
}
