package tracking

import (
	"analytics/clickConnect"
	"context"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

// table name in ch
type Data_bkt_events struct {
	Date_time       proto.ColDateTime
	Request_id      proto.ColUUID
	Publisher_id    proto.ColUUID
	Adunit_id       proto.ColUUID
	Provider_id     proto.ColUUID
	Adsource_id     proto.ColUUID
	Tag_temp_id     proto.ColUUID
	Tag_id          proto.ColUUID
	Provider_src_id proto.ColUUID
	Start           proto.ColUInt32
	FivesView       proto.ColUInt32
	FirstQuartile   proto.ColUInt32
	MidPoint        proto.ColUInt32
	ThirdQuartile   proto.ColUInt32
	Complete        proto.ColUInt32
}

func Video_events(conn *ch.Client, Events_Data *Data_bkt_events) error {

	ctx := context.Background()

	input := proto.Input{
		{Name: "date_time", Data: Events_Data.Date_time},
		{Name: "request_id", Data: &Events_Data.Request_id},
		{Name: "publisher_id", Data: &Events_Data.Publisher_id},
		{Name: "adunit_id", Data: &Events_Data.Adunit_id},
		{Name: "provider_id", Data: &Events_Data.Provider_id},
		{Name: "adsource_id", Data: &Events_Data.Adsource_id},
		{Name: "tag_temp_id", Data: &Events_Data.Tag_temp_id},
		{Name: "tag_id", Data: &Events_Data.Tag_id},
		{Name: "provider_src_id", Data: &Events_Data.Provider_src_id},
		{Name: "start", Data: &Events_Data.Start},
		{Name: "5sView", Data: &Events_Data.FivesView},
		{Name: "firstQuartile", Data: &Events_Data.FirstQuartile},
		{Name: "midpoint", Data: &Events_Data.MidPoint},
		{Name: "thirdQuartile", Data: &Events_Data.ThirdQuartile},
		{Name: "complete", Data: &Events_Data.Complete},
	}

	conn = clickConnect.ClickhouseConnection()
	defer conn.Close()
	if err4 := conn.Do(ctx, ch.Query{
		Body:  input.Into("am_data_bkt_event"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		panic(err4)
	}

	return nil
}
