package tracking

import (
	"analytics/clickConnect"
	"context"
	"fmt"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Vast_errors struct {
	Code proto.ColInt32
	Msg  proto.ColStr
}

func Vast_err(Client *ch.Client, err *Vast_errors) error {

	ctx := context.Background()

	input := proto.Input{
		{Name: "code", Data: &err.Code},
		{Name: "msg", Data: &err.Msg},
	}

	Client = clickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("vast_errors"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		fmt.Println(err4)
	}

	return nil
}
