package tracking

import (
	"analytics/clickConnect"
	"context"
	"fmt"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Track_ad_request struct {
	Date_time    proto.ColDateTime
	Request_id   proto.ColUUID
	Adunit_id    proto.ColUUID
	Publisher_id proto.ColUUID
	Tag_temp_id  proto.ColUUID
	Tag_id       proto.ColUUID
	Ip           proto.ColStr
	Domain       proto.ColStr
	Country_code proto.ColStr
	Country_Name proto.ColStr
	Os           proto.ColStr
	Environment  proto.ColInt8
}

func Track_ad_req(Client *ch.Client, ad_req *Track_ad_request) error {

	//fmt.Println("INSIDE am_track_ad_requests_Inserted Tracking calleds ")

	ctx := context.Background()

	input := proto.Input{
		{Name: "date_time", Data: ad_req.Date_time},
		{Name: "request_id", Data: &ad_req.Request_id},
		{Name: "tag_temp_id", Data: &ad_req.Tag_temp_id},
		{Name: "tag_id", Data: &ad_req.Tag_id},
		{Name: "publisher_id", Data: &ad_req.Publisher_id},
		{Name: "adunit_id", Data: &ad_req.Adunit_id},
		{Name: "ip", Data: &ad_req.Ip},
		{Name: "domain", Data: &ad_req.Domain},
		{Name: "country_code", Data: &ad_req.Country_code},
		{Name: "country_name", Data: &ad_req.Country_Name},
		{Name: "os", Data: &ad_req.Os},
		{Name: "environment", Data: &ad_req.Environment},
	}

	Client = clickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("am_track_ad_requests"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {

		fmt.Println(err4)

	}

	// if _, err := conn.NewInsert().Model(&ad_req).Exec(context.Background()); err != nil {
	// 	panic(err)
	// }
	return nil
}
