package tracking

import (
	"analytics/clickConnect"
	"context"
	"fmt"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Rtb_response struct {
	Date_time  proto.ColDateTime
	Request_id proto.ColUUID
	Data       proto.ColStr
}

func Rtb_Res(Client *ch.Client, res *Rtb_response) error {

	ctx := context.Background()

	input := proto.Input{
		{Name: "date_time", Data: res.Date_time},
		{Name: "request_id", Data: &res.Request_id},
		{Name: "data", Data: &res.Data},
	}

	Client = clickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("am_rtb_responses"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		fmt.Println(err4)
	}
	// if _, err := conn.NewInsert().Model(&res).Exec(context.Background()); err != nil {
	// 	panic(err)
	// }
	return nil
}
