package tracking

import (
	"analytics/clickConnect"
	"context"
	"fmt"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Rtb_requests struct {
	// ch.CHModel `ch:"table:am_rtb_requests"`

	Date_time  proto.ColDateTime
	Request_id proto.ColUUID
	Data       proto.ColStr
}

func Rtb_Req(Client *ch.Client, req *Rtb_requests) error {

	ctx := context.Background()

	input := proto.Input{
		{Name: "date_time", Data: req.Date_time},
		{Name: "request_id", Data: &req.Request_id},
		{Name: "data", Data: &req.Data},
	}

	Client = clickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("am_rtb_requests"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		fmt.Println(err4)
	}

	// if _, err := conn.NewInsert().Model(&req).Exec(context.Background()); err != nil {
	// 	panic(err)
	// }
	return nil
}
