package tracking

import (
	"analytics/clickConnect"
	"context"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Data_bkt_m struct {
	Date_time       proto.ColDateTime
	Request_id      proto.ColUUID
	Publisher_id    proto.ColUUID
	Adunit_id       proto.ColUUID
	Provider_id     proto.ColUUID
	Adsource_id     proto.ColUUID
	Tag_temp_id     proto.ColUUID
	Tag_id          proto.ColUUID
	Provider_src_id proto.ColUUID
	Imp_Count       proto.ColInt8
	Won_price       proto.ColFloat64
	Pub_rev         proto.ColFloat64
	Pub_rev_usd     proto.ColFloat64
	Admin_rev       proto.ColFloat64
	Gross_rev       proto.ColFloat64
}

func Imp_insert(Client *ch.Client, imp *Data_bkt_m) error {
	ctx := context.Background()
	input := proto.Input{
		{Name: "date_time", Data: imp.Date_time},
		{Name: "request_id", Data: &imp.Request_id},
		{Name: "publisher_id", Data: &imp.Publisher_id},
		{Name: "adunit_id", Data: &imp.Adunit_id},
		{Name: "provider_id", Data: &imp.Provider_id},
		{Name: "adsource_id", Data: &imp.Adsource_id},
		{Name: "tag_temp_id", Data: &imp.Tag_temp_id},
		{Name: "tag_id", Data: &imp.Tag_id},
		{Name: "provider_src_id", Data: &imp.Provider_src_id},
		{Name: "imp_count", Data: &imp.Imp_Count},
		{Name: "won_price", Data: &imp.Won_price},
		{Name: "pub_rev", Data: &imp.Pub_rev},
		{Name: "pub_rev_usd", Data: &imp.Pub_rev_usd},
		{Name: "admin_rev", Data: &imp.Admin_rev},
		{Name: "gross_rev", Data: &imp.Gross_rev},
	}

	Client = clickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("am_data_bkt_m"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		panic(err4)
	}
	// if _, err := conn.NewInsert().Model(&imp).Exec(context.Background()); err != nil {
	// 	panic(err)
	// }
	return nil
}
