package tracking

import (
	// ch "analytics/clickClient"

	"analytics/clickConnect"
	"context"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Data_bkt_c struct {
	Date_time       proto.ColDateTime
	Request_id      proto.ColUUID
	Publisher_id    proto.ColUUID
	Adunit_id       proto.ColUUID
	Provider_id     proto.ColUUID
	Adsource_id     proto.ColUUID
	Tag_temp_id     proto.ColUUID
	Tag_id          proto.ColUUID
	Provider_src_id proto.ColUUID
	Clk_count       proto.ColInt8
}

func Click_insert(conn *ch.Client, Click_Data *Data_bkt_c) error {
	ctx := context.Background()

	input := proto.Input{
		{Name: "date_time", Data: Click_Data.Date_time},
		{Name: "request_id", Data: &Click_Data.Request_id},
		{Name: "publisher_id", Data: &Click_Data.Publisher_id},
		{Name: "adunit_id", Data: &Click_Data.Adunit_id},
		{Name: "provider_id", Data: &Click_Data.Provider_id},
		{Name: "adsource_id", Data: &Click_Data.Adsource_id},
		{Name: "tag_temp_id", Data: &Click_Data.Tag_temp_id},
		{Name: "tag_id", Data: &Click_Data.Tag_id},
		{Name: "provider_src_id", Data: &Click_Data.Provider_src_id},
		{Name: "clk_count", Data: &Click_Data.Clk_count},
	}

	conn = clickConnect.ClickhouseConnection()
	defer conn.Close()
	if err4 := conn.Do(ctx, ch.Query{
		Body:  input.Into("am_data_bkt_c"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		panic(err4)
	}

	return nil
}
