package tracking

import (
	"analytics/clickConnect"
	"context"
	"fmt"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Track_Response struct {
	Date_time       proto.ColDateTime
	Request_id      proto.ColUUID
	Publisher_id    proto.ColUUID
	Adunit_id       proto.ColUUID
	Provider_id     proto.ColUUID
	Adsource_id     proto.ColUUID
	Tag_temp_id     proto.ColUUID
	Tag_id          proto.ColUUID
	Provider_src_id proto.ColUUID
	Res_count       proto.ColInt8
}

func Track_res(Client *ch.Client, ad_res *Track_Response) error {

	ctx := context.Background()

	input := proto.Input{
		{Name: "date_time", Data: ad_res.Date_time},
		{Name: "request_id", Data: &ad_res.Request_id},
		{Name: "publisher_id", Data: &ad_res.Publisher_id},
		{Name: "adunit_id", Data: &ad_res.Adunit_id},
		{Name: "provider_id", Data: &ad_res.Provider_id},
		{Name: "adsource_id", Data: &ad_res.Adsource_id},
		{Name: "tag_temp_id", Data: &ad_res.Tag_temp_id},
		{Name: "tag_id", Data: &ad_res.Tag_id},
		{Name: "provider_src_id", Data: &ad_res.Provider_src_id},
		{Name: "res_count", Data: &ad_res.Res_count},
	}

	Client = clickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("am_response_stats"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		fmt.Println(err4)
	}

	return nil
}
