package tracking

import (
	"analytics/clickConnect"
	"context"
	"fmt"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Track_Request struct {
	Date_time       proto.ColDateTime
	Request_id      proto.ColUUID
	Publisher_id    proto.ColUUID
	Adunit_id       proto.ColUUID
	Provider_id     proto.ColUUID
	Adsource_id     proto.ColUUID
	Tag_temp_id     proto.ColUUID
	Tag_id          proto.ColUUID
	Provider_src_id proto.ColUUID
	Req_count       proto.ColInt8
}

func Track_req(Client *ch.Client, ad_req *Track_Request) error {

	ctx := context.Background()

	input := proto.Input{
		{Name: "date_time", Data: ad_req.Date_time},
		{Name: "request_id", Data: &ad_req.Request_id},
		{Name: "publisher_id", Data: &ad_req.Publisher_id},
		{Name: "adunit_id", Data: &ad_req.Adunit_id},
		{Name: "provider_id", Data: &ad_req.Provider_id},
		{Name: "adsource_id", Data: &ad_req.Adsource_id},
		{Name: "tag_temp_id", Data: &ad_req.Tag_temp_id},
		{Name: "tag_id", Data: &ad_req.Tag_id},
		{Name: "provider_src_id", Data: &ad_req.Provider_src_id},
		{Name: "req_count", Data: &ad_req.Req_count},
	}

	Client = clickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("am_requests_stats"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		fmt.Println(err4)
	}

	// if _, err := conn.NewInsert().Model(&ad_req).Exec(context.Background()); err != nil {
	// 	panic(err)
	// }
	return nil
}
