package fetching

import (
	"alpha/redisclient"
	"analytics/structure"

	"github.com/mitchellh/mapstructure"
)

var redisrepo = redisclient.Initialize()

func Cur_val(key string) map[string]string {
	hashmap := make(map[string]string)
	redisrepo.HGetKey(key, hashmap)
	return hashmap
}

func Publisher_share(publisher_id string) structure.Payment_Settings {
	pub_share := structure.Payment_Settings{}
	hashmap := make(map[string]string)
	redisrepo.HGetKey("Payment_Settings_"+publisher_id, hashmap)
	mapstructure.Decode(hashmap, &pub_share)
	return pub_share
}

func Pub_acc_cur(publisher_id string) structure.Publisher_Settings {
	currency := structure.Publisher_Settings{}
	hashmap := make(map[string]string)
	redisrepo.HGetKey("Settings_"+publisher_id, hashmap)
	mapstructure.Decode(hashmap, &currency)
	return currency
}
