package clickConnect

import (
	config "alpha/configuration"
	"context"
	"fmt"
	"net"

	"github.com/ClickHouse/ch-go"
)

func ClickhouseConnection() *ch.Client {
	// fmt.Println("CLICKHOUSE CONNECTED")

	ctx := context.Background()

	conn, err := net.Dial("tcp", config.GetConfig("host", "click")+":"+config.GetConfig("port", "click"))
	if err != nil {
		// handle error
	}

	Client, _ := ch.Connect(ctx, conn, ch.Options{
		Address:  config.GetConfig("host", "click") + ":" + config.GetConfig("port", "click"), // 127.0.0.1:9000
		Database: config.GetConfig("name", "clickDb"),                                         // "default"
		User:     config.GetConfig("user", "click"),                                           // "default"
		Password: config.GetConfig("pass", "click"),                                           // blank string by default

	})

	err2 := Client.Ping(ctx)
	if err2 != nil {
		fmt.Println(err2)
	}
	return Client

}
