package clickClient

import (
	"analytics/clickConnect"
	"analytics/fetching"
	"analytics/helper"
	"analytics/structure"
	"analytics/tracking"
	"analytics/validation"
	"context"
	"encoding/json"
	"log"
	"math"
	"strings"
	"sync"
	"time"

	"github.com/ClickHouse/ch-go"
)

var Client *ch.Client
var ctx = context.Background()
var mu sync.Mutex

func init() {
	Client = clickConnect.ClickhouseConnection()
}

func Click(Request_id string, Publisher_id string, Adunit_id string, Provider_id string, Adsource_id string, Tag_id string, Tag_temp_id string, Provider_src_id string) error {

	var clk int8
	clk = 1

	var Click_Data tracking.Data_bkt_c
	Click_Data.Date_time.Append(time.Now())
	Click_Data.Request_id.Append(validation.StringToUUID(Request_id))
	Click_Data.Publisher_id.Append(validation.StringToUUID(Publisher_id))
	Click_Data.Adunit_id.Append(validation.StringToUUID(Adunit_id))
	Click_Data.Provider_id.Append(validation.StringToUUID(Provider_id))
	Click_Data.Adsource_id.Append(validation.StringToUUID(Adsource_id))
	Click_Data.Tag_temp_id.Append(validation.StringToUUID(Tag_temp_id))
	Click_Data.Tag_id.Append(validation.StringToUUID(Tag_id))
	Click_Data.Provider_src_id.Append(validation.StringToUUID(Provider_src_id))
	Click_Data.Clk_count.Append(clk)

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := tracking.Click_insert(Client, &Click_Data)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()

	return nil
}

func View_Imp(Request_id string, Publisher_id string, Adunit_id string, Provider_id string, Adsource_id string, Tag_id string, Tag_temp_id string, Provider_src_id string) error {

	var imp int8
	imp = 1

	var View_Data tracking.Data_bkt_viewImp
	View_Data.Date_time.Append(time.Now())
	View_Data.Request_id.Append(validation.StringToUUID(Request_id))
	View_Data.Publisher_id.Append(validation.StringToUUID(Publisher_id))
	View_Data.Adunit_id.Append(validation.StringToUUID(Adunit_id))
	View_Data.Provider_id.Append(validation.StringToUUID(Provider_id))
	View_Data.Adsource_id.Append(validation.StringToUUID(Adsource_id))
	View_Data.Tag_temp_id.Append(validation.StringToUUID(Tag_temp_id))
	View_Data.Tag_id.Append(validation.StringToUUID(Tag_id))
	View_Data.Provider_src_id.Append(validation.StringToUUID(Provider_src_id))
	View_Data.Viewable_imp_count.Append(imp)

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := tracking.Viewable_insert(Client, &View_Data)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()

	return nil
}

func roundFloat(val float64, precision uint) float64 {
	ratio := math.Pow(10, float64(precision))
	return math.Round(val*ratio) / ratio
}

func Win_Imp(Request_id string, Publisher_id string, Adunit_id string, Provider_id string, Adsource_id string, Tag_id string, Tag_temp_id string, Provider_src_id string, won_price float64, res_cur string, owned_by string) error {

	currency_usd := structure.Currency_data{}
	currency := structure.Currency_data{}
	var pub_acc_cur, pub_bid_cur string
	var res_price float64
	cur := fetching.Pub_acc_cur(Publisher_id)
	pub_acc_cur = cur.Account_currency
	pub_bid_cur = cur.Bidding_currency

	var CPM, cpm, pub_share, admin_share, publisher_revenue, admin_revenue, gross_revenue, publisher_rev_usd, krw, usd_ttb float64

	CPM_Price := won_price / 1000
	cpm = roundFloat(CPM_Price, 6)

	share := fetching.Publisher_share(Publisher_id)
	pub_share_str := share.Revenue_share
	pub := helper.StringToFloat(pub_share_str)
	adm := 100 - pub

	if owned_by == "0" {
		pub_share = pub
		admin_share = adm
	} else {
		pub_share = 100
		admin_share = 0
	}

	resp := fetching.Cur_val("multicurrency")

	for k1, v1 := range resp {
		if k1 == "USD" {
			err := json.Unmarshal([]byte(v1), &currency_usd)
			if err != nil {
				return err
			}
			ttb := currency_usd.Ttb
			ttb_val := strings.Replace(ttb, ",", "", -1)
			usd_ttb = helper.StringToFloat(ttb_val)
			krw_usd := 1 / usd_ttb
			krw = roundFloat(krw_usd, 6)
		}
	}

	res_price = won_price
	CPM = res_price / 1000
	if res_cur != "" {
		if res_cur == pub_bid_cur {
			if pub_acc_cur == res_cur {
				pub_rev := CPM / 100 * pub_share
				publisher_rev := pub_rev
				publisher_revenue = roundFloat(publisher_rev, 6)
				if pub_acc_cur == "USD" && res_cur == "USD" {
					publisher_rev_usd = roundFloat(pub_rev, 6)
					admin_rev := CPM / 100 * admin_share
					admin_revenue = roundFloat(admin_rev, 6)
				} else if pub_acc_cur == "KRW" && res_cur == "KRW" {
					pub_rev_usd := publisher_rev * krw
					publisher_rev_usd = roundFloat(pub_rev_usd, 6)
					admin_rev := CPM / 100 * admin_share
					admin_rev_usd := admin_rev * krw
					admin_revenue = roundFloat(admin_rev_usd, 6)
				}
			} else {
				pub_rev := CPM / 100 * pub_share
				if pub_acc_cur == "KRW" {
					publisher_rev := pub_rev * usd_ttb
					publisher_revenue = roundFloat(publisher_rev, 6)
					publisher_rev_usd = roundFloat(pub_rev, 6)
					admin_rev := CPM / 100 * admin_share
					admin_revenue = roundFloat(admin_rev, 6)
				} else if pub_acc_cur == "USD" {
					publisher_rev := pub_rev * krw
					publisher_revenue = roundFloat(publisher_rev, 6)
					publisher_rev_usd = publisher_revenue
					admin_rev := CPM / 100 * admin_share
					admin_rev_usd := admin_rev * krw
					admin_revenue = roundFloat(admin_rev_usd, 6)
				}

			}
		}

	} else {
		for k, v := range resp {
			if pub_acc_cur == pub_bid_cur {
				if res_cur == "" && k == "USD" && pub_acc_cur == "USD" {
					if cpm != 0 {
						pub_rev := CPM / 100 * pub_share
						publisher_revenue = roundFloat(pub_rev, 6)
						publisher_rev_usd = roundFloat(pub_rev, 6)
						admin_rev := CPM / 100 * admin_share
						admin_revenue = roundFloat(admin_rev, 6)
					}
				} else if res_cur == "" && k == "KRW" && pub_acc_cur == "KRW" {
					if cpm != 0 && krw != 0 {
						pub_rev := CPM / 100 * pub_share
						publisher_revenue = roundFloat(pub_rev, 6)
						pub_rev_usd := pub_rev * krw
						publisher_rev_usd = roundFloat(pub_rev_usd, 6)
						admin_rev := CPM / 100 * admin_share
						admin_rev_usd := admin_rev * krw
						admin_revenue = roundFloat(admin_rev_usd, 6)
					}
				} else if res_cur == "" && k != "USD" && k != "KRW" && k == pub_acc_cur {
					err := json.Unmarshal([]byte(v), &currency)
					if err != nil {
						return err
					}
					ttb := currency.Ttb
					ttb_val := strings.Replace(ttb, ",", "", -1)
					other_ttb := helper.StringToFloat(ttb_val)
					if cpm != 0 && krw != 0 {
						pub_rev := CPM / 100 * pub_share
						publisher_revenue = roundFloat(pub_rev, 6)
						pub_rev_krw := pub_rev * other_ttb
						pub_rev_usd := pub_rev_krw * krw
						publisher_rev_usd = roundFloat(pub_rev_usd, 6)
						admin_rev := CPM / 100 * admin_share
						admin_rev_krw := admin_rev * other_ttb
						admin_rev_usd := admin_rev_krw * krw
						admin_revenue = roundFloat(admin_rev_usd, 6)
					}
				}
			} else {
				if res_cur == "" && k == "USD" && pub_acc_cur == "KRW" {
					if cpm != 0 {
						pub_rev := CPM / 100 * pub_share
						publisher_revenue = roundFloat(pub_rev, 6)
						pub_rev_usd := pub_rev * krw
						publisher_rev_usd = roundFloat(pub_rev_usd, 6)
						admin_rev := CPM / 100 * admin_share
						admin_rev_usd := admin_rev * krw
						admin_revenue = roundFloat(admin_rev_usd, 6)
					}
				} else if res_cur == "" && k == "KRW" && pub_acc_cur == "USD" {
					if cpm != 0 {
						pub_rev := cpm / 100 * pub_share
						publisher_rev_usd = pub_rev
						publisher_revenue = roundFloat(publisher_rev_usd, 6)
						publisher_rev_usd = roundFloat(publisher_rev_usd, 6)
						admin_rev := CPM / 100 * admin_share
						admin_revenue = roundFloat(admin_rev, 6)
					}
				}
			}
		}
	}
	gross := publisher_rev_usd + admin_revenue
	gross_revenue = roundFloat(gross, 6)
	var Impression_table tracking.Data_bkt_m

	Impression_table.Date_time.Append(time.Now())
	Impression_table.Request_id.Append(validation.StringToUUID(Request_id))
	Impression_table.Publisher_id.Append(validation.StringToUUID(Publisher_id))
	Impression_table.Adunit_id.Append(validation.StringToUUID(Adunit_id))
	Impression_table.Provider_id.Append(validation.StringToUUID(Provider_id))
	Impression_table.Adsource_id.Append(validation.StringToUUID(Adsource_id))
	Impression_table.Tag_temp_id.Append(validation.StringToUUID(Tag_temp_id))
	Impression_table.Tag_id.Append(validation.StringToUUID(Tag_id))
	Impression_table.Provider_src_id.Append(validation.StringToUUID(Provider_src_id))
	Impression_table.Imp_Count.Append(1)
	Impression_table.Won_price.Append(cpm)
	Impression_table.Pub_rev.Append(publisher_revenue)
	Impression_table.Pub_rev_usd.Append(publisher_rev_usd)
	Impression_table.Admin_rev.Append(admin_revenue)
	Impression_table.Gross_rev.Append(gross_revenue)
	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := tracking.Imp_insert(Client, &Impression_table)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()
	return nil
}

func Track_ad_request(Request_id string, Adunit_id string, Publisher_id string, Tag_temp_id string, Tag_id string, ip string, domain string, countrycode string, countryname string, os string, environment int8) error {

	var Track_Req tracking.Track_ad_request
	Track_Req.Date_time.Append(time.Now())
	Track_Req.Request_id.Append(validation.StringToUUID(Request_id))

	Track_Req.Tag_temp_id.Append(validation.StringToUUID(Tag_temp_id))
	Track_Req.Tag_id.Append(validation.StringToUUID(Tag_id))
	Track_Req.Publisher_id.Append(validation.StringToUUID(Publisher_id))
	Track_Req.Adunit_id.Append(validation.StringToUUID(Adunit_id))
	Track_Req.Ip.Append(ip)
	Track_Req.Domain.Append(domain)
	Track_Req.Country_code.Append(countrycode)
	Track_Req.Country_Name.Append(countryname)
	Track_Req.Os.Append(os)
	Track_Req.Environment.Append(environment)

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := tracking.Track_ad_req(Client, &Track_Req)

	if err != nil {
		// fmt.Printf("error %+v", err)
		// fmt.Println(err)
	}
	mu.Unlock()

	return nil

}

func Track_request(Publisher_id string, Adunit_id string, Provider_id string, Adsource_id string, Request_id string, Tag_id string, Tag_temp_id string, Provider_src_id string, Request_Count int8) error {

	var Request_Stats tracking.Track_Request
	Request_Stats.Date_time.Append(time.Now())
	Request_Stats.Request_id.Append(validation.StringToUUID(Request_id))
	Request_Stats.Publisher_id.Append(validation.StringToUUID(Publisher_id))
	Request_Stats.Adunit_id.Append(validation.StringToUUID(Adunit_id))
	Request_Stats.Provider_id.Append(validation.StringToUUID(Provider_id))
	Request_Stats.Adsource_id.Append(validation.StringToUUID(Adsource_id))
	Request_Stats.Tag_temp_id.Append(validation.StringToUUID(Tag_temp_id))
	Request_Stats.Tag_id.Append(validation.StringToUUID(Tag_id))
	Request_Stats.Provider_src_id.Append(validation.StringToUUID(Provider_src_id))
	Request_Stats.Req_count.Append(Request_Count)

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := tracking.Track_req(Client, &Request_Stats)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()

	return nil
}

func Track_response(Publisher_id string, Adunit_id string, Provider_id string, Adsource_id string, Request_id string, Tag_id string, Tag_temp_id string, Provider_src_id string, Response_Count int8) error {

	var Response_Stats tracking.Track_Response
	Response_Stats.Date_time.Append(time.Now())
	Response_Stats.Request_id.Append(validation.StringToUUID(Request_id))
	Response_Stats.Publisher_id.Append(validation.StringToUUID(Publisher_id))
	Response_Stats.Adunit_id.Append(validation.StringToUUID(Adunit_id))
	Response_Stats.Provider_id.Append(validation.StringToUUID(Provider_id))
	Response_Stats.Adsource_id.Append(validation.StringToUUID(Adsource_id))
	Response_Stats.Tag_temp_id.Append(validation.StringToUUID(Tag_temp_id))
	Response_Stats.Tag_id.Append(validation.StringToUUID(Tag_id))
	Response_Stats.Provider_src_id.Append(validation.StringToUUID(Provider_src_id))
	Response_Stats.Res_count.Append(Response_Count)

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := tracking.Track_res(Client, &Response_Stats)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()

	return nil
}

func Track_win(Publisher_id string, Adunit_id string, Provider_id string, Adsource_id string, Request_id string, Tag_id string, Tag_temp_id string, Provider_src_id string, Win_Count int8) error {

	var Win_Stats tracking.Track_Win
	Win_Stats.Date_time.Append(time.Now())
	Win_Stats.Request_id.Append(validation.StringToUUID(Request_id))
	Win_Stats.Publisher_id.Append(validation.StringToUUID(Publisher_id))
	Win_Stats.Adunit_id.Append(validation.StringToUUID(Adunit_id))
	Win_Stats.Provider_id.Append(validation.StringToUUID(Provider_id))
	Win_Stats.Adsource_id.Append(validation.StringToUUID(Adsource_id))
	Win_Stats.Tag_temp_id.Append(validation.StringToUUID(Tag_temp_id))
	Win_Stats.Tag_id.Append(validation.StringToUUID(Tag_id))
	Win_Stats.Provider_src_id.Append(validation.StringToUUID(Provider_src_id))
	Win_Stats.Win_count.Append(Win_Count)

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := tracking.Track_win(Client, &Win_Stats)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()

	return nil
}

func Track_Video_Events(Request_id string, Publisher_id string, Adunit_id string, Provider_id string, Adsource_id string, Tag_id string, Tag_temp_id string, Provider_src_id string, Event string) error {

	var start_count, firstQuartile_count, midpoint_count, thirdQuartile_count, complete_count, fivesView_count uint32
	if Event == "start" {
		start_count = 1
	} else if Event == "firstQuartile" {
		firstQuartile_count = 1
	} else if Event == "midpoint" {
		midpoint_count = 1
	} else if Event == "thirdQuartile" {
		thirdQuartile_count = 1
	} else if Event == "complete" {
		complete_count = 1
	} else if Event == "5sView" {
		fivesView_count = 1
	}

	var Data_bkt_event tracking.Data_bkt_events
	Data_bkt_event.Date_time.Append(time.Now())
	Data_bkt_event.Request_id.Append(validation.StringToUUID(Request_id))
	Data_bkt_event.Publisher_id.Append(validation.StringToUUID(Publisher_id))
	Data_bkt_event.Adunit_id.Append(validation.StringToUUID(Adunit_id))
	Data_bkt_event.Provider_id.Append(validation.StringToUUID(Provider_id))
	Data_bkt_event.Adsource_id.Append(validation.StringToUUID(Adsource_id))
	Data_bkt_event.Tag_temp_id.Append(validation.StringToUUID(Tag_temp_id))
	Data_bkt_event.Tag_id.Append(validation.StringToUUID(Tag_id))
	Data_bkt_event.Provider_src_id.Append(validation.StringToUUID(Provider_src_id))
	Data_bkt_event.Start.Append(start_count)
	Data_bkt_event.FivesView.Append(fivesView_count)
	Data_bkt_event.FirstQuartile.Append(firstQuartile_count)
	Data_bkt_event.MidPoint.Append(midpoint_count)
	Data_bkt_event.ThirdQuartile.Append(thirdQuartile_count)
	Data_bkt_event.Complete.Append(complete_count)

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := tracking.Video_events(Client, &Data_bkt_event)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()

	return nil

}

func RtbReq(Request_id string, Data string) error {

	var RTB_Req tracking.Rtb_requests
	RTB_Req.Date_time.Append(time.Now())
	RTB_Req.Request_id.Append(validation.StringToUUID(Request_id))
	RTB_Req.Data.Append(Data)

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := tracking.Rtb_Req(Client, &RTB_Req)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()

	return nil

}

func RtbRes(Request_id string, Data string) error {

	var RTB_Res tracking.Rtb_response
	RTB_Res.Date_time.Append(time.Now())
	RTB_Res.Request_id.Append(validation.StringToUUID(Request_id))
	RTB_Res.Data.Append(Data)

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := tracking.Rtb_Res(Client, &RTB_Res)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()

	return nil

}

func Vast_errors(code int32, msg string) error {

	var vast_err tracking.Vast_errors
	vast_err.Code.Append(code)
	vast_err.Msg.Append(msg)

	mu.Lock()
	err := tracking.Vast_err(Client, &vast_err)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()

	return nil
}
