package router

import (
	"alpha/handler"
	"crypto/tls"
	"fmt"
	"net/http"

	config "alpha/configuration"

	"github.com/gorilla/mux"
)

func SaySomething() {
	fmt.Println("Admaru Ad Delivery Server Started")
}

func SetUpHandler() {
	r := mux.NewRouter()
	r.HandleFunc("/", handler.Home).Methods("GET")
	r.HandleFunc("/AdAsync", handler.AdAsync).Methods("GET")
	r.HandleFunc("/loaderio-4b4b469b22f0864a210c6a683ee214eb.txt", validataion).Methods("GET") // Added for load testing
	r.HandleFunc("/VastGen", handler.VastGen).Methods("GET")
	r.HandleFunc("/Adapter", handler.Adapter).Methods("GET")
	r.HandleFunc("/tptres", handler.Tptres).Methods("GET")
	r.HandleFunc("/VideoVast", handler.VideoVast).Methods("GET")
	r.HandleFunc("/usersync", handler.Usersync).Methods("GET")
	r.HandleFunc("/Impression", handler.AdImp).Methods("GET")
	r.HandleFunc("/Click", handler.AdClick).Methods("GET")
	r.HandleFunc("/Track_adrequest", handler.TrackAdRequest).Methods("GET")
	r.HandleFunc("/Ad_Request", handler.Request_Count).Methods("GET")
	r.HandleFunc("/Ad_Response", handler.Response_Count).Methods("GET")
	r.HandleFunc("/Ad_Win", handler.Win_Count).Methods("GET")
	r.HandleFunc("/Event_Track", handler.Event_Tracking).Methods("GET")
	r.HandleFunc("/Viewable_Imp", handler.AdViewImp).Methods("GET")
	r.HandleFunc("/Rtb_Req", handler.RtbRequest).Methods("POST")
	r.HandleFunc("/Rtb_Res", handler.RtbResponse).Methods("POST")

	srv := &http.Server{
		Addr:    config.GetConfig("port", "app"),
		Handler: r,
		TLSConfig: &tls.Config{
			MinVersion:               tls.VersionTLS12,
			MaxVersion:               tls.VersionTLS13,
			PreferServerCipherSuites: true,
		},
	}
	srv.SetKeepAlivesEnabled(false)
	if err := srv.ListenAndServeTLS(config.GetConfig("CertFile", "key"), config.GetConfig("KeyFile", "key")); err != nil {
		panic(err)
	}

	// if err := http.ListenAndServe(string(config.GetConfig("port", "app")), r); err != nil {
	// 	panic(err)
	// }
}

// Added for load testing
func validataion(w http.ResponseWriter, r *http.Request) {
	html := `loaderio-4b4b469b22f0864a210c6a683ee214eb`
	w.Write([]byte(fmt.Sprintf(html)))
}
