package logger

import (
	config "alpha/configuration"
	"flag"
	"fmt"
	"go/build"
	"log"
	"os"
)

var (
	Log *log.Logger
)

func init() {
	// set location of log file
	var logpath = build.Default.GOPATH + config.GetConfig("path", "log")
	flag.Parse()
	var file, err1 = os.OpenFile(logpath, os.O_RDWR|os.O_CREATE|os.O_APPEND, 0666)
	if err1 != nil {
		fmt.Println(err1)
	}
	Log = log.New(file, "", log.LstdFlags|log.Lshortfile)
}
