package handler

import (
	"alpha/addelivery"
	"alpha/addelivery/helper"
	"analytics/clickClient"
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"
	"strconv"
	"strings"
	"time"
)

func Home(w http.ResponseWriter, r *http.Request) {
	html := `<html>
		<head>
			<title>Ad Delivery System</title>
		</head>
		<body>
			<h1>Admaru Ad Delivery Server Started</h1>
		</body>
	</html>`
	w.Write([]byte(html))
}

func AdAsync(w http.ResponseWriter, r *http.Request) {

	content := addelivery.AdAsyncTag(w, r)
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	m, err := url.Parse(helper.GetUrlParam(r, "loc"))
	if err == nil {
		w.Header().Set("Access-Control-Allow-Origin", m.Scheme+"://"+m.Host)
	}
	u, _ := url.Parse(r.Header.Get("Referer"))
	if helper.GetUrlParam(r, "viewenable") == "yes" {
		w.Header().Set("Content-Type", "application/json; charset=utf-8")
	} else {
		w.Header().Set("Content-Type", "text/html; charset=utf-8")
	}

	w.Header().Set("Access-Control-Allow-Origin", u.Scheme+"://"+u.Host)
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")
	w.Write([]byte(content))

}

func VastGen(w http.ResponseWriter, r *http.Request) {

	content := addelivery.VastGenerator(w, r)
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	u, _ := url.Parse(r.Header.Get("Referer"))

	w.Header().Set("Content-Type", "text/xml; charset=utf-8")
	w.Header().Set("Access-Control-Allow-Origin", u.Scheme+"://"+u.Host)
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")

	w.Write([]byte(content))
}

func Adapter(w http.ResponseWriter, r *http.Request) {
	content := addelivery.AdapterAdunit(w, r)
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	m, err := url.Parse(helper.GetUrlParam(r, "loc"))
	if err == nil {
		w.Header().Set("Access-Control-Allow-Origin", m.Scheme+"://"+m.Host)
	}
	w.Header().Set("Content-Type", "text/json; charset=utf-8")
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")
	w.Write([]byte(content))
}

func Tptres(w http.ResponseWriter, r *http.Request) {

	content := `<ins class='dcmads' style='display:inline-block;width:300px;height:250px'
    data-dcm-placement='N6103.1355588DOUBLECLICK.COMBID1/B28594265.357717956'
    data-dcm-rendering-mode='script'
    data-dcm-https-only
    data-dcm-api-frameworks='[APIFRAMEWORKS]'
    data-dcm-omid-partner='[OMIDPARTNER]'
    data-dcm-gdpr-applies='gdpr=${GDPR}'
    data-dcm-gdpr-consent='gdpr_consent=${GDPR_CONSENT_755}'
    data-dcm-addtl-consent='addtl_consent=${ADDTL_CONSENT}'
    data-dcm-ltd='false'
    data-dcm-resettable-device-id=''
    data-dcm-app-id=''>
  <script src='https://www.googletagservices.com/dcm/dcmads.js'></script>
</ins>
`
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	m, err := url.Parse(helper.GetUrlParam(r, "loc"))
	if err == nil {
		w.Header().Set("Access-Control-Allow-Origin", m.Scheme+"://"+m.Host)
	}
	u, _ := url.Parse(r.Header.Get("Referer"))
	w.Header().Set("Content-Type", "text/html; charset=utf-8")
	w.Header().Set("Access-Control-Allow-Origin", u.Scheme+"://"+u.Host)
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")
	w.Write([]byte(content))

}
func TestResponse(w http.ResponseWriter, r *http.Request) {

	content := "Test response"
	w.Header().Set("Access-Control-Max-Age", strconv.Itoa(3600))
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	m, err := url.Parse(helper.GetUrlParam(r, "loc"))
	if err == nil {
		w.Header().Set("Access-Control-Allow-Origin", m.Scheme+"://"+m.Host)
	}
	w.Header().Set("Content-Type", "text/json; charset=utf-8")

	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")
	w.Write([]byte(content))

}

func AdClick(w http.ResponseWriter, r *http.Request) {

	//CROS Code start
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")
	//CROS Code end
	fmt.Sprintf("body :%+s\n", helper.GetUrlParam(r, "adunitid"))

	Request_id := helper.GetUrlParam(r, "requestid")

	checkStr := strings.Contains(Request_id, "__")
	if checkStr == true {

		var Requestid string
		var adsourceid string
		var adunitid string
		var Providerid string
		var Publisherid string

		var tagid string
		var tagtempid string
		var pro_src_id string
		var dest string

		Params := strings.Split(Request_id, "__")

		Requestid = Params[0]

		adsource := strings.Split(Params[1], "adsourceid=")
		adsourceid = adsource[1]

		adunit := strings.Split(Params[2], "adunitid=")
		adunitid = adunit[1]

		Provider := strings.Split(Params[3], "Providerid=")
		Providerid = Provider[1]

		Publisher := strings.Split(Params[4], "Publisherid=")
		Publisherid = Publisher[1]

		tag := strings.Split(Params[6], "tagid=")
		tagid = tag[1]

		tagtemp := strings.Split(Params[7], "tagtempid=")
		tagtempid = tagtemp[1]

		pro_src := strings.Split(Params[8], "pro_src_id=")
		pro_src_id = pro_src[1]

		iurl := strings.Split(Params[5], "url=")
		dest = iurl[1]

		http.Redirect(w, r, dest, http.StatusFound)
		ClickCount(Requestid, Publisherid, adunitid, Providerid, adsourceid, tagid, tagtempid, pro_src_id)

	} else {

		Adunit_Id := helper.GetUrlParam(r, "adunitid")
		Adsource_Id := helper.GetUrlParam(r, "adsourceid")
		Provider_Id := helper.GetUrlParam(r, "Providerid")
		Publisher_Id := helper.GetUrlParam(r, "Publisherid")
		Tag_id := helper.GetUrlParam(r, "tagid")
		Tag_temp_id := helper.GetUrlParam(r, "tagtempid")
		Provider_src_id := helper.GetUrlParam(r, "pro_src_id")

		Url := helper.GetUrlParam(r, "url")
		if Url != "" {
			http.Redirect(w, r, Url, http.StatusFound)
		}

		ClickCount(Request_id, Publisher_Id, Adunit_Id, Provider_Id, Adsource_Id, Tag_id, Tag_temp_id, Provider_src_id)
	}
}

func AdImp(w http.ResponseWriter, r *http.Request) {
	//CROS Code start
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")
	Request_id := helper.GetUrlParam(r, "req_id")
	Publisher_id := helper.GetUrlParam(r, "publisher_id")
	Adunit_id := helper.GetUrlParam(r, "adunit_id")
	Provider_id := helper.GetUrlParam(r, "provider_id")
	Adsource_id := helper.GetUrlParam(r, "adsource_id")
	Tag_id := helper.GetUrlParam(r, "tagid")
	Tag_temp_id := helper.GetUrlParam(r, "tagtempid")
	Provider_src_id := helper.GetUrlParam(r, "pro_src_id")
	Won_price := helper.GetUrlParam(r, "won_price")
	owned_by := helper.GetUrlParam(r, "owned_by")
	res_cur := helper.GetUrlParam(r, "res_cur")
	price := helper.StringToFloat(Won_price)
	ImpCount(Request_id, Publisher_id, Adunit_id, Provider_id, Adsource_id, Tag_id, Tag_temp_id, Provider_src_id, price, res_cur, owned_by)
}

func AdViewImp(w http.ResponseWriter, r *http.Request) {
	//CROS Code start
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")
	Request_id := helper.GetUrlParam(r, "req_id")
	Publisher_id := helper.GetUrlParam(r, "publisher_id")
	Adunit_id := helper.GetUrlParam(r, "adunit_id")
	Provider_id := helper.GetUrlParam(r, "provider_id")
	Adsource_id := helper.GetUrlParam(r, "adsource_id")
	Tag_id := helper.GetUrlParam(r, "tag_id")
	Tag_temp_id := helper.GetUrlParam(r, "tagtemp_id")
	Provider_src_id := helper.GetUrlParam(r, "pro_src_id")
	ViewImpCount(Request_id, Publisher_id, Adunit_id, Provider_id, Adsource_id, Tag_id, Tag_temp_id, Provider_src_id)
}

func TrackAdRequest(w http.ResponseWriter, r *http.Request) {
	//CROS Code start
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")

	Request_id := helper.GetUrlParam(r, "req_id")
	Publisher_id := helper.GetUrlParam(r, "publisher_id")
	Adunit_id := helper.GetUrlParam(r, "adunit_id")
	Tag_id := helper.GetUrlParam(r, "tagid")
	Tag_temp_id := helper.GetUrlParam(r, "tagtempid")
	ip := r.URL.Query().Get("ip")
	domain := r.URL.Query().Get("domain")
	country_code := r.URL.Query().Get("country_code")
	country_name := r.URL.Query().Get("country_name")
	os := r.URL.Query().Get("os")
	environment := r.URL.Query().Get("environment")
	env_str := helper.StringToInt(environment)
	env := int8(env_str)
	TrackRequest(Request_id, Publisher_id, Adunit_id, Tag_id, Tag_temp_id, ip, domain, country_code, country_name, os, env)
}

func Request_Count(w http.ResponseWriter, r *http.Request) {
	//CROS Code start
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")
	Request_id := helper.GetUrlParam(r, "req_id")
	Publisher_id := helper.GetUrlParam(r, "publisher_id")
	Adunit_id := helper.GetUrlParam(r, "adunit_id")
	Provider_id := helper.GetUrlParam(r, "provider_id")
	Adsource_id := helper.GetUrlParam(r, "adsource_id")
	Tag_id := helper.GetUrlParam(r, "tagid")
	Tag_temp_id := helper.GetUrlParam(r, "tagtempid")
	Provider_src_id := helper.GetUrlParam(r, "pro_src_id")
	Req_Count := helper.GetUrlParam(r, "req_count")
	count := helper.StringToInt(Req_Count)
	Req_count := int8(count)
	TrackReq_Count(Request_id, Publisher_id, Adunit_id, Provider_id, Adsource_id, Tag_id, Tag_temp_id, Provider_src_id, Req_count)
}

func Response_Count(w http.ResponseWriter, r *http.Request) {
	//CROS Code start
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")

	Request_id := helper.GetUrlParam(r, "req_id")
	Publisher_id := helper.GetUrlParam(r, "publisher_id")
	Adunit_id := helper.GetUrlParam(r, "adunit_id")
	Provider_id := helper.GetUrlParam(r, "provider_id")
	Adsource_id := helper.GetUrlParam(r, "adsource_id")
	Tag_id := helper.GetUrlParam(r, "tagid")
	Tag_temp_id := helper.GetUrlParam(r, "tagtempid")
	Provider_src_id := helper.GetUrlParam(r, "pro_src_id")
	Res_Count := helper.GetUrlParam(r, "res_count")
	count := helper.StringToInt(Res_Count)
	Res_count := int8(count)
	TrackRes_Count(Request_id, Publisher_id, Adunit_id, Provider_id, Adsource_id, Tag_id, Tag_temp_id, Provider_src_id, Res_count)
}

func Win_Count(w http.ResponseWriter, r *http.Request) {
	//CROS Code start
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")

	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")
	Request_id := helper.GetUrlParam(r, "req_id")
	Publisher_id := helper.GetUrlParam(r, "publisher_id")
	Adunit_id := helper.GetUrlParam(r, "adunit_id")
	Provider_id := helper.GetUrlParam(r, "provider_id")
	Adsource_id := helper.GetUrlParam(r, "adsource_id")
	Tag_id := helper.GetUrlParam(r, "tagid")
	Tag_temp_id := helper.GetUrlParam(r, "tagtempid")
	Provider_src_id := helper.GetUrlParam(r, "pro_src_id")
	Won_Count := helper.GetUrlParam(r, "won_count")
	count := helper.StringToInt(Won_Count)
	Won_count := int8(count)
	TrackWin_Count(Request_id, Publisher_id, Adunit_id, Provider_id, Adsource_id, Tag_id, Tag_temp_id, Provider_src_id, Won_count)
}

func Event_Tracking(w http.ResponseWriter, r *http.Request) {

	//CROS Code start
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")

	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")

	Request_id := helper.GetUrlParam(r, "req_id")

	Publisher_id := helper.GetUrlParam(r, "publisher_id")
	Adunit_id := helper.GetUrlParam(r, "adunitid")

	Provider_id := helper.GetUrlParam(r, "provider_id")
	Adsource_id := helper.GetUrlParam(r, "adsource_id")
	Tag_id := helper.GetUrlParam(r, "tagid")
	Tag_temp_id := helper.GetUrlParam(r, "tagtempid")
	Provider_src_id := helper.GetUrlParam(r, "pro_src_id")
	Event := helper.GetUrlParam(r, "event")
	TrackEvents(Request_id, Publisher_id, Adunit_id, Provider_id, Adsource_id, Tag_id, Tag_temp_id, Provider_src_id, Event)
}

func RtbRequest(w http.ResponseWriter, r *http.Request) {
	//CROS Code start
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	m, err := url.Parse(helper.GetUrlParam(r, "loc"))
	if err == nil {
		w.Header().Set("Access-Control-Allow-Origin", m.Scheme+"://"+m.Host)
	}
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")
	Request_id := helper.GetUrlParam(r, "req_id")

	var res map[string]interface{}

	json.NewDecoder(r.Body).Decode(&res)
	jsonData, err := json.Marshal(res)
	if err != nil {
		fmt.Println(err.Error())
		return
	}

	jsonStr := string(jsonData)
	rtb_request(Request_id, jsonStr)
}

func RtbResponse(w http.ResponseWriter, r *http.Request) {
	//CROS Code start
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	m, err := url.Parse(helper.GetUrlParam(r, "loc"))
	if err == nil {
		w.Header().Set("Access-Control-Allow-Origin", m.Scheme+"://"+m.Host)
	}
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")
	Request_id := helper.GetUrlParam(r, "req_id")

	var res map[string]interface{}

	json.NewDecoder(r.Body).Decode(&res)
	jsonData, err := json.Marshal(res)
	if err != nil {
		fmt.Println(err.Error())
		return
	}

	jsonStr := string(jsonData)
	rtb_response(Request_id, jsonStr)
}

func VastError(w http.ResponseWriter, r *http.Request) {
	//CROS Code start
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")

	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")

	var res map[string]interface{}
	json.NewDecoder(r.Body).Decode(&res)
	codeString := fmt.Sprint(res["code"])
	msgString := fmt.Sprint(res["msg"])
	vast_err(codeString, msgString)
}

func vast_err(code string, message string) {
	code_int := helper.StringToInt(code)
	err_code := int32(code_int)
	clickClient.Vast_errors(err_code, message)
}

func rtb_request(request_id string, data string) {

	clickClient.RtbReq(request_id, data)
}

func rtb_response(request_id string, data string) {

	clickClient.RtbRes(request_id, data)
}

func TrackEvents(request_id string, publisher_id string, adunit_id string, provider_id string, adsource_id string, tag_id string, tag_temp_id string, provider_src_id string, event string) {

	clickClient.Track_Video_Events(request_id, publisher_id, adunit_id, provider_id, adsource_id, tag_id, tag_temp_id, provider_src_id, event)
}

func TrackRequest(request_id string, publisher_id string, adunit_id string, tag_id string, tag_temp_id string, ip string, domain string, country_code string, country_name string, os string, environment int8) {

	clickClient.Track_ad_request(request_id, adunit_id, publisher_id, tag_temp_id, tag_id, ip, domain, country_code, country_name, os, environment)
}

func TrackReq_Count(request_id string, publisher_id string, adunit_id string, provider_id string, adsource_id string, tag_id string, tag_temp_id string, provider_src_id string, request_count int8) {

	clickClient.Track_request(publisher_id, adunit_id, provider_id, adsource_id, request_id, tag_id, tag_temp_id, provider_src_id, request_count)
}

func TrackRes_Count(request_id string, publisher_id string, adunit_id string, provider_id string, adsource_id string, tag_id string, tag_temp_id string, provider_src_id string, response_count int8) {

	clickClient.Track_response(publisher_id, adunit_id, provider_id, adsource_id, request_id, tag_id, tag_temp_id, provider_src_id, response_count)
}

func TrackWin_Count(request_id string, publisher_id string, adunit_id string, provider_id string, adsource_id string, tag_id string, tag_temp_id string, provider_src_id string, won_count int8) {

	clickClient.Track_win(publisher_id, adunit_id, provider_id, adsource_id, request_id, tag_id, tag_temp_id, provider_src_id, won_count)
}

func ImpCount(request_id string, publisher_id string, adunit_id string, provider_id string, adsource_id string, tag_id string, tag_temp_id string, provider_src_id string, won_price float64, res_cur string, owned_by string) {

	clickClient.Win_Imp(request_id, publisher_id, adunit_id, provider_id, adsource_id, tag_id, tag_temp_id, provider_src_id, won_price, res_cur, owned_by)
}

func ClickCount(Request_id string, Publisher_id string, Adunit_id string, Provider_id string, Adsource_id string, tag_id string, tag_temp_id string, provider_src_id string) {

	clickClient.Click(Request_id, Publisher_id, Adunit_id, Provider_id, Adsource_id, tag_id, tag_temp_id, provider_src_id)

}

func ViewImpCount(request_id string, publisher_id string, adunit_id string, provider_id string, adsource_id string, tag_id string, tag_temp_id string, provider_src_id string) {

	clickClient.View_Imp(request_id, publisher_id, adunit_id, provider_id, adsource_id, tag_id, tag_temp_id, provider_src_id)
}

func Usersync(w http.ResponseWriter, r *http.Request) {

	redirect := helper.GetUrlParam(r, "UID")
	Cookie, err := r.Cookie("b_id")
	if err != nil {

		Cookie = &http.Cookie{
			Name:     "b_id",
			Value:    redirect,
			Path:     "/",
			Domain:   ".admaru.com",
			Secure:   true,
			Expires:  time.Now().Add(365 * 24 * time.Hour),
			SameSite: http.SameSiteNoneMode,
		}
		http.SetCookie(w, Cookie)

	}
}

func VideoVast(w http.ResponseWriter, r *http.Request) {
	content, contentype := addelivery.VideoVastTag(w, r)
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	m, err := url.Parse(helper.GetUrlParam(r, "loc"))
	if err == nil {
		w.Header().Set("Access-Control-Allow-Origin", m.Scheme+"://"+m.Host)
	}

	if contentype == "html" {
		w.Header().Set("Content-Type", "text/html; charset=utf-8")

	} else {
		w.Header().Set("Content-Type", "application/json; charset=utf-8")

	}

	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")
	w.Write([]byte(content))
}
