package configuration

import (
	"log"
	"os"

	"github.com/joho/godotenv"
)

func init() {

	configpath := "configuration"
	err := godotenv.Load(configpath + ".env")

	if err != nil {
		log.Fatalf("Error loading " + configpath + ".env file")
	}
}

func GetConfig(key string, tab string) string {

	return os.Getenv(tab + "_" + key)
}
