package validation

import (
	"reflect"
	"regexp"

	"golang.org/x/exp/slices"
)

func IsValidUUID(uuid string) bool {
	r := regexp.MustCompile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")
	return r.MatchString(uuid)
}

func TagValidation(tagtype string, templateid string, status string, isdelete string) bool {
	if tagtype != "" && templateid != "" && status == "1" && isdelete == "" {

		arrayerr := []bool{reflect.TypeOf(tagtype).Kind() == reflect.String, IsValidUUID(templateid)}
		return !slices.Contains(arrayerr, false)
	}
	return false
}
func TemplateValidation(settings string, status string, isdelete string) bool {
	if settings != "" && status == "1" && isdelete == "" {
		arrayerr := []bool{reflect.TypeOf(settings).Kind() == reflect.String}
		return !slices.Contains(arrayerr, false)
	}
	return false
}
func InstreamValidation(Inlinecontect string) bool {
	if Inlinecontect != "" {
		arrayerr := []bool{reflect.TypeOf(Inlinecontect).Kind() == reflect.String}
		return !slices.Contains(arrayerr, false)
	}
	return false
}

func AdunitValidation(adunittype string, envtype string, width int, height int, status string, isdelete string, environment string) bool {
	if adunittype != "" && width != 0 && height != 0 && status == "1" && isdelete == "" && envtype == environment {
		arrayerr := []bool{reflect.TypeOf(adunittype).Kind() == reflect.String, reflect.TypeOf(width).Kind() == reflect.Int, reflect.TypeOf(height).Kind() == reflect.Int}
		return !slices.Contains(arrayerr, false)
	}
	return false
}

func PublisherValidation(domain string, sellerid string, status string, isdelete string) bool {
	if status == "1" && isdelete == "" {
		return true
	}
	return false
}

func AdsourceValidation(adformt string, srcobj string, adtype string, Bidprice string, filename string, provider string, width int, height int, status string, isdelete string, adsenv string, usrenv string) bool {
	if adformt != "" && srcobj != "" && adtype != "" && Bidprice != "" && provider != "" && status == "1" && isdelete == "" && adsenv != "" && usrenv != "" && adsenv == usrenv {
		arrayerr := []bool{reflect.TypeOf(width).Kind() == reflect.Int, reflect.TypeOf(height).Kind() == reflect.Int}
		return !slices.Contains(arrayerr, false)
	}
	return false
}

func CappingValidation(starttime int, endtime int, pacing string, count int, interval string) bool {
	if pacing != "" && interval != "" && count != 0 {
		arrayerr := []bool{reflect.TypeOf(starttime).Kind() == reflect.Int, reflect.TypeOf(endtime).Kind() == reflect.Int, reflect.TypeOf(pacing).Kind() == reflect.String, reflect.TypeOf(interval).Kind() == reflect.String, reflect.TypeOf(count).Kind() == reflect.Int}
		return !slices.Contains(arrayerr, false)
	}
	return false
}
