package structure

import (
	"net/http"
)

type AdmaruOutput struct {
	R                     *http.Request
	Adunit_id             string
	Adunit_details        AdUnitDetails
	Provider_id           string
	Tag_id                string
	Tag_Generation        TagGeneration
	Temp_Generation       TempGeneration
	Banner_Template       Tagsettings
	OutstreamTemplate     Outstream_Template
	InstreamTemplate      Instream_Template
	Provider_Details      ProviderDetails
	Globalvariable        GlobalVariables
	PublisherDetails      PublisherDetails
	Publisher_id          string
	ImpUrl                string
	ClickUrl              string
	CORSDomain            string
	Html                  string
	Adunit_type           string
	Priority_Level        int
	Priority_Call         int
	Priority_Next         int
	Adsource_details      []AdSourceDetails
	Adsource_id           string
	ScreenRes             string
	Playertype            string
	Request               *http.Request
	Response              http.ResponseWriter
	Autorefreshrand       string
	Capping               string
	ArrayOfCapping        map[string]string
	Addelivery_Tag        string
	PrgrmPrice            float64
	DrtPrice              float64
	MultiadPrebidCal      string
	MultiadPrebidCPM      string
	MultiadWinAdType      int
	MultiAdformatPriority int
	Autorefresh           string
	DeliveryAdType        string
	Js                    string
	Account_currency      string
	Bidding_currency      string
	AdapterHTML           string
	AdapterPrice          string
	AdapterAdtype         string
	AdapterVASTtag        string
	AdapterVastTracking   string
	AdapterVASTImpression string
	AdapterVASTClick      string
	AdapterTrackingURL    string
	AdapterDeliverAdType  string
	Request_Id            string
	Prebid_Resonse        string
	Is_Prebidwon          string
	Bidding_price         string
	Viewable_Html         string
	Viewable_Imp          string
	Viewable_Enable       string
	Viewable_Rand         string
	Drtadsource           []AdSourceDetails
	DrtadsourceRes        []AdSourceDetails
	Prgrmadsource         []AdSourceDetails
	PrgrmadsourceRes      []AdSourceDetails
	MPadsource            []AdSourceDetails
	RTBAdsources          []AdSourceDetails
	RTBAdsourcesRes       []AdSourceDetails
	PrebidAdsources       []AdSourceDetails
	MPRTBAdsources        []AdSourceDetails
	MPPrebidAdsources     []AdSourceDetails
	MultiAdFinalDir       AdSourceDetails
	MultiAdFinalRTB       RTBResponse
	AdapterFinalAdsource  AdSourceDetails
	Video_Temp            Video_Template
	Multiads              bool
	MarketPlaceAds        bool
	Internal_ad           bool
	External_ad           bool
	MultiAdFormat         bool
	PrebidConnected       bool
	NextPriority          bool
	AdDelivered           bool
	Viewable_Tagid        string
	VastRetry_Enable      string
	Is_Libload            string
	Is_Multiadformat      bool
	Videovastadtype       string
	Videovastresponsetype string
	Impcap                string
	Passbackcall          string
	Is_vastretry          string
	DFP_Delivery          string
	FinalAdsourceType     string
}

type Video_Template struct {
	Height int
	Width  int
}
type TagGeneration struct {
	Publisher_id     string `redis:"publisher_id"`
	Banner_Adunit_id string `redis:"banner_adunit_id"`
	Tag_Type         string `redis:"tag_type"`
	Name             string `redis:"name"`
	Status           string `redis:"status"`
	Video_Adunit_id  string `redis:"video_adunit_id"`
	Tag_id           string `redis:"tag_id"`
	Template_id      string `redis:"template_id"`
	Is_Deleted       string `json:"is_deleted"`
}

type TempGeneration struct {
	Template_id    string `redis:"template_id"`
	Publisher_id   string `redis:"publisher_id"`
	Template_type  string `redis:"template_type"`
	Name           string `redis:"name"`
	Status         string `redis:"status"`
	Settings       string `redis:"settings"`
	Is_Deleted     string `json:"is_deleted"`
	Inline_Content string `json:"inline_contents"`
}

type Tagsettings struct {
	Size     string   `json:"size"`
	Refresh  Refresh  `json:"refresh"`
	Passback Passback `json:"Passback"`
	Height   int
	Width    int
}

type Refresh struct {
	Enabled bool
	Rate    string `json:"rate"`
	MaxImp  string `json:"maxImp"`
}

type AdUnitDetails struct {
	Adunit_id    string `redis:"adunit_id"`
	Adunit_type  string `redis:"adunit_type"`
	Envtype      string `redis:"envtype"`
	Status       string `redis:"status"`
	Banner_Size  string `redis:"banner_size"`
	Name         string `redis:"name"`
	Height       int
	Width        int
	Tracker_Data []Tracker_Data
	Publisher    string `redis:"publisher"`
	Is_Deleted   string `json:"is_deleted"`
}

type AdSourceDetails struct {
	Adsourceid      string `json:"adsourceid"`
	Adformat        string `json:"adformat"`
	Src_Obj         string `json:"src_obj"`
	Env_Type        string `json:"env_type"`
	Status          string `json:"status"`
	Provider        string `json:"provider"`
	ProviderSrc     string `json:"Endpoint_Url"`
	Capping_Json    string `json:"capping"`
	Publisher       string `json:"publisher"`
	Banner_Size     string `json:"banner_size"`
	Adtype          string `json:"adtype"`
	Thirdpartytag   string `json:"thirdpartytag"`
	Bidprice        string `json:"bidprice"`
	FileName        string `json:"filename"`
	Name            string `json:"name"`
	Is_Deleted      string `json:"is_deleted"`
	Owned_by        string `json:"owned_by"`
	Height          int
	Width           int
	Capping         ImpCapping
	AutoRefCapping  string
	Request_id      string
	Provider_Src_id string
	TargetData      TargetingData
	Tracker_Data    []Tracker_Data
	Cookie_Sync_url string `json:"cookie_sync_url"`
}

type AdsourceCheck struct {
	Adformat string `json:"adformat"`
	Env_Type string `json:"env_type"`
	Bidprice string `json:"bidprice"`
}

type Adunit_Tracker struct {
	Adunit_id  string `redis:"Adunit_Id"`
	Tracker_id string `redis:"Tracker_Id"`
	Data       []Tracker_Data
}

type Adsource_Tracker struct {
	Adsource_id string `redis:"Source_Id"`
	Tracker_id  string `redis:"Tracker_Id"`
	Data        []Tracker_Data
}

type Tracker_Data struct {
	Event        string `json:"event"`
	Tracker_type string `json:"tracker_type"`
	Tracker_src  string `json:"tracker_src"`
}

type ImpCapping struct {
	Pacing    string   `json:"pacing"`
	Cappings  Capping  `json:"capping"`
	Durations Duration `json:"duration"`
}

type Capping struct {
	Count    int    `json:"count"`
	Intervel string `json:"interval"`
}

type Duration struct {
	EndHour   int `json:"end_hour"`
	StartHour int `json:"start_hour"`
}

type BannerSize struct {
	Height string
	Width  string
}

type ConnAdSourceDetails struct {
	Adsourceid string `json:"adsourceid"`
}

type ConnAdunitDetails struct {
	Priorty_1 []ConnAdSourceDetails
	Priorty_2 []ConnAdSourceDetails
	Priorty_3 []ConnAdSourceDetails
	Priorty_4 []ConnAdSourceDetails
	Priorty_5 []ConnAdSourceDetails
}

type ConnMarketAdSourceDetails struct {
	MarketAdsourceid string `json:"marketplaceid"`
}

type MarketPlaceConnAdunitDetails struct {
	Priorty_1 []ConnMarketAdSourceDetails
	Priorty_2 []ConnMarketAdSourceDetails
	Priorty_3 []ConnMarketAdSourceDetails
	Priorty_4 []ConnMarketAdSourceDetails
	Priorty_5 []ConnMarketAdSourceDetails
}

type ConnectedADSInMarketPlace struct {
	Adsources []ConnAdSourceDetails
}

type ProviderDetails struct {
	Provider_id  string `redis:"provider_id"`
	Type         string `redis:"type"`
	ProviderSrc  string `redis:"providersrc"`
	Descrption   string `redis:"descrption"`
	Publisher_id string `redis:"publisher_id"`
	Status       string `redis:"status"`
	Is_Deleted   string `json:"is_deleted"`
}

type GlobalVariables struct {
	R               *http.Request
	Ip_address      string
	Latitude        string
	Longitude       string
	Country_code    string
	Country_name    string
	Subdivision_one string
	Subdivision_two string
	Continent       string
	City            string
	Postal_code     string
	UsMetro         string
	Organisation    string
	ConnectionType  string
	Useragent       string
	DeviceName      string
	DeviceModel     string
	DeviceType      string
	Environment     string
	Os              string
	Osv             string
	OsShort         string
	Language        string
	Domain          string
	Browser         string
	BrowserVersion  string
	BrowserShort    string
	Hostname        string
	PageURL         string
	RefURL          string
	DomainName      string
	Source          string
	Timezone        string
}

type PublisherDetails struct {
	Publisher_Id   string `redis:"publisher_id"`
	Publisher_Name string `redis:"name"`
	Email          string `redis:"email"`
	Website        string `redis:"website"`
	Company        string `redis:"company"`
	Country_code   string `redis:"country_code"`
	Country_name   string `redis:"country_name"`
	Description    string `redis:"description"`
	Role_Type      string `redis:"roletype"`
	Status         string `redis:"status"`
	Level          string `redis:"level"`
	Owner_id       string `redis:"owner_id"`
	//newly add
	Account_CUR      string           `redis:"account_cur"`
	Biding_CUR       string           `redis:"biding_cur"`
	Is_Deleted       string           `json:"is_deleted"`
	Publisher_Seller Publisher_Seller `json:"publisher_seller"`
}

type Publisher_Seller struct {
	Publisher_seller_id string `json:"publisher_seller_id"`
	Domain              string `json:"domain"`
	Publisher_id        string `json:"publisher_id"`
	Seller_id           string `json:"seller_id"`
	Seller_name         string `json:"seller_name"`
	Seller_type         string `json:"seller_type"`
}

type Payment_Settings struct {
	Video_serving_fee  string `redis:"video_serving_fee"`
	Banner_serving_fee string `redis:"banner_serving_fee"`
	Video_req_fee      string `redis:"video_req_fee"`
	Revenue_share      string `redis:"revenue_share"`
}

type Publisher_Settings struct {
	Account_currency string `redis:"account_currency"`
	Bidding_currency string `redis:"bidding_currency"`
}

type Currency struct {
	Cur_unit string
	Data     []Currency_data
}

type Currency_data struct {
	Result          int    `json:"result"`
	Currency_unit   string `json:"cur_unit"`
	Ttb             string `json:"ttb"`
	Tts             string `json:"tts"`
	Deal_base_r     string `json:"deal_bas_r"`
	Bkpr            string `json:"bkpr"`
	Yy_efee_r       string `json:"yy_efee_r"`
	Ten_dd_efee_r   string `json:"ten_dd_efee_r"`
	Kftc_bkpr       string `json:"kftc_bkpr"`
	Kftc_deal_bas_r string `json:"kftc_deal_bas_r"`
	Currency_nm     string `json:"cur_nm"`
}

type PrebidPublisherid struct {
	PubId string
}

type ProviderSrc struct {
	EndPoint_Url string
}

// deomo
type REs struct {
	Ads struct {
		Bidderid       int `json:"Bidderid"`
		At             int `json:"at"`
		SeconBidBuffer int `json:"seconBidBuffer"`
		Response       struct {
			ID      string `json:"id"`
			Seatbid []struct {
				Bid []struct {
					ID      string   `json:"id"`
					Impid   string   `json:"impid"`
					Price   float64  `json:"price"`
					Adid    string   `json:"adid"`
					Nurl    string   `json:"nurl"`
					Burl    string   `json:"burl"`
					Lurl    string   `json:"lurl"`
					Adm     string   `json:"adm"`
					Adomain []string `json:"adomain"`
					Cid     string   `json:"cid"`
					Crid    string   `json:"crid"`
					H       int      `json:"h"`
					W       int      `json:"w"`
					Ext     struct {
						Btype int `json:"btype"`
					} `json:"ext"`
				} `json:"bid"`
				Seat string `json:"seat"`
			} `json:"seatbid"`
			Bidid string `json:"bidid"`
			Cur   string `json:"cur"`
			Ext   struct {
				Pixelurl string `json:"pixelurl"`
			} `json:"ext"`
		} `json:"Response"`
	} `json:"ads"`
}

type RTBsrc struct {
	Endpoint string `json:"endpoint"`
}

/************BidderIdChecker*******************/
type BidderChecker struct {
	BidderId string `json:"bidder"`
}

/*************Prebid Provider Src Params start MK***********************/

/******Rubicon Param*********************/
type Rubicon struct {
	Bidder string        `json:"bidder"`
	Param  ParamsRubicon `json:"params"`
}

type ParamsRubicon struct {
	Zoneid    int `json:"zoneId"`
	Siteid    int `json:"siteId"`
	Accountid int `json:"accountId"`
}

/***************IX bidder****************************/
type IXBidder struct {
	Bidder string   `json:"bidder"`
	Param  ParamsIX `json:"params"`
}

type ParamsIX struct {
	SiteId string `json:"siteId"`
}

/***************Pubmatic bidder*********************/
type PubmaticBidder struct {
	Bidder string         `json:"bidder"`
	Param  ParamsPubmatic `json:"params"`
}

type ParamsPubmatic struct {
	PublisherId string `json:"publisherId"`
	Adslot      string `json:"adSlot"`
}

/***************Criteo bidder****************************/
type CriteoBidder struct {
	Bidder string       `json:"bidder"`
	Param  ParamsCriteo `json:"params"`
}

type ParamsCriteo struct {
	ZoneId    int `json:"zoneId"`
	NetworkId int `json:"networkId"`
}

/***************TripleLift bidder****************************/
type TripleLiftBidder struct {
	Bidder string           `json:"bidder"`
	Param  ParamsTripleLift `json:"params"`
}
type ParamsTripleLift struct {
	InventoryCode string `json:"inventoryCode"`
}

/***************Conversant(Epsilon) bidder****************************/
type ConversantBidder struct {
	Bidder string           `json:"bidder"`
	Param  ParamsConversant `json:"params"`
}

type ParamsConversant struct {
	Site_id string `json:"site_id"`
	Secure  int    `json:"secure"`
	Tag_id  string `json:"tag_id"`
}

/***************Sovrn bidder****************************/
type SovrnBidder struct {
	Bidder string      `json:"bidder"`
	Param  ParamsSovrn `json:"params"`
}

type ParamsSovrn struct {
	Tagid string `json:"tagid"`
}

/***************OneTag bidder****************************/
type OneTagBidder struct {
	Bidder string       `json:"bidder"`
	Param  ParamsOneTag `json:"params"`
}

type ParamsOneTag struct {
	PubId string `json:"pubId"`
}

/***************SmartAdServer bidder****************************/
type SmartAdServerBidder struct {
	Bidder string              `json:"bidder"`
	Param  ParamsSmartAdServer `json:"params"`
}

type ParamsSmartAdServer struct {
	SiteId   int    `json:"siteId"`
	PageId   int    `json:"pageId"`
	FormatId int    `json:"formatId"`
	Domain   string `json:"domain"`
}

/***************YahooSSP bidder****************************/
type YahooSSPBidder struct {
	Bidder string         `json:"bidder"`
	Param  ParamsYahooSSP `json:"params"`
}

type ParamsYahooSSP struct {
	PubId string `json:"pubId"`
}

/***************UCFunnel bidder****************************/
type UCFunnelBidder struct {
	Bidder string         `json:"bidder"`
	Param  ParamsUCFunnel `json:"params"`
}

type ParamsUCFunnel struct {
	Adid string `json:"adid"`
}

/***************152Media(onefiftytwomedia) bidder****************************/
type OnefiftytwomediaBidder struct {
	Bidder string                 `json:"bidder"`
	Param  ParamsOnefiftytwomedia `json:"params"`
}

type ParamsOnefiftytwomedia struct {
	Aid int `json:"aid"`
}

/***************AdMixer bidder****************************/
type AdMixerBidder struct {
	Bidder string        `json:"bidder"`
	Param  ParamsAdMixer `json:"params"`
}

type ParamsAdMixer struct {
	AdspaceId string `json:"adspaceId"`
}

/***************NHNACE bidder****************************/
type NHNACEBidder struct {
	Bidder string       `json:"bidder"`
	Param  ParamsNHNACE `json:"params"`
}

type ParamsNHNACE struct {
	AdspaceId string `json:"adspaceId"`
}

/*************Prebid Provider Src Params end MK***********************/

type PrebidUrls struct {
	BidderName       string `json:"bidder_name"`
	Endpoint_Url     string `json:"endpoint_url"`
	Method           string `json:"method"`
	Payload          string `json:"payload"`
	Track_Response   string `json:"track_response_states"`
	Track_Impression string `json:"track_imp_states"`
	Track_Win        string `json:"track_win_states"`
	Track_Click      string `json:"track_click_states"`
}

// Targeting struct

type TargetingData struct {
	OS         []int          `json:"os"`
	Country    []string       `json:"country"`
	Enviroment []int          `json:"environment"`
	DaysHours  []DayWithHours `json:"daysHours"`
}

type DayWithHours struct {
	Day      int      `json:"day"`
	AllDay   bool     `json:"allDay"`
	Excludes []string `json:"excludes"`
}

type OSValue struct {
	OS_val string
}

type Outstream_Template10 struct {
	MaxWidth        int                    `json:"maxWidth,omitempty"`
	MinHeight       int                    `json:"minHeight,omitempty"`
	PlayerMode      map[string]interface{} `json:"playerMode,omitempty"`
	PlayerInterface map[string]interface{} `json:"playerInterface,omitempty"`
	MaxImpression   int                    `json:"maxImpression,omitempty"`
	AutoPlay        string                 `json:"autoPlay,omitempty"`
	ZIndex          int                    `json:"zIndex,omitempty"`
	InIframe        bool                   `json:"inIframe,omitempty"`
	LogoVideo       map[string]interface{} `json:"LogoVideo,omitempty"`
	Passback        map[string]interface{} `json:"Passback,omitempty"`
}

type Outstream_Template struct {
	ZIndex          int             `json:"zIndex"`
	TempPassback    TempPassback    `json:"Passback"`
	AutoPlay        bool            `json:"autoPlay"`
	InIframe        bool            `json:"inIframe"`
	MaxWidth        int             `json:"maxWidth"`
	MinWidth        int             `json:"minHeight"`
	LogoVideo       LogoVideo       `json:"LogoVideo"`
	PlayerMode      PlayerMode      `json:"playerMode"`
	Skip            Skip            `json:"skip"`
	MaxImpression   int             `json:"maxImpression"`
	PlayerInterface PlayerInterface `json:"playerInterface"`
	Responsive      Responsive      `json:"mobileView"`
	VastRetry       int             `json:"vastRetry"`
	ReminderZindex  ReminderZindex  `json:"reminderZindex"`
}

type ReminderZindex struct {
	ZIndexBool  bool   `json:"reminderZindex"`
	ZIndexId    string `json:"zindexId"`
	ZindexValue string `json:"zindexValue"`
}

// Instream Template
type Instream_Template struct {
	Loop            int             `json:"loop"`
	AutoCountinue   int             `json:"autocontinue"`
	AutoPlay        bool            `json:"autoPlay"`
	MaxWidth        int             `json:"maxWidth"`
	MinWidth        int             `json:"minWidth"`
	LogoVideo       LogoVideo       `json:"LogoVideo"`
	PlayerMode      PlayerMode      `json:"playerMode"`
	PlayerInterface PlayerInterface `json:"playerInterface"`
}

type Passback struct {
	URL            string `json:"url"`
	LinkOrTag      string `json:"linkOrTag"`
	DestinationUrl string `json:"destination_url"`
}
type LogoVideo struct {
	LogoLink         string `json:"logoLink"`
	LogoVideo        bool   `json:"LogoVideo"`
	LogoClickthrough string `json:"logoClickthrough"`
	LogoWidth        int    `json:"logoWidth"`
	LogoHeight       int    `json:"logoHeight"`
}
type PlayerMode struct {
	InView          int    `json:"inView"`
	Location        string `json:"location"`
	FloatType       string `json:"floatType"`
	PlayerMode      string `json:"playerMode"`
	PlayOnview      bool   `json:"playOnview"`
	PlayModeView    int    `json:"playModeView"`
	SideViewWidth   string `json:"sideviewWidth"`
	SideViewHeight  string `json:"sideviewHeight"`
	LeftMargin      int    `json:"leftMargin"`
	RightMargin     int    `json:"rightMargin"`
	BottomMargin    int    `json:"bottomMargin"`
	RemainderWidth  int    `json:"remainderWidth"`
	RemainderHeight int    `json:"remainderHeight"`
}
type PlayerInterface struct {
	CloseButton     bool `json:"closeButton"`
	ReplayButton    bool `json:"replayButton"`
	PlayerInterface bool `json:"playerInterface"`
}

type Skip struct {
	Skip     bool   `json:"skip"`
	SkipText string `json:"skip_text"`
	SkipTime int    `json:"skip_time"`
}

type VastWrapper struct {
	Vassttag string `json:"vassttag"`
	Name     string `json:"name"`
	Adunitid string `json:"adunitid"`
	Clickurl string `json:"clickurl"`
	Impurl   string `json:"impurl"`
	Track    string `json:"track"`
}

type MarketPlaceDetails struct {
	Marketplace_id string `json:"marketplace_id"`
	Status         string `json:"status"`
	Publisher      string `json:"publisher"`
	Name           string `json:"name"`
}

type MarketPlace struct {
	Marketplace_id string `json:"marketplace_id"`
	Created_by     string `json:"createdby"`
	Updated_at     string `json:"updated_at"`
	Created_at     string `json:"created_at"`
	Description    string `json:"description"`
	Publisher      string `json:"publisher"`
	Status         string `json:"status"`
	Name           string `json:"name"`
	Updated_by     string `json:"updated_by"`
	Is_Deleted     string `json:"is_deleted"`
}

/*******************RTB Test res**************************/
type RTBResponse struct {
	Ads Ads `json:"ads"`
}
type Ads struct {
	Bidderid       int      `json:"Bidderid,omitempty"`
	At             int      `json:"at,omitempty"`
	SeconBidBuffer int      `json:"seconBidBuffer,omitempty"`
	Adtype         int      `json:"adtype,omitempty"`
	CookieSync_URL string   `json:"cookiesync_url,omitempty"`
	Floor_Price    float64  `json:"floor_price,omitempty"`
	Response       Response `json:"Response,omitempty"`
}
type Response struct {
	Bidid    string       `json:"bidid,omitempty"`
	Cur      string       `json:"cur,omitempty"`
	Ext      Ext          `json:"ext,omitempty"`
	ID       string       `json:"id,omitempty"`
	Seatbid  []Seatbid    `json:"seatbid,omitempty"`
	Tracking TrackingData `json:"Tracking,omitempty"`
}

type Ext struct {
	Syncurls []string `json:"syncurls"`
	Btype    int      `json:"btype,omitempty"`
}
type Bid struct {
	ID      string   `json:"id,omitempty"`
	Impid   string   `json:"impid,omitempty"`
	Price   float64  `json:"price,omitempty"`
	Adid    string   `json:"adid,omitempty"`
	Nurl    string   `json:"nurl,omitempty"`
	Burl    string   `json:"burl,omitempty"`
	Lurl    string   `json:"lurl,omitempty"`
	Adm     string   `json:"adm,omitempty"`
	Adomain []string `json:"adomain,omitempty"`
	Cid     string   `json:"cid,omitempty"`
	Crid    string   `json:"crid,omitempty"`
	H       int      `json:"h,omitempty,omitempty"`
	W       int      `json:"w,omitempty"`
	Ext     Ext      `json:"ext,omitempty"`
}
type Seatbid struct {
	Bid  []Bid  `json:"bid,omitempty"`
	Seat string `json:"seat,omitempty"`
}
type TrackingData struct {
	Adsource_Id    string
	Request_Id     string
	Provider_Id    string
	ProviderSrc_Id string
	Owned_by       string
}

type SupplychainPrebid struct {
	Schain Schain `json:"schain"`
}
type Schain struct {
	Validation string        `json:"validation"`
	Config     Configuration `json:"config"`
}

type Configuration struct {
	Version  string  `json:"ver"`
	Complete int     `json:"complete"`
	Node     []Nodes `json:"nodes"`
}

type Nodes struct {
	ASI string `json:"asi"`
	SID string `json:"sid"`
	HP  int    `json:"hp"`
}
type Responsive struct {
	ResponsiveSize    bool `json:"responsiveSize"`
	MobileView        bool `json:"mobileView"`
	ResponsiveRemSize bool `json:"responsiveRemSize"`
}

type TempPassback struct {
	URL            string `json:"url"`
	DFP            DFP    `json:"dfp"`
	LinkOrTag      string `json:"linkOrTag"`
	DestinationUrl string `json:"destination_url"`
}

type DFP struct {
	DFP     bool   `json:"dfp"`
	Slot_id string `json:"slot_id"`
	Div_id  string `json:"div_id"`
}

type ProviderCookieSync struct {
	Cookie_sync_url string `json:"cookie_sync_url"`
}
