package multiCurrency

import (
	"alpha/addelivery/fetching"
	"alpha/addelivery/helper"
	"alpha/addelivery/structure"
	"encoding/json"
	"fmt"
	"math"
	"strings"
)

func Convert_currency(bid_price float64, bid_cur string, acc_cur string) float64 {

	currency := structure.Currency_data{}

	var convert_price, krw float64
	resp := fetching.Cur_val("multicurrency")
	for k1, v1 := range resp {

		if k1 == "USD" || k1 == "KRW" {
			if k1 == "USD" {
				err := json.Unmarshal([]byte(v1), &currency)
				if err != nil {
					fmt.Println(err)
				}
				ttb := currency.Ttb
				ttb_val := strings.Replace(ttb, ",", "", -1)
				usd_ttb := helper.StringToFloat(ttb_val)
				krw = 1 / usd_ttb
			}
			if bid_cur == acc_cur {
				convert_price = bid_price
			} else if k1 == "USD" && acc_cur == "USD" && bid_cur == "KRW" {
				err := json.Unmarshal([]byte(v1), &currency)
				if err != nil {
					fmt.Println(err)
				}
				ttb := currency.Ttb
				ttb_val := strings.Replace(ttb, ",", "", -1)
				usd_ttb := helper.StringToFloat(ttb_val)
				convert_price = bid_price * usd_ttb
			} else if k1 == "KRW" && acc_cur == "KRW" && bid_cur == "USD" {
				err := json.Unmarshal([]byte(v1), &currency)
				if err != nil {
					fmt.Println(err)
				}
				convert_price = bid_price * krw
			}
		} else {
			continue
		}

	}
	convert_price = roundFloat(convert_price, 6)
	return convert_price
}

func roundFloat(val float64, precision uint) float64 {
	ratio := math.Pow(10, float64(precision))
	return math.Round(val*ratio) / ratio
}

func Convert_USD(bid_price float64, acc_cur string) float64 {

	currency := structure.Currency_data{}

	var convert_price, krw, usd_ttb float64
	resp := fetching.Cur_val("multicurrency")

	for k1, v1 := range resp {
		if k1 == "USD" {
			err := json.Unmarshal([]byte(v1), &currency)
			if err != nil {
				fmt.Println(err)
			}
			ttb := currency.Ttb
			ttb_val := strings.Replace(ttb, ",", "", -1)
			usd_ttb = helper.StringToFloat(ttb_val)
			krw = 1 / usd_ttb
		}
	}

	if acc_cur == "USD" {
		convert_price = bid_price

	} else if acc_cur == "KRW" {

		convert_price = bid_price * krw

	}

	convert_price = roundFloat(convert_price, 6)
	return convert_price

}
