package helper

import (
	"fmt"
	"math/rand"
	"net/http"
	"strconv"
	"strings"
	"time"
)

func GetUrlParam(r *http.Request, val string) string {

	value := r.URL.Query()[val]
	if len(value) != 0 {
		return value[0]
	} else {
		return ""
	}
}

// Function for generating random number
func RandNumber(len int) int {
	l := "1"
	for i := 0; i < len; i++ {
		l += "0"
	}
	stri, _ := strconv.Atoi(l)
	rand.Seed(time.Now().UnixNano())
	return rand.Intn(stri)
}

func RandToken(len int) string {
	b := make([]byte, len)
	rand.Read(b)
	return fmt.Sprintf("%x", b)
}

func IntToString(in int) string {

	return strconv.Itoa(in)
}

func StringToInt(str string) int {

	r, _ := strconv.Atoi(str)

	return r
}

func ArrayOfInttoString(a []int, delim string) string {

	return strings.Trim(strings.Join(strings.Split(fmt.Sprint(a), " "), delim), "[]")
}

func ConvertStrJsonToRawJson(jsonvalue []byte) string {

	jsonvaluee := strings.ReplaceAll(string(jsonvalue), "\\", "")
	jsonvalueee := strings.ReplaceAll(string(jsonvaluee), "u0026", "&")
	jsonvalueeee := strings.ReplaceAll(string(jsonvalueee), `"{`, "{")
	jsonvalueeeee := strings.ReplaceAll(string(jsonvalueeee), `}"`, "}")
	jsonvalueeeeee := strings.ReplaceAll(string(jsonvalueeeee), `"[`, "[")
	finaljson := strings.ReplaceAll(string(jsonvalueeeeee), `]"`, "]")

	return finaljson
}

func StringToFloat(str string) float64 {

	r, _ := strconv.ParseFloat(str, 64)

	return r
}
