package fetching

import (
	"alpha/addelivery/helper"
	"alpha/addelivery/structure"
	"alpha/redisclient"
	"encoding/json"
	"fmt"

	"strings"

	"github.com/mitchellh/mapstructure"
)

var redisrepo = redisclient.Initialize()

func FetchTagModel(tag_id string) structure.TagGeneration {

	tag := structure.TagGeneration{}
	hashmap := make(map[string]string)
	redisrepo.HGetKey("Tag_"+tag_id, hashmap)
	mapstructure.Decode(hashmap, &tag)
	return tag

}

func FetchTemplates(template_id string) structure.TempGeneration {
	taglist := structure.TempGeneration{}
	hashmap := make(map[string]string)
	redisrepo.HGetKey("tag_temp_"+template_id, hashmap)
	mapstructure.Decode(hashmap, &taglist)
	return taglist
}

func FetchAdunitModel(adunit_id string) structure.AdUnitDetails {
	adunit := structure.AdUnitDetails{}
	hashmap := make(map[string]string)
	redisrepo.HGetKey("AdUnit_"+adunit_id, hashmap)
	switch hashmap["adunit_type"] {
	case "1":

		mapstructure.Decode(hashmap, &adunit)
		Height, Width := FetchBannerSize(adunit.Banner_Size)
		adunit.Height = Height
		adunit.Width = Width

	case "2":

		mapstructure.Decode(hashmap, &adunit)
	}

	return adunit

}

func FetchAdsourceModel(adsource_id string) structure.AdSourceDetails {
	adsource := structure.AdSourceDetails{}
	hashmap := make(map[string]string)
	redisrepo.HGetKey("Adsource_"+adsource_id, hashmap)
	mapstructure.Decode(hashmap, &adsource)
	if err := json.Unmarshal([]byte(hashmap["capping"]), &adsource.Capping); err != nil {
		fmt.Println(err)
	}
	targetData := FetchingTargeting(adsource_id)
	adsource.TargetData = targetData
	switch hashmap["adformat"] {
	case "Banner":
		Height, Width := FetchBannerSize(adsource.Banner_Size)
		adsource.Height = Height
		adsource.Width = Width
	}

	return adsource
}

func FetchConnDetails(conn_id string) (structure.ConnAdunitDetails, []string) {
	connectedstruct := structure.ConnAdunitDetails{}
	hashmap := make(map[string]string)
	redisrepo.HGetKey("adunit_adsource_"+conn_id, hashmap)
	var prioritylevel []string
	for k, v := range hashmap {
		if k == "priority_1" {
			prioritylevel = append(prioritylevel, "priority_1")
			err := json.Unmarshal([]byte(v), &connectedstruct.Priorty_1)
			if err != nil {
				fmt.Println(err)
			}
		} else if k == "priority_2" {
			prioritylevel = append(prioritylevel, "priority_2")
			err := json.Unmarshal([]byte(v), &connectedstruct.Priorty_2)
			if err != nil {
				fmt.Println(err)
			}
		} else if k == "priority_3" {
			prioritylevel = append(prioritylevel, "priority_3")
			err := json.Unmarshal([]byte(v), &connectedstruct.Priorty_3)
			if err != nil {
				fmt.Println(err)
			}
		} else if k == "priority_4" {
			prioritylevel = append(prioritylevel, "priority_4")
			err := json.Unmarshal([]byte(v), &connectedstruct.Priorty_4)
			if err != nil {
				fmt.Println(err)
			}
		} else if k == "priority_5" {
			prioritylevel = append(prioritylevel, "priority_5")

			err := json.Unmarshal([]byte(v), &connectedstruct.Priorty_5)
			if err != nil {
				fmt.Println(err)
			}
		}

	}

	return connectedstruct, prioritylevel
}

func MarketPlaceFetchConnDetails(conn_id string) (structure.MarketPlaceConnAdunitDetails, []string) {
	connectedstruct := structure.MarketPlaceConnAdunitDetails{}
	hashmap := make(map[string]string)
	redisrepo.HGetKey("adunit_marketplace_"+conn_id, hashmap)
	var prioritylevel []string
	for k, v := range hashmap {
		if k == "priority_1" {
			prioritylevel = append(prioritylevel, "priority_1")
			err := json.Unmarshal([]byte(v), &connectedstruct.Priorty_1)
			if err != nil {
				fmt.Println(err)
			}
		} else if k == "priority_2" {
			prioritylevel = append(prioritylevel, "priority_2")
			err := json.Unmarshal([]byte(v), &connectedstruct.Priorty_2)
			if err != nil {
				fmt.Println(err)
			}
		} else if k == "priority_3" {
			prioritylevel = append(prioritylevel, "priority_3")
			err := json.Unmarshal([]byte(v), &connectedstruct.Priorty_3)
			if err != nil {
				fmt.Println(err)
			}
		} else if k == "priority_4" {
			prioritylevel = append(prioritylevel, "priority_4")
			err := json.Unmarshal([]byte(v), &connectedstruct.Priorty_4)
			if err != nil {
				fmt.Println(err)
			}
		} else if k == "priority_5" {
			prioritylevel = append(prioritylevel, "priority_5")
			err := json.Unmarshal([]byte(v), &connectedstruct.Priorty_5)
			if err != nil {
				fmt.Println(err)
			}
		}

	}
	return connectedstruct, prioritylevel
}

func FetchConnectedAdsInMarketPlace(market_ads_id string) structure.ConnectedADSInMarketPlace {
	connectedstruct := structure.ConnectedADSInMarketPlace{}
	hashmap := make(map[string]string)
	redisrepo.HGetKey("MarketPlaceAdsource_"+market_ads_id, hashmap)
	for k, v := range hashmap {
		if k == "connectedAds" {
			err := json.Unmarshal([]byte(v), &connectedstruct.Adsources)
			if err != nil {
				fmt.Println(err)
			}
		}
	}
	return connectedstruct
}

func FetchProviderDetails(providerid string) structure.ProviderDetails {
	provider := structure.ProviderDetails{}
	hashmap := make(map[string]string)
	redisrepo.HGetKey("Provider_"+providerid, hashmap)
	mapstructure.Decode(hashmap, &provider)
	return provider

}

func FetchPublisherDetails(publisher_id string) structure.PublisherDetails {
	publisher := structure.PublisherDetails{}
	hashmap := make(map[string]string)
	sellerhashmap := make(map[string]string)
	redisrepo.HGetKey("Publisher_"+publisher_id, hashmap)
	mapstructure.Decode(hashmap, &publisher)
	redisrepo.HGetKey("Publisher_seller"+publisher_id, sellerhashmap)
	mapstructure.Decode(sellerhashmap, &publisher.Publisher_Seller)
	return publisher

}

func FetchBannerSize(bannerid string) (int, int) {
	bannersize := structure.BannerSize{}
	redisrepo.HFGetKey(bannerid, &bannersize)
	Height := helper.StringToInt(bannersize.Height)
	Width := helper.StringToInt(bannersize.Width)
	return Height, Width

}

func FetchAdsourceTracker(adsource_id string) structure.Adsource_Tracker {
	tracker := structure.Adsource_Tracker{}
	hashmap := make(map[string]string)
	redisrepo.HGetKey("Adsource_Tracker_"+adsource_id, hashmap)
	for k, v := range hashmap {
		if k == "Source_Id" {
			mapstructure.Decode(v, &tracker.Adsource_id)
		}
		if k == "Tracker_Id" {
			mapstructure.Decode(v, &tracker.Tracker_id)
		}
		if k == "Trackers_Data" {
			err := json.Unmarshal([]byte(v), &tracker.Data)
			if err != nil {
				fmt.Println(err)
			}
		}
	}
	return tracker
}

func FetchAdunitTracker(adunit_id string) structure.Adunit_Tracker {
	tracker := structure.Adunit_Tracker{}
	hashmap := make(map[string]string)
	redisrepo.HGetKey("AdUnit_Tracker_"+adunit_id, hashmap)
	for k, v := range hashmap {
		if k == "Adunit_Id" {
			mapstructure.Decode(v, &tracker.Adunit_id)
		}
		if k == "Tracker_Id" {
			mapstructure.Decode(v, &tracker.Tracker_id)
		}
		if k == "Trackers_Data" {
			err := json.Unmarshal([]byte(v), &tracker.Data)
			if err != nil {
				fmt.Println(err)
			}
		}
	}
	return tracker
}

func ConvertJs(html string) string {

	var jsLines []string
	var search []string
	var replace []string

	search = append(search, "\\")
	search = append(search, "\r")
	search = append(search, "'")
	search = append(search, "<")

	replace = append(replace, "\\\\")
	replace = append(replace, "")
	replace = append(replace, "\\'")
	replace = append(replace, "<'+'")

	for i, element := range search {

		html = strings.ReplaceAll(html, element, replace[i])
	}

	lines := strings.Split(html, "\n")

	for _, e := range lines {

		if strings.Trim(e, "") != "" {

			jsLines = append(jsLines, strings.Trim(e, ""))

		}

	}

	buffer := "var ox_name ='" + strings.Join(jsLines, "") + "';"
	buffer = buffer + "\ndocument.write(ox_name);\n"
	return buffer

}

func GetPublisherDetails(adsourceSrc string) structure.PublisherDetails {
	publisher_id := adsourceSrc
	publisher := structure.PublisherDetails{}
	publisherDetails := FetchPublisherDetails(publisher_id)
	publisher = publisherDetails
	return publisher
}
func FetchingTargeting(adsourceid string) structure.TargetingData {
	targeting := structure.TargetingData{}
	redisrepo.GetKey("targetData_"+adsourceid, &targeting)
	return targeting
}

func FetchOS(OS_id string) structure.OSValue {
	os_val := structure.OSValue{}
	redisrepo.OSHFGetKey(OS_id, &os_val)

	return os_val

}

func FetchingPublisher_share(publisher_id string) structure.Payment_Settings {
	pub_share := structure.Payment_Settings{}
	hashmap := make(map[string]string)
	redisrepo.HGetKey("Payment_Settings_"+publisher_id, hashmap)
	mapstructure.Decode(hashmap, &pub_share)
	return pub_share
}
func FetchPub_settings(publisher_id string) structure.Publisher_Settings {
	currency := structure.Publisher_Settings{}
	hashmap := make(map[string]string)
	redisrepo.HGetKey("Settings_"+publisher_id, hashmap)
	mapstructure.Decode(hashmap, &currency)
	return currency
}

func Cur_val(key string) map[string]string {
	hashmap := make(map[string]string)
	redisrepo.HGetKey(key, hashmap)
	return hashmap
}

func FetchMarketplace(marketplaceid string) structure.MarketPlace {
	marketplace := structure.MarketPlace{}
	hashmap := make(map[string]string)
	redisrepo.HGetKey("MarketPlace_"+marketplaceid, hashmap)
	mapstructure.Decode(hashmap, &marketplace)
	return marketplace
}

func FetchProviderCookieSync(providersrcid string) structure.ProviderCookieSync {
	provider := structure.ProviderCookieSync{}
	hashmap := make(map[string]string)
	redisrepo.GetKeyByField(providersrcid, "provider_source", hashmap)
	mapstructure.Decode(hashmap, &provider)

	return provider
}
