package deliverylimitation

import (
	"alpha/addelivery/fetching"
	"alpha/addelivery/globalvariaables"
	"alpha/addelivery/structure"
	"net/http"
	"strconv"
	"strings"
	"time"
)

type DeliverLimitStruct struct {
	R               *http.Request
	Ip_address      string
	Latitude        string
	Longitude       string
	Country_code    string
	Country_name    string
	Subdivision_one string
	Subdivision_two string
	Continent       string
	City            string
	Postal_code     string
	UsMetro         string
	Organisation    string
	ConnectionType  string
	Useragent       string
	Os              string
	Osv             string
	OsShort         string
	Language        string
	Domain          string
	Browser         string
	BrowserVersion  string
	BrowserShort    string
	Hostname        string
	PageURL         string
	RefURL          string
	DomainName      string
	Device          string
	DeviceName      string
	DeviceModel     string
	Source          string
	Timezone        string
}

func CheckAcls(targetInfo structure.TargetingData, r *http.Request) bool {

	var OSCheck, countryCheck, deviceCheck, tagetCheck, daysHoursCheck bool

	globalvariables := globalvariaables.SetAllGrobalVariables(r)
	op := "=~"
	countryData := targetInfo.Country
	osData := targetInfo.OS
	deviceData := targetInfo.Enviroment
	tagetCheck = false
	daysHours := targetInfo.DaysHours
	var DeviceVal []string
	var fetchingOs []string
	if len(countryData) == 0 && len(osData) == 0 && len(deviceData) == 0 && len(daysHours) == 0 {
		tagetCheck = true
	}
	Deliverylimitation := DeliverLimitStruct{
		R:               globalvariables.R,
		Ip_address:      globalvariables.Ip_address,
		Latitude:        globalvariables.Latitude,
		Longitude:       globalvariables.Longitude,
		Country_code:    globalvariables.Country_code,
		Country_name:    globalvariables.Country_name,
		Subdivision_one: globalvariables.Subdivision_one,
		Continent:       globalvariables.Continent,
		City:            globalvariables.City,
		Useragent:       globalvariables.Useragent,
		Os:              globalvariables.Os,
		Osv:             globalvariables.Osv,
		OsShort:         globalvariables.OsShort,
		Language:        globalvariables.Language,
		Domain:          globalvariables.Domain,
		Browser:         globalvariables.Browser,
		BrowserVersion:  globalvariables.BrowserVersion,
		BrowserShort:    globalvariables.BrowserShort,
		Hostname:        globalvariables.Hostname,
		PageURL:         globalvariables.PageURL,
		RefURL:          globalvariables.RefURL,
		DomainName:      globalvariables.DomainName,
		Device:          globalvariables.DeviceType,
		DeviceName:      globalvariables.DeviceName,
		DeviceModel:     globalvariables.DeviceModel,
		Source:          globalvariables.Source,
		Timezone:        globalvariables.Timezone}

	// Country targeting changes
	if len(countryData) != 0 {
		countryCheck = Country(countryData, op, Deliverylimitation.Country_code)

	} else {
		countryCheck = true
	}
	// OS targeting changes
	if len(osData) != 0 {

		for _, j := range osData {

			Osvalue := fetching.FetchOS(strconv.Itoa(j))
			fetchingOs = append(fetchingOs, Osvalue.OS_val)

		}

		OSCheck = Os(fetchingOs, op, Deliverylimitation.Os)

	} else {
		OSCheck = true
	}
	// Environment targeting changes
	if len(deviceData) != 0 {

		for _, i := range deviceData {

			if i == 1 {
				DeviceVal = append(DeviceVal, "Computer")
			}
			if i == 2 {
				DeviceVal = append(DeviceVal, "Phone")
			}
			if i == 3 {
				DeviceVal = append(DeviceVal, "Mobile App")
			}

		}

		for _, d := range DeviceVal {

			if d == Deliverylimitation.Device {
				deviceCheck = true
			}
		}

	} else {
		deviceCheck = true
	}

	if len(daysHours) != 0 {
		dhcheck := 0
		loc, _ := time.LoadLocation(Deliverylimitation.Timezone)
		now := time.Now().In(loc)

		res1 := strings.Split(now.Format(time.RubyDate), " ")
		dayArray := []string{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"}
		var userDay int
		for i, d := range dayArray {
			if strings.EqualFold(res1[0], d) {
				userDay = i
				break
			}
		}
		for _, dh := range daysHours {
			if dh.AllDay == false && userDay == dh.Day {
				for _, hr := range dh.Excludes {
					if hr == res1[3][0:2] {
						dhcheck = 1
						break
					}
				}
			}
		}
		if dhcheck == 1 {
			daysHoursCheck = false
		} else {
			daysHoursCheck = true
		}

	} else {
		daysHoursCheck = true
	}
	if countryCheck && OSCheck && deviceCheck && daysHoursCheck {
		tagetCheck = true
	}
	return tagetCheck
}

func Os(limitation []string, op string, val string) bool {

	result := CheckRealArrayValueMatch(limitation, val)

	switch op {
	case "=~":
		return result
	case "!~":
		return !result
	}

	return false
}

func Country(limitation []string, op string, val string) bool {

	result := CheckRealArrayValueMatch(limitation, val)

	switch op {
	case "=~":
		return result
	case "!~":
		return !result
	}

	return false
}

func CheckRealArrayValueMatch(limitation []string, val string) bool {

	for _, i := range limitation {

		if i == val {
			return true
			break
		}
	}

	return false

}
