package delivery

import (
	"alpha/addelivery/ad"
	"alpha/addelivery/adrtb"
	"alpha/addelivery/capping"
	"alpha/addelivery/multiCurrency"
	"analytics/clickClient"
	"bytes"
	"encoding/json"
	"math/rand"
	"sort"
	"sync"
	"unsafe"

	"alpha/addelivery/fetching"
	"alpha/addelivery/helper"
	config "alpha/configuration"
	"net/http"
	"time"

	"alpha/addelivery/structure"
	"fmt"
	"strconv"
	"strings"
)

func DirectAD(admaruoutput *structure.AdmaruOutput, directadsource []structure.AdSourceDetails, wg *sync.WaitGroup, w http.ResponseWriter, r *http.Request) {
	defer wg.Done()
	var finalads structure.AdSourceDetails
	Randomchecker := ArrayChecker(directadsource)
	finalads = HighestCPMCal(directadsource)
	admaruoutput.Adsource_id = finalads.Adsourceid
	admaruoutput.Provider_id = finalads.Provider
	admaruoutput.Publisher_id = finalads.Publisher
	if admaruoutput.Multiads != true && Randomchecker {
		if finalads.Capping.Pacing != "" {
			capping.CookieCapping(w, r, finalads.Capping, finalads)
		}
	}

	floor_price := finalads.Bidprice
	floor_price_float := helper.StringToFloat(floor_price)
	req_cur := multiCurrency.Convert_currency(floor_price_float, admaruoutput.Bidding_currency, admaruoutput.Account_currency)
	req_cur_str := fmt.Sprintf("%v", req_cur)
	finalads.Bidprice = req_cur_str
	switch {
	case Randomchecker:
		switch admaruoutput.Temp_Generation.Template_type {
		case "1":

			switch {
			case admaruoutput.Multiads == true:
				s, _ := strconv.ParseFloat(finalads.Bidprice, 64)
				admaruoutput.DrtPrice = s
				admaruoutput.MultiAdFinalDir = finalads
			default:
				if finalads.Adformat == "Banner" {
					ad.AdRender(finalads, admaruoutput)
				} else {
					ad.VideoAdRander(finalads, admaruoutput)
				}

			}
		case "2":
			inline := structure.Instream_Template{}
			json.Unmarshal([]byte(admaruoutput.Temp_Generation.Settings), &inline)
			switch {
			case admaruoutput.Multiads == true:
				s, _ := strconv.ParseFloat(finalads.Bidprice, 64)
				admaruoutput.DrtPrice = s
				admaruoutput.MultiAdFinalDir = finalads
			default:
				ad.VideoAdRander(finalads, admaruoutput)
			}

		case "3":
			switch {
			case admaruoutput.Multiads == true:
				s, _ := strconv.ParseFloat(finalads.Bidprice, 64)
				admaruoutput.DrtPrice = s
				admaruoutput.MultiAdFinalDir = finalads
			default:
				ad.VideoAdRander(finalads, admaruoutput)
			}

		}

	case !Randomchecker:
		switch {
		case admaruoutput.Multiads == true:
			s, _ := strconv.ParseFloat(finalads.Bidprice, 64)
			admaruoutput.DrtPrice = s
			admaruoutput.MultiAdFinalDir = finalads
		default:
			RandomAdDelivery(directadsource, admaruoutput, w, r)
		}
	default:
		admaruoutput.Internal_ad = false
	}

}

func ProgrammaticAd(admaruoutput *structure.AdmaruOutput, arrayRTBads []structure.AdSourceDetails, wg *sync.WaitGroup, r *http.Request, w http.ResponseWriter) {
	defer wg.Done()
	var mu sync.Mutex
	var VideoArray []structure.AdSourceDetails
	var BannerArray []structure.AdSourceDetails
	var RTBresar adrtb.ProgramaticRes

	var wg2 sync.WaitGroup
	var final adrtb.RTBResponse

	if len(arrayRTBads) != 0 {
		for _, ad := range arrayRTBads {
			switch ad.Adformat {
			case "Banner":
				BannerArray = append(BannerArray, ad)
			case "Video":
				VideoArray = append(VideoArray, ad)
			}
		}
		switch {
		case len(BannerArray) != 0 && len(VideoArray) != 0:
			wg2.Add(len(BannerArray) + len(VideoArray))
			for _, Sads := range BannerArray {
				go adrtb.GetRTBAd(admaruoutput, Sads, &RTBresar, &wg2, &mu)
			}
			for _, Sads := range VideoArray {
				go adrtb.GetRTBAd(admaruoutput, Sads, &RTBresar, &wg2, &mu)
			}
			wg2.Wait()

		case len(BannerArray) != 0:
			wg2.Add(len(BannerArray))
			for _, Sads := range BannerArray {
				go adrtb.GetRTBAd(admaruoutput, Sads, &RTBresar, &wg2, &mu)
			}
			wg2.Wait()

		case len(VideoArray) != 0:
			wg2.Add(len(VideoArray))
			for _, Sads := range VideoArray {
				go adrtb.GetRTBAd(admaruoutput, Sads, &RTBresar, &wg2, &mu)
			}
			wg2.Wait()
		}

		final = RTBResPriceCal(RTBresar.RTBResArray, admaruoutput)
		replacesmacros := MacrosReplace(final)
		errj := json.Unmarshal([]byte(replacesmacros), &final)
		if errj != nil {
			fmt.Println(errj)
		}
		if admaruoutput.Multiads == true {
			if len(final.Ads.Response.Seatbid) != 0 && len(final.Ads.Response.Seatbid[0].Bid) != 0 {
				admaruoutput.PrgrmPrice = final.Ads.Response.Seatbid[0].Bid[0].Price
			} else {
				admaruoutput.PrgrmPrice = 0
			}
			admaruoutput.MultiAdFinalRTB = *(*structure.RTBResponse)(unsafe.Pointer(&final))
		} else {
			finalRTBRes := *(*structure.RTBResponse)(unsafe.Pointer(&final))

			go RtbWinStats_N(finalRTBRes, admaruoutput)
			HighProgrammaticAdCal(finalRTBRes, admaruoutput, r, w)
		}

	}

}

func MultiAdBiddingCal(admaruoutput *structure.AdmaruOutput, r *http.Request, w http.ResponseWriter) {
	var prebidPrice float64
	var comparedir float64
	var winadtypearray []int

	if admaruoutput.MultiadPrebidCPM != "" {
		prebidPrice, _ = strconv.ParseFloat(admaruoutput.MultiadPrebidCPM, 64)
	} else {
		prebidPrice = 0
	}

	if admaruoutput.DrtPrice == 0 && admaruoutput.PrgrmPrice == 0 && prebidPrice == 0 {
		return
	}

	//Random ad delivery
	if prebidPrice == admaruoutput.PrgrmPrice && admaruoutput.PrgrmPrice == admaruoutput.DrtPrice {
		admaruoutput.MultiadWinAdType = rand.Intn(3)

	} else {
		if prebidPrice > admaruoutput.PrgrmPrice {
			comparedir = prebidPrice
			admaruoutput.MultiadWinAdType = 0
		} else {
			comparedir = admaruoutput.PrgrmPrice
			admaruoutput.MultiadWinAdType = 1
		}

		if admaruoutput.DrtPrice > comparedir {
			admaruoutput.MultiadWinAdType = 2
		} else if admaruoutput.DrtPrice == comparedir {
			winadtypearray = append(winadtypearray, admaruoutput.MultiadWinAdType, 2)
			admaruoutput.MultiadWinAdType = winadtypearray[rand.Intn(2)]
		}
	}

	if admaruoutput.DrtPrice == 0 && admaruoutput.PrgrmPrice == 0 && prebidPrice == 0 {

		return
	}

	switch admaruoutput.MultiadWinAdType {
	case 0:
		admaruoutput.Is_Prebidwon = "Yes"
		PrebidAd(admaruoutput.PrebidAdsources, admaruoutput)

		admaruoutput.AdDelivered = true
	case 1:

		res_cur := admaruoutput.MultiAdFinalRTB.Ads.Response.Cur

		if admaruoutput.Bidding_currency == res_cur {
			go RtbWinStats_N(admaruoutput.MultiAdFinalRTB, admaruoutput)
			HighProgrammaticAdCal(admaruoutput.MultiAdFinalRTB, admaruoutput, r, w)
		}
		admaruoutput.AdDelivered = true
	case 2:

		if admaruoutput.MultiAdFinalDir.Capping.Pacing != "" {
			capping.CookieCapping(w, r, admaruoutput.MultiAdFinalDir.Capping, admaruoutput.MultiAdFinalDir)
		}
		if admaruoutput.MultiAdFinalDir.Adformat == "Banner" {
			ad.AdRender(admaruoutput.MultiAdFinalDir, admaruoutput)
		} else if admaruoutput.MultiAdFinalDir.Adformat == "Video" {
			ad.VideoAdRander(admaruoutput.MultiAdFinalDir, admaruoutput)
		}
		admaruoutput.AdDelivered = true
		return
	}

}

func HighestCPMCal(adsource []structure.AdSourceDetails) structure.AdSourceDetails {

	adsarray := structure.AdSourceDetails{}

	adsarray = adsource[0]
	var price float64
	p, err := strconv.ParseFloat(adsarray.Bidprice, 64)
	if err != nil {
		fmt.Println(err)
	}
	price = p
	for i, v := range adsource {

		s, err := strconv.ParseFloat(v.Bidprice, 64)
		if err != nil {
			fmt.Println(err)
		}
		if price < s {
			adsarray = adsource[i]
			fp, err := strconv.ParseFloat(adsarray.Bidprice, 64)
			if err != nil {
				fmt.Println(err)
			}
			price = fp
		}
	}
	return adsarray

}

func RTBResPriceCal(arrayRTBres_2 []adrtb.RTBResponse, admaruoutput *structure.AdmaruOutput) adrtb.RTBResponse {
	finalres := adrtb.RTBResponse{}
	var secoundbid []adrtb.RTBResponse
	var arrayRTBres []adrtb.RTBResponse

	for _, k := range arrayRTBres_2 {
		res_cur := k.Ads.Response.Cur
		if admaruoutput.Bidding_currency == res_cur {
			arrayRTBres = append(arrayRTBres, k)
		}
	}

	if len(arrayRTBres) != 0 {
		finalres = arrayRTBres[0]
		if len(finalres.Ads.Response.Seatbid) != 0 && len(finalres.Ads.Response.Seatbid[0].Bid) != 0 {
			sort.Slice(arrayRTBres, func(i, j int) bool {
				return arrayRTBres[i].Ads.Response.Seatbid[0].Bid[0].Price > arrayRTBres[j].Ads.Response.Seatbid[0].Bid[0].Price
			})

			if len(arrayRTBres) >= 2 && arrayRTBres[0].Ads.At == 2 {

				for i := 1; i < len(arrayRTBres); i++ {
					if arrayRTBres[1].Ads.Response.Seatbid[0].Bid[0].Price == arrayRTBres[i].Ads.Response.Seatbid[0].Bid[0].Price {
						secoundbid = append(secoundbid, arrayRTBres[i])
					}
				}
				finalres = secoundbid[rand.Intn(len(secoundbid))]

			} else {
				finalres = arrayRTBres[0]
			}
			if finalres.Ads.Response.Seatbid[0].Bid[0].Price < finalres.Ads.Floor_Price {
				finalres = adrtb.RTBResponse{}
				return finalres
			}
			return finalres
		}

	}

	return finalres
}

func HighProgrammaticAdCal(responcertb structure.RTBResponse, admaruout *structure.AdmaruOutput, r *http.Request, w http.ResponseWriter) {

	if len(responcertb.Ads.Response.Seatbid) != 0 {
		if len(responcertb.Ads.Response.Seatbid[0].Bid) != 0 {

			switch {
			case admaruout.Multiads && responcertb.Ads.Adtype == 1 || !admaruout.Multiads && admaruout.Temp_Generation.Template_type == "1":
				admaruout.DeliveryAdType = "RTB"
				rand1 := helper.RandToken(5)
				if admaruout.Autorefreshrand != "" {
					rand1 = admaruout.Autorefreshrand
				} else {
					admaruout.Autorefreshrand = rand1
				}

				/**********Third Party Tracker Start**********/
				var impression1 string
				var impression2 string
				var impression3 string

				var viewimpression1 string
				var viewimpression2 string
				var viewimpression3 string

				var clicks1 string
				var clicks2 string
				var clicks3 string
				Adsource_id := responcertb.Ads.Response.Tracking.Adsource_Id
				adsoure := fetching.FetchAdsourceTracker(Adsource_id)

				if len(adsoure.Data) > 0 {

					for _, v := range adsoure.Data {

						Event := v.Event
						if Event == "1" {

							Tracker_type := v.Tracker_type

							if Tracker_type == "1" {

								impimg := strings.Replace(v.Tracker_src, "\n", "", -1)
								impimg = strings.Replace(impimg, `\`, ``, -1)

								impression1 += `<img src='` + impimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
							} else if Tracker_type == "2" {

								impsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
								impsrc2 = strings.Replace(impsrc2, `\`, ``, -1)
								impression2 += strings.Replace(impsrc2, "  ", " ", -1)

							} else if Tracker_type == "3" {

								impsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
								impsrc3 = strings.Replace(impsrc3, `\`, ``, -1)
								impression3 += strings.Replace(impsrc3, "  ", " ", -1)
							}
						}

						if Event == "2" {

							Tracker_type := v.Tracker_type

							if Tracker_type == "1" {

								viewimpimg := strings.Replace(v.Tracker_src, "\n", "", -1)
								viewimpimg = strings.Replace(viewimpimg, `\`, ``, -1)

								viewimpression1 += `<img src='` + viewimpimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
							} else if Tracker_type == "2" {

								viewimpsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
								viewimpsrc2 = strings.Replace(viewimpsrc2, `\`, ``, -1)
								viewimpression2 += strings.Replace(viewimpsrc2, "  ", " ", -1)

							} else if Tracker_type == "3" {

								viewimpsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
								viewimpsrc3 = strings.Replace(viewimpsrc3, `\`, ``, -1)
								viewimpression3 += strings.Replace(viewimpsrc3, "  ", " ", -1)
							}
						}

						if Event == "3" {

							Tracker_type := v.Tracker_type

							if Tracker_type == "1" {

								clicksimg := strings.Replace(v.Tracker_src, "\n", "", -1)
								clicksimg = strings.Replace(clicksimg, `\`, ``, -1)

								clicks1 += `<img src='` + clicksimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
							} else if Tracker_type == "2" {

								clickssrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
								clickssrc2 = strings.Replace(clickssrc2, `\`, ``, -1)
								clicks2 += strings.Replace(clickssrc2, "  ", " ", -1)

							} else if Tracker_type == "3" {

								clickssrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
								clickssrc3 = strings.Replace(clickssrc3, `\`, ``, -1)
								clicks3 += strings.Replace(clickssrc3, "  ", " ", -1)
							}
						}
					}
				}

				adunit := fetching.FetchAdunitTracker(admaruout.Adunit_details.Adunit_id)

				if len(adunit.Data) > 0 {

					for _, val := range adunit.Data {

						Event1 := val.Event

						if Event1 == "1" {

							Trackertype := val.Tracker_type

							if Trackertype == "1" {

								impimgu := strings.Replace(val.Tracker_src, "\n", "", -1)
								impimgu = strings.Replace(impimgu, `\`, ``, -1)

								impression1 += `<img src='` + impimgu + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
							} else if Trackertype == "2" {

								impsrcu := strings.Replace(val.Tracker_src, "\n", "", -1)
								impsrcu = strings.Replace(impsrcu, `\`, ``, -1)
								impression2 += strings.Replace(impsrcu, "  ", " ", -1)

							} else if Trackertype == "3" {

								impsrcf := strings.Replace(val.Tracker_src, "\n", "", -1)
								impsrcf = strings.Replace(impsrcf, `\`, ``, -1)
								impression3 += strings.Replace(impsrcf, "  ", " ", -1)
							}
						}

						if Event1 == "2" {

							Tracker_type := val.Tracker_type

							if Tracker_type == "1" {

								viewimpimgi := strings.Replace(val.Tracker_src, "\n", "", -1)
								viewimpimgi = strings.Replace(viewimpimgi, `\`, ``, -1)

								viewimpression1 += `<img src='` + viewimpimgi + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
							} else if Tracker_type == "2" {

								viewimpsrc2i := strings.Replace(val.Tracker_src, "\n", "", -1)
								viewimpsrc2i = strings.Replace(viewimpsrc2i, `\`, ``, -1)
								viewimpression2 += strings.Replace(viewimpsrc2i, "  ", " ", -1)

							} else if Tracker_type == "3" {

								viewimpsrc3i := strings.Replace(val.Tracker_src, "\n", "", -1)
								viewimpsrc3i = strings.Replace(viewimpsrc3i, `\`, ``, -1)
								viewimpression3 += strings.Replace(viewimpsrc3i, "  ", " ", -1)
							}
						}

						if Event1 == "3" {

							Tracker_type := val.Tracker_type

							if Tracker_type == "1" {

								clicksimg1 := strings.Replace(val.Tracker_src, "\n", "", -1)
								clicksimg1 = strings.Replace(clicksimg1, `\`, ``, -1)

								clicks1 += `<img src='` + clicksimg1 + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
							} else if Tracker_type == "2" {

								clickssrcu2 := strings.Replace(val.Tracker_src, "\n", "", -1)
								clickssrcu2 = strings.Replace(clickssrcu2, `\`, ``, -1)
								clicks2 += strings.Replace(clickssrcu2, "  ", " ", -1)

							} else if Tracker_type == "3" {

								clickssrcu3 := strings.Replace(val.Tracker_src, "\n", "", -1)
								clickssrcu3 = strings.Replace(clickssrcu3, `\`, ``, -1)
								clicks3 += strings.Replace(clickssrcu3, "  ", " ", -1)
							}
						}
					}
				}

				var viewbleStart string
				var viewbleEnd string
				var viewbleDiv string
				var innerHTMLviews string

				if viewimpression1 != "" || viewimpression2 != "" || viewimpression3 != "" {

					if viewimpression2 != "" {
						viewimpression2 = strings.Replace(viewimpression2, "\n", "", -1)
						viewimpression2 = strings.Replace(viewimpression2, `</script>`, `<\/script>`, -1)
					}
					if viewimpression3 != "" {
						viewimpression3 = strings.Replace(viewimpression3, `</script>`, `<\/script>`, -1)
						viewimpression3 = strings.Replace(viewimpression3, "\n", "", -1)
					}

					viewbleDiv = `<div id='viewble_` + rand1 + `'></div>`
					innerHTMLviews = `var mainDIVview` + rand1 + ` = document.getElementById('viewble_` + rand1 + `');
					var childDivview` + rand1 + ` = document.createElement("div");       
					childDivview` + rand1 + `.innerHTML = "` + viewimpression1 + viewimpression2 + viewimpression3 + `";
					mainDIVview` + rand1 + `.appendChild(childDivview` + rand1 + `);
					var mainscriptview` + rand1 + ` = mainDIVview` + rand1 + `.getElementsByTagName("script");
					for (var scriptTagsview` + rand1 + ` of mainscriptview` + rand1 + `) {
					var scriptContentview` + rand1 + ` = scriptTagsview` + rand1 + `.textContent;
					eval(scriptContentview` + rand1 + `);
					if (scriptTagsview` + rand1 + `.src) {
						var scriptElementview` + rand1 + ` = document.createElement("script");
						scriptElementview` + rand1 + `.src = scriptTagsview` + rand1 + `.src;
						document.head.appendChild(scriptElementview` + rand1 + `);
					}
					}`

					admaruout.Viewable_Html = innerHTMLviews
				}

				ViewableImpBanner := config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Viewable_Imp?req_id=" + responcertb.Ads.Response.Tracking.Request_Id + "&adsource_id=" + responcertb.Ads.Response.Tracking.Adsource_Id + "&adunit_id=" + admaruout.Adunit_details.Adunit_id + "&provider_id=" + responcertb.Ads.Response.Tracking.Provider_Id + "&publisher_id=" + admaruout.Adunit_details.Publisher + "&tag_id=" + admaruout.Tag_Generation.Tag_id + "&tagtemp_id=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + responcertb.Ads.Response.Tracking.ProviderSrc_Id + "&loc=" + r.Header.Get("Referer")

				admaruout.Viewable_Imp = ViewableImpBanner
				var viewbleJS string
				Height := admaruout.Banner_Template.Height
				var percent string
				if Height < 1000 {
					percent = "75"
				} else {
					percent = "30"
				}
				if admaruout.Autorefresh != "yes" && admaruout.MultiadPrebidCal != "yes" && admaruout.Adunit_type != "PrebidPriority" {
					viewbleStart = `<div id='test-ad` + rand1 + `'> <div id='viewImp_` + rand1 + `'>`
					viewbleEnd = `</div> </div>`
				} else if admaruout.Autorefresh == "yes" {
					viewbleStart = `<div id='test-ad` + rand1 + `'>`
					viewbleEnd = `</div>`
				}
				viewbleJS = `
				<script type='text/javascript' src='https://dn2m2ku6gzfcq.cloudfront.net/static/viewability.js'></script>
				<script type='text/javascript'>var ad_elem` + rand1 + ` = document.getElementById('test-ad` + rand1 + `');
				var ViewableImp = '` + ViewableImpBanner + `';
				localStorage.setItem('reqIDAuto` + rand1 + `',"` + responcertb.Ads.Response.Tracking.Request_Id + `");
				var url = new URL(ViewableImp);
				var time 	= 1 * 1000;
				var percent = ` + percent + `;
				oav` + rand1 + ` = new OpenAdViewability();
				oav` + rand1 + `.DEBUG_MODE = true;
					var j` + rand1 + ` = 0;	 
				oav` + rand1 + `.checkViewability(ad_elem` + rand1 + `, function(check) {
				if(check.percentViewable >=percent){		
					if(j` + rand1 + `==0 && url.searchParams.get("req_id")==localStorage.getItem('reqIDAuto` + rand1 + `' )){	
						` + admaruout.Viewable_Html + `
					var xhttp = new XMLHttpRequest();
					xhttp.open('GET', ViewableImp, true);		
					xhttp.send();
					localStorage.removeItem('reqIDAuto` + rand1 + `' );
					j` + rand1 + `++;		
				}
				}
				});			 
				</script>`

				var JSscript string
				var divStart string
				var divEnd string
				var Clickdiv string
				var ClickHTML string

				price := fmt.Sprint(responcertb.Ads.Response.Seatbid[0].Bid[0].Price)
				currency := responcertb.Ads.Response.Cur
				ImpressionBanner := config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Impression?req_id=" + responcertb.Ads.Response.Tracking.Request_Id + "&adsource_id=" + responcertb.Ads.Response.Tracking.Adsource_Id + "&adunit_id=" + admaruout.Adunit_details.Adunit_id + "&provider_id=" + responcertb.Ads.Response.Tracking.Provider_Id + "&publisher_id=" + admaruout.Adunit_details.Publisher + "&tagid=" + admaruout.Tag_Generation.Tag_id + "&tagtempid=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + responcertb.Ads.Response.Tracking.ProviderSrc_Id + "&won_price=" + price + "&res_cur=" + currency + "&loc=" + r.Header.Get("Referer") + "&owned_by=" + responcertb.Ads.Response.Tracking.Owned_by

				ClickD := config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Click?requestid=" + responcertb.Ads.Response.Tracking.Request_Id + "&adsourceid=" + responcertb.Ads.Response.Tracking.Adsource_Id + "&adunitid=" + admaruout.Adunit_details.Adunit_id + "&Providerid=" + responcertb.Ads.Response.Tracking.Provider_Id + "&Publisherid=" + admaruout.Adunit_details.Publisher + "&tagid=" + admaruout.Tag_Generation.Tag_id + "&tagtempid=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + responcertb.Ads.Response.Tracking.ProviderSrc_Id + "&loc=" + r.Header.Get("Referer")

				height := responcertb.Ads.Response.Seatbid[0].Bid[0].H
				width := responcertb.Ads.Response.Seatbid[0].Bid[0].W

				H := helper.IntToString(height)
				W := helper.IntToString(width)

				if clicks1 != "" || clicks2 != "" || clicks3 != "" {

					if clicks2 != "" {
						clicks2 = strings.Replace(clicks2, "\n", "", -1)
						clicks2 = strings.Replace(clicks2, `</script>`, `<\/script>`, -1)
					}
					if clicks3 != "" {
						clicks3 = strings.Replace(clicks3, `</script>`, `<\/script>`, -1)
						clicks3 = strings.Replace(clicks3, "\n", "", -1)
					}

					Clickdiv = `<div id='track_` + rand1 + `'></div>`
					ClickHTML = `var mainDIVclick` + rand1 + ` = document.getElementById('track_` + rand1 + `');
					var childDivclick` + rand1 + ` = document.createElement("div");       
					childDivclick` + rand1 + `.innerHTML = "` + clicks1 + clicks2 + clicks3 + `";
					mainDIVclick` + rand1 + `.appendChild(childDivclick` + rand1 + `);
					var mainscriptclick` + rand1 + ` = mainDIVclick` + rand1 + `.getElementsByTagName("script");
					for (var scriptTagsclick` + rand1 + ` of mainscriptclick` + rand1 + `) {
					  var scriptContentclick` + rand1 + ` = scriptTagsclick` + rand1 + `.textContent;
					  eval(scriptContentclick` + rand1 + `);
					  if (scriptTagsclick` + rand1 + `.src) {
						var scriptElementclick` + rand1 + ` = document.createElement("script");
						scriptElementclick` + rand1 + `.src = scriptTagsclick` + rand1 + `.src;
						document.head.appendChild(scriptElementclick` + rand1 + `);
					  }
					}`

				}
				if admaruout.Adunit_type == "Adapter" {
					ClickHTML = strings.Replace(ClickHTML, `"`, "`", -1)
					ClickHTML = strings.ReplaceAll(ClickHTML, "$", "$`+`")
					ClickHTML = strings.Replace(ClickHTML, `<\/script>`, "<\\\\/script>", -1)
				}
				JSscript = `<script type='text/javascript'>
			function check_` + rand1 + `()
			{	
					` + ClickHTML + `
					var ClickD = "` + ClickD + `";
					var xhr = new XMLHttpRequest();
					xhr.open('GET', ClickD, true);
					xhr.send();
				}
				var ImpressionBanner = "` + ImpressionBanner + `";
				var xhrbk = new XMLHttpRequest();
				xhrbk.open('GET', ImpressionBanner, true);
				xhrbk.send();
			</script>`

				ClicktrackJS := `<script type='text/javascript'>
	
			document.getElementById('ad_` + rand1 + `').onclick = function fun() {
				check_` + rand1 + `();
			}
		
			</script>`

				divStart = `<div id='ad_` + rand1 + `'  style='width:` + W + `px;height:` + H + `px;'>`
				divEnd = `</div>`

				/**********Third Party Tracker End**********/

				/*****Impression capping for RTB*************/

				admaruout.Html = admaruout.Html + viewbleStart + divStart + responcertb.Ads.Response.Seatbid[0].Bid[0].Adm + divEnd + "<img width=0 height=0 src='" + responcertb.Ads.Response.Seatbid[0].Bid[0].Burl + "'>" + Clickdiv + viewbleDiv + impression1 + impression2 + impression3 + viewbleEnd + ClicktrackJS + viewbleJS + JSscript

				if admaruout.MultiadWinAdType == 1 && admaruout.MultiAdFormat && admaruout.Adunit_type != "Adapter" {
					res, _ := json.Marshal(admaruout.MultiAdFinalRTB)
					if admaruout.MultiAdFinalRTB.Ads.Adtype == 1 {
						admaruout.Html = admaruout.Html + ` <script type='text/javascript'>var res = ` + string(res) + `;console.log("Winning Ad Type : RTB Banner Ad"); console.log("Winning Response :"+JSON.stringify(res));</script>`
					} else if admaruout.MultiAdFinalRTB.Ads.Adtype == 2 {
						admaruout.Html = admaruout.Html + `<script type='text/javascript'>var res = ` + string(res) + `;console.log("Winning Ad Type : RTB Video Ad"); console.log("Winning Response :"+JSON.stringify(res));</script>`
					}

				}

				if admaruout.Adunit_type == "Adapter" {
					s := strings.Replace(admaruout.Html, `"`, "'", -1)
					price := fmt.Sprintf("%f", responcertb.Ads.Response.Seatbid[0].Bid[0].Price)

					admaruout.AdapterFinalAdsource.Adsourceid = responcertb.Ads.Response.Tracking.Adsource_Id

					admaruout.AdapterHTML = s
					admaruout.AdapterPrice = price
					admaruout.AdapterAdtype = "RTB_BANNER"
				}

				admaruout.External_ad = true
			case admaruout.Multiads && responcertb.Ads.Adtype == 2 || !admaruout.Multiads && (admaruout.Temp_Generation.Template_type == "3" || admaruout.Temp_Generation.Template_type == "2"):

				video_url := config.GetConfig("path", "library") + "AdmaruAdDelivery/AdmaruVideoDelivery/videoplayback.mp4"
				var impFinal1 string
				var clickFinal1 string
				var track string
				clickFinal1 = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Click?requestid=" + responcertb.Ads.Response.Tracking.Request_Id + "&adsourceid=" + responcertb.Ads.Response.Tracking.Adsource_Id + "&adunitid=" + admaruout.Adunit_details.Adunit_id + "&Providerid=" + responcertb.Ads.Response.Tracking.Provider_Id + "&Publisherid=" + admaruout.Adunit_details.Publisher + "&tagid=" + admaruout.Tag_Generation.Tag_id + "&tagtempid=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + responcertb.Ads.Response.Tracking.ProviderSrc_Id + "&loc=" + r.Header.Get("Referer")
				price := fmt.Sprint(responcertb.Ads.Response.Seatbid[0].Bid[0].Price)
				currency := responcertb.Ads.Response.Cur
				impFinal1 = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Impression?req_id=" + responcertb.Ads.Response.Tracking.Request_Id + "&adsource_id=" + responcertb.Ads.Response.Tracking.Adsource_Id + "&adunit_id=" + admaruout.Adunit_details.Adunit_id + "&provider_id=" + responcertb.Ads.Response.Tracking.Provider_Id + "&publisher_id=" + admaruout.Adunit_details.Publisher + "&tagid=" + admaruout.Tag_Generation.Tag_id + "&tagtempid=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + responcertb.Ads.Response.Tracking.ProviderSrc_Id + "&won_price=" + price + "&res_cur=" + currency + "&loc=" + r.Header.Get("Referer") + "&owned_by=" + responcertb.Ads.Response.Tracking.Owned_by
				track = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Event_Track?req_id=" + responcertb.Ads.Response.Tracking.Request_Id + "&adsource_id=" + responcertb.Ads.Response.Tracking.Adsource_Id + "&adunitid=" + admaruout.Adunit_details.Adunit_id + "&provider_id=" + responcertb.Ads.Response.Tracking.Provider_Id + "&publisher_id=" + admaruout.Adunit_details.Publisher + "&tagid=" + admaruout.Tag_Generation.Tag_id + "&tagtempid=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + responcertb.Ads.Response.Tracking.ProviderSrc_Id

				ViewableImp := config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Viewable_Imp?req_id=" + responcertb.Ads.Response.Tracking.Request_Id + "&adsource_id=" + responcertb.Ads.Response.Tracking.Adsource_Id + "&adunit_id=" + admaruout.Adunit_details.Adunit_id + "&provider_id=" + responcertb.Ads.Response.Tracking.Provider_Id + "&publisher_id=" + admaruout.Adunit_details.Publisher + "&tag_id=" + admaruout.Tag_Generation.Tag_id + "&tagtemp_id=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + responcertb.Ads.Response.Tracking.ProviderSrc_Id + "&loc=" + r.Header.Get("Referer")
				vastXml := responcertb.Ads.Response.Seatbid[0].Bid[0].Adm
				Adtype := "rtbvast"

				_5sView := config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Event_Track?req_id=" + responcertb.Ads.Response.Tracking.Request_Id + "&adsource_id=" + responcertb.Ads.Response.Tracking.Adsource_Id + "&adunitid=" + admaruout.Adunit_details.Adunit_id + "&provider_id=" + responcertb.Ads.Response.Tracking.Provider_Id + "&publisher_id=" + admaruout.Adunit_details.Publisher + "&tagid=" + admaruout.Tag_Generation.Tag_id + "&tagtempid=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + responcertb.Ads.Response.Tracking.ProviderSrc_Id + "&event=5sView"
				//Adapter
				if admaruout.Adunit_type == "Adapter" {
					admaruout.AdapterPrice = price
					admaruout.AdapterFinalAdsource.Request_id = responcertb.Ads.Response.Tracking.Request_Id
					admaruout.AdapterFinalAdsource.Adsourceid = responcertb.Ads.Response.Tracking.Adsource_Id
					admaruout.AdapterVASTtag = vastXml
					admaruout.AdapterTrackingURL = track

					admaruout.AdapterVastTracking = strings.Replace(vastXml, "</Impression>", "</Impression><Impression><![CDATA["+impFinal1+"]]></Impression><ViewableImpression> <Viewable> <![CDATA["+_5sView+"]]> </Viewable> </ViewableImpression>", 1)
					admaruout.AdapterVastTracking = strings.Replace(admaruout.AdapterVastTracking, "</VideoClicks>", "<ClickTracking><![CDATA["+clickFinal1+"]]></ClickTracking></VideoClicks>", 1)

					admaruout.AdapterAdtype = "RTB_VIDEO"
				}

				admaruout.External_ad = true
				AdsourceID := responcertb.Ads.Response.Tracking.Adsource_Id
				ad.VideoJsPlayer(admaruout, AdsourceID, responcertb.Ads.Response.Seatbid[0].Bid[0].Adm, video_url, clickFinal1, Adtype, ViewableImp, impFinal1, responcertb.Ads.CookieSync_URL, track, _5sView, "RTB")

			}

		} else {
			admaruout.External_ad = false
		}
	} else {
		admaruout.External_ad = false
	}
}

func RtbWinStats(final structure.RTBResponse, admaruoutput *structure.AdmaruOutput) {
	request_id := final.Ads.Response.Tracking.Request_Id
	publisher_id := admaruoutput.Adunit_details.Publisher
	adunit_id := admaruoutput.Adunit_details.Adunit_id
	tagid := admaruoutput.Tag_Generation.Tag_id
	tagtempid := admaruoutput.Tag_Generation.Template_id

	provider_id := final.Ads.Response.Tracking.Provider_Id
	adsource_id := final.Ads.Response.Tracking.Adsource_Id
	pro_src_id := final.Ads.Response.Tracking.ProviderSrc_Id
	won_count := "1"
	adrequest1, _ := http.NewRequest("GET", config.GetConfig("protocol", "webpath")+config.GetConfig("delivery", "webpath")+"/Ad_Win?req_id="+request_id+"&publisher_id="+publisher_id+"&adunit_id="+adunit_id+"&provider_id="+provider_id+"&adsource_id="+adsource_id+"&tagid="+tagid+"&tagtempid="+tagtempid+"&pro_src_id="+pro_src_id+"&won_count="+won_count+"", nil)
	client2 := &http.Client{Timeout: time.Duration(0) * time.Millisecond}
	resp, err := client2.Do(adrequest1)
	if err != nil {
		fmt.Println(err)
	}

	defer resp.Body.Close()

}

func RtbWinStats_N(final structure.RTBResponse, admaruoutput *structure.AdmaruOutput) {

	clickClient.Track_win(admaruoutput.Adunit_details.Publisher, admaruoutput.Adunit_details.Adunit_id, final.Ads.Response.Tracking.Provider_Id, final.Ads.Response.Tracking.Adsource_Id, final.Ads.Response.Tracking.Request_Id, admaruoutput.Tag_Generation.Tag_id, admaruoutput.Tag_Generation.Template_id, final.Ads.Response.Tracking.ProviderSrc_Id, 1)
}

func RtbImp(final structure.RTBResponse, admaruoutput *structure.AdmaruOutput) {
	request_id := final.Ads.Response.Tracking.Request_Id
	publisher_id := admaruoutput.Adunit_details.Publisher
	adunit_id := admaruoutput.Adunit_details.Adunit_id
	tagid := admaruoutput.Tag_Generation.Tag_id
	tagtempid := admaruoutput.Tag_Generation.Template_id

	provider_id := final.Ads.Response.Tracking.Provider_Id
	adsource_id := final.Ads.Response.Tracking.Adsource_Id
	pro_src_id := final.Ads.Response.Tracking.ProviderSrc_Id
	price := fmt.Sprint(final.Ads.Response.Seatbid[0].Bid[0].Price)

	request, err := http.NewRequest("GET", config.GetConfig("protocol", "webpath")+config.GetConfig("delivery", "webpath")+"/Impression?req_id="+request_id+"&publisher_id="+publisher_id+"&provider_id="+provider_id+"&adsource_id="+adsource_id+"&adunit_id="+adunit_id+"&tagid="+tagid+"&tagtempid="+tagtempid+"&pro_src_id="+pro_src_id+"&won_price="+price, nil)
	if err != nil {
		fmt.Println(err)
	}
	client := &http.Client{Timeout: time.Duration(0) * time.Millisecond}
	resp, err := client.Do(request)
	if err != nil {
		fmt.Println(err)
	}
	defer resp.Body.Close()

}

func ArrayChecker(arrayofadsource []structure.AdSourceDetails) bool {

	var Checker []byte
	var err error
	var check []byte
	var arrayjson []byte
	if len(arrayofadsource) != 1 {
		arrayoff := []structure.AdsourceCheck{}
		arrayjson, err = json.Marshal(arrayofadsource)
		if err != nil {
			fmt.Println(err)
		}
		err = json.Unmarshal(arrayjson, &arrayoff)
		if err != nil {
			fmt.Println(err)
		}

		Checker, err = json.Marshal(arrayoff[0])
		if err != nil {
			fmt.Println(err)
		}
		if len(arrayofadsource) != 0 {
			for i := 0; i < len(arrayoff); i++ {
				check, err = json.Marshal(arrayoff[i])
				if err != nil {
					fmt.Println(err)
				}
				res := bytes.Compare(Checker, check)
				if res != 0 {
					return true
				}
			}
		}
		return false
	}
	return true

}

func RandomAdDelivery(arrayofadsource []structure.AdSourceDetails, admaruoutput *structure.AdmaruOutput, w http.ResponseWriter, r *http.Request) {
	var evenadsource []structure.AdSourceDetails
	var asapadsource []structure.AdSourceDetails
	var emtyadsource []structure.AdSourceDetails

	for i := 0; i < len(arrayofadsource); i++ {

		floor_price := arrayofadsource[i].Bidprice
		floor_price_float := helper.StringToFloat(floor_price)
		req_cur := multiCurrency.Convert_currency(floor_price_float, admaruoutput.Bidding_currency, admaruoutput.Account_currency)
		req_cur_str := fmt.Sprintf("%v", req_cur)
		arrayofadsource[i].Bidprice = req_cur_str
		switch {
		case arrayofadsource[i].Capping.Pacing == "even":
			evenadsource = append(evenadsource, arrayofadsource[i])
		case arrayofadsource[i].Capping.Pacing == "asap":
			asapadsource = append(asapadsource, arrayofadsource[i])
		default:
			emtyadsource = append(emtyadsource, arrayofadsource[i])
		}
	}

	switch {
	case len(asapadsource) != 0:
		num := rand.Intn(len(asapadsource))
		admaruoutput.Adsource_id = asapadsource[num].Adsourceid
		admaruoutput.Provider_id = asapadsource[num].Provider
		admaruoutput.Publisher_id = asapadsource[num].Publisher

		if asapadsource[num].Capping.Pacing != "" {
			capping.CookieCapping(w, r, asapadsource[num].Capping, asapadsource[num])
		}
		RandomAdRender(asapadsource[num], admaruoutput)

	case len(evenadsource) != 0:
		num := rand.Intn(len(evenadsource))
		admaruoutput.Adsource_id = evenadsource[num].Adsourceid
		admaruoutput.Provider_id = evenadsource[num].Provider
		admaruoutput.Publisher_id = evenadsource[num].Publisher

		if evenadsource[num].Capping.Pacing != "" {
			capping.CookieCapping(w, r, evenadsource[num].Capping, evenadsource[num])
		}
		RandomAdRender(evenadsource[num], admaruoutput)

	default:
		num := rand.Intn(len(emtyadsource))
		admaruoutput.Adsource_id = emtyadsource[num].Adsourceid
		admaruoutput.Provider_id = emtyadsource[num].Provider
		admaruoutput.Publisher_id = emtyadsource[num].Publisher
		RandomAdRender(emtyadsource[num], admaruoutput)
	}

}

func PrebidAd(arrayPrebidads []structure.AdSourceDetails, admaruoutput *structure.AdmaruOutput) {
	admaruoutput.Addelivery_Tag = "no"
	admaruoutput.DeliveryAdType = "Prebid"

	if admaruoutput.Is_Multiadformat == true {

		adrtb.GetPrebidBannerAd(admaruoutput, arrayPrebidads, admaruoutput.Is_Multiadformat)

	} else {
		switch arrayPrebidads[0].Adformat {
		case "Banner":
			adrtb.GetPrebidBannerAd(admaruoutput, arrayPrebidads, admaruoutput.Is_Multiadformat)
		case "Video":
			adrtb.GetPrebidVideoAd(admaruoutput, arrayPrebidads)
		}
	}

}

func RandomAdRender(finalads structure.AdSourceDetails, admaruoutput *structure.AdmaruOutput) {
	switch admaruoutput.Temp_Generation.Template_type {
	case "1":
		ad.AdRender(finalads, admaruoutput)
	case "2":
		inline := structure.Instream_Template{}
		json.Unmarshal([]byte(admaruoutput.Temp_Generation.Settings), &inline)
		ad.VideoAdRander(finalads, admaruoutput)
	case "3":
		ad.VideoAdRander(finalads, admaruoutput)
	}

}

func MacrosReplace(finalresponse adrtb.RTBResponse) string {
	stringres, _ := json.Marshal(finalresponse)
	var replaceResponse string
	replaceResponse = string(stringres)
	replaceResponse = strings.Replace(replaceResponse, "${AUCTION_ID}", fmt.Sprint(finalresponse.Ads.Bidderid), -1)
	replaceResponse = strings.Replace(replaceResponse, "${AUCTION_BID_ID}", finalresponse.Ads.Response.Bidid, -1)
	replaceResponse = strings.Replace(replaceResponse, "${AUCTION_CURRENCY}", finalresponse.Ads.Response.Cur, -1)
	if len(finalresponse.Ads.Response.Seatbid) != 0 && len(finalresponse.Ads.Response.Seatbid[0].Bid) != 0 {
		replaceResponse = strings.Replace(replaceResponse, "${AUCTION_IMP_ID}", finalresponse.Ads.Response.Seatbid[0].Bid[0].Impid, -1)

		replaceResponse = strings.Replace(replaceResponse, "${AUCTION_AD_ID}", finalresponse.Ads.Response.Seatbid[0].Bid[0].Adid, -1)
		replaceResponse = strings.Replace(replaceResponse, "${AUCTION_PRICE}", fmt.Sprint(finalresponse.Ads.Response.Seatbid[0].Bid[0].Price), -1)

		replaceResponse = strings.Replace(replaceResponse, "${AUCTION_MBR}", fmt.Sprint(finalresponse.Ads.Response.Seatbid[0].Bid[0].Price), -1)

		if finalresponse.Ads.Response.Seatbid[0].Bid[0].Price > 0.01 {
			mintowin := finalresponse.Ads.Response.Seatbid[0].Bid[0].Price - 0.10
			replaceResponse = strings.Replace(replaceResponse, "${AUCTION_MIN_TO_WIN}", fmt.Sprint(mintowin), -1)
		} else {
			replaceResponse = strings.Replace(replaceResponse, "${AUCTION_MIN_TO_WIN}", fmt.Sprint(finalresponse.Ads.Response.Seatbid[0].Bid[0].Price), -1)

		}
	}

	return replaceResponse

}
