package capping

import (
	"alpha/addelivery/helper"
	"alpha/addelivery/structure"
	"alpha/redisclient"
	"net/http"
	"strings"
	"time"
)

type CCapping struct {
	Start    string `json:"start"`
	End      string `json:"end"`
	Count    string `json:"count"`
	ImpCount string `json:"impcount"`
}
type CkCapping struct {
	Start    int `json:"start"`
	End      int `json:"end"`
	Count    int `json:"count"`
	ImpCount int `json:"impcount"`
}

var redisrepo = redisclient.Initialize()
var countreducecheck int

func CheckAdsCapping(adsource structure.AdSourceDetails, r *http.Request) bool {
	var usrcnt string = "ADMARUFCU_"
	var adscnt string = "ADMARUFCA_"
	var adsimpcount int
	loc, _ := time.LoadLocation("UTC")
	var timenow int64 = time.Now().In(loc).UnixNano() / 1000000

	if timenow > int64(adsource.Capping.Durations.StartHour) && timenow < int64(adsource.Capping.Durations.EndHour) && adsource.Capping.Durations.EndHour != 0 {
		cappingvalue, err := redisrepo.CappingGetKey(adscnt + adsource.Adsourceid)
		if err != nil {
			adsimpcount = 1
		} else {
			adsimpcount = helper.StringToInt(strings.Split(cappingvalue, "=")[1])
		}
		cappingvalueu, err1 := redisrepo.CappingGetKey(usrcnt + adsource.Adsourceid)
		if err1 == nil {

			CookieCapping := CkCapping{}
			CookieCapping.Start = helper.StringToInt(strings.Split(strings.Split(cappingvalueu, "-")[0], "=")[1])
			CookieCapping.End = helper.StringToInt(strings.Split(strings.Split(cappingvalueu, "-")[1], "=")[1])
			CookieCapping.ImpCount = helper.StringToInt(strings.Split(strings.Split(cappingvalueu, "-")[2], "=")[1])
			CookieCapping.Count = helper.StringToInt(strings.Split(strings.Split(cappingvalueu, "-")[3], "=")[1])
			if CookieCapping.ImpCount > adsimpcount && timenow < int64(CookieCapping.End) {
				return true

			} else if CookieCapping.ImpCount > adsimpcount && timenow < int64(adsource.Capping.Durations.EndHour) {
				return true
			} else if CookieCapping.ImpCount > adsimpcount && timenow < int64(adsource.Capping.Durations.EndHour) {

				return timenow >= int64(CookieCapping.End)

			} else if CookieCapping.ImpCount > adsimpcount && timenow < int64(CookieCapping.End) {

				return true
			} else if CookieCapping.ImpCount == adsimpcount && timenow > int64(CookieCapping.End) && timenow < int64(adsource.Capping.Durations.EndHour) && CookieCapping.Count != 0 {
				return true
			}
			return false
		} else {
			timetest, impcount, usercount, countreduce := CappingCal(timenow, adsource.Capping, countreducecheck)
			CookieCapping := CkCapping{}
			CookieCapping.Start = adsource.Capping.Durations.StartHour
			CookieCapping.End = timetest
			CookieCapping.ImpCount = impcount
			CookieCapping.Count = usercount - countreduce

			if CookieCapping.ImpCount > adsimpcount && timenow < int64(CookieCapping.End) {
				return true

			} else if CookieCapping.ImpCount > adsimpcount && timenow < int64(adsource.Capping.Durations.EndHour) {
				return true
			} else if CookieCapping.ImpCount > adsimpcount && timenow < int64(adsource.Capping.Durations.EndHour) {

				return timenow <= int64(CookieCapping.End)

			} else if CookieCapping.ImpCount > adsimpcount && timenow < int64(CookieCapping.End) {

				return true
			}
			return false
		}
		return true
	} else if timenow > int64(adsource.Capping.Durations.StartHour) && adsource.Capping.Durations.EndHour == 0 {
		cappingvalue, err := redisrepo.CappingGetKey(adscnt + adsource.Adsourceid)
		if err != nil {

			adsimpcount = 1
		} else {
			adsimpcount = helper.StringToInt(strings.Split(cappingvalue, "=")[1])
		}
		cappingvalueu, err1 := redisrepo.CappingGetKey(usrcnt + adsource.Adsourceid)
		if err1 == nil {
			CookieCapping := CkCapping{}
			CookieCapping.Start = helper.StringToInt(strings.Split(strings.Split(cappingvalueu, "-")[0], "=")[1])
			CookieCapping.End = helper.StringToInt(strings.Split(strings.Split(cappingvalueu, "-")[1], "=")[1])
			CookieCapping.ImpCount = helper.StringToInt(strings.Split(strings.Split(cappingvalueu, "-")[2], "=")[1])
			CookieCapping.Count = helper.StringToInt(strings.Split(strings.Split(cappingvalueu, "-")[3], "=")[1])

			if CookieCapping.End == 0 {
				if CookieCapping.ImpCount > adsimpcount {

					return true
				} else if CookieCapping.ImpCount == adsimpcount && CookieCapping.Count != 0 {

					return true
				}
			} else {
				if CookieCapping.ImpCount > adsimpcount && timenow < int64(CookieCapping.End) {

					return true
				} else if CookieCapping.ImpCount > adsimpcount && timenow < int64(adsource.Capping.Durations.EndHour) {

					return true
				} else if CookieCapping.ImpCount > adsimpcount && timenow < int64(adsource.Capping.Durations.EndHour) {

					return timenow >= int64(CookieCapping.End)

				} else if CookieCapping.ImpCount > adsimpcount && timenow < int64(CookieCapping.End) {

					return true
				} else if CookieCapping.ImpCount == adsimpcount && timenow > int64(CookieCapping.End) && CookieCapping.Count != 0 {

					return true
				}
			}

			return false

		} else {

			timetest, impcount, usercount, countreduce := CappingCal(timenow, adsource.Capping, countreducecheck)
			CookieCapping := CkCapping{}
			CookieCapping.Start = adsource.Capping.Durations.StartHour
			CookieCapping.End = timetest
			CookieCapping.ImpCount = impcount
			CookieCapping.Count = usercount - countreduce
			if CookieCapping.End == 0 {
				if CookieCapping.ImpCount > adsimpcount {

					return true
				} else if CookieCapping.ImpCount == adsimpcount && CookieCapping.Count != 0 {

					return true
				}
			} else {
				if CookieCapping.ImpCount > adsimpcount && timenow < int64(CookieCapping.End) {

					return true

				} else if CookieCapping.ImpCount > adsimpcount && timenow < int64(adsource.Capping.Durations.EndHour) {

					return true
				} else if CookieCapping.ImpCount > adsimpcount && timenow < int64(adsource.Capping.Durations.EndHour) {

					return timenow >= int64(CookieCapping.End)

				} else if CookieCapping.ImpCount > adsimpcount && timenow < int64(CookieCapping.End) {

					return true
				} else if CookieCapping.ImpCount == adsimpcount && CookieCapping.Count != 0 && timenow > int64(CookieCapping.End) {

					return true
				}
			}

			return false
		}

	}

	return false

}

func CookieCapping(w http.ResponseWriter, r *http.Request, impcapping structure.ImpCapping, adsource structure.AdSourceDetails) {

	var usrcnt string = "ADMARUFCU_"
	var adscnt string = "ADMARUFCA_"
	var conveter bool
	var expire bool
	loc, _ := time.LoadLocation("UTC")
	var timenow int64 = time.Now().In(loc).UnixNano() / 1000000

	timetest, impcount, usercount, countreduce := CappingCal(timenow, impcapping, countreducecheck)

	capping := &CCapping{}
	capping.Start = helper.IntToString(impcapping.Durations.StartHour)
	capping.End = helper.IntToString(timetest)
	capping.Count = helper.IntToString(usercount - countreduce)

	cappingStart := "start=" + capping.Start
	cappingEnd := "end=" + capping.End
	cappingImpCount := "impcount=" + helper.IntToString(impcount)
	cappingCount := "count=" + capping.Count

	cappingValue := cappingStart + "-" + cappingEnd + "-" + cappingImpCount + "-" + cappingCount

	adscount := "adscount=1"
	adsimp := CookieSetorGet(adscnt, adscount, adsource, r, w, conveter, expire)
	expire = true
	Value := CookieSetorGet(usrcnt, cappingValue, adsource, r, w, conveter, expire)
	if Value != "" && adsimp != "1" {
		var adsimpcount int
		if adsimp != "" {
			adsimpcount = helper.StringToInt(strings.Split(adsimp, "=")[1])
		}
		CookieCapping := CkCapping{}
		CookieCapping.Start = helper.StringToInt(strings.Split(strings.Split(Value, "-")[0], "=")[1])
		CookieCapping.End = helper.StringToInt(strings.Split(strings.Split(Value, "-")[1], "=")[1])
		CookieCapping.ImpCount = helper.StringToInt(strings.Split(strings.Split(Value, "-")[2], "=")[1])
		CookieCapping.Count = helper.StringToInt(strings.Split(strings.Split(Value, "-")[3], "=")[1])
		if CookieCapping.Count != 0 && adsource.Capping.Durations.EndHour != 0 {
			if timenow > int64(CookieCapping.Start) && timenow > int64(CookieCapping.End) {
				if CookieCapping.Count != 0 {
					if timenow < int64(impcapping.Durations.EndHour) {
						updatecount := usercount - countreduce
						capping := &CCapping{}
						capping.Start = helper.IntToString(CookieCapping.Start)
						capping.End = helper.IntToString(timetest)
						capping.ImpCount = helper.IntToString(impcount)
						capping.Count = helper.IntToString(updatecount)

						cappingStart := "start=" + capping.Start
						cappingEnd := "end=" + capping.End
						cappingImpCount := "impcount=" + capping.ImpCount
						cappingCount := "count=" + capping.Count

						cappingValue := cappingStart + "-" + cappingEnd + "-" + cappingImpCount + "-" + cappingCount
						conveter = true
						Value = CookieSetorGet(usrcnt, cappingValue, adsource, r, w, conveter, expire)

						adsvalue := 1
						adscount := "adscount=" + helper.IntToString(adsvalue)
						adsimp = CookieSetorGet(adscnt, adscount, adsource, r, w, conveter, !expire)
					}

				} else {
					nextcookie := CCapping{}
					nextcookie.Start = helper.IntToString(CookieCapping.Start)
					nextcookie.End = helper.IntToString(CookieCapping.End)
					nextcookie.ImpCount = helper.IntToString(CookieCapping.ImpCount)
					nextcookie.Count = "Expire"
					cappingStart := "start=" + nextcookie.Start
					cappingEnd := "end=" + nextcookie.End
					cappingImpCount := "impcount=" + nextcookie.ImpCount
					cappingCount := "count=" + nextcookie.Count

					cappingValue := cappingStart + "-" + cappingEnd + "-" + cappingImpCount + "-" + cappingCount
					conveter = true
					Value = CookieSetorGet(usrcnt, cappingValue, adsource, r, w, conveter, !expire)
				}
			} else if timenow > int64(CookieCapping.Start) && timenow < int64(CookieCapping.End) && CookieCapping.ImpCount != adsimpcount {
				if CookieCapping.ImpCount > adsimpcount {

					updatecount := usercount - countreduce
					nextcookie := CCapping{}
					nextcookie.Start = helper.IntToString(CookieCapping.Start)
					nextcookie.End = helper.IntToString(timetest)
					nextcookie.ImpCount = helper.IntToString(CookieCapping.ImpCount)
					nextcookie.Count = helper.IntToString(updatecount)
					cappingStart := "start=" + nextcookie.Start
					cappingEnd := "end=" + nextcookie.End
					cappingImpCount := "impcount=" + nextcookie.ImpCount
					cappingCount := "count=" + nextcookie.Count

					cappingValue := cappingStart + "-" + cappingEnd + "-" + cappingImpCount + "-" + cappingCount
					conveter = true
					Value = CookieSetorGet(usrcnt, cappingValue, adsource, r, w, conveter, expire)
					adsvalue := adsimpcount + 1
					adscount := "adscount=" + helper.IntToString(adsvalue)
					adsimp = CookieSetorGet(adscnt, adscount, adsource, r, w, conveter, !expire)

				}
			}

		} else if adsource.Capping.Durations.EndHour == 0 {
			if timenow > int64(CookieCapping.Start) && CookieCapping.ImpCount == adsimpcount {

				if CookieCapping.Count != 0 {

					updatecount := usercount - countreduce
					capping := &CCapping{}
					capping.Start = helper.IntToString(CookieCapping.Start)
					capping.End = helper.IntToString(timetest)
					capping.ImpCount = helper.IntToString(impcount)
					capping.Count = helper.IntToString(updatecount)

					cappingStart := "start=" + capping.Start
					cappingEnd := "end=" + capping.End
					cappingImpCount := "impcount=" + capping.ImpCount
					cappingCount := "count=" + capping.Count

					cappingValue := cappingStart + "-" + cappingEnd + "-" + cappingImpCount + "-" + cappingCount
					conveter = true
					Value = CookieSetorGet(usrcnt, cappingValue, adsource, r, w, conveter, expire)

					adsvalue := 1
					adscount := "adscount=" + helper.IntToString(adsvalue)
					adsimp = CookieSetorGet(adscnt, adscount, adsource, r, w, conveter, !expire)

				} else {

					nextcookie := CCapping{}
					nextcookie.Start = helper.IntToString(CookieCapping.Start)
					nextcookie.End = helper.IntToString(CookieCapping.End)
					nextcookie.ImpCount = helper.IntToString(CookieCapping.ImpCount)
					nextcookie.Count = "Expire"
					cappingStart := "start=" + nextcookie.Start
					cappingEnd := "end=" + nextcookie.End
					cappingImpCount := "impcount=" + nextcookie.ImpCount
					cappingCount := "count=" + nextcookie.Count

					cappingValue := cappingStart + "-" + cappingEnd + "-" + cappingImpCount + "-" + cappingCount
					conveter = true
					Value = CookieSetorGet(usrcnt, cappingValue, adsource, r, w, conveter, !expire)
				}
			} else if timenow > int64(CookieCapping.Start) && CookieCapping.ImpCount != adsimpcount {

				if CookieCapping.ImpCount > adsimpcount {

					updatecount := usercount - countreduce
					nextcookie := CCapping{}
					nextcookie.Start = helper.IntToString(CookieCapping.Start)
					nextcookie.End = helper.IntToString(timetest)
					nextcookie.ImpCount = helper.IntToString(CookieCapping.ImpCount)
					nextcookie.Count = helper.IntToString(updatecount)
					cappingStart := "start=" + nextcookie.Start
					cappingEnd := "end=" + nextcookie.End
					cappingImpCount := "impcount=" + nextcookie.ImpCount
					cappingCount := "count=" + nextcookie.Count

					cappingValue := cappingStart + "-" + cappingEnd + "-" + cappingImpCount + "-" + cappingCount
					conveter = true
					Value = CookieSetorGet(usrcnt, cappingValue, adsource, r, w, conveter, expire)
					adsvalue := adsimpcount + 1
					adscount := "adscount=" + helper.IntToString(adsvalue)
					adsimp = CookieSetorGet(adscnt, adscount, adsource, r, w, conveter, !expire)

				}
			}
		}

	}

}

func CappingCal(timenow int64, impcapping structure.ImpCapping, countreducee int) (int, int, int, int) {
	const (
		Daily   = 24
		Monthly = 12
	)
	var countreduce int
	var impcount int
	var usercount int
	var timetest int
	var incrementcount int
	if impcapping.Pacing == "even" {
		if impcapping.Cappings.Intervel == "day" {
			incrementcount = 3600000
			timetest = impcapping.Durations.StartHour
			for i := 0; i < Daily; i++ {
				timetest = timetest + incrementcount
				if timenow > int64(impcapping.Durations.StartHour) && timenow < int64(timetest) {
					countreduce = i
					countreducee = 1
					break
				}

				if i == 23 {
					i = 0
				}
			}
			impcount = impcapping.Cappings.Count / Daily

			usercount = Daily

		} else if impcapping.Cappings.Intervel == "month" {
			incrementcount = 2678400000
			timetest = impcapping.Durations.StartHour
			for i := 0; i < Monthly; i++ {
				timetest = timetest + incrementcount
				if timenow > int64(impcapping.Durations.StartHour) && timenow < int64(timetest) {
					countreduce = i
					countreducee = 1
					break
				}

				if i == 11 {
					i = 0
				}
			}
			impcount = impcapping.Cappings.Count / Monthly
			usercount = Monthly

		} else if impcapping.Cappings.Intervel == "total" {
			timetest = impcapping.Durations.EndHour
			impcount = impcapping.Cappings.Count
			usercount = 0

		}
	} else if impcapping.Pacing == "asap" {
		if impcapping.Cappings.Intervel == "day" {
			incrementcount = 86400000
			timetest = impcapping.Durations.StartHour
			for i := 0; i < Daily; i++ {
				timetest = timetest + incrementcount
				if timenow > int64(impcapping.Durations.StartHour) && timenow < int64(timetest) {
					countreduce = i
					countreducee = 1
					break
				}
				if i == 23 {
					i = 0
				}
			}
			impcount = impcapping.Cappings.Count

			usercount = 365

		} else if impcapping.Cappings.Intervel == "month" {
			incrementcount = 2678400000
			timetest = impcapping.Durations.StartHour
			for i := 0; i < Monthly; i++ {
				timetest = timetest + incrementcount
				if timenow > int64(impcapping.Durations.StartHour) && timenow < int64(timetest) {
					countreduce = i
					countreducee = 1
					break
				}
				if i == 11 {
					i = 0
				}
			}
			impcount = impcapping.Cappings.Count
			usercount = 12

		} else if impcapping.Cappings.Intervel == "total" {
			timetest = impcapping.Durations.EndHour
			impcount = impcapping.Cappings.Count
			usercount = 0

		}
	}
	return timetest, impcount, usercount, countreduce
}

func CookieSetorGet(key string, value string, adsource structure.AdSourceDetails, r *http.Request, w http.ResponseWriter, conveter bool, expire bool) string {
	var cappingvalue string
	var err error
	if conveter && !expire {
		redisrepo.SetKey(key+adsource.Adsourceid, value, 0)
		return ""
	} else if conveter && expire {
		redisrepo.SetKey(key+adsource.Adsourceid, value, 1)
		return ""
	} else if !conveter && !expire {
		cappingvalue, err = redisrepo.CappingGetKey(key + adsource.Adsourceid)
		if err != nil {
			redisrepo.SetKey(key+adsource.Adsourceid, value, 0)
			return ""
		}
		return cappingvalue
	} else if !conveter && expire {
		cappingvalue, err = redisrepo.CappingGetKey(key + adsource.Adsourceid)
		if err != nil {
			redisrepo.SetKey(key+adsource.Adsourceid, value, 1)
			return value
		}
		return cappingvalue
	}
	return ""
}
