package adunit

import (
	"alpha/addelivery/capping"
	"alpha/addelivery/delivery"
	"alpha/addelivery/deliverylimitation"
	"alpha/addelivery/fetching"
	"alpha/addelivery/helper"
	"alpha/addelivery/structure"
	"alpha/addelivery/validation"
	config "alpha/configuration"
	"analytics/clickClient"
	"fmt"
	"net/http"
	"sort"
	"strconv"
	"sync"
	"time"
)

func GetTagDetails(admaruOutput *structure.AdmaruOutput) {
	tag_id := admaruOutput.Tag_id
	tag_info := fetching.FetchTagModel(tag_id)
	admaruOutput.Tag_Generation = tag_info
}

func GetAdunitDetails(adunit1 string) structure.AdUnitDetails {
	adunit_info := fetching.FetchAdunitModel(adunit1)
	return adunit_info
}

func GetAdsourceDetails(admaruoutput *structure.AdmaruOutput, adunit_id string, w http.ResponseWriter, r *http.Request) {

	var Multiadchecker int
	connDetails, connectionidx := fetching.FetchConnDetails(adunit_id)
	listOfConnections := make(map[string][]structure.ConnAdSourceDetails)
	var check bool = true
	listOfConnections["priority_1"] = connDetails.Priorty_1
	listOfConnections["priority_2"] = connDetails.Priorty_2
	listOfConnections["priority_3"] = connDetails.Priorty_3
	listOfConnections["priority_4"] = connDetails.Priorty_4
	listOfConnections["priority_5"] = connDetails.Priorty_5

	marketPlaceConnDetails, marketPlaceconnectionidx := fetching.MarketPlaceFetchConnDetails(adunit_id)
	listOfMarketPlaceConnections := make(map[string][]structure.ConnMarketAdSourceDetails)
	listOfMarketPlaceConnections["priority_1"] = marketPlaceConnDetails.Priorty_1
	listOfMarketPlaceConnections["priority_2"] = marketPlaceConnDetails.Priorty_2
	listOfMarketPlaceConnections["priority_3"] = marketPlaceConnDetails.Priorty_3
	listOfMarketPlaceConnections["priority_4"] = marketPlaceConnDetails.Priorty_4
	listOfMarketPlaceConnections["priority_5"] = marketPlaceConnDetails.Priorty_5
	connectionidx = append(connectionidx, marketPlaceconnectionidx...)
	filteredconnections := []structure.AdSourceDetails{}

	Priority := PriorityChecker(connectionidx)

	if admaruoutput.MultiadPrebidCal == "yes" {
		admaruoutput.MultiAdformatPriority = helper.StringToInt(helper.GetUrlParam(r, "MultiAdformatPriority"))
	} else {
		admaruoutput.MultiAdformatPriority = 0
	}
	if admaruoutput.Adunit_type == "PrebidPriority" {
		admaruoutput.MultiAdformatPriority = admaruoutput.Priority_Call
	}
	for i := admaruoutput.MultiAdformatPriority; i < len(Priority); i++ {
		if admaruoutput.AdDelivered == true {
			break
		}
		if (i != admaruoutput.MultiAdformatPriority && admaruoutput.MultiadPrebidCal == "yes") || admaruoutput.Adunit_type == "PrebidPriority" {
			admaruoutput.NextPriority = true
		}
		n := Priority[i]
		singlePriority := listOfConnections[n]
		marketPlaceSinglePriority := listOfMarketPlaceConnections[n]
		if len(marketPlaceSinglePriority) != 0 {
			var ConnectedADSInMarketPlace structure.ConnectedADSInMarketPlace
			var AdsInMarketPlace []structure.ConnAdSourceDetails
			for _, i := range marketPlaceSinglePriority {
				Marketplace := fetching.FetchMarketplace(i.MarketAdsourceid)
				if Marketplace.Status == "1" && Marketplace.Is_Deleted == "" {
					ConnectedADSInMarketPlace = fetching.FetchConnectedAdsInMarketPlace(i.MarketAdsourceid)
					AdsInMarketPlace = append(AdsInMarketPlace, ConnectedADSInMarketPlace.Adsources...)
				}

			}
			if len(AdsInMarketPlace) >= 0 {
				if len(AdsInMarketPlace) == 0 {
					admaruoutput.MultiAdFormat = false
				} else {
					admaruoutput.MultiAdFormat = true
				}
				for _, adsid := range AdsInMarketPlace {
					adsource_info := fetching.FetchAdsourceModel(adsid.Adsourceid)

					if validation.AdsourceValidation(adsource_info.Adformat, adsource_info.Src_Obj, adsource_info.Adtype, adsource_info.Bidprice, adsource_info.FileName, adsource_info.Provider, adsource_info.Width, adsource_info.Height, adsource_info.Status, adsource_info.Is_Deleted, adsource_info.Env_Type, admaruoutput.Globalvariable.Environment) {
						if adsource_info.Adformat == "Banner" {
							if adsource_info.Height == admaruoutput.Banner_Template.Height && adsource_info.Width == admaruoutput.Banner_Template.Width {
								filteredconnections = append(filteredconnections, adsource_info)
							}
						} else {
							filteredconnections = append(filteredconnections, adsource_info)
						}

						if (adsource_info.Adtype == "B_PBID" || adsource_info.Adtype == "V_PBID") && admaruoutput.MultiAdFormat {
							admaruoutput.PrebidConnected = true
						}
						check = false
					}

				}
				for j := 0; j < len(singlePriority); j++ {
					adsource_id := singlePriority[j].Adsourceid
					adsource_info := fetching.FetchAdsourceModel(adsource_id)
					if validation.AdsourceValidation(adsource_info.Adformat, adsource_info.Src_Obj, adsource_info.Adtype, adsource_info.Bidprice, adsource_info.FileName, adsource_info.Provider, adsource_info.Width, adsource_info.Height, adsource_info.Status, adsource_info.Is_Deleted, adsource_info.Env_Type, admaruoutput.Globalvariable.Environment) {
						filteredconnections = append(filteredconnections, adsource_info)
						if adsource_info.Adtype == "B_PBID" || adsource_info.Adtype == "V_PBID" {
							admaruoutput.PrebidConnected = true
						}
						check = false
					}

				}

			} else {
				admaruoutput.MultiAdFormat = false
				for j := 0; j < len(singlePriority); j++ {
					adsource_id := singlePriority[j].Adsourceid
					adsource_info := fetching.FetchAdsourceModel(adsource_id)
					if validation.AdsourceValidation(adsource_info.Adformat, adsource_info.Src_Obj, adsource_info.Adtype, adsource_info.Bidprice, adsource_info.FileName, adsource_info.Provider, adsource_info.Width, adsource_info.Height, adsource_info.Status, adsource_info.Is_Deleted, adsource_info.Env_Type, admaruoutput.Globalvariable.Environment) {
						filteredconnections = append(filteredconnections, adsource_info)
						check = false
					}

				}
			}
		} else {

			for j := 0; j < len(singlePriority); j++ {
				adsource_id := singlePriority[j].Adsourceid
				adsource_info := fetching.FetchAdsourceModel(adsource_id)

				if validation.AdsourceValidation(adsource_info.Adformat, adsource_info.Src_Obj, adsource_info.Adtype, adsource_info.Bidprice, adsource_info.FileName, adsource_info.Provider, adsource_info.Width, adsource_info.Height, adsource_info.Status, adsource_info.Is_Deleted, adsource_info.Env_Type, admaruoutput.Globalvariable.Environment) {
					if adsource_info.Adtype == "B_PBID" || adsource_info.Adtype == "V_PBID" {
						Multiadchecker++
						admaruoutput.PrebidConnected = true
					}
					filteredconnections = append(filteredconnections, adsource_info)
					check = false
				}

				if Multiadchecker != 0 {
					admaruoutput.MultiAdFormat = true
				}

			}
		}
		if check == true {
			continue
		} else {
			admaruoutput.Priority_Level = i
			if i+1 != len(Priority) {
				admaruoutput.Priority_Next = i + 1
			}

			AdDeliveryProcess(filteredconnections, admaruoutput, w, r)
		}
		if admaruoutput.External_ad == true || admaruoutput.Internal_ad == true {
			break
		}
		filteredconnections = nil
		admaruoutput.Drtadsource = nil
		admaruoutput.Prgrmadsource = nil
		admaruoutput.MPadsource = nil
		admaruoutput.DrtadsourceRes = nil
		admaruoutput.PrgrmadsourceRes = nil
		admaruoutput.RTBAdsources = nil
		admaruoutput.PrebidAdsources = nil
		admaruoutput.MPRTBAdsources = nil
		admaruoutput.MPPrebidAdsources = nil
		admaruoutput.PrebidConnected = false
		admaruoutput.RTBAdsourcesRes = nil
		admaruoutput.NextPriority = false
	}

}
func HighestCPMCal(adsource []structure.AdSourceDetails) structure.AdSourceDetails {

	adsarray := structure.AdSourceDetails{}
	adsarray = adsource[0]
	var price float64
	p, err := strconv.ParseFloat(adsarray.Bidprice, 64)
	if err == nil {
		fmt.Println(err)
	}
	price = p
	for i, v := range adsource {
		s, err := strconv.ParseFloat(v.Bidprice, 64)
		if err == nil {
			fmt.Println(err)
		}
		if price < s {
			adsarray = adsource[i]
		}
	}
	return adsarray

}

func AdDeliveryProcess(filteredconnections []structure.AdSourceDetails, admaruoutput *structure.AdmaruOutput, w http.ResponseWriter, r *http.Request) {

	admaruoutput.Adsource_details = filteredconnections
	var targetchecker bool
	targetchecker = false
	var wg sync.WaitGroup
	var mu sync.Mutex
	wg.Add(len(admaruoutput.Adsource_details))
	for _, val2 := range admaruoutput.Adsource_details {

		go AllAdsourceChecks(val2, admaruoutput, w, r, &wg, &mu)

	}
	wg.Wait()

	switch {
	//Direct,Prebid,MarketPlace
	case len(admaruoutput.Drtadsource) != 0 && len(admaruoutput.Prgrmadsource) != 0:
		wg.Add(len(admaruoutput.Drtadsource) + len(admaruoutput.Prgrmadsource))
		for _, val := range admaruoutput.Drtadsource {
			go DirectAdArrayAdd(val, targetchecker, admaruoutput, w, r, &wg, &mu)
		}
		for _, val := range admaruoutput.Prgrmadsource {
			go ProgramAdArrayAdd(val, targetchecker, admaruoutput, w, r, &wg, &mu)
		}
		wg.Wait()

		//Direct
	case len(admaruoutput.Drtadsource) != 0:
		wg.Add(len(admaruoutput.Drtadsource))
		for _, val := range admaruoutput.Drtadsource {
			go DirectAdArrayAdd(val, targetchecker, admaruoutput, w, r, &wg, &mu)
		}
		wg.Wait()
		//Prebid
	case len(admaruoutput.Prgrmadsource) != 0:
		wg.Add(len(admaruoutput.Prgrmadsource))
		for _, val := range admaruoutput.Prgrmadsource {
			go ProgramAdArrayAdd(val, targetchecker, admaruoutput, w, r, &wg, &mu)
		}
		wg.Wait()
		//MarketPlace
	}

	if (len(admaruoutput.DrtadsourceRes) != 0 && len(admaruoutput.RTBAdsourcesRes) != 0 && len(admaruoutput.PrebidAdsources) != 0) || (len(admaruoutput.DrtadsourceRes) != 0 && len(admaruoutput.RTBAdsourcesRes) != 0) || (len(admaruoutput.PrebidAdsources) != 0 && len(admaruoutput.DrtadsourceRes) != 0) || (len(admaruoutput.PrebidAdsources) != 0 && len(admaruoutput.RTBAdsourcesRes) != 0) {
		admaruoutput.MultiAdFormat = true
	}

	//Delivery flow
	switch {
	case admaruoutput.MultiAdFormat == true && (len(admaruoutput.DrtadsourceRes) != 0 || len(admaruoutput.RTBAdsourcesRes) != 0):

		switch {

		case admaruoutput.MultiadPrebidCal == "yes" && admaruoutput.MultiAdFormat:
			admaruoutput.Multiads = true
			if admaruoutput.NextPriority {
				if len(admaruoutput.PrebidAdsources) != 0 {

					delivery.PrebidAd(admaruoutput.PrebidAdsources, admaruoutput)

				} else if len(admaruoutput.DrtadsourceRes) != 0 && len(admaruoutput.RTBAdsourcesRes) != 0 {
					admaruoutput.Multiads = true
					wg.Add(2)

					go delivery.DirectAD(admaruoutput, admaruoutput.DrtadsourceRes, &wg, w, r)
					go delivery.ProgrammaticAd(admaruoutput, admaruoutput.RTBAdsourcesRes, &wg, r, w)
					wg.Wait()
				} else if len(admaruoutput.DrtadsourceRes) != 0 {
					wg.Add(1)
					go delivery.DirectAD(admaruoutput, admaruoutput.DrtadsourceRes, &wg, w, r)
					wg.Wait()
				} else {
					admaruoutput.Multiads = true
					wg.Add(1)
					go delivery.ProgrammaticAd(admaruoutput, admaruoutput.RTBAdsourcesRes, &wg, r, w)
					wg.Wait()
				}
			} else if len(admaruoutput.DrtadsourceRes) != 0 && len(admaruoutput.RTBAdsourcesRes) != 0 {
				admaruoutput.Multiads = true
				wg.Add(2)

				go delivery.DirectAD(admaruoutput, admaruoutput.DrtadsourceRes, &wg, w, r)
				go delivery.ProgrammaticAd(admaruoutput, admaruoutput.RTBAdsourcesRes, &wg, r, w)
				wg.Wait()
			} else if len(admaruoutput.DrtadsourceRes) != 0 {
				wg.Add(1)
				go delivery.DirectAD(admaruoutput, admaruoutput.DrtadsourceRes, &wg, w, r)
				wg.Wait()
			} else {
				admaruoutput.Multiads = true
				wg.Add(1)
				go delivery.ProgrammaticAd(admaruoutput, admaruoutput.RTBAdsourcesRes, &wg, r, w)
				wg.Wait()
			}
			if admaruoutput.Multiads == true {
				delivery.MultiAdBiddingCal(admaruoutput, r, w)
			}

		case (admaruoutput.MultiadPrebidCal == "" && admaruoutput.MultiAdFormat):

			if len(admaruoutput.PrebidAdsources) != 0 {

				delivery.PrebidAd(admaruoutput.PrebidAdsources, admaruoutput)

			} else if len(admaruoutput.DrtadsourceRes) != 0 && len(admaruoutput.RTBAdsourcesRes) != 0 {
				admaruoutput.Multiads = true
				wg.Add(2)
				go delivery.DirectAD(admaruoutput, admaruoutput.DrtadsourceRes, &wg, w, r)
				go delivery.ProgrammaticAd(admaruoutput, admaruoutput.RTBAdsourcesRes, &wg, r, w)
				wg.Wait()
			} else if len(admaruoutput.DrtadsourceRes) != 0 {
				wg.Add(1)
				go delivery.DirectAD(admaruoutput, admaruoutput.DrtadsourceRes, &wg, w, r)
				wg.Wait()
			} else {
				admaruoutput.Multiads = true
				wg.Add(1)
				go delivery.ProgrammaticAd(admaruoutput, admaruoutput.RTBAdsourcesRes, &wg, r, w)
				wg.Wait()
			}
			if admaruoutput.Multiads == true {
				delivery.MultiAdBiddingCal(admaruoutput, r, w)
			}

		}

	case len(admaruoutput.DrtadsourceRes) != 0:

		admaruoutput.Multiads = false
		wg.Add(1)
		go delivery.DirectAD(admaruoutput, admaruoutput.DrtadsourceRes, &wg, w, r)
		wg.Wait()

	case len(admaruoutput.RTBAdsourcesRes) != 0:
		admaruoutput.Multiads = false
		wg.Add(1)
		go delivery.ProgrammaticAd(admaruoutput, admaruoutput.RTBAdsourcesRes, &wg, r, w)
		wg.Wait()

	case len(admaruoutput.PrebidAdsources) != 0:

		admaruoutput.Multiads = false
		admaruoutput.MultiAdFormat = false
		delivery.PrebidAd(admaruoutput.PrebidAdsources, admaruoutput)

	}

}

func AllAdsourceChecks(adsource structure.AdSourceDetails, admaruoutput *structure.AdmaruOutput, w http.ResponseWriter, r *http.Request, wg *sync.WaitGroup, mu *sync.Mutex) {
	defer wg.Done()
	provider_info := fetching.FetchProviderDetails(adsource.Provider)
	if provider_info.Status == "1" && provider_info.Is_Deleted == "" {

		adsource.Request_id = admaruoutput.Request_Id

	}

	adsource.Provider_Src_id = provider_info.ProviderSrc

	if (admaruoutput.MultiadPrebidCal == "yes" && admaruoutput.NextPriority == true) || (admaruoutput.MultiadPrebidCal != "yes") {
		if adsource.Adtype != "B_PBID" && adsource.Adtype != "V_PBID" {
			go RequestStats_N(adsource, admaruoutput)
		}
	}

	switch {
	case provider_info.Type == "0":
		mu.Lock()
		admaruoutput.Drtadsource = append(admaruoutput.Drtadsource, adsource)
		mu.Unlock()
	case provider_info.Type == "1":
		mu.Lock()
		admaruoutput.Prgrmadsource = append(admaruoutput.Prgrmadsource, adsource)
		mu.Unlock()
	case provider_info.Type == "2":
		if adsource.Adtype == "B_HTML" || adsource.Adtype == "B_IMG" || adsource.Adtype == "B_LINK" || adsource.Adtype == "B_TAG" || adsource.Adtype == "V_LINEAR" || adsource.Adtype == "V_LINK" || adsource.Adtype == "V_VAST" {
			mu.Lock()
			admaruoutput.Drtadsource = append(admaruoutput.Drtadsource, adsource)
			mu.Unlock()
		} else {
			mu.Lock()
			admaruoutput.Prgrmadsource = append(admaruoutput.Prgrmadsource, adsource)
			mu.Unlock()
		}
	}

}

func DirectAdArrayAdd(adsource structure.AdSourceDetails, targetchecker bool, admaruoutput *structure.AdmaruOutput, w http.ResponseWriter, r *http.Request, wg *sync.WaitGroup, mu *sync.Mutex) {
	var count string
	targetchecker = false
	defer wg.Done()
	if len(adsource.TargetData.OS) != 0 || len(adsource.TargetData.Country) != 0 || len(adsource.TargetData.Enviroment) != 0 || len(adsource.TargetData.DaysHours) != 0 {
		targetchecker = true
	}

	switch {
	case admaruoutput.Adunit_type != "Adapter" && adsource.Capping.Pacing != "" && targetchecker:

		if validation.CappingValidation(adsource.Capping.Durations.StartHour, adsource.Capping.Durations.EndHour, adsource.Capping.Pacing, adsource.Capping.Cappings.Count, adsource.Capping.Cappings.Intervel) {
			demo := capping.CheckAdsCapping(adsource, r)
			ChDeliveyLimit := deliverylimitation.CheckAcls(adsource.TargetData, r)
			if demo && ChDeliveyLimit {
				count = "1"
				switch {
				case admaruoutput.MultiadPrebidCal == "yes":
					if admaruoutput.NextPriority == true {
						go ResponseStats_N(adsource, admaruoutput, count)
					}

				case admaruoutput.MultiadPrebidCal != "yes":
					go ResponseStats_N(adsource, admaruoutput, count)
				}

				SumOfDirectADSRES(admaruoutput, adsource, mu)
			}
		}

	case admaruoutput.Adunit_type != "Adapter" && adsource.Capping.Pacing != "":

		if validation.CappingValidation(adsource.Capping.Durations.StartHour, adsource.Capping.Durations.EndHour, adsource.Capping.Pacing, adsource.Capping.Cappings.Count, adsource.Capping.Cappings.Intervel) {
			demo := capping.CheckAdsCapping(adsource, r)
			if demo {
				count = "1"
				switch {
				case admaruoutput.MultiadPrebidCal == "yes":
					if admaruoutput.NextPriority == true {
						go ResponseStats_N(adsource, admaruoutput, count)
					}

				case admaruoutput.MultiadPrebidCal != "yes":
					go ResponseStats_N(adsource, admaruoutput, count)
				}

				SumOfDirectADSRES(admaruoutput, adsource, mu)
			}
		}

	case targetchecker:
		ChDeliveyLimit := deliverylimitation.CheckAcls(adsource.TargetData, r)
		if ChDeliveyLimit {
			count = "1"
			switch {
			case admaruoutput.MultiadPrebidCal == "yes":
				if admaruoutput.NextPriority == true {
					go ResponseStats_N(adsource, admaruoutput, count)
				}

			case admaruoutput.MultiadPrebidCal != "yes":
				go ResponseStats_N(adsource, admaruoutput, count)
			}
			SumOfDirectADSRES(admaruoutput, adsource, mu)
		}

	default:
		count = "1"
		switch {
		case admaruoutput.MultiadPrebidCal == "yes":
			if admaruoutput.NextPriority == true {
				go ResponseStats_N(adsource, admaruoutput, count)
			}

		case admaruoutput.MultiadPrebidCal != "yes":
			go ResponseStats_N(adsource, admaruoutput, count)
		}
		SumOfDirectADSRES(admaruoutput, adsource, mu)

	}
}

func SumOfDirectADSRES(admaruoutput *structure.AdmaruOutput, adsource structure.AdSourceDetails, mu *sync.Mutex) {
	mu.Lock()
	admaruoutput.DrtadsourceRes = append(admaruoutput.DrtadsourceRes, adsource)
	mu.Unlock()
}

func ProgramAdArrayAdd(adsource structure.AdSourceDetails, targetchecker bool, admaruoutput *structure.AdmaruOutput, w http.ResponseWriter, r *http.Request, wg *sync.WaitGroup, mu *sync.Mutex) {
	targetchecker = false
	defer wg.Done()
	if len(adsource.TargetData.OS) != 0 || len(adsource.TargetData.Country) != 0 || len(adsource.TargetData.Enviroment) != 0 || len(adsource.TargetData.DaysHours) != 0 {
		targetchecker = true
	}

	if targetchecker {
		ChDeliveyLimit := deliverylimitation.CheckAcls(adsource.TargetData, r)
		if ChDeliveyLimit {
			SumOfProgrmADSRES(admaruoutput, adsource, mu)
		} else {
			switch {
			case admaruoutput.MultiadPrebidCal != "yes":
				if admaruoutput.Adunit_type != "Adapter" && (adsource.Adtype == "B_PBID" || adsource.Adtype == "V_PBID") {
					go RequestStats_N(adsource, admaruoutput)
				}
			case admaruoutput.MultiadPrebidCal == "yes":
				if admaruoutput.NextPriority == true && (adsource.Adtype == "B_PBID" || adsource.Adtype == "V_PBID") {
					go RequestStats_N(adsource, admaruoutput)
				}
			}

		}
	} else {
		SumOfProgrmADSRES(admaruoutput, adsource, mu)

	}
}
func SumOfProgrmADSRES(admaruoutput *structure.AdmaruOutput, adsource structure.AdSourceDetails, mu *sync.Mutex) {
	mu.Lock()
	if adsource.Adtype != "B_PBID" && adsource.Adtype != "V_PBID" {
		Providersrc := fetching.FetchProviderCookieSync(adsource.Provider_Src_id)
		adsource.Cookie_Sync_url = Providersrc.Cookie_sync_url
		admaruoutput.RTBAdsourcesRes = append(admaruoutput.RTBAdsourcesRes, adsource)
	} else {
		if admaruoutput.Adunit_type != "Adapter" {
			if admaruoutput.Adunit_details.Adunit_type == "1" && adsource.Adformat == "Video" {
				admaruoutput.Is_Multiadformat = true
			}
			admaruoutput.PrebidAdsources = append(admaruoutput.PrebidAdsources, adsource)
		}
	}
	mu.Unlock()
}

func TrackAdReq(admaruoutput *structure.AdmaruOutput) {

	Domain := admaruoutput.Globalvariable.Source
	Country_code := admaruoutput.Globalvariable.Country_code
	Country_name := admaruoutput.Globalvariable.Country_name
	env := admaruoutput.Globalvariable.Environment
	request, err := http.NewRequest("GET", config.GetConfig("protocol", "webpath")+config.GetConfig("delivery", "webpath")+"/Track_adrequest?req_id="+admaruoutput.Request_Id+"&publisher_id="+admaruoutput.Adunit_details.Publisher+"&adunit_id="+admaruoutput.Adunit_details.Adunit_id+"&tagid="+admaruoutput.Tag_Generation.Tag_id+"&tagtempid="+admaruoutput.Tag_Generation.Template_id+"&ip="+admaruoutput.Globalvariable.Ip_address+"&domain="+Domain+"&country_code="+Country_code+"&country_name="+Country_name+"&os="+admaruoutput.Globalvariable.Os+"&environment="+env, nil)
	if err != nil {
		fmt.Println(err)
	}

	client := &http.Client{Timeout: time.Duration(0) * time.Millisecond}
	resp, err := client.Do(request)
	if err != nil {
		fmt.Println(err)
	}
	defer resp.Body.Close()

}

func RequestStats(Adsource structure.AdSourceDetails, admaruoutput *structure.AdmaruOutput) {

	requeststats, err := http.NewRequest("GET", config.GetConfig("protocol", "webpath")+config.GetConfig("delivery", "webpath")+"/Ad_Request?req_id="+Adsource.Request_id+"&publisher_id="+admaruoutput.Adunit_details.Publisher+"&adunit_id="+admaruoutput.Adunit_details.Adunit_id+"&provider_id="+Adsource.Provider+"&adsource_id="+Adsource.Adsourceid+"&tagid="+admaruoutput.Tag_Generation.Tag_id+"&tagtempid="+admaruoutput.Tag_Generation.Template_id+"&pro_src_id="+Adsource.Provider_Src_id+"&req_count=1", nil)
	if err != nil {
		fmt.Println(err)
	}

	clientstates := &http.Client{Timeout: time.Duration(0) * time.Millisecond}
	respstats, err := clientstates.Do(requeststats)
	if err != nil {
		fmt.Println(err)
	}
	if respstats == nil {
	}
	if respstats != nil {
		respstats.Body.Close()
	}

}

func ResponseStats(Adsource structure.AdSourceDetails, admaruoutput *structure.AdmaruOutput, count string) {

	response, err := http.NewRequest("GET", config.GetConfig("protocol", "webpath")+config.GetConfig("delivery", "webpath")+"/Ad_Response?req_id="+Adsource.Request_id+"&publisher_id="+admaruoutput.Adunit_details.Publisher+"&adunit_id="+admaruoutput.Adunit_details.Adunit_id+"&provider_id="+Adsource.Provider+"&adsource_id="+Adsource.Adsourceid+"&tagid="+admaruoutput.Tag_Generation.Tag_id+"&tagtempid="+admaruoutput.Tag_Generation.Template_id+"&pro_src_id="+Adsource.Provider_Src_id+"&res_count="+count, nil)
	if err != nil {
		fmt.Println(err)
	}

	client := &http.Client{Timeout: time.Duration(0) * time.Millisecond}
	resp, err := client.Do(response)
	if err != nil {
		fmt.Println(err)
	}
	defer resp.Body.Close()

}

func TrackAdReq_N(admaruoutput *structure.AdmaruOutput) {
	env := admaruoutput.Globalvariable.Environment
	env_str := helper.StringToInt(env)
	environment := int8(env_str)
	clickClient.Track_ad_request(admaruoutput.Request_Id, admaruoutput.Adunit_details.Adunit_id, admaruoutput.Adunit_details.Publisher, admaruoutput.Tag_Generation.Template_id, admaruoutput.Tag_Generation.Tag_id, admaruoutput.Globalvariable.Ip_address, admaruoutput.Globalvariable.Source, admaruoutput.Globalvariable.Country_code, admaruoutput.Globalvariable.Country_name, admaruoutput.Globalvariable.Os, environment)
}

func RequestStats_N(Adsource structure.AdSourceDetails, admaruoutput *structure.AdmaruOutput) {
	clickClient.Track_request(admaruoutput.Adunit_details.Publisher, admaruoutput.Adunit_details.Adunit_id, Adsource.Provider, Adsource.Adsourceid, Adsource.Request_id, admaruoutput.Tag_Generation.Tag_id, admaruoutput.Tag_Generation.Template_id, Adsource.Provider_Src_id, 1)
}

func ResponseStats_N(Adsource structure.AdSourceDetails, admaruoutput *structure.AdmaruOutput, count string) {
	count_str := helper.StringToInt(count)
	count_int := int8(count_str)
	clickClient.Track_response(admaruoutput.Adunit_details.Publisher, admaruoutput.Adunit_details.Adunit_id, Adsource.Provider, Adsource.Adsourceid, Adsource.Request_id, admaruoutput.Tag_Generation.Tag_id, admaruoutput.Tag_Generation.Template_id, Adsource.Provider_Src_id, count_int)
}

func PriorityChecker(prioritylevel []string) []string {
	customOrder := []string{"priority_1", "priority_2", "priority_3", "priority_4", "priority_5"}

	orderMap := make(map[string]int)
	for i, v := range customOrder {
		orderMap[v] = i
	}

	sort.Slice(prioritylevel, func(i, j int) bool {
		return orderMap[prioritylevel[i]] < orderMap[prioritylevel[j]]
	})
	return removeDuplicates(prioritylevel[:])
}

func removeDuplicates(input []string) []string {
	uniqueMap := make(map[string]bool)
	result := []string{}

	for _, item := range input {
		if _, exists := uniqueMap[item]; !exists {
			result = append(result, item)
			uniqueMap[item] = true
		}
	}

	return result
}
