package adrtb

import (
	"alpha/addelivery/helper"
	"alpha/addelivery/multiCurrency"
	"alpha/addelivery/structure"
	"encoding/json"
	"fmt"
	"io/ioutil"
	"math"
	"strconv"
	"strings"

	"github.com/gofrs/uuid"
)

func GetId() uuid.UUID {
	var u1 = uuid.Must(uuid.NewV4())
	return u1
}

type demo012 struct {
	Mimes []string `json:"mimes`
}

func GetImpImgObj(admaruOutput *structure.AdmaruOutput, adunitExchage AdunitExchange, adsourceDetails structure.AdSourceDetails, publisherDetails structure.PublisherDetails) []IMP_Obj {
	impImg := IMP_Obj{}
	var bidfloat float64
	var arraywseat []string
	var err error
	impImg.Id = "1"
	if err := json.Unmarshal([]byte(admaruOutput.Temp_Generation.Settings), &admaruOutput.Banner_Template); err != nil {
		fmt.Println(err)
	}

	impImg.Banner.Height = admaruOutput.Banner_Template.Height
	impImg.Banner.Width = admaruOutput.Banner_Template.Width
	impImg.Banner.Mimes = adunitExchage.Mimes.Image

	impImg.TagId = adunitExchage.Tag_id
	if adunitExchage.PMP.Enabled == true {
		arrayofdeals := PMP_obj{}
		arrayofdeals.Private_Auction = 1
		for _, deal := range adunitExchage.PMP.Deals {

			arraywseat = append(arraywseat, deal.Wseat)
			singledeal := Deals{DealId: deal.Dealid, Wseat: arraywseat}
			arrayofdeals.Deal = append(arrayofdeals.Deal, singledeal)
			arraywseat = nil
		}
		impImg.Pmp = arrayofdeals
	} else {
		impImg.Pmp.Private_Auction = 0
	}
	bidprice := adsourceDetails.Bidprice
	if bidfloat, err = strconv.ParseFloat(bidprice, 64); err != nil {
		fmt.Println(err)
	}
	bidpricee := bidfloat

	bid_cur := admaruOutput.Bidding_currency
	acc_cur := admaruOutput.Account_currency
	bidding_price := multiCurrency.Convert_currency(bidpricee, bid_cur, acc_cur)
	impImg.BidFloor = math.Round(bidding_price*10000) / 10000
	impImg.Interstitial = helper.StringToInt(adunitExchage.Interstitial)
	var impTmgs []IMP_Obj
	impTmgs = append(impTmgs, impImg)
	return impTmgs
}

func GetImpVideoObj(admaruOutput *structure.AdmaruOutput, adunitExchage AdunitExchange, adsourceDetails structure.AdSourceDetails, publisherDetails structure.PublisherDetails) []IMP_Video_Obj {
	impImg := IMP_Video_Obj{}
	var err error
	template_settings := structure.Outstream_Template{}

	err = json.Unmarshal([]byte(admaruOutput.Temp_Generation.Settings), &template_settings)
	if err != nil {
		fmt.Println(err)
	}

	var bidfloat float64
	var arraywseat []string

	impImg.Id = "1"
	impImg.Video.Height = template_settings.MinWidth
	impImg.Video.Width = template_settings.MaxWidth
	impImg.Video.MaxDuration = helper.StringToInt(adunitExchage.Maxduration)
	impImg.Video.MaxBitrate = helper.StringToInt(adunitExchage.Maxbitrate)
	if adunitExchage.Framework != "" {
		impImg.Video.APi = append(impImg.Video.APi, ApiFramework(adunitExchage.Framework))
	}

	impImg.Video.Protocol = append(impImg.Video.Protocol, 1, 2, 3, 7)
	if adunitExchage.Protocols != "0" {
		impImg.Video.Protocol = append(impImg.Video.Protocol, 4, 5, 6, 8)
	}
	impImg.Video.Placement = helper.StringToInt(adunitExchage.Placement)
	impImg.Video.PlaybackMethod = append(impImg.Video.PlaybackMethod, helper.StringToInt(adunitExchage.PlaybackMethod))

	impImg.Video.Mimes = VideoMime(adunitExchage.Mimes)

	impImg.TagId = adunitExchage.Tag_id
	if adunitExchage.PMP.Enabled != false {
		arrayofdeals := PMP_obj{}
		arrayofdeals.Private_Auction = 1
		for _, deal := range adunitExchage.PMP.Deals {
			arraywseat = append(arraywseat, deal.Wseat)
			singledeal := Deals{DealId: deal.Dealid, Wseat: arraywseat}
			arrayofdeals.Deal = append(arrayofdeals.Deal, singledeal)
			arraywseat = nil
		}
		impImg.Pmp = arrayofdeals
	} else {
		impImg.Pmp.Private_Auction = 0
	}
	bidprice := adsourceDetails.Bidprice
	if bidfloat, err = strconv.ParseFloat(bidprice, 64); err != nil {
		fmt.Println(err)
	}
	bidpricee := bidfloat

	bid_cur := admaruOutput.Bidding_currency
	acc_cur := admaruOutput.Account_currency
	bidding_price := multiCurrency.Convert_currency(bidpricee, bid_cur, acc_cur)
	impImg.BidFloor = math.Round(bidding_price*10000) / 10000
	impImg.Interstitial = helper.StringToInt(adunitExchage.Interstitial)
	var impTmgs []IMP_Video_Obj
	impTmgs = append(impTmgs, impImg)
	return impTmgs
}

func GetSiteObj(admaruOutput *structure.AdmaruOutput, adunitExchage AdunitExchange, globalVariable structure.GlobalVariables, pubDetails structure.PublisherDetails) SiteObj {
	siteObj := SiteObj{}
	siteObj.Id = adunitExchage.Site_id
	siteObj.Publisher.Id = adunitExchage.Publisher_id
	siteObj.Publisher.Name = pubDetails.Publisher_Name
	siteObj.Publisher.Domain = pubDetails.Website
	return siteObj
}

func GetRestriObj(adunitExchage AdunitExchange) Restrictions_Obj {
	restri := Restrictions_Obj{}
	var Badvv []string
	if adunitExchage.B_Adv_Domain != "" {
		Badvv = append(Badvv, adunitExchage.B_Adv_Domain)
	}
	var Bapp []string
	if adunitExchage.B_Adv_Bundle != "" {
		Bapp = append(Bapp, adunitExchage.B_Adv_Bundle)
	}
	restri.Badv = Badvv
	if len(adunitExchage.B_Adv_Categories) != 0 {
		restri.Bcat = adunitExchage.B_Adv_Categories
	}
	restri.Bapp = Bapp
	return restri
}

func GetUserObj(admaruOutput *structure.AdmaruOutput, adunitExchage AdunitExchange) User_Obj {
	buyerid, buyerid_err := admaruOutput.R.Cookie("b_id")
	user := User_Obj{}
	if buyerid_err == nil {
		user.Buyeruid = buyerid.Value
	}
	return user
}

func GetDeviceObj(adunitExchage AdunitExchange, globalVariable structure.GlobalVariables) Device_Obj {

	device := Device_Obj{}
	if device.DNT == 0 {
		device.UA = globalVariable.Useragent
		device.IP = globalVariable.Ip_address
		device.Make = globalVariable.DeviceName
		device.Model = globalVariable.DeviceModel
		device.OS = globalVariable.Os
		device.OSV = globalVariable.Osv
		device.Geo = GetGeoObj(globalVariable)
		switch globalVariable.DeviceType {
		case "Computer":
			device.DeviceType = 2
		case "Phone":
			device.DeviceType = 1
		case "Tablet":
			device.DeviceType = 5
		case "Tv":
			device.DeviceType = 3
		case "Console":
			device.DeviceType = 7
		default:
			device.DeviceType = 2

		}
	}
	return device
}

func GetGeoObj(globalVariable structure.GlobalVariables) Geo_Obj {

	geoObj := Geo_Obj{}

	geoObj.Type = 1

	data, err1 := ioutil.ReadFile("countrycode.json")
	if err1 != nil {
		fmt.Println("failed reading data from file: %s", err1)
	}
	updatedcountry := make(map[string]string)
	err := json.Unmarshal(data, &updatedcountry)
	if err != nil {
		fmt.Println(err)
	}
	digits := strings.Split(globalVariable.Country_code, "")
	if len(digits) >= 2 {
		geoObj.Country = updatedcountry[globalVariable.Country_code]

	} else {
		geoObj.Country = globalVariable.Country_code
	}

	return geoObj

}

func GetDSP(admaruOutput *structure.AdmaruOutput, adunitExchange AdunitExchange, pub_Details structure.PublisherDetails) []DSP_Obj {
	dsp_objs := []DSP_Obj{}

	var dsp_obj DSP_Obj
	dsp_obj.Id = 1

	dsp_obj.Ver = "2.5"
	dsp_obj.End_Url = string(adunitExchange.Endpoint_URL)
	dsp_obj.At = helper.StringToInt(adunitExchange.Auction_Type)
	dsp_obj.Cur = append(dsp_obj.Cur, pub_Details.Biding_CUR)
	dsp_objs = append(dsp_objs, dsp_obj)

	return dsp_objs
}

func VideoMime(video Mimes) []string {

	var VideoMime []string

	if len(video.VPaid) != 0 {
		for _, val := range video.VPaid {
			VideoMime = append(VideoMime, val)
		}

	}

	if len(video.Video) != 0 {
		for _, v := range video.Video {
			VideoMime = append(VideoMime, v)
		}
	}
	return VideoMime
}

func ApiFramework(framework string) int {
	var value int
	switch framework {
	case "VPAID 1.0":
		value = 1
	case "VPAID 2.0":
		value = 2
	case "MRAID-1":
		value = 3
	case "ORMMA":
		value = 4
	case "MRAID-2":
		value = 5
	case "MRAID-3":
		value = 6
	}
	return value
}

func GetSourceObj(admaruOutput *structure.AdmaruOutput) SourceExt {
	source := SourceExt{}
	Node := Nodes{}
	source.Ext.Schain.Config.Complete = 1
	source.Ext.Schain.Config.Version = "1.0"
	Node.ASI = admaruOutput.PublisherDetails.Publisher_Seller.Domain
	Node.SID = admaruOutput.PublisherDetails.Publisher_Seller.Seller_id
	Node.HP = 1
	source.Ext.Schain.Config.Node = append(source.Ext.Schain.Config.Node, Node)
	return source
}
