package adrtb

import (
	"alpha/addelivery/helper"
	"alpha/addelivery/structure"
)

func GenerateImageObj(admaruOutput *structure.AdmaruOutput, adsource structure.AdSourceDetails, adunitExchage AdunitExchange, siteDetails SiteObj, globalvariable structure.GlobalVariables, pub_Details structure.PublisherDetails) SSP_Request {
	var cur []string
	cur = append(cur, admaruOutput.Bidding_currency)
	ssp_req := SSP_Request{}
	ssp_req.At = helper.StringToInt(adunitExchage.Auction_Type)
	ssp_req.Cur = cur
	ssp_req.Tmax = helper.StringToInt(adunitExchage.Tmax)
	ssp_req.Id = adsource.Request_id
	ssp_req.DSP = GetDSP(admaruOutput, adunitExchage, pub_Details)
	ssp_req.Test = helper.StringToInt(adunitExchage.Test)
	ssp_req.Imp = GetImpImgObj(admaruOutput, adunitExchage, adsource, pub_Details)
	ssp_req.Site = GetSiteObj(admaruOutput, adunitExchage, globalvariable, pub_Details)
	ssp_req.Device = GetDeviceObj(adunitExchage, globalvariable)
	ssp_req.Restriction = GetRestriObj(adunitExchage)
	ssp_req.User = GetUserObj(admaruOutput, adunitExchage)
	ssp_req.Source = GetSourceObj(admaruOutput)

	return ssp_req
}

func GenerateVideoObj(admaruOutput *structure.AdmaruOutput, adsource structure.AdSourceDetails, adunitExchage AdunitExchange, siteDetails SiteObj, globalvariable structure.GlobalVariables, pub_Details structure.PublisherDetails) SSP_Video_Request {
	var cur []string
	cur = append(cur, admaruOutput.Bidding_currency)
	ssp_req := SSP_Video_Request{}
	ssp_req.At = helper.StringToInt(adunitExchage.Auction_Type)
	ssp_req.Cur = cur
	ssp_req.Tmax = helper.StringToInt(adunitExchage.Tmax)
	ssp_req.Id = adsource.Request_id
	ssp_req.DSP = GetDSP(admaruOutput, adunitExchage, pub_Details)
	ssp_req.Test = helper.StringToInt(adunitExchage.Test)
	ssp_req.Imp = GetImpVideoObj(admaruOutput, adunitExchage, adsource, pub_Details)
	ssp_req.Site = GetSiteObj(admaruOutput, adunitExchage, globalvariable, pub_Details)
	ssp_req.Device = GetDeviceObj(adunitExchage, globalvariable)
	ssp_req.Restriction = GetRestriObj(adunitExchage)
	ssp_req.User = GetUserObj(admaruOutput, adunitExchage)
	ssp_req.Source = GetSourceObj(admaruOutput)
	return ssp_req
}
