package adrtb

type PMP_obj_UI struct {
	Enabled bool           `json:"enabled"`
	Deal    []Deals_obj_UI `json:"deals"`
}
type Deals_obj_UI struct {
	DealId string `json:"dealid"`
	Wseat  string `json:"wseat"`
}

/*****************RTB Request Start*******************/
type SSP_Request struct {
	Id          string           `json:"id"`
	At          int              `json:"at"`
	DSP         []DSP_Obj        `json:"dsp"`
	Tmax        int              `json:"tmax"`
	Cur         []string         `json:"cur"`
	Imp         []IMP_Obj        `json:"imp"`
	Device      Device_Obj       `json:"device"`
	Site        SiteObj          `json:"site"`
	Test        int              `json:"test"`
	Restriction Restrictions_Obj `json:"restriction"`
	Reg         Regex            `json:"reg"`
	User        User_Obj         `json:"user"`
	Source      SourceExt        `json:"source"`
}

type SiteObj struct {
	Id        string   `json:"id,omitempty"`
	Publisher Site_pub `json:"pub"`
}

type Site_pub struct {
	Id     string `json:"id"`
	Name   string `json:"name"`
	Domain string `json:"domain"`
}

type DSP_Obj struct {
	Id       int      `json:"id"`
	Ver      string   `json:"ver"`
	End_Url  string   `json:"end_url"`
	At       int      `json:"at"`
	Cur      []string `json:"cur"`
	Source   string   `json:"source"`
	Buyer_id string   `json:"buyer_id"`
}

type IMP_Obj struct {
	Id           string     `json:"id"`
	Banner       Banner_Obj `json:"banner"`
	Pmp          PMP_obj    `json:"pmp"`
	BidFloor     float64    `json:"bidfloor"`
	TagId        string     `json:"tagid"`
	Interstitial int        `json:"instl"`
}

type Banner_Obj struct {
	Width  int      `json:"w"`
	Height int      `json:"h"`
	Mimes  []string `json:"mimes,omitempty"`
}

type Banner_Obj_Mime struct {
	Width  int      `json:"w"`
	Height int      `json:"h"`
	Mimes  []string `json:"mimes"`
}

/************Video RTB Object********************/

type SSP_Video_Request struct {
	Id          string           `json:"id"`
	At          int              `json:"at"`
	DSP         []DSP_Obj        `json:"dsp"`
	Tmax        int              `json:"tmax"`
	Cur         []string         `json:"cur"`
	Imp         []IMP_Video_Obj  `json:"imp"`
	Device      Device_Obj       `json:"device"`
	Site        SiteObj          `json:"site"`
	Test        int              `json:"test"`
	Restriction Restrictions_Obj `json:"restriction"`
	Reg         Regex            `json:"reg"`
	User        User_Obj         `json:"user"`
	Source      SourceExt        `json:"source"`
}

type IMP_Video_Obj struct {
	Id           string    `json:"id"`
	BidFloor     float64   `json:"bidfloor"`
	Video        Video_Obj `json:"video"`
	Pmp          PMP_obj   `json:"pmp"`
	TagId        string    `json:"tagid"`
	Interstitial int       `json:"instl"`
}
type IMP_Video_Obj2 struct {
	Id              string    `json:"id"`
	BidFloor        float64   `json:"bidfloor"`
	Video           Video_Obj `json:"video"`
	Private_Auction int       `json:"Private_auction"`
	TagId           string    `json:"tagid"`
	Interstitial    int       `json:"instl"`
}
type Video_Obj struct {
	Width          int      `json:"w"`
	Height         int      `json:"h"`
	Mimes          []string `json:"mimes"`
	MaxDuration    int      `json:"maxduration"`
	MaxBitrate     int      `json:"maxbitrate"`
	APi            []int    `json:"api"`
	Placement      int      `json:"placement"`
	Protocol       []int    `json:"protocols"`
	PlaybackMethod []int    `json:"playbackmethod"`
}

/************Video RTB Object********************/

type PMP_obj struct {
	Private_Auction int     `json:"private_auction"`
	Deal            []Deals `json:"deals,omitempty"`
}
type Deals struct {
	DealId string   `json:"dealid"`
	Wseat  []string `json:"wseat"`
}

type Device_Obj struct {
	DNT        int     `json:"dnt"`
	UA         string  `json:"ua"`
	IP         string  `json:"ip"`
	Make       string  `json:"make"`
	Model      string  `json:"model"`
	DeviceType int     `json:"devicetype"`
	OS         string  `json:"os"`
	OSV        string  `json:"osv"`
	Geo        Geo_Obj `json:"geo"`
}

type Restrictions_Obj struct {
	Badv []string `json:"badv"`
	Bcat []string `json:"bcat"`
	Bapp []string `json:"bapp"`
}

type Regex struct {
	COPPA int `json:"coppa"`
}

type Geo_Obj struct {
	Latitude  float64 `json:"lat"`
	Longitude float64 `json:"lon"`
	Type      int     `json:"type"`
	Country   string  `json:"country"`
}

type User_Obj struct {
	Buyeruid string `json:"buyeruid"`
}

/*****************RTB Request End*******************/
type CustomResponse struct {
	ID       string  `json:"id"`
	BidID    string  `json:"bidid,omitempty"`
	Currency string  `json:"cur,omitempty"`
	Seat     string  `json:"seat,omitempty"`
	Imp      string  `json:"imp"`
	AdID     string  `json:"adid,omitempty"`
	CID      string  `json:"cid,omitempty"`
	Adm      string  `json:"adm"`
	Price    float64 `json:"price"`
	Bidderid int     `json:"bidderid"`
	NURL     string  `json:"nurl"`
	BURL     string  `json:"burl,omitempty"`
}

type External_Res struct {
	Ads Ads `json:"ads"`
}

type RTBResponse struct {
	Ads Ads `json:"ads"`
}
type Ads struct {
	Bidderid       int      `json:"Bidderid,omitempty"`
	At             int      `json:"at,omitempty"`
	SeconBidBuffer int      `json:"seconBidBuffer,omitempty"`
	Adtype         int      `json:"adtype,omitempty"`
	CookieSync_URL string   `json:"cookiesync_url,omitempty"`
	Floor_Price    float64  `json:"floor_price,omitempty"`
	Response       Response `json:"Response,omitempty"`
}
type Response struct {
	Bidid    string       `json:"bidid,omitempty"`
	Cur      string       `json:"cur,omitempty"`
	Ext      Ext          `json:"ext,omitempty"`
	ID       string       `json:"id,omitempty"`
	Seatbid  []Seatbid    `json:"seatbid,omitempty"`
	Tracking TrackingData `json:"Tracking,omitempty"`
}

type Ext struct {
	Syncurls []string `json:"syncurls"`
	Btype    int      `json:"btype,omitempty"`
}
type Bid struct {
	ID      string   `json:"id,omitempty"`
	Impid   string   `json:"impid,omitempty"`
	Price   float64  `json:"price,omitempty"`
	Adid    string   `json:"adid,omitempty"`
	Nurl    string   `json:"nurl,omitempty"`
	Burl    string   `json:"burl,omitempty"`
	Lurl    string   `json:"lurl,omitempty"`
	Adm     string   `json:"adm,omitempty"`
	Adomain []string `json:"adomain,omitempty"`
	Cid     string   `json:"cid,omitempty"`
	Crid    string   `json:"crid,omitempty"`
	H       int      `json:"h,omitempty,omitempty"`
	W       int      `json:"w,omitempty"`
	Ext     Ext      `json:"ext,omitempty"`
}
type Seatbid struct {
	Bid  []Bid  `json:"bid,omitempty"`
	Seat string `json:"seat,omitempty"`
}

type TrackingData struct {
	Adsource_Id    string
	Request_Id     string
	Provider_Id    string
	ProviderSrc_Id string
	Owned_by       string
}

type SeatBid struct {
	Bids []Bid  `json:"bid,omitempty"`
	Seat string `json:"seat,omitempty"`
}

type Ext_Ext struct {
	Pixelurl string `json:"pixelurl"`
}

//Prebid Structs

type Prebid_Req struct {
	Src_Obj map[string]interface{} `json:"bids"`
}

//testing for prebid

type External__Prebid_Res struct {
	Ads PrebidRes `json:"asd"`
}

type PrebidRes struct {
	ID      string  `json:"id"`
	SeatBid []Seats `json:"seatbid"`
	Cur     string  `json:"cur"`
}

type Seats struct {
	Bid  []Bids `json:"bid"`
	Seat string `json:"seat"`
}
type Bids struct {
	ID      string     `json:"id"`
	Impid   string     `json:"impid"`
	Price   float64    `json:"price"`
	Adm     string     `json:"adm"`
	Adomain []string   `json:"adomain"`
	Iurl    string     `json:"iurl"`
	Crid    string     `json:"crid"`
	H       int        `json:"h"`
	W       int        `json:"w"`
	Ext     Ext_Prebid `json:"ext"`
}

type Ext_Prebid struct {
	Dspid   int `json:"dspid"`
	Bidtype int `json:"bidtype"`
}

type Data struct {
	Pbadslot string `json:"pbadslot,omitempty"`
}
type Pre_Ext struct {
	Data Data `json:"data,omitempty"`
}
type Banner struct {
	W        int `json:"w,omitempty"`
	H        int `json:"h,omitempty"`
	Pos      int `json:"pos,omitempty"`
	Topframe int `json:"topframe,omitempty"`
}
type Imp struct {
	ID          string `json:"id,omitempty"`
	Tagid       string `json:"tagid,omitempty"`
	Secure      int    `json:"secure,omitempty"`
	Ext         Ext    `json:"ext,omitempty"`
	Bidfloorcur string `json:"bidfloorcur,omitempty"`
	Banner      Banner `json:"banner,omitempty"`
}

// Mime struct
type MimeImage struct {
	Image []string `json:"image"`
}

type MimeVideo struct {
	VPaid []string `json:"vpaid"`
	Video []string `json:"video"`
}

/*****************testing**************/
type AdunitExchange struct {
	B_Adv_Categories []string `json:"cat"`
	DNT              string   `json:"dnt"`
	PMP              Pmp      `json:"pmp"`
	Site_id          string   `json:"site"`
	Test             string   `json:"test"`
	Tmax             string   `json:"tmax"`
	Interstitial     string   `json:"instl"`
	Mimes            Mimes    `json:"mimes"`
	Tag_id           string   `json:"tagid"`
	Bidder           string   `json:"bidder"`
	B_Adv_Bundle     string   `json:"bundle"`
	B_Adv_Domain     string   `json:"adomain"`
	Endpoint_URL     string   `json:"endpoint"`
	Type             string   `json:"site_app"`
	DNSProxy         string   `json:"dns_proxy"`
	CookieSync_URL   string   `json:"cookie_sync_url"`
	Cookiesyc        string   `json:"cookiesync"`
	Publisher_id     string   `json:"publisherId"`
	Auction_Type     string   `json:"auction_type"`
	PrivateAuction   string   `json:"private_auction"`
	Maxbitrate       string   `json:"maxbitrate"`
	Maxduration      string   `json:"maxduration"`
	Protocols        string   `json:"protocols"`
	Framework        string   `json:"framework"`
	Placement        string   `json:"placement"`
	Protocol         string   `json:"protocol"`
	PlaybackMethod   string   `json:"playbackmethod"`
}
type Dealss struct {
	Wseat  string `json:"wseat"`
	Dealid string `json:"dealid"`
}
type Pmp struct {
	Deals   []Dealss `json:"deals"`
	Enabled bool     `json:"enabled"`
}
type Mimes struct {
	Image []string `json:"image"`
	VPaid []string `json:"vpaid"`
	Video []string `json:"video"`
}

type ProgramaticRes struct {
	RTBResArray []RTBResponse
}

type SourceExt struct {
	Ext SupplychainPrebid `json:"ext"`
}
type SupplychainPrebid struct {
	Schain Schain `json:"schain"`
}
type Schain struct {
	Config Configuration `json:"config"`
}

type Configuration struct {
	Version  string  `json:"ver"`
	Complete int     `json:"complete"`
	Node     []Nodes `json:"nodes"`
}

type Nodes struct {
	ASI string `json:"asi"`
	SID string `json:"sid"`
	HP  int    `json:"hp"`
}
