package adrtb

import (
	"alpha/addelivery/fetching"
	"alpha/addelivery/helper"
	"alpha/addelivery/multiCurrency"
	"alpha/addelivery/structure"
	config "alpha/configuration"
	"analytics/clickClient"
	"bytes"
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/http"
	"net/url"
	"strconv"

	"strings"
	"sync"
	"time"
)

type InlineContent struct {
	Video_Url        string `json:"video_url"`
	ClickThrough_Url string `json:"ClickThrough_url"`
}

type VideoVast struct {
	Template_Settings  structure.Outstream_Template `json:"template_settings"`
	Bidder_Details     string                       `json:"bidder_details"`
	Request_Id         string                       `json:"Request_Id"`
	ThirdPartyTrackers string                       `json:"third_part_trackers"`
}

var randasd string = helper.RandToken(5)

var GetAPICall string = ` function GetApiCalling(url){
	var xmlHttp = new XMLHttpRequest();
	xmlHttp.open( "GET", url, true );
			xmlHttp.send();
} `

func GetRTBAd(admaruoutput *structure.AdmaruOutput, adsource structure.AdSourceDetails, RTBresar *ProgramaticRes, wg *sync.WaitGroup, mu *sync.Mutex) {
	defer wg.Done()
	demoparam := AdunitExchange{}
	rtbresponce := RTBResponse{}
	var adtype int
	var bidfloat float64
	var err5 error
	globalvariables := admaruoutput.Globalvariable

	err := json.Unmarshal([]byte(adsource.Src_Obj), &demoparam)
	if err != nil {
		fmt.Println(err)
	}

	publisherDetails := fetching.GetPublisherDetails(adsource.Publisher)

	site_obj := SiteObj{}
	site_obj.Id = publisherDetails.Publisher_Id

	var req interface{}
	switch adsource.Adformat {
	case "Banner":
		adtype = 1
		req = GenerateImageObj(admaruoutput, adsource, demoparam, site_obj, globalvariables, publisherDetails)

	case "Video":
		adtype = 2
		req = GenerateVideoObj(admaruoutput, adsource, demoparam, site_obj, globalvariables, publisherDetails)
	}
	req_json, err := json.Marshal(req)
	if err != nil {
		fmt.Println(err)
	}

	request, err := http.NewRequest("POST", config.GetConfig("mainpath", "ssp"), bytes.NewBuffer(req_json))
	request.Header.Set("Content-Type", "application/json")
	client := &http.Client{}
	resp, err := client.Do(request)

	if err != nil {
		fmt.Println(err)
	} else {
		defer resp.Body.Close()
	}

	if resp != nil {
		if resp.Status == "200 OK" {

			body, _ := ioutil.ReadAll(resp.Body)

			err := json.Unmarshal(body, &rtbresponce)
			if err != nil {
				fmt.Println(err)
			}
			if len(rtbresponce.Ads.Response.Seatbid) != 0 && len(rtbresponce.Ads.Response.Seatbid[0].Bid) != 0 {
				go ResponseStats_N(adsource, admaruoutput)

			}

			rtbresponce.Ads.Response.Tracking.Adsource_Id = adsource.Adsourceid
			rtbresponce.Ads.Response.Tracking.Request_Id = adsource.Request_id
			rtbresponce.Ads.Response.Tracking.Provider_Id = adsource.Provider
			rtbresponce.Ads.Response.Tracking.ProviderSrc_Id = adsource.Provider_Src_id
			rtbresponce.Ads.Response.Tracking.Owned_by = adsource.Owned_by

			rtbresponce.Ads.Adtype = adtype
			if bidfloat, err5 = strconv.ParseFloat(adsource.Bidprice, 64); err != nil {
				fmt.Println(err5)
			}
			rtbresponce.Ads.Floor_Price = bidfloat

			rtbresponce.Ads.CookieSync_URL = demoparam.CookieSync_URL
			if len(rtbresponce.Ads.Response.Seatbid) != 0 {
				mu.Lock()
				RTBresar.RTBResArray = append(RTBresar.RTBResArray, rtbresponce)
				mu.Unlock()
			}
		}
	}

	_, buyerid_err := admaruoutput.R.Cookie("b_id")
	if demoparam.CookieSync_URL != "" && buyerid_err != nil {
		if admaruoutput.Html != "" {
			admaruoutput.Html += `<img width=0 height=0 src='` + demoparam.CookieSync_URL + `'>`
		} else {
			admaruoutput.Html = `<img width=0 height=0 src='` + demoparam.CookieSync_URL + `'>`

		}
	}

	if len(rtbresponce.Ads.Response.Ext.Syncurls) != 0 {
		for _, v := range rtbresponce.Ads.Response.Ext.Syncurls {

			admaruoutput.Html = admaruoutput.Html + `<img width=0 height=0 src='` + v + `'>`
		}
	}

	rtbresponce.Ads.Response.Tracking.Adsource_Id = adsource.Adsourceid
	rtbresponce.Ads.Response.Tracking.Request_Id = adsource.Request_id
	rtbresponce.Ads.Response.Tracking.Provider_Id = adsource.Provider
	rtbresponce.Ads.Response.Tracking.ProviderSrc_Id = adsource.Provider_Src_id
	rtbresponce.Ads.Response.Tracking.Owned_by = adsource.Owned_by

}

func GetPrebidBannerAd(admaruoutput *structure.AdmaruOutput, adsource []structure.AdSourceDetails, Is_Multiadformat bool) {

	PrebidSupplychain := structure.SupplychainPrebid{}
	Node := structure.Nodes{}
	PrebidSupplychain.Schain.Validation = "strict"
	PrebidSupplychain.Schain.Config.Version = "1.0"
	PrebidSupplychain.Schain.Config.Complete = 1
	Node.ASI = admaruoutput.PublisherDetails.Publisher_Seller.Domain
	Node.SID = admaruoutput.PublisherDetails.Publisher_Seller.Seller_id
	Node.HP = 1
	PrebidSupplychain.Schain.Config.Node = append(PrebidSupplychain.Schain.Config.Node, Node)
	var randasd string = helper.RandToken(5)
	var size []int
	admaruoutput.DeliveryAdType = "Prebid"
	var rand1 string = helper.RandToken(5)
	var tagid string = "Prebid_" + rand1
	/**********Third Party Tracker Start**********/
	var Impressiondiv string

	var impression1 string
	var impression2 string
	var impression3 string

	var viewimpression1 string
	var viewimpression2 string
	var viewimpression3 string

	var clicks1 string
	var clicks2 string
	var clicks3 string

	Adsource_id := admaruoutput.Adsource_details[0].Adsourceid
	adsoure := fetching.FetchAdsourceTracker(Adsource_id)

	if len(adsoure.Data) > 0 {

		for _, v := range adsoure.Data {

			Event := v.Event
			if Event == "1" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					impimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					impimg = strings.Replace(impimg, `\`, ``, -1)

					impression1 += `<img src='` + impimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					impsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					impsrc2 = strings.Replace(impsrc2, `\`, ``, -1)
					impression2 += strings.Replace(impsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					impsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					impsrc3 = strings.Replace(impsrc3, `\`, ``, -1)
					impression3 += strings.Replace(impsrc3, "  ", " ", -1)
				}
			}

			if Event == "2" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					viewimpimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpimg = strings.Replace(viewimpimg, `\`, ``, -1)

					viewimpression1 += `<img src='` + viewimpimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					viewimpsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpsrc2 = strings.Replace(viewimpsrc2, `\`, ``, -1)
					viewimpression2 += strings.Replace(viewimpsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					viewimpsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpsrc3 = strings.Replace(viewimpsrc3, `\`, ``, -1)
					viewimpression3 += strings.Replace(viewimpsrc3, "  ", " ", -1)
				}
			}

			if Event == "3" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					clicksimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					clicksimg = strings.Replace(clicksimg, `\`, ``, -1)

					clicks1 += `<img src='` + clicksimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					clickssrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					clickssrc2 = strings.Replace(clickssrc2, `\`, ``, -1)
					clicks2 += strings.Replace(clickssrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					clickssrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					clickssrc3 = strings.Replace(clickssrc3, `\`, ``, -1)
					clicks3 += strings.Replace(clickssrc3, "  ", " ", -1)
				}
			}
		}
	}

	adunit := fetching.FetchAdunitTracker(admaruoutput.Adunit_details.Adunit_id)

	if len(adunit.Data) > 0 {

		for _, val := range adunit.Data {

			Event1 := val.Event

			if Event1 == "1" {

				Trackertype := val.Tracker_type

				if Trackertype == "1" {

					impimgu := strings.Replace(val.Tracker_src, "\n", "", -1)
					impimgu = strings.Replace(impimgu, `\`, ``, -1)

					impression1 += `<img src='` + impimgu + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Trackertype == "2" {

					impsrcu := strings.Replace(val.Tracker_src, "\n", "", -1)
					impsrcu = strings.Replace(impsrcu, `\`, ``, -1)
					impression2 += strings.Replace(impsrcu, "  ", " ", -1)

				} else if Trackertype == "3" {

					impsrcf := strings.Replace(val.Tracker_src, "\n", "", -1)
					impsrcf = strings.Replace(impsrcf, `\`, ``, -1)
					impression3 += strings.Replace(impsrcf, "  ", " ", -1)
				}
			}

			if Event1 == "2" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					viewimpimgi := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpimgi = strings.Replace(viewimpimgi, `\`, ``, -1)

					viewimpression1 += `<img src='` + viewimpimgi + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					viewimpsrc2i := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpsrc2i = strings.Replace(viewimpsrc2i, `\`, ``, -1)
					viewimpression2 += strings.Replace(viewimpsrc2i, "  ", " ", -1)

				} else if Tracker_type == "3" {

					viewimpsrc3i := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpsrc3i = strings.Replace(viewimpsrc3i, `\`, ``, -1)
					viewimpression3 += strings.Replace(viewimpsrc3i, "  ", " ", -1)
				}
			}

			if Event1 == "3" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					clicksimg1 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clicksimg1 = strings.Replace(clicksimg1, `\`, ``, -1)

					clicks1 += `<img src='` + clicksimg1 + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					clickssrcu2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clickssrcu2 = strings.Replace(clickssrcu2, `\`, ``, -1)
					clicks2 += strings.Replace(clickssrcu2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					clickssrcu3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clickssrcu3 = strings.Replace(clickssrcu3, `\`, ``, -1)
					clicks3 += strings.Replace(clickssrcu3, "  ", " ", -1)
				}
			}
		}
	}

	if impression2 != "" {
		impression2 = strings.Replace(impression2, "\n", "", -1)
		impression2 = strings.Replace(impression2, `</script>`, `<\/script>`, -1)
	}
	if impression3 != "" {
		impression3 = strings.Replace(impression3, `</script>`, `<\/script>`, -1)
		impression3 = strings.Replace(impression3, "\n", "", -1)
	}

	if admaruoutput.Autorefreshrand != "" {
		rand1 = admaruoutput.Autorefreshrand
	} else if admaruoutput.Autorefreshrand == "" {
		admaruoutput.Autorefreshrand = rand1

	}

	tagid = "Prebid_" + rand1

	finalimpression := impression1 + impression2 + impression3
	var innerHTMLImp string
	if impression1 != "" || impression2 != "" || impression3 != "" {

		Impressiondiv = `<div id='track_` + rand1 + `'></div>`
		if admaruoutput.MultiadPrebidCal != "yes" && admaruoutput.Adunit_type != "PrebidPriority" {
			innerHTMLImp = `var mainDIVImp` + rand1 + ` = document.getElementById('track_` + rand1 + `');
		var childDivImp` + rand1 + ` = document.createElement("div");       
		childDivImp` + rand1 + `.innerHTML = "` + finalimpression + `";
		mainDIVImp` + rand1 + `.appendChild(childDivImp` + rand1 + `);
		var mainscriptImp` + rand1 + ` = mainDIVImp` + rand1 + `.getElementsByTagName("script");
		for (var scriptTagsImp` + rand1 + ` of mainscriptImp` + rand1 + `) {
		  var scriptContentImp` + rand1 + ` = scriptTagsImp` + rand1 + `.textContent;
		  eval(scriptContentImp` + rand1 + `);
		  if (scriptTagsImp` + rand1 + `.src) {
			var scriptElementImp` + rand1 + ` = document.createElement("script");
			scriptElementImp` + rand1 + `.src = scriptTagsImp` + rand1 + `.src;
			document.head.appendChild(scriptElementImp` + rand1 + `);
		  }
		}`
		} else {
			innerHTMLImp = `document.getElementById("track_` + rand1 + `").innerHTML = "` + finalimpression + `";`

		}
	}
	var Clickdiv string
	var innerHTMLclick string
	if clicks1 != "" || clicks2 != "" || clicks3 != "" {

		if clicks2 != "" {
			clicks2 = strings.Replace(clicks2, "\n", "", -1)
			clicks2 = strings.Replace(clicks2, `</script>`, `<\/script>`, -1)
		}
		if clicks3 != "" {
			clicks3 = strings.Replace(clicks3, `</script>`, `<\/script>`, -1)
			clicks3 = strings.Replace(clicks3, "\n", "", -1)
		}

		Clickdiv = `<div id='clk_` + rand1 + `'></div>`
		if admaruoutput.MultiadPrebidCal != "yes" && admaruoutput.Adunit_type != "PrebidPriority" {
			innerHTMLclick = `var mainDIVclick` + rand1 + ` = document.getElementById('clk_` + rand1 + `');
		var childDivclick` + rand1 + ` = document.createElement("div");       
		childDivclick` + rand1 + `.innerHTML = "` + clicks1 + clicks2 + clicks3 + `";
		mainDIVclick` + rand1 + `.appendChild(childDivclick` + rand1 + `);
		var mainscriptclick` + rand1 + ` = mainDIVclick` + rand1 + `.getElementsByTagName("script");
		for (var scriptTagsclick` + rand1 + ` of mainscriptclick` + rand1 + `) {
		  var scriptContentclick` + rand1 + ` = scriptTagsclick` + rand1 + `.textContent;
		  eval(scriptContentclick` + rand1 + `);
		  if (scriptTagsclick` + rand1 + `.src) {
			var scriptElementclick` + rand1 + ` = document.createElement("script");
			scriptElementclick` + rand1 + `.src = scriptTagsclick` + rand1 + `.src;
			document.head.appendChild(scriptElementclick` + rand1 + `);
		  }
		}`
		} else {
			innerHTMLclick = `document.getElementById("clk_` + rand1 + `").innerHTML = "` + clicks1 + clicks2 + clicks3 + `";`

		}
	}

	var viewbleStart string
	var viewbleEnd string
	var viewbleDiv string
	var innerHTML string
	var multitag string
	var autorefStart string
	var autorefEnd string
	if viewimpression1 != "" || viewimpression2 != "" || viewimpression3 != "" {

		if viewimpression2 != "" {
			viewimpression2 = strings.Replace(viewimpression2, "\n", "", -1)
			viewimpression2 = strings.Replace(viewimpression2, `</script>`, `<\/script>`, -1)
		}
		if viewimpression3 != "" {
			viewimpression3 = strings.Replace(viewimpression3, `</script>`, `<\/script>`, -1)
			viewimpression3 = strings.Replace(viewimpression3, "\n", "", -1)
		}

		viewbleDiv = `<div id='viewble_` + rand1 + `'></div>`
		if admaruoutput.MultiadPrebidCal != "yes" && admaruoutput.Adunit_type != "PrebidPriority" {

			innerHTML = `var mainDIVview` + rand1 + ` = document.getElementById('viewble_` + rand1 + `');
		var childDivview` + rand1 + ` = document.createElement("div");       
		childDivview` + rand1 + `.innerHTML = "` + viewimpression1 + viewimpression2 + viewimpression3 + `";
		mainDIVview` + rand1 + `.appendChild(childDivview` + rand1 + `);
		var mainscriptview` + rand1 + ` = mainDIVview` + rand1 + `.getElementsByTagName("script");
		for (var scriptTagsview` + rand1 + ` of mainscriptview` + rand1 + `) {
		  var scriptContentview` + rand1 + ` = scriptTagsview` + rand1 + `.textContent;
		  eval(scriptContentview` + rand1 + `);
		  if (scriptTagsview` + rand1 + `.src) {
			var scriptElementview` + rand1 + ` = document.createElement("script");
			scriptElementview` + rand1 + `.src = scriptTagsview` + rand1 + `.src;
			document.head.appendChild(scriptElementview` + rand1 + `);
		  }
		}`
		} else {
			innerHTML = `document.getElementById('viewble_` + rand1 + `').innerHTML = "` + viewimpression1 + viewimpression2 + viewimpression3 + `";`

		}
		admaruoutput.Viewable_Html = innerHTML
	}

	/**********Third Party Tracker End**********/

	var BidderArray []string
	Biddderjsonmap := make(map[string]interface{})
	Biddermap := make(map[string]interface{})

	size = append(size, admaruoutput.Adunit_details.Width, admaruoutput.Adunit_details.Height)
	for _, v := range adsource {
		err := json.Unmarshal([]byte(v.Src_Obj), &Biddermap)
		if err != nil {
			fmt.Println(err)
		}

		PrebidTracking(Biddermap, admaruoutput, v, rand1)

		Bidderjson, err := json.Marshal(Biddermap)
		if err != nil {
			fmt.Println(err)
		}

		BidderArray = append(BidderArray, string(Bidderjson))

	}

	if admaruoutput.Autorefresh != "yes" && admaruoutput.MultiadPrebidCal != "yes" && admaruoutput.Adunit_type != "PrebidPriority" {
		viewbleStart = `<div id='test-ad` + rand1 + `'> <div id='viewImp_` + rand1 + `'>`
		viewbleEnd = `</div> </div>`

	} else {
		viewbleStart = `<div id='test-ad` + rand1 + `'> `
		viewbleEnd = `</div>`
	}

	autorefStart = `<div id='autoref-ad` + admaruoutput.Autorefreshrand + `'>`

	autorefEnd = `</div>`
	multitag = `<div id="adrend"></div>`

	BiddermapJson, err := json.Marshal(BidderArray)
	if err != nil {
		fmt.Println(err)
	}

	if admaruoutput.Adunit_type != "PrebidPriority" {
		Biddderjsonmap["Addelivery_Tag"] = "no"
	}
	if admaruoutput.MultiAdFormat == true {
		Biddderjsonmap["MarketPlace"] = "yes"
		Biddderjsonmap["MultiAdformatPriority"] = admaruoutput.MultiAdformatPriority
	} else {
		Biddderjsonmap["MarketPlace"] = "no"
	}
	Biddderjsonmap["Bidder_Details"] = string(BiddermapJson)

	Biddderjsonmapp, err := json.Marshal(Biddderjsonmap)
	if err != nil {
		fmt.Println(err)
	}

	var passbackscript string = Passback(admaruoutput, rand1)

	var Videolib string = `		<script src="` + config.GetConfig("path", "player") + `/admaru-player.js"></script>
	<link rel="stylesheet" href="` + config.GetConfig("path", "player") + `/admaru-player.css">
	<script src="https://code.jquery.com/jquery-1.12.1.min.js"></script>`
	if admaruoutput.Is_Multiadformat == false {
		Videolib = ""
	}

	var Track_Req_Res1 string = `
	pbjs.onEvent('bidRequested', bidderRequest => {
		
		if(bidderRequest.auctionId != localStorage.getItem("bid_AuctionId_"+bidderRequest['bids'][count]['bidId']) )
		{
		localStorage.setItem("bid_AuctionId_"+bidderRequest['bids'][count]['bidId'], bidderRequest.auctionId);
			bidderRequest['bids'].forEach(function(v,k){
				if(v!=""){
					
					Request_bids[bidderRequest['bids'][count]['bidId']]=v;count++;
					var Reqcounter = 0;
					if(v['adUnitCode'] == '` + tagid + `' && Reqcounter == 0){
							var Request_URL=v['Request_URL'];
							let myPromise = new Promise(function(myResolve, myReject) {
								myResolve(Request_URL);
							});
							myPromise.then(
							function(value) {GetApiCalling(value);}
							);
					}
					Reqcounter++;		
				}
			});count=0;
		}
		});

	
		pbjs.onEvent('bidResponse', bid => {
		
			if(bid.auctionId == localStorage.getItem("bid_AuctionId_"+bid.requestId) && localStorage.getItem("bid_AuctionId_"+bid.requestId) != "Bidder_done" )
			{
				if(localStorage.getItem("bid_adid_"+bid.requestId) == bid.adId)
				{
					localStorage.setItem("bid_AuctionId_"+bid.requestId, "Bidder_done");
				}else
				{
					var counter = 0;
					if(bid.adUnitCode == '` + tagid + `'){
						localStorage.setItem("bid_adid_"+bid.requestId, bid.adId);
						Res_status="&res_count=1";
						Bidder_Response=bid;
						if(counter == 0){
							var Response_URL=Request_bids[bid['requestId']]['Response_URL'] !="" ? Request_bids[bid['requestId']]['Response_URL']+Res_status :"";
							let myPromise1 = new Promise(function(myResolve, myReject) {
								myResolve(Response_URL);
							});
							myPromise1.then(
							function(value) {GetApiCalling(value);}
							);
						}
						counter++;
					}
				}
			}	
		});`

	var Track_Win_Nobid1 string = ` 
	if(WonBid!="" && WonBid!=null){ 
		localStorage.removeItem("bid_adid_"+WonBid['bidId']);
		localStorage.removeItem("bid_AuctionId_"+WonBid['bidId']);
		var Adwon_URL=WonBid['Adwon_URL'] !="" ? WonBid['Adwon_URL'] :"";
		var AdImpression_URL=WonBid['AdImpression_URL'] !="" ? WonBid['AdImpression_URL']+'&won_price='+highestCpmBids` + randasd + `[0]['cpm'] :"";
		let myPromise1 = new Promise(function(myResolve, myReject) {
			myResolve(Adwon_URL);
		});
		myPromise1.then(
			function(value) {GetApiCalling(value);}
		);
		let myPromise2 = new Promise(function(myResolve, myReject) {
			myResolve(AdImpression_URL);
		});
		myPromise2.then(
			function(value) {GetApiCalling(value);}
		);		
	}`
	var pbjs string = `Request_bids ={};Bidder_Response={};`
	if admaruoutput.Adunit_type != "PrebidPriority" {
		pbjs = `var pbjs = pbjs || {}; pbjs.que = pbjs.que || [];
		var Request_bids ={};var Bidder_Response={};`
	}

	var Prebid_Common_Variables = `var Bids=[` + helper.ConvertStrJsonToRawJson(Biddderjsonmapp) + `];
	var Bidders_Info=Bids[0];
	var Priority_level=Bids[0]['Bidder_Details'][0]['priority'];
	var tag_id=Bids[0]['Bidder_Details'][0]['tag_id'];
	   
	var Res_status="&res_count=0"; 
	` + pbjs + `  var count=0; 
	var PREBID_TIMEOUT = 8000;
	var xmlHttp = new XMLHttpRequest();`
	var Prebid_Adunit string
	if Is_Multiadformat == false {
		Prebid_Adunit = `var Multi_Ad=Bidders_Info["MarketPlace"];
	var sizes =  [[` + helper.ArrayOfInttoString(size, ",") + `]];
	pbjs.adserverRequestSent = false;
	var adUnits = [{
	code: '` + tagid + `',
	mediaTypes: {
		banner: {
			sizes: sizes
		}
	},
	floors: {
		currency: 'USD',
		skipRate: 5,
		values: {
			'banner': Bidders_Info['Bidder_Details'][0]['floorprice'] 
		}
	},
	 bids: Bidders_Info['Bidder_Details']
}];`
	} else {

		Prebid_Adunit = `var Multi_Ad=Bidders_Info["MarketPlace"];
	var Bidder_Response={};
	var sizes =  [[` + helper.ArrayOfInttoString(size, ",") + `]];
	pbjs.adserverRequestSent = false;
	var adUnits ="";
	adUnits = [{
	code: '` + tagid + `',
	mediaTypes: {
		banner: {
			sizes: sizes
		},
		video: {
			context: "outstream",   
			playerSize: [` + helper.ArrayOfInttoString(size, ",") + `],
			mimes: ["video/mp4","video/x-ms-wmv","video/webm","application/javascript"],
			protocols: [1, 2, 3, 4, 5, 6, 7, 8],
			playbackmethod: [2],
			api: [2],
			skip:0,
			placement:2,
			linearity: 1,
			minduration:5,
			maxduration:60,
			
		}
	},
	floors: {
		currency: 'USD',
		skipRate: 5,
		values: {
			'banner': Bidders_Info['Bidder_Details'][0]['floorprice'] 
		}
	},
	 bids: Bidders_Info['Bidder_Details']
}];`
	}

	var Prebid_ConfigSetup = `pbjs.setConfig({ debug: false,	
		useBidCache: false,
		"currency": {
			"adServerCurrency": Bidders_Info['Bidder_Details'][0]['BiddingCurrency'],
			"granularityMultiplier": 1,
		 },
		 "schain": {
			"validation": "strict",
			"config": {
			  "ver":"1.0",
			  "complete": 1,
			  "nodes": [
				{
					"asi":"` + admaruoutput.PublisherDetails.Publisher_Seller.Domain + `",
				"sid":"` + admaruoutput.PublisherDetails.Publisher_Seller.Seller_id + `",
				  "hp":1
				}
			  ]
			}
		  }
		});`

	var prebidVideo_func = `function callAdmaruRenderer(ad) {

        var link  = document.createElement('link');
		link.rel  = 'stylesheet';
		link.href = "` + config.GetConfig("path", "player") + `/admaru-player.css";
		document.head.appendChild(link);

		var script1 = document.createElement('script');

		script1.setAttribute("src","` + config.GetConfig("path", "player") + `/admaru-player.js");

		document.head.appendChild(script1);

		var script2 = document.createElement('script');

		script2.setAttribute("src","https://code.jquery.com/jquery-1.12.1.min.js");

		document.head.appendChild(script2);

		var divplayer = document.createElement("div");
		divplayer.setAttribute("class", "rm_videowrapper_` + randasd + `");
		divplayer.setAttribute("id", "rm_videowrapper_` + randasd + `");
		document.getElementById("test-ad` + rand1 + `").appendChild(divplayer);
		 if(ad.search(/<VAST/ig) !== -1){
			  var xmlBlob = new Blob([ad], {type: "application/xml"});
			  ad = URL.createObjectURL(xmlBlob);
		 }
	   let adsParams_` + randasd + ` = {
				playerId: "rm_videowrapper_` + randasd + `",
				sources: [
				{
					src: "https://d2zihajmogu5jn.cloudfront.net/tiny.mp4",
					type: "video/mp4"
				}
				],
			  
				threshold: 20,
				context: 'outstream', 
				nonViewableBehavior: false, 
				sideStream : {
					enabled: false,
					returnToPage: true,
					position: "bottom-right", 
					width: 300,
					height: 169,
					offsetL: 10,
					offsetR: 10,
					offsetB: 10
				},
				width: 300,
				height: 250,
				Ui: {
						closeButton : false,
						replayButton : false,   
						playBigButton : false, 
						allowFullscreen : false    
				},
				playbackMethod: "autoplay_muted", 
				inIframe: false,
				isIbh: false,
				ads: {
				  adTagUrl: ad,
				  
				  showSkipButton : false,
				  skipButtonLocation: "bottom-right",
				  skipOffSet: 5,
				  skipText: "Skip %%TIME%% ..",
				  skipButtonText: "Skip Ad",
				  viewableEventTime: 5,
				  defaultEventUrl: String(EventURl),
				  eventUrls:{
					impression: [String(AdClick_URL)],
				   	click:[String(AdClick_URL)],						 					  
				   	viewable:[String(AdViewableEvent_URL)],
				  }		  
				 
				}
			};
			   setTimeout(
				function() {
		    player` + rand1 + `= adMaru.load(adsParams_` + randasd + `);
				},2500);
			
		 }`
	var auto_click string = `document.getElementById('test-ad` + rand1 + `').onclick = function() { 
		` + innerHTMLclick + `
		xmlHttp.open("GET", AdClick_URL, true ); 
		xmlHttp.send();
	}`
	if admaruoutput.Autorefresh == "yes" {
		auto_click = `document.getElementById("` + tagid + `").contentWindow.document.body.onclick = 
			function() { 
				var Click_track= document.createElement("div");
				Click_track.id="clk_` + rand1 + `";
				Click_track.innerHTML="` + clicks1 + clicks2 + clicks3 + `";
				var ParentDiv=window.parent.document.getElementById("Autoref_` + rand1 + `").parentElement;
				var MainParentDiv=ParentDiv.parentElement;
				` + innerHTMLclick + `
				xmlHttp.open("GET", AdClick_URL, true ); 
				xmlHttp.send();
			};`
	}

	var AdrenderPart = `var AdClick_URL=WonBid['AdClick_URL'] !="" ? WonBid['AdClick_URL'] :"";
				var AdViewImpression_URL=WonBid['AdViewImpression_URL'] !="" ? WonBid['AdViewImpression_URL'] :"";
						var EventURl = WonBid['AdTrack'];
						var AdViewableEvent_URL=WonBid['AdViewableEvent_URL'];
				var Nobids=pbjs.getNoBidsForAdUnitCode('` + tagid + `');
						` + Track_Win_Nobid1 + `
	
							if(highestCpmBids` + randasd + `[0].mediaType=="banner")
							{
							` + innerHTMLImp + `
				var iframe_` + rand1 + `= document.getElementById("` + tagid + `");
				var iframeDoc = iframe_` + rand1 + `.contentWindow.document;
				var adServerTargeting = pbjs.getAdserverTargetingForAdUnitCode("` + tagid + `");
				pbjs.renderAd(iframeDoc, adServerTargeting["hb_adid"]);
				var ad_elem` + rand1 + ` = document.getElementById('test-ad` + rand1 + `');
				var ViewableImp = AdViewImpression_URL;	 
				localStorage.setItem('reqIDAuto` + rand1 + `',WonBid['Request_Id']);
				var url = new URL(ViewableImp);  
				var percent = 75;
				oav` + rand1 + ` = new OpenAdViewability();
				oav` + rand1 + `.DEBUG_MODE = false;
				var j` + rand1 + ` = 0;
				oav` + rand1 + `.checkViewability(ad_elem` + rand1 + `, function(check) {

			if(check.percentViewable >=percent){
				if(j` + rand1 + `==0 && url.searchParams.get("req_id")==localStorage.getItem('reqIDAuto` + rand1 + `' )){	
				   	 ` + admaruoutput.Viewable_Html + `
					var xhttp = new XMLHttpRequest();
					xhttp.open("GET", ViewableImp, true);	            	
					xhttp.send();	            	
					j` + rand1 + `++;	
					localStorage.removeItem('reqIDAuto` + rand1 + `' );	
				}
			}
		});
							
							window.addEventListener("blur", () => {
							setTimeout(() => {
								if (document.activeElement.id === "` + tagid + `") {
									` + innerHTMLclick + `
									let myPromise4 = new Promise(function(myResolve, myReject) {
										myResolve(AdClick_URL);
								});
										myPromise4.then(
										function(value) {GetApiCalling(value);}
										);
									window.focus();
								}
							});
							});
							` + auto_click + `
						}else
						{
							document.getElementById("` + tagid + `").outerHTML="";
							` + prebidVideo_func + `
							
							let ad = highestCpmBids` + randasd + `[0].ad || highestCpmBids` + randasd + `[0].vastXml;
							if (ad) {
								callAdmaruRenderer(ad)
							} else {
								if (highestCpmBids` + randasd + `[0].vastUrl) {
								callAdmaruRenderer( highestCpmBids` + randasd + `[0].vastUrl);
								} else {
							}
							}
					
					
					
						}`
	// Prebid Banner Ad Delivery Start
	switch {
	// If Winning Bid is Prebid for bidding to gather cases
	case admaruoutput.Is_Prebidwon == "Yes":
		admaruoutput.External_ad = true
		tagid = "Prebid_" + admaruoutput.Autorefreshrand
		admaruoutput.Html =
			`Prebidwon`
	case admaruoutput.Adunit_type == "async" || admaruoutput.Adunit_type == "PrebidPriority":
		admaruoutput.External_ad = true
		if admaruoutput.NextPriority && admaruoutput.Adunit_type != "PrebidPriority" {
			admaruoutput.Html = helper.ConvertStrJsonToRawJson(Biddderjsonmapp)
		} else {
			if admaruoutput.Autorefresh == "yes" {
				admaruoutput.Html = viewbleStart + `
				<iframe id="` + tagid + `" FRAMEBORDER="0" SCROLLING="no" MARGINHEIGHT="0" MARGINWIDTH="0" TOPMARGIN="0" LEFTMARGIN="0" ALLOWTRANSPARENCY="true" WIDTH="500" HEIGHT="300"> </iframe>` + Clickdiv + viewbleDiv + Impressiondiv + autorefEnd + viewbleEnd + `
			
				<script async src="` + config.GetConfig("path", "library") + `/Admaru.js"></script>
				` + Videolib + `
				<script type='text/javascript' src='` + config.GetConfig("path", "library") + `/viewability.js'></script>
				<script type="text/javascript" >
				var passsbacktest = "` + passbackscript + `";
				passsbacktest=decodeURIComponent(passsbacktest);
				passsbacktest=passsbacktest.replaceAll("\n","");
				
				` + GetAPICall + Prebid_Common_Variables + `
					var Multi_Ad=Bidders_Info["MarketPlace"];
					var WonBid;
					var highestCPM` + rand1 + `;
					
					` + Prebid_Adunit + `
					pbjs.que.push(function() { 
						pbjs.removeAdUnit('` + tagid + `');
					});
				pbjs.que.push(function() {
				pbjs.removeAdUnit('` + tagid + `');
				pbjs.addAdUnits(adUnits);` + Track_Req_Res1 + `
				` + Prebid_ConfigSetup + `
				pbjs.requestBids({ 
				timeout: PREBID_TIMEOUT,
				adUnitCodes: ['` + tagid + `'],
				bidsBackHandler: function(bids) {  
					var highestCpmBids` + randasd + ` = pbjs.getHighestCpmBids('` + tagid + `'); 
					if(highestCpmBids` + randasd + `!="")
					{
						WonBid = Request_bids[highestCpmBids` + randasd + `[0]['requestId']] != "" ? Request_bids[highestCpmBids` + randasd + `[0]['requestId']] : "";

						highestCPM` + rand1 + `= highestCpmBids` + randasd + `!="" ? highestCpmBids` + randasd + `[0]['cpm'] : 0;
						if(WonBid.floorprice>highestCPM` + rand1 + `){
							highestCPM` + rand1 + `=0;
						}
					}else
					{
						highestCPM` + rand1 + `=0;
					}
				if(highestCPM` + rand1 + `==0 && Multi_Ad=="no"){ 
					if (Bidders_Info['Bidder_Details'][0]['priority_next'] != 0 ) {
						var apicall = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&priority='+Bidders_Info['Bidder_Details'][0]['priority']+'&priority_next='+Bidders_Info['Bidder_Details'][0]['priority_next']+'&rand=` + rand1 + `&trackingloc=` + config.GetConfig("commonpath", "file") + `&adtype=PrebidPriority&requestId=` + admaruoutput.Request_Id + `&Is_MultiAd=yes';
						fetch(apicall) 
						.then(response => {       
							return response.text(); 
						})
						.then(htmlContent => {
							var mainDIV` + rand1 + ` = document.getElementById('viewImp_` + rand1 + `');
							document.getElementById('` + tagid + `').outerHTML="";
							var childDiv` + rand1 + ` = document.createElement("div");       
							childDiv` + rand1 + `.innerHTML = htmlContent;
							mainDIV` + rand1 + `.appendChild(childDiv` + rand1 + `);

							var mainscript` + rand1 + ` = mainDIV` + rand1 + `.getElementsByTagName("script");
							for (var scriptTags` + rand1 + ` of mainscript` + rand1 + `) {
							  var scriptContent` + rand1 + ` = scriptTags` + rand1 + `.textContent;
							  eval(scriptContent` + rand1 + `);
							  if (scriptTags` + rand1 + `.src) {
								var scriptElement` + rand1 + ` = document.createElement("script");
								scriptElement` + rand1 + `.src = scriptTags` + rand1 + `.src;
								document.head.appendChild(scriptElement` + rand1 + `);
							  }
							}
						
						})
						.catch(error => {
						});
					}else{
					var	htmlContent = passsbacktest;
					
					var mainDIV` + randasd + ` = document.getElementById('test-ad` + rand1 + `');
					var childDiv` + randasd + ` = document.createElement("div");       
					childDiv` + randasd + `.innerHTML = htmlContent;
					mainDIV` + randasd + `.innerHTML = "";
					mainDIV` + randasd + `.appendChild(childDiv` + randasd + `);
					
					var mainscript` + randasd + ` = mainDIV` + randasd + `.getElementsByTagName("script");
					for (var scriptTags` + randasd + ` of mainscript` + randasd + `) {
					var scriptContent` + randasd + ` = scriptTags` + randasd + `.textContent;
					eval(scriptContent` + randasd + `);
					if (scriptTags` + randasd + `.src) {
					var scriptElement` + randasd + ` = document.createElement("script");
					scriptElement` + randasd + `.src = scriptTags` + randasd + `.src;
					document.head.appendChild(scriptElement` + randasd + `);
					}
					}
					}
				}else{
					if(Multi_Ad=="yes"){ 
					if(highestCpmBids` + randasd + `!=""){
					
					
					var bidRES;
					var RESadtype;
					var BidderResponse;

					if(highestCpmBids` + randasd + `[0].mediaType!="banner")
					{
						bidRES=highestCpmBids` + randasd + `[0].vastXml;
						RESadtype="video";
						BidderResponse=[{"Adwon_URL" : WonBid['Adwon_URL'],
					"cpm" : highestCpmBids` + randasd + `[0]['cpm'],
					"AdViewImpression_URL" : WonBid['AdViewImpression_URL'],"AdClick_URL" : WonBid['AdClick_URL'],"ad" : bidRES,"adtypeRES":RESadtype,"AdImpression_URL" : WonBid['AdImpression_URL'],"EventURl" : WonBid['AdTrack'],"AdViewableEvent_URL":WonBid['AdViewableEvent_URL']}];
				
					}else{
						bidRES=highestCpmBids` + randasd + `[0].ad;
						RESadtype="banner";

					BidderResponse=[{"Adwon_URL" : WonBid['Adwon_URL'],
					"cpm" : highestCpmBids` + randasd + `[0]['cpm'],
					"AdViewImpression_URL" : WonBid['AdViewImpression_URL'],"AdClick_URL" : WonBid['AdClick_URL'],"ad" : bidRES,"adtypeRES":RESadtype,"AdImpression_URL" : WonBid['AdImpression_URL']}];
					
					}

					var apicall = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&MultiAdformatPriority='+Bidders_Info['Bidder_Details'][0]['priority']+'&highestBidCpm='+highestCPM` + rand1 + `+'&Is_MultiAd='+Multi_Ad+'&tagidRand=` + tagid + `&loc=` + admaruoutput.CORSDomain + `&rand=` + rand1 + `&requestId=` + admaruoutput.Request_Id + `&Is_MultiAd=yes';
					fetch(apicall) 
						.then(response => {       
							return response.text(); 
						})
						.then(htmlContent => {
							if(htmlContent!="Prebidwon")
							{	
							var mainDIV` + rand1 + ` = document.getElementById('test-ad` + rand1 + `');
							document.getElementById('` + tagid + `').outerHTML="";
							var childDiv` + rand1 + ` = document.createElement("div");       
							childDiv` + rand1 + `.innerHTML = htmlContent;
							mainDIV` + rand1 + `.appendChild(childDiv` + rand1 + `);

							var mainscript` + rand1 + ` = mainDIV` + rand1 + `.getElementsByTagName("script");
							for (var scriptTags` + rand1 + ` of mainscript` + rand1 + `) {
							  var scriptContent` + rand1 + ` = scriptTags` + rand1 + `.textContent;
							  eval(scriptContent` + rand1 + `);
							  if (scriptTags` + rand1 + `.src) {
								var scriptElement` + rand1 + ` = document.createElement("script");
								scriptElement` + rand1 + `.src = scriptTags` + rand1 + `.src;
								document.head.appendChild(scriptElement` + rand1 + `);
							  }
							}
							}else{

								` + AdrenderPart + `
							}
						})
						.catch(error => {
						});
						
					}
					else{
						var apicall = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&MultiAdformatPriority='+Bidders_Info['Bidder_Details'][0]['priority']+'&highestBidCpm='+highestCPM` + rand1 + `+'&Is_MultiAd='+Multi_Ad+'&tagidRand=` + tagid + `&loc=` + admaruoutput.CORSDomain + `&rand=` + rand1 + `&requestId=` + admaruoutput.Request_Id + `&Is_MultiAd=yes';
						fetch(apicall) 
						.then(response => {       
							return response.text(); 
						})
						.then(htmlContent => {
							var mainDIV` + rand1 + ` = document.getElementById('viewImp_` + rand1 + `');
							document.getElementById('` + tagid + `').outerHTML="";
							var childDiv` + rand1 + ` = document.createElement("div");       
							childDiv` + rand1 + `.innerHTML = htmlContent;
							mainDIV` + rand1 + `.appendChild(childDiv` + rand1 + `);

							var mainscript` + rand1 + ` = mainDIV` + rand1 + `.getElementsByTagName("script");
							for (var scriptTags` + rand1 + ` of mainscript` + rand1 + `) {
							  var scriptContent` + rand1 + ` = scriptTags` + rand1 + `.textContent;
							  eval(scriptContent` + rand1 + `);
							  if (scriptTags` + rand1 + `.src) {
								var scriptElement` + rand1 + ` = document.createElement("script");
								scriptElement` + rand1 + `.src = scriptTags` + rand1 + `.src;
								document.head.appendChild(scriptElement` + rand1 + `);
							  }
							}
						
						})
						.catch(error => {
						});
					}
					}else{
						` + AdrenderPart + `
					
					}
						
						}}});});
			</script>` + Clickdiv + Impressiondiv
			} else if admaruoutput.Adunit_type == "PrebidPriority" {
				admaruoutput.Html = multitag + viewbleStart + autorefStart + `
				<iframe id="` + tagid + `" FRAMEBORDER="0" SCROLLING="no" MARGINHEIGHT="0" MARGINWIDTH="0" TOPMARGIN="0" LEFTMARGIN="0" ALLOWTRANSPARENCY="true" WIDTH="300" HEIGHT="300" > </iframe>` + Clickdiv + viewbleDiv + Impressiondiv + autorefEnd + viewbleEnd + `
				<script async src="` + config.GetConfig("path", "library") + `/Admaru.js"></script>
				` + Videolib + `
				<script type='text/javascript' src='` + config.GetConfig("path", "library") + `/viewability.js'></script>
				<script type="text/javascript" >
				var passsbacktest = "` + passbackscript + `";
				passsbacktest=decodeURIComponent(passsbacktest);
				passsbacktest=passsbacktest.replaceAll("\n","");
				
				` + GetAPICall + Prebid_Common_Variables + `
						var WonBid;
						var highestCPM` + rand1 + `;
						` + Prebid_Adunit + `
				pbjs.que.push(function() { 
					pbjs.removeAdUnit('` + tagid + `');
				});
				pbjs.que.push(function() {
					pbjs.removeAdUnit('` + tagid + `');
					pbjs.addAdUnits(adUnits);
						` + Track_Req_Res1 + `
				` + Prebid_ConfigSetup + `
				pbjs.requestBids({ 
				timeout: PREBID_TIMEOUT,
				adUnitCodes: ['` + tagid + `'],
				bidsBackHandler: function(bids) {  
					var highestCpmBids` + randasd + ` = pbjs.getHighestCpmBids('` + tagid + `'); 
					if(highestCpmBids` + randasd + `!="")
					{
						WonBid = Request_bids[highestCpmBids` + randasd + `[0]['requestId']] != "" ? Request_bids[highestCpmBids` + randasd + `[0]['requestId']] : "";

						highestCPM` + rand1 + `= highestCpmBids` + randasd + `!="" ? highestCpmBids` + randasd + `[0]['cpm'] : 0;
						if(WonBid.floorprice>highestCPM` + rand1 + `){
							highestCPM` + rand1 + `=0;
						}
					}else
					{
						highestCPM` + rand1 + `=0;
					}
				if(highestCPM` + rand1 + `==0 && Multi_Ad=="no"){ 
					if (Bidders_Info['Bidder_Details'][0]['priority_next'] != 0 ) {
						var apicall = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&priority='+Bidders_Info['Bidder_Details'][0]['priority']+'&priority_next='+Bidders_Info['Bidder_Details'][0]['priority_next']+'&rand=` + rand1 + `&trackingloc=` + config.GetConfig("commonpath", "file") + `&adtype=PrebidPriority&requestId=` + admaruoutput.Request_Id + `&Is_MultiAd=yes';
						fetch(apicall) 
						.then(response => {       
							return response.text(); 
						})
						.then(htmlContent => {
							var mainDIV` + rand1 + ` = document.getElementById('viewImp_` + rand1 + `');
							document.getElementById('` + tagid + `').outerHTML="";
							var childDiv` + rand1 + ` = document.createElement("div");       
							childDiv` + rand1 + `.innerHTML = htmlContent;
							mainDIV` + rand1 + `.appendChild(childDiv` + rand1 + `);

							var mainscript` + rand1 + ` = mainDIV` + rand1 + `.getElementsByTagName("script");
							for (var scriptTags` + rand1 + ` of mainscript` + rand1 + `) {
							  var scriptContent` + rand1 + ` = scriptTags` + rand1 + `.textContent;
							  eval(scriptContent` + rand1 + `);
							  if (scriptTags` + rand1 + `.src) {
								var scriptElement` + rand1 + ` = document.createElement("script");
								scriptElement` + rand1 + `.src = scriptTags` + rand1 + `.src;
								document.head.appendChild(scriptElement` + rand1 + `);
							  }
							}
						
						})
						.catch(error => {
						});
				}else{
					var	htmlContent = passsbacktest;
					
					var mainDIV` + randasd + ` = document.getElementById('test-ad` + rand1 + `');
					var childDiv` + randasd + ` = document.createElement("div");       
					childDiv` + randasd + `.innerHTML = htmlContent;
					mainDIV` + randasd + `.innerHTML = "";
					mainDIV` + randasd + `.appendChild(childDiv` + randasd + `);
					
					var mainscript` + randasd + ` = mainDIV` + randasd + `.getElementsByTagName("script");
					for (var scriptTags` + randasd + ` of mainscript` + randasd + `) {
					var scriptContent` + randasd + ` = scriptTags` + randasd + `.textContent;
					eval(scriptContent` + randasd + `);
					if (scriptTags` + randasd + `.src) {
					var scriptElement` + randasd + ` = document.createElement("script");
					scriptElement` + randasd + `.src = scriptTags` + randasd + `.src;
					document.head.appendChild(scriptElement` + randasd + `);
					}
					}
					}
				}else{
					if(Multi_Ad=="yes"){ 
					if(highestCpmBids` + randasd + `!=""){
									
					var bidRES;
					var RESadtype;
					var BidderResponse;

					if(highestCpmBids` + randasd + `[0].mediaType!="banner")
					{
						bidRES=highestCpmBids` + randasd + `[0].vastXml;
						RESadtype="video";
						BidderResponse=[{"Adwon_URL" : WonBid['Adwon_URL'],
					"cpm" : highestCpmBids` + randasd + `[0]['cpm'],
					"AdViewImpression_URL" : WonBid['AdViewImpression_URL'],"AdClick_URL" : WonBid['AdClick_URL'],"ad" : bidRES,"adtypeRES":RESadtype,"AdImpression_URL" : WonBid['AdImpression_URL'],"EventURl" : WonBid['AdTrack'],"AdViewableEvent_URL":WonBid['AdViewableEvent_URL']}];
					
					}else{
						bidRES=highestCpmBids` + randasd + `[0].ad;
						RESadtype="banner";
					BidderResponse=[{"Adwon_URL" : WonBid['Adwon_URL'],
					"cpm" : highestCpmBids` + randasd + `[0]['cpm'],
					"AdViewImpression_URL" : WonBid['AdViewImpression_URL'],"AdClick_URL" : WonBid['AdClick_URL'],"ad" : bidRES,"adtypeRES":RESadtype,"AdImpression_URL" : WonBid['AdImpression_URL']}];
					
					}	
					
					var apicall = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&MultiAdformatPriority='+Bidders_Info['Bidder_Details'][0]['priority']+'&highestBidCpm='+highestCPM` + rand1 + `+'&Is_MultiAd='+Multi_Ad+'&tagidRand=` + tagid + `&loc=` + admaruoutput.CORSDomain + `&rand=` + rand1 + `&requestId=` + admaruoutput.Request_Id + `&Is_MultiAd=yes';
					fetch(apicall) 
						.then(response => {       
							return response.text(); 
						})
						.then(htmlContent => {
							if(htmlContent!="Prebidwon")
							{	
							var mainDIV` + rand1 + ` = document.getElementById('test-ad` + rand1 + `');
							document.getElementById('` + tagid + `').outerHTML="";
							var childDiv` + rand1 + ` = document.createElement("div");       
							childDiv` + rand1 + `.innerHTML = htmlContent;
							mainDIV` + rand1 + `.appendChild(childDiv` + rand1 + `);

							var mainscript` + rand1 + ` = mainDIV` + rand1 + `.getElementsByTagName("script");
							for (var scriptTags` + rand1 + ` of mainscript` + rand1 + `) {
							  var scriptContent` + rand1 + ` = scriptTags` + rand1 + `.textContent;
							  eval(scriptContent` + rand1 + `);
							  if (scriptTags` + rand1 + `.src) {
								var scriptElement` + rand1 + ` = document.createElement("script");
								scriptElement` + rand1 + `.src = scriptTags` + rand1 + `.src;
								document.head.appendChild(scriptElement` + rand1 + `);
							  }
							}
							}else{

								` + AdrenderPart + `
							}
						})
						.catch(error => {
						});
						
					}
					else{
						var apicall = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&MultiAdformatPriority='+Bidders_Info['Bidder_Details'][0]['priority']+'&highestBidCpm='+highestCPM` + rand1 + `+'&Is_MultiAd='+Multi_Ad+'&tagidRand=` + tagid + `&loc=` + admaruoutput.CORSDomain + `&rand=` + rand1 + `&requestId=` + admaruoutput.Request_Id + `&Is_MultiAd=yes';
						fetch(apicall) 
						.then(response => {       
							return response.text(); 
						})
						.then(htmlContent => {
							var mainDIV` + rand1 + ` = document.getElementById('viewImp_` + rand1 + `');
							document.getElementById('` + tagid + `').outerHTML="";
							var childDiv` + rand1 + ` = document.createElement("div");       
							childDiv` + rand1 + `.innerHTML = htmlContent;
							mainDIV` + rand1 + `.appendChild(childDiv` + rand1 + `);

							var mainscript` + rand1 + ` = mainDIV` + rand1 + `.getElementsByTagName("script");
							for (var scriptTags` + rand1 + ` of mainscript` + rand1 + `) {
							  var scriptContent` + rand1 + ` = scriptTags` + rand1 + `.textContent;
							  eval(scriptContent` + rand1 + `);
							  if (scriptTags` + rand1 + `.src) {
								var scriptElement` + rand1 + ` = document.createElement("script");
								scriptElement` + rand1 + `.src = scriptTags` + rand1 + `.src;
								document.head.appendChild(scriptElement` + rand1 + `);
							  }
							}
						
						})
						.catch(error => {
						});
					}
					}else{				
						` + AdrenderPart + `		
					}
						
						}}});});
			</script>` + Clickdiv + viewbleDiv + Impressiondiv
			} else {
				admaruoutput.Html = `
				` + multitag + viewbleStart + autorefStart + `
				<iframe id="` + tagid + `" FRAMEBORDER="0" SCROLLING="no" MARGINHEIGHT="0" MARGINWIDTH="0" TOPMARGIN="0" LEFTMARGIN="0" ALLOWTRANSPARENCY="true" WIDTH="444" HEIGHT="300" > </iframe>` + Clickdiv + viewbleDiv + Impressiondiv + autorefEnd + viewbleEnd + `
				<script async src="` + config.GetConfig("path", "library") + `/Admaru.js"></script>
				` + Videolib + `
				<script type='text/javascript' src='` + config.GetConfig("path", "library") + `/viewability.js'></script>
				<script type="text/javascript" >
				var passsbacktest = "` + passbackscript + `";
				passsbacktest=decodeURIComponent(passsbacktest);
				passsbacktest=passsbacktest.replaceAll("\n","");
				
				` + GetAPICall + `	
				` + Prebid_Common_Variables + `
					var WonBid;
					var highestCPM` + rand1 + `;
				` + Prebid_Adunit + `

				pbjs.que.push(function() {
						pbjs.addAdUnits(adUnits);
						` + Track_Req_Res1 + `
				` + Prebid_ConfigSetup + `
								pbjs.requestBids({ 
				timeout: PREBID_TIMEOUT,
				adUnitCodes: ['` + tagid + `'],
				bidsBackHandler: function(bids) {  
					var highestCpmBids` + randasd + ` = pbjs.getHighestCpmBids('` + tagid + `'); 
					if(highestCpmBids` + randasd + `!="")
					{
						WonBid = Request_bids[highestCpmBids` + randasd + `[0]['requestId']] != "" ? Request_bids[highestCpmBids` + randasd + `[0]['requestId']] : "";

						highestCPM` + rand1 + `= highestCpmBids` + randasd + `!="" ? highestCpmBids` + randasd + `[0]['cpm'] : 0;
						if(WonBid.floorprice>highestCPM` + rand1 + `){
							highestCPM` + rand1 + `=0;
						}
					}else
					{
						highestCPM` + rand1 + `=0;
					}

					
				if((highestCPM` + rand1 + `==0 && Multi_Ad=="no")){ 
					if (Bidders_Info['Bidder_Details'][0]['priority_next'] != 0 ) {
						var apicall = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&priority='+Bidders_Info['Bidder_Details'][0]['priority']+'&priority_next='+Bidders_Info['Bidder_Details'][0]['priority_next']+'&rand=` + rand1 + `&trackingloc=` + config.GetConfig("commonpath", "file") + `&adtype=PrebidPriority&requestId=` + admaruoutput.Request_Id + `&Is_MultiAd=yes';

						fetch(apicall) 
						.then(response => {       
							return response.text(); 
						})
						.then(htmlContent => {
							var mainDIV` + rand1 + ` = document.getElementById('viewImp_` + rand1 + `');
							document.getElementById('` + tagid + `').outerHTML="";
							var childDiv` + rand1 + ` = document.createElement("div");       
							childDiv` + rand1 + `.innerHTML = htmlContent;
							mainDIV` + rand1 + `.appendChild(childDiv` + rand1 + `);

							var mainscript` + rand1 + ` = mainDIV` + rand1 + `.getElementsByTagName("script");
							for (var scriptTags` + rand1 + ` of mainscript` + rand1 + `) {
							  var scriptContent` + rand1 + ` = scriptTags` + rand1 + `.textContent;
							  eval(scriptContent` + rand1 + `);
							  if (scriptTags` + rand1 + `.src) {
								var scriptElement` + rand1 + ` = document.createElement("script");
								scriptElement` + rand1 + `.src = scriptTags` + rand1 + `.src;
								document.head.appendChild(scriptElement` + rand1 + `);
							  }
							}
						
						})
						.catch(error => {
						});
					}else{
					var	htmlContent = passsbacktest;
 
					var mainDIV` + randasd + ` = document.getElementById('test-ad` + rand1 + `');
					var childDiv` + randasd + ` = document.createElement("div");       
					childDiv` + randasd + `.innerHTML = htmlContent;
					mainDIV` + randasd + `.innerHTML = "";
					mainDIV` + randasd + `.appendChild(childDiv` + randasd + `);

					var mainscript` + randasd + ` = mainDIV` + randasd + `.getElementsByTagName("script");
					for (var scriptTags` + randasd + ` of mainscript` + randasd + `) {
					var scriptContent` + randasd + ` = scriptTags` + randasd + `.textContent;
					eval(scriptContent` + randasd + `);
					if (scriptTags` + randasd + `.src) {
						var scriptElement` + randasd + ` = document.createElement("script");
						scriptElement` + randasd + `.src = scriptTags` + randasd + `.src;
						document.head.appendChild(scriptElement` + randasd + `);
					}
					}
					}
					
				}else{
					if(Multi_Ad=="yes"){ 
					if(highestCpmBids` + randasd + `!=""){
					var bidRES;
					var RESadtype;
					var BidderResponse;

					if(highestCpmBids` + randasd + `[0].mediaType!="banner")
					{
						bidRES=highestCpmBids` + randasd + `[0].vastXml;
						RESadtype="video";
						BidderResponse=[{"Adwon_URL" : WonBid['Adwon_URL'],
					"cpm" : highestCpmBids` + randasd + `[0]['cpm'],
					"AdViewImpression_URL" : WonBid['AdViewImpression_URL'],"AdClick_URL" : WonBid['AdClick_URL'],"ad" : bidRES,"adtypeRES":RESadtype,"AdImpression_URL" : WonBid['AdImpression_URL'],"EventURl" : WonBid['AdTrack'],"AdViewableEvent_URL":WonBid['AdViewableEvent_URL']}];
					
					}else{
						bidRES=highestCpmBids` + randasd + `[0].ad;
						RESadtype="banner";

					BidderResponse=[{"Adwon_URL" : WonBid['Adwon_URL'],
					"cpm" : highestCpmBids` + randasd + `[0]['cpm'],
					"AdViewImpression_URL" : WonBid['AdViewImpression_URL'],"AdClick_URL" : WonBid['AdClick_URL'],"ad" : bidRES,"adtypeRES":RESadtype,"AdImpression_URL" : WonBid['AdImpression_URL']}];
					
					}
					var apicall = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&MultiAdformatPriority='+Bidders_Info['Bidder_Details'][0]['priority']+'&highestBidCpm='+highestCPM` + rand1 + `+'&Is_MultiAd='+Multi_Ad+'&tagidRand=` + tagid + `&loc=` + admaruoutput.CORSDomain + `&rand=` + rand1 + `&requestId=` + admaruoutput.Request_Id + `&Is_MultiAd=yes';
					fetch(apicall) 
						.then(response => {       
							return response.text(); 
						})
						.then(htmlContent => {							
						
							if(htmlContent!="Prebidwon")
							{
							var mainDIV` + rand1 + ` = document.getElementById('test-ad` + rand1 + `');
							document.getElementById('` + tagid + `').outerHTML="";
							var childDiv` + rand1 + ` = document.createElement("div");       
							childDiv` + rand1 + `.innerHTML = htmlContent;
							mainDIV` + rand1 + `.appendChild(childDiv` + rand1 + `);

							var mainscript` + rand1 + ` = mainDIV` + rand1 + `.getElementsByTagName("script");
							for (var scriptTags` + rand1 + ` of mainscript` + rand1 + `) {
							  var scriptContent` + rand1 + ` = scriptTags` + rand1 + `.textContent;
							  eval(scriptContent` + rand1 + `);
							  if (scriptTags` + rand1 + `.src) {
								var scriptElement` + rand1 + ` = document.createElement("script");
								scriptElement` + rand1 + `.src = scriptTags` + rand1 + `.src;
								document.head.appendChild(scriptElement` + rand1 + `);
							  }
							}
							}else{

								` + AdrenderPart + `
							}
						
						})
						.catch(error => {
						});

						
					}
					else{
						var apicall = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&MultiAdformatPriority='+Bidders_Info['Bidder_Details'][0]['priority']+'&highestBidCpm='+highestCPM` + rand1 + `+'&Is_MultiAd='+Multi_Ad+'&tagidRand=` + tagid + `&loc=` + admaruoutput.CORSDomain + `&rand=` + rand1 + `&requestId=` + admaruoutput.Request_Id + `&Is_MultiAd=yes';


						fetch(apicall) 
						.then(response => {       
							return response.text(); 
						})
						.then(htmlContent => {
							var mainDIV` + rand1 + ` = document.getElementById('viewImp_` + rand1 + `');
							document.getElementById('` + tagid + `').outerHTML="";
							var childDiv` + rand1 + ` = document.createElement("div");       
							childDiv` + rand1 + `.innerHTML = htmlContent;
							mainDIV` + rand1 + `.appendChild(childDiv` + rand1 + `);

							var mainscript` + rand1 + ` = mainDIV` + rand1 + `.getElementsByTagName("script");
							for (var scriptTags` + rand1 + ` of mainscript` + rand1 + `) {
							  var scriptContent` + rand1 + ` = scriptTags` + rand1 + `.textContent;
							  eval(scriptContent` + rand1 + `);
							  if (scriptTags` + rand1 + `.src) {
								var scriptElement` + rand1 + ` = document.createElement("script");
								scriptElement` + rand1 + `.src = scriptTags` + rand1 + `.src;
								document.head.appendChild(scriptElement` + rand1 + `);
							  }
							}
						
						})
						.catch(error => {
						});
					}
					}else{
						` + AdrenderPart + `
					
				}
					}}});});
			</script>` + Clickdiv + viewbleDiv + Impressiondiv
			}
		}
	}
	// Prebid Banner Ad Delivery End
}

func GetPrebidVideoAd(admaruoutput *structure.AdmaruOutput, adsource []structure.AdSourceDetails) {

	publisher_bid_cur := fetching.FetchPub_settings(admaruoutput.Adsource_details[0].Publisher)
	bidding_currency := publisher_bid_cur.Bidding_currency
	account_currency := publisher_bid_cur.Account_currency
	admaruoutput.Bidding_currency = bidding_currency
	admaruoutput.Account_currency = account_currency
	/**********Third Party Tracker Start**********/

	rand := helper.RandToken(5)
	if admaruoutput.Autorefreshrand != "" {
		rand = admaruoutput.Autorefreshrand
	} else if admaruoutput.Autorefreshrand == "" {
		admaruoutput.Autorefreshrand = rand
	}
	var first1 string
	var first2 string
	var first3 string

	var mid1 string
	var mid2 string
	var mid3 string

	var third1 string
	var third2 string
	var third3 string

	var start1 string
	var start2 string
	var start3 string

	var mute1 string
	var mute2 string
	var mute3 string

	var unmute1 string
	var unmute2 string
	var unmute3 string

	var pause1 string
	var pause2 string
	var pause3 string

	var resume1 string
	var resume2 string
	var resume3 string

	var complete1 string
	var complete2 string
	var complete3 string

	var close1 string
	var close2 string
	var close3 string

	var impression1 string
	var impression2 string
	var impression3 string

	var viewimpression1 string
	var viewimpression2 string
	var viewimpression3 string

	var clicks1 string
	var clicks2 string
	var clicks3 string

	Adsource_id := admaruoutput.Adsource_details[0].Adsourceid

	adsoure := fetching.FetchAdsourceTracker(Adsource_id)

	if len(adsoure.Data) > 0 {

		for _, v := range adsoure.Data {

			Event := v.Event

			if Event == "1" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					firstimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					firstimg = strings.Replace(firstimg, `\`, ``, -1)

					first1 = firstimg
				} else if Tracker_type == "2" {

					firstsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					firstsrc2 = strings.Replace(firstsrc2, `\`, ``, -1)
					first2 = strings.Replace(firstsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					firstsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					firstsrc3 = strings.Replace(firstsrc3, `\`, ``, -1)
					first3 = strings.Replace(firstsrc3, "  ", " ", -1)
				}
			}

			if Event == "2" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					midimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					midimg = strings.Replace(midimg, `\`, ``, -1)

					mid1 = midimg
				} else if Tracker_type == "2" {

					midsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					midsrc2 = strings.Replace(midsrc2, `\`, ``, -1)
					mid2 = strings.Replace(midsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					midsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					midsrc3 = strings.Replace(midsrc3, `\`, ``, -1)
					mid3 = strings.Replace(midsrc3, "  ", " ", -1)
				}
			}

			if Event == "3" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					thirdimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					thirdimg = strings.Replace(thirdimg, `\`, ``, -1)

					third1 = thirdimg
				} else if Tracker_type == "2" {

					thirdsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					thirdsrc2 = strings.Replace(thirdsrc2, `\`, ``, -1)
					third2 = strings.Replace(thirdsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					thirdsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					thirdsrc3 = strings.Replace(thirdsrc3, `\`, ``, -1)
					third3 = strings.Replace(thirdsrc3, "  ", " ", -1)
				}
			}

			if Event == "5" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					startimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					startimg = strings.Replace(startimg, `\`, ``, -1)

					start1 = startimg
				} else if Tracker_type == "2" {

					startsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					startsrc2 = strings.Replace(startsrc2, `\`, ``, -1)
					start2 = strings.Replace(startsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					startsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					startsrc3 = strings.Replace(startsrc3, `\`, ``, -1)
					start3 = strings.Replace(startsrc3, "  ", " ", -1)
				}
			}

			if Event == "6" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					muteimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					muteimg = strings.Replace(muteimg, `\`, ``, -1)

					mute1 = muteimg
				} else if Tracker_type == "2" {

					mutesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					mutesrc2 = strings.Replace(mutesrc2, `\`, ``, -1)
					mute2 = strings.Replace(mutesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					mutesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					mutesrc3 = strings.Replace(mutesrc3, `\`, ``, -1)
					mute3 = strings.Replace(mutesrc3, "  ", " ", -1)
				}
			}

			if Event == "7" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					unmuteimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					unmuteimg = strings.Replace(unmuteimg, `\`, ``, -1)

					unmute1 = unmuteimg
				} else if Tracker_type == "2" {

					unmutesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					unmutesrc2 = strings.Replace(unmutesrc2, `\`, ``, -1)
					unmute2 = strings.Replace(unmutesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					unmutesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					unmutesrc3 = strings.Replace(unmutesrc3, `\`, ``, -1)
					unmute3 = strings.Replace(unmutesrc3, "  ", " ", -1)
				}
			}

			if Event == "8" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					pauseimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					pauseimg = strings.Replace(pauseimg, `\`, ``, -1)

					pause1 = pauseimg
				} else if Tracker_type == "2" {

					pausesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					pausesrc2 = strings.Replace(pausesrc2, `\`, ``, -1)
					pause2 = strings.Replace(pausesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					pausesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					pausesrc3 = strings.Replace(pausesrc3, `\`, ``, -1)
					pause3 = strings.Replace(pausesrc3, "  ", " ", -1)
				}
			}

			if Event == "9" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					resumeimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					resumeimg = strings.Replace(resumeimg, `\`, ``, -1)

					resume1 = resumeimg
				} else if Tracker_type == "2" {

					resumesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					resumesrc2 = strings.Replace(resumesrc2, `\`, ``, -1)
					resume2 = strings.Replace(resumesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					resumesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					resumesrc3 = strings.Replace(resumesrc3, `\`, ``, -1)
					resume3 = strings.Replace(resumesrc3, "  ", " ", -1)
				}
			}

			if Event == "13" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					closeimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					closeimg = strings.Replace(closeimg, `\`, ``, -1)

					close1 = closeimg
				} else if Tracker_type == "2" {

					closesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					closesrc2 = strings.Replace(closesrc2, `\`, ``, -1)
					close2 = strings.Replace(closesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					closesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					closesrc3 = strings.Replace(closesrc3, `\`, ``, -1)
					close3 = strings.Replace(closesrc3, "  ", " ", -1)
				}
			}

			if Event == "4" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					completeimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					completeimg = strings.Replace(completeimg, `\`, ``, -1)

					complete1 = completeimg
				} else if Tracker_type == "2" {

					completesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					completesrc2 = strings.Replace(completesrc2, `\`, ``, -1)
					complete2 = strings.Replace(completesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					completesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					completesrc3 = strings.Replace(completesrc3, `\`, ``, -1)
					complete3 = strings.Replace(completesrc3, "  ", " ", -1)
				}
			}

			if Event == "10" {

				Trackertype := v.Tracker_type

				if Trackertype == "1" {

					impimgu := strings.Replace(v.Tracker_src, "\n", "", -1)
					impimgu = strings.Replace(impimgu, `\`, ``, -1)

					impression1 = impimgu
				} else if Trackertype == "2" {

					impsrcu := strings.Replace(v.Tracker_src, "\n", "", -1)
					impsrcu = strings.Replace(impsrcu, `\`, ``, -1)
					impression2 = strings.Replace(impsrcu, "  ", " ", -1)

				} else if Trackertype == "3" {

					impsrcf := strings.Replace(v.Tracker_src, "\n", "", -1)
					impsrcf = strings.Replace(impsrcf, `\`, ``, -1)
					impression3 = strings.Replace(impsrcf, "  ", " ", -1)
				}
			}

			if Event == "11" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					viewimpimgi := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpimgi = strings.Replace(viewimpimgi, `\`, ``, -1)

					viewimpression1 = viewimpimgi
				} else if Tracker_type == "2" {

					viewimpsrc2i := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpsrc2i = strings.Replace(viewimpsrc2i, `\`, ``, -1)
					viewimpression2 = strings.Replace(viewimpsrc2i, "  ", " ", -1)

				} else if Tracker_type == "3" {

					viewimpsrc3i := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpsrc3i = strings.Replace(viewimpsrc3i, `\`, ``, -1)
					viewimpression3 = strings.Replace(viewimpsrc3i, "  ", " ", -1)
				}
			}

			if Event == "12" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					clicksimg1 := strings.Replace(v.Tracker_src, "\n", "", -1)
					clicksimg1 = strings.Replace(clicksimg1, `\`, ``, -1)

					clicks1 = clicksimg1
				} else if Tracker_type == "2" {

					clickssrcu2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					clickssrcu2 = strings.Replace(clickssrcu2, `\`, ``, -1)
					clicks2 = strings.Replace(clickssrcu2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					clickssrcu3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					clickssrcu3 = strings.Replace(clickssrcu3, `\`, ``, -1)
					clicks3 = strings.Replace(clickssrcu3, "  ", " ", -1)
				}
			}
		}
	}

	var adu_first1 string
	var adu_first2 string
	var adu_first3 string

	var adu_mid1 string
	var adu_mid2 string
	var adu_mid3 string

	var adu_third1 string
	var adu_third2 string
	var adu_third3 string

	var adu_start1 string
	var adu_start2 string
	var adu_start3 string

	var adu_mute1 string
	var adu_mute2 string
	var adu_mute3 string

	var adu_unmute1 string
	var adu_unmute2 string
	var adu_unmute3 string

	var adu_pause1 string
	var adu_pause2 string
	var adu_pause3 string

	var adu_resume1 string
	var adu_resume2 string
	var adu_resume3 string

	var adu_complete1 string
	var adu_complete2 string
	var adu_complete3 string

	var adu_close1 string
	var adu_close2 string
	var adu_close3 string

	var adu_impression1 string
	var adu_impression2 string
	var adu_impression3 string

	var adu_viewimpression1 string
	var adu_viewimpression2 string
	var adu_viewimpression3 string

	var adu_clicks1 string
	var adu_clicks2 string
	var adu_clicks3 string

	adunit := fetching.FetchAdunitTracker(admaruoutput.Adunit_details.Adunit_id)

	if len(adunit.Data) > 0 {

		for _, val := range adunit.Data {

			Event1 := val.Event

			if Event1 == "1" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					firstimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					firstimg = strings.Replace(firstimg, `\`, ``, -1)

					adu_first1 = firstimg
				} else if Tracker_type == "2" {

					firstsrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					firstsrc2 = strings.Replace(firstsrc2, `\`, ``, -1)
					adu_first2 = strings.Replace(firstsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					firstsrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					firstsrc3 = strings.Replace(firstsrc3, `\`, ``, -1)
					adu_first3 = strings.Replace(firstsrc3, "  ", " ", -1)
				}
			}

			if Event1 == "2" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					midimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					midimg = strings.Replace(midimg, `\`, ``, -1)

					adu_mid1 = midimg
				} else if Tracker_type == "2" {

					midsrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					midsrc2 = strings.Replace(midsrc2, `\`, ``, -1)
					adu_mid2 = strings.Replace(midsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					midsrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					midsrc3 = strings.Replace(midsrc3, `\`, ``, -1)
					adu_mid3 = strings.Replace(midsrc3, "  ", " ", -1)
				}
			}

			if Event1 == "3" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					thirdimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					thirdimg = strings.Replace(thirdimg, `\`, ``, -1)

					adu_third1 = thirdimg
				} else if Tracker_type == "2" {

					thirdsrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					thirdsrc2 = strings.Replace(thirdsrc2, `\`, ``, -1)
					adu_third2 = strings.Replace(thirdsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					thirdsrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					thirdsrc3 = strings.Replace(thirdsrc3, `\`, ``, -1)
					adu_third3 = strings.Replace(thirdsrc3, "  ", " ", -1)
				}
			}

			if Event1 == "5" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					startimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					startimg = strings.Replace(startimg, `\`, ``, -1)

					adu_start1 = startimg
				} else if Tracker_type == "2" {

					startsrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					startsrc2 = strings.Replace(startsrc2, `\`, ``, -1)
					adu_start2 = strings.Replace(startsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					startsrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					startsrc3 = strings.Replace(startsrc3, `\`, ``, -1)
					adu_start3 = strings.Replace(startsrc3, "  ", " ", -1)
				}
			}

			if Event1 == "6" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					muteimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					muteimg = strings.Replace(muteimg, `\`, ``, -1)

					adu_mute1 = muteimg
				} else if Tracker_type == "2" {

					mutesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					mutesrc2 = strings.Replace(mutesrc2, `\`, ``, -1)
					adu_mute2 = strings.Replace(mutesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					mutesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					mutesrc3 = strings.Replace(mutesrc3, `\`, ``, -1)
					adu_mute3 = strings.Replace(mutesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "7" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					unmuteimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					unmuteimg = strings.Replace(unmuteimg, `\`, ``, -1)

					adu_unmute1 = unmuteimg
				} else if Tracker_type == "2" {

					unmutesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					unmutesrc2 = strings.Replace(unmutesrc2, `\`, ``, -1)
					adu_unmute2 = strings.Replace(unmutesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					unmutesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					unmutesrc3 = strings.Replace(unmutesrc3, `\`, ``, -1)
					adu_unmute3 = strings.Replace(unmutesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "8" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					pauseimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					pauseimg = strings.Replace(pauseimg, `\`, ``, -1)

					adu_pause1 = pauseimg
				} else if Tracker_type == "2" {

					pausesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					pausesrc2 = strings.Replace(pausesrc2, `\`, ``, -1)
					adu_pause2 = strings.Replace(pausesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					pausesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					pausesrc3 = strings.Replace(pausesrc3, `\`, ``, -1)
					adu_pause3 = strings.Replace(pausesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "9" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					resumeimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					resumeimg = strings.Replace(resumeimg, `\`, ``, -1)

					adu_resume1 = resumeimg
				} else if Tracker_type == "2" {

					resumesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					resumesrc2 = strings.Replace(resumesrc2, `\`, ``, -1)
					adu_resume2 = strings.Replace(resumesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					resumesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					resumesrc3 = strings.Replace(resumesrc3, `\`, ``, -1)
					adu_resume3 = strings.Replace(resumesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "13" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					closeimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					closeimg = strings.Replace(closeimg, `\`, ``, -1)

					adu_close1 = closeimg
				} else if Tracker_type == "2" {

					closesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					closesrc2 = strings.Replace(closesrc2, `\`, ``, -1)
					adu_close2 = strings.Replace(closesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					closesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					closesrc3 = strings.Replace(closesrc3, `\`, ``, -1)
					adu_close3 = strings.Replace(closesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "4" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					completeimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					completeimg = strings.Replace(completeimg, `\`, ``, -1)

					adu_complete1 = completeimg
				} else if Tracker_type == "2" {

					completesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					completesrc2 = strings.Replace(completesrc2, `\`, ``, -1)
					adu_complete2 = strings.Replace(completesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					completesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					completesrc3 = strings.Replace(completesrc3, `\`, ``, -1)
					adu_complete3 = strings.Replace(completesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "10" {

				Trackertype := val.Tracker_type

				if Trackertype == "1" {

					impimgu := strings.Replace(val.Tracker_src, "\n", "", -1)
					impimgu = strings.Replace(impimgu, `\`, ``, -1)

					adu_impression1 = impimgu
				} else if Trackertype == "2" {

					impsrcu := strings.Replace(val.Tracker_src, "\n", "", -1)
					impsrcu = strings.Replace(impsrcu, `\`, ``, -1)
					adu_impression2 = strings.Replace(impsrcu, "  ", " ", -1)

				} else if Trackertype == "3" {

					impsrcf := strings.Replace(val.Tracker_src, "\n", "", -1)
					impsrcf = strings.Replace(impsrcf, `\`, ``, -1)
					adu_impression3 = strings.Replace(impsrcf, "  ", " ", -1)
				}
			}

			if Event1 == "11" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					viewimpimgi := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpimgi = strings.Replace(viewimpimgi, `\`, ``, -1)

					adu_viewimpression1 = viewimpimgi
				} else if Tracker_type == "2" {

					viewimpsrc2i := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpsrc2i = strings.Replace(viewimpsrc2i, `\`, ``, -1)
					adu_viewimpression2 = strings.Replace(viewimpsrc2i, "  ", " ", -1)

				} else if Tracker_type == "3" {

					viewimpsrc3i := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpsrc3i = strings.Replace(viewimpsrc3i, `\`, ``, -1)
					adu_viewimpression3 = strings.Replace(viewimpsrc3i, "  ", " ", -1)
				}
			}

			if Event1 == "12" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					clicksimg1 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clicksimg1 = strings.Replace(clicksimg1, `\`, ``, -1)

					adu_clicks1 = clicksimg1
				} else if Tracker_type == "2" {

					clickssrcu2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clickssrcu2 = strings.Replace(clickssrcu2, `\`, ``, -1)
					adu_clicks2 = strings.Replace(clickssrcu2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					clickssrcu3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clickssrcu3 = strings.Replace(clickssrcu3, `\`, ``, -1)
					adu_clicks3 = strings.Replace(clickssrcu3, "  ", " ", -1)
				}
			}
		}
	}

	if impression1 != "" || impression2 != "" || impression3 != "" {

		if impression2 != "" {
			impression2 = strings.Replace(impression2, "\n", "", -1)
			impression2 = strings.Replace(impression2, `</script>`, `<\/script>`, -1)
		}
		if impression3 != "" {
			impression3 = strings.Replace(impression3, `</script>`, `<\/script>`, -1)
			impression3 = strings.Replace(impression3, "\n", "", -1)
		}
	}
	if clicks1 != "" || clicks2 != "" || clicks3 != "" {

		if clicks2 != "" {
			clicks2 = strings.Replace(clicks2, "\n", "", -1)
			clicks2 = strings.Replace(clicks2, `</script>`, `<\/script>`, -1)
		}
		if clicks3 != "" {
			clicks3 = strings.Replace(clicks3, `</script>`, `<\/script>`, -1)
			clicks3 = strings.Replace(clicks3, "\n", "", -1)
		}
	}
	if viewimpression1 != "" || viewimpression2 != "" || viewimpression3 != "" {

		if viewimpression2 != "" {
			viewimpression2 = strings.Replace(viewimpression2, "\n", "", -1)
			viewimpression2 = strings.Replace(viewimpression2, `</script>`, `<\/script>`, -1)
		}
		if viewimpression3 != "" {
			viewimpression3 = strings.Replace(viewimpression3, `</script>`, `<\/script>`, -1)
			viewimpression3 = strings.Replace(viewimpression3, "\n", "", -1)
		}
	}

	if first1 != "" || first2 != "" || first3 != "" {

		if first2 != "" {
			first2 = strings.Replace(first2, "\n", "", -1)
			first2 = strings.Replace(first2, `</script>`, `<\/script>`, -1)
		}
		if first3 != "" {
			first3 = strings.Replace(first3, `</script>`, `<\/script>`, -1)
			first3 = strings.Replace(first3, "\n", "", -1)
		}
	}
	if mid1 != "" || mid2 != "" || mid3 != "" {

		if mid2 != "" {
			mid2 = strings.Replace(mid2, "\n", "", -1)
			mid2 = strings.Replace(mid2, `</script>`, `<\/script>`, -1)
		}
		if mid3 != "" {
			mid3 = strings.Replace(mid3, `</script>`, `<\/script>`, -1)
			mid3 = strings.Replace(mid3, "\n", "", -1)
		}
	}
	if third1 != "" || third2 != "" || third3 != "" {

		if third2 != "" {
			third2 = strings.Replace(third2, "\n", "", -1)
			third2 = strings.Replace(third2, `</script>`, `<\/script>`, -1)
		}
		if third3 != "" {
			third3 = strings.Replace(third3, `</script>`, `<\/script>`, -1)
			third3 = strings.Replace(third3, "\n", "", -1)
		}
	}

	if start1 != "" || start2 != "" || start3 != "" {

		if start2 != "" {
			start2 = strings.Replace(start2, "\n", "", -1)
			start2 = strings.Replace(start2, `</script>`, `<\/script>`, -1)
		}
		if start3 != "" {
			start3 = strings.Replace(start3, `</script>`, `<\/script>`, -1)
			start3 = strings.Replace(start3, "\n", "", -1)
		}
	}
	if mute1 != "" || mute2 != "" || mute3 != "" {

		if mute2 != "" {
			mute2 = strings.Replace(mute2, "\n", "", -1)
			mute2 = strings.Replace(mute2, `</script>`, `<\/script>`, -1)
		}
		if mute3 != "" {
			mute3 = strings.Replace(mute3, `</script>`, `<\/script>`, -1)
			mute3 = strings.Replace(mute3, "\n", "", -1)
		}
	}
	if unmute1 != "" || unmute2 != "" || unmute3 != "" {

		if unmute2 != "" {
			unmute2 = strings.Replace(unmute2, "\n", "", -1)
			unmute2 = strings.Replace(unmute2, `</script>`, `<\/script>`, -1)
		}
		if unmute3 != "" {
			unmute3 = strings.Replace(unmute3, `</script>`, `<\/script>`, -1)
			unmute3 = strings.Replace(unmute3, "\n", "", -1)
		}
	}

	if pause1 != "" || pause2 != "" || pause3 != "" {

		if pause2 != "" {
			pause2 = strings.Replace(pause2, "\n", "", -1)
			pause2 = strings.Replace(pause2, `</script>`, `<\/script>`, -1)
		}
		if pause3 != "" {
			pause3 = strings.Replace(pause3, `</script>`, `<\/script>`, -1)
			pause3 = strings.Replace(pause3, "\n", "", -1)
		}
	}
	if complete1 != "" || complete2 != "" || complete3 != "" {

		if complete2 != "" {
			complete2 = strings.Replace(complete2, "\n", "", -1)
			complete2 = strings.Replace(complete2, `</script>`, `<\/script>`, -1)
		}
		if complete3 != "" {
			complete3 = strings.Replace(complete3, `</script>`, `<\/script>`, -1)
			complete3 = strings.Replace(complete3, "\n", "", -1)
		}
	}

	if resume1 != "" || resume2 != "" || resume3 != "" {

		if resume2 != "" {
			resume2 = strings.Replace(resume2, "\n", "", -1)
			resume2 = strings.Replace(resume2, `</script>`, `<\/script>`, -1)
		}
		if resume3 != "" {
			resume3 = strings.Replace(resume3, `</script>`, `<\/script>`, -1)
			resume3 = strings.Replace(resume3, "\n", "", -1)
		}
	}
	if close1 != "" || close2 != "" || close3 != "" {

		if close2 != "" {
			close2 = strings.Replace(close2, "\n", "", -1)
			close2 = strings.Replace(close2, `</script>`, `<\/script>`, -1)
		}
		if close3 != "" {
			close3 = strings.Replace(close3, `</script>`, `<\/script>`, -1)
			close3 = strings.Replace(close3, "\n", "", -1)
		}
	}

	if adu_impression1 != "" || adu_impression2 != "" || adu_impression3 != "" {

		if adu_impression2 != "" {
			adu_impression2 = strings.Replace(adu_impression2, "\n", "", -1)
			adu_impression2 = strings.Replace(adu_impression2, `</script>`, `<\/script>`, -1)
		}
		if adu_impression3 != "" {
			adu_impression3 = strings.Replace(adu_impression3, `</script>`, `<\/script>`, -1)
			adu_impression3 = strings.Replace(adu_impression3, "\n", "", -1)
		}
	}
	if adu_clicks1 != "" || adu_clicks2 != "" || adu_clicks3 != "" {

		if adu_clicks2 != "" {
			adu_clicks2 = strings.Replace(adu_clicks2, "\n", "", -1)
			adu_clicks2 = strings.Replace(adu_clicks2, `</script>`, `<\/script>`, -1)
		}
		if adu_clicks3 != "" {
			adu_clicks3 = strings.Replace(adu_clicks3, `</script>`, `<\/script>`, -1)
			adu_clicks3 = strings.Replace(adu_clicks3, "\n", "", -1)
		}
	}
	if adu_viewimpression1 != "" || adu_viewimpression2 != "" || adu_viewimpression3 != "" {

		if adu_viewimpression2 != "" {
			adu_viewimpression2 = strings.Replace(adu_viewimpression2, "\n", "", -1)
			adu_viewimpression2 = strings.Replace(adu_viewimpression2, `</script>`, `<\/script>`, -1)
		}
		if adu_viewimpression3 != "" {
			adu_viewimpression3 = strings.Replace(adu_viewimpression3, `</script>`, `<\/script>`, -1)
			adu_viewimpression3 = strings.Replace(adu_viewimpression3, "\n", "", -1)
		}
	}

	if adu_first1 != "" || adu_first2 != "" || adu_first3 != "" {

		if adu_first2 != "" {
			adu_first2 = strings.Replace(adu_first2, "\n", "", -1)
			adu_first2 = strings.Replace(adu_first2, `</script>`, `<\/script>`, -1)
		}
		if adu_first3 != "" {
			adu_first3 = strings.Replace(adu_first3, `</script>`, `<\/script>`, -1)
			adu_first3 = strings.Replace(adu_first3, "\n", "", -1)
		}
	}
	if adu_mid1 != "" || adu_mid2 != "" || adu_mid3 != "" {

		if adu_mid2 != "" {
			adu_mid2 = strings.Replace(adu_mid2, "\n", "", -1)
			adu_mid2 = strings.Replace(adu_mid2, `</script>`, `<\/script>`, -1)
		}
		if adu_mid3 != "" {
			adu_mid3 = strings.Replace(adu_mid3, `</script>`, `<\/script>`, -1)
			adu_mid3 = strings.Replace(adu_mid3, "\n", "", -1)
		}
	}
	if adu_third1 != "" || adu_third2 != "" || adu_third3 != "" {

		if adu_third2 != "" {
			adu_third2 = strings.Replace(adu_third2, "\n", "", -1)
			adu_third2 = strings.Replace(adu_third2, `</script>`, `<\/script>`, -1)
		}
		if adu_third3 != "" {
			adu_third3 = strings.Replace(adu_third3, `</script>`, `<\/script>`, -1)
			adu_third3 = strings.Replace(adu_third3, "\n", "", -1)
		}
	}

	if adu_start1 != "" || adu_start2 != "" || adu_start3 != "" {

		if adu_start2 != "" {
			adu_start2 = strings.Replace(adu_start2, "\n", "", -1)
			adu_start2 = strings.Replace(adu_start2, `</script>`, `<\/script>`, -1)
		}
		if adu_start3 != "" {
			adu_start3 = strings.Replace(adu_start3, `</script>`, `<\/script>`, -1)
			adu_start3 = strings.Replace(adu_start3, "\n", "", -1)
		}
	}
	if adu_mute1 != "" || adu_mute2 != "" || adu_mute3 != "" {

		if adu_mute2 != "" {
			adu_mute2 = strings.Replace(adu_mute2, "\n", "", -1)
			adu_mute2 = strings.Replace(adu_mute2, `</script>`, `<\/script>`, -1)
		}
		if adu_mute3 != "" {
			adu_mute3 = strings.Replace(adu_mute3, `</script>`, `<\/script>`, -1)
			adu_mute3 = strings.Replace(adu_mute3, "\n", "", -1)
		}
	}
	if adu_unmute1 != "" || adu_unmute2 != "" || adu_unmute3 != "" {

		if adu_unmute2 != "" {
			adu_unmute2 = strings.Replace(adu_unmute2, "\n", "", -1)
			adu_unmute2 = strings.Replace(adu_unmute2, `</script>`, `<\/script>`, -1)
		}
		if adu_unmute3 != "" {
			adu_unmute3 = strings.Replace(adu_unmute3, `</script>`, `<\/script>`, -1)
			adu_unmute3 = strings.Replace(adu_unmute3, "\n", "", -1)
		}
	}

	if adu_pause1 != "" || adu_pause2 != "" || adu_pause3 != "" {

		if adu_pause2 != "" {
			adu_pause2 = strings.Replace(adu_pause2, "\n", "", -1)
			adu_pause2 = strings.Replace(adu_pause2, `</script>`, `<\/script>`, -1)
		}
		if adu_pause3 != "" {
			adu_pause3 = strings.Replace(adu_pause3, `</script>`, `<\/script>`, -1)
			adu_pause3 = strings.Replace(adu_pause3, "\n", "", -1)
		}
	}
	if adu_complete1 != "" || adu_complete2 != "" || adu_complete3 != "" {

		if adu_complete2 != "" {
			adu_complete2 = strings.Replace(adu_complete2, "\n", "", -1)
			adu_complete2 = strings.Replace(adu_complete2, `</script>`, `<\/script>`, -1)
		}
		if adu_complete3 != "" {
			adu_complete3 = strings.Replace(adu_complete3, `</script>`, `<\/script>`, -1)
			adu_complete3 = strings.Replace(adu_complete3, "\n", "", -1)
		}
	}

	if adu_resume1 != "" || adu_resume2 != "" || adu_resume3 != "" {

		if adu_resume2 != "" {
			adu_resume2 = strings.Replace(adu_resume2, "\n", "", -1)
			adu_resume2 = strings.Replace(adu_resume2, `</script>`, `<\/script>`, -1)
		}
		if adu_resume3 != "" {
			adu_resume3 = strings.Replace(adu_resume3, `</script>`, `<\/script>`, -1)
			adu_resume3 = strings.Replace(adu_resume3, "\n", "", -1)
		}
	}
	if adu_close1 != "" || adu_close2 != "" || adu_close3 != "" {

		if adu_close2 != "" {
			adu_close2 = strings.Replace(adu_close2, "\n", "", -1)
			adu_close2 = strings.Replace(adu_close2, `</script>`, `<\/script>`, -1)
		}
		if adu_close3 != "" {
			adu_close3 = strings.Replace(adu_close3, `</script>`, `<\/script>`, -1)
			adu_close3 = strings.Replace(adu_close3, "\n", "", -1)
		}
	}

	var _3rd_img_firstQuartile string
	var _3rd_js_firstQuartile string
	var _3rd_iframe_firstQuartile string

	var _3rd_img_midpoint string
	var _3rd_js_midpoint string
	var _3rd_iframe_midpoint string

	var _3rd_img_thirdQuartile string
	var _3rd_js_thirdQuartile string
	var _3rd_iframe_thirdQuartile string

	var _3rd_img_pause string
	var _3rd_js_pause string
	var _3rd_iframe_pause string

	var _3rd_img_resume string
	var _3rd_js_resume string
	var _3rd_iframe_resume string

	var _3rd_img_mute string
	var _3rd_js_mute string
	var _3rd_iframe_mute string

	var _3rd_img_unmute string
	var _3rd_js_unmute string
	var _3rd_iframe_unmute string

	var _3rd_img_skip string
	var _3rd_js_skip string
	var _3rd_iframe_skip string

	var _3rd_img_impression string
	var _3rd_js_impression string
	var _3rd_iframe_impression string

	var _3rd_img_viewableImpression string
	var _3rd_js_viewableImpression string
	var _3rd_iframe_viewableImpression string

	var _3rd_img_click string
	var _3rd_js_click string
	var _3rd_iframe_click string

	var _3rd_img_start string
	var _3rd_js_start string
	var _3rd_iframe_start string

	var _3rd_img_complete string
	var _3rd_js_complete string
	var _3rd_iframe_complete string

	var _3rd_img_close string
	var _3rd_js_close string
	var _3rd_iframe_close string

	if first1 != "" && adu_first1 != "" {

		_3rd_img_firstQuartile = `_3rd_img_firstQuartile: ["` + first1 + `", "` + adu_first1 + `"],`
	} else if first1 != "" {

		_3rd_img_firstQuartile = `_3rd_img_firstQuartile: ["` + first1 + `"],`

	} else if adu_first1 != "" {

		_3rd_img_firstQuartile = `_3rd_img_firstQuartile: ["` + adu_first1 + `"],`
	}

	if first2 != "" && adu_first2 != "" {

		_3rd_js_firstQuartile = `_3rd_js_firstQuartile: ["` + first2 + `", "` + adu_first2 + `"],`
	} else if first2 != "" {

		_3rd_js_firstQuartile = `_3rd_js_firstQuartile: ["` + first2 + `"],`

	} else if adu_first2 != "" {

		_3rd_js_firstQuartile = `_3rd_js_firstQuartile: ["` + adu_first2 + `"],`

	}

	if first3 != "" && adu_first3 != "" {

		_3rd_iframe_firstQuartile = `_3rd_iframe_firstQuartile: ["` + first3 + `", "` + adu_first3 + `"],`
	} else if first3 != "" {

		_3rd_iframe_firstQuartile = `_3rd_iframe_firstQuartile: ["` + first3 + `"],`

	} else if adu_first3 != "" {

		_3rd_iframe_firstQuartile = `_3rd_iframe_firstQuartile: ["` + adu_first3 + `"],`

	}

	if mid1 != "" && adu_mid1 != "" {

		_3rd_img_midpoint = `_3rd_img_midpoint: ["` + mid1 + `", "` + adu_mid1 + `"],`
	} else if mid1 != "" {

		_3rd_img_midpoint = `_3rd_img_midpoint: ["` + mid1 + `"],`

	} else if adu_mid1 != "" {

		_3rd_img_midpoint = `_3rd_img_midpoint: ["` + adu_mid1 + `"],`

	}

	if mid2 != "" && adu_mid2 != "" {

		_3rd_js_midpoint = `_3rd_js_midpoint: ["` + mid2 + `", "` + adu_mid2 + `"],`
	} else if mid2 != "" {

		_3rd_js_midpoint = `_3rd_js_midpoint: ["` + mid2 + `"],`

	} else if adu_mid2 != "" {

		_3rd_js_midpoint = `_3rd_js_midpoint: ["` + adu_mid2 + `"],`

	}

	if mid3 != "" && adu_mid3 != "" {
		_3rd_iframe_midpoint = `_3rd_iframe_midpoint: ["` + mid3 + `", "` + adu_mid3 + `"],`
	} else if mid3 != "" {
		_3rd_iframe_midpoint = `_3rd_iframe_midpoint: ["` + mid3 + `"],`
	} else if adu_mid3 != "" {
		_3rd_iframe_midpoint = `_3rd_iframe_midpoint: ["` + adu_mid3 + `"],`
	}

	if third1 != "" && adu_third1 != "" {

		_3rd_img_thirdQuartile = `_3rd_img_thirdQuartile: ["` + third1 + `", "` + adu_third1 + `"],`

	} else if third1 != "" {

		_3rd_img_thirdQuartile = `_3rd_img_thirdQuartile: ["` + third1 + `"],`

	} else if adu_third1 != "" {

		_3rd_img_thirdQuartile = `_3rd_img_thirdQuartile: ["` + adu_third1 + `"],`

	}

	if third2 != "" && adu_third2 != "" {

		_3rd_js_thirdQuartile = `_3rd_js_thirdQuartile: ["` + third2 + `", "` + adu_third2 + `"],`

	} else if third2 != "" {

		_3rd_js_thirdQuartile = `_3rd_js_thirdQuartile: ["` + third2 + `"],`

	} else if adu_third2 != "" {

		_3rd_js_thirdQuartile = `_3rd_js_thirdQuartile: ["` + adu_third2 + `"],`

	}

	if third3 != "" && adu_third3 != "" {

		_3rd_iframe_thirdQuartile = `_3rd_iframe_thirdQuartile: ["` + third3 + `", "` + adu_third3 + `"],`

	} else if third3 != "" {

		_3rd_iframe_thirdQuartile = `_3rd_iframe_thirdQuartile: ["` + third3 + `"],`

	} else if adu_third3 != "" {

		_3rd_iframe_thirdQuartile = `_3rd_iframe_thirdQuartile: ["` + adu_third3 + `"],`

	}

	if pause1 != "" && adu_pause1 != "" {

		_3rd_img_pause = `_3rd_img_pause: ["` + pause1 + `", "` + adu_pause1 + `"],`

	} else if pause1 != "" {

		_3rd_img_pause = `_3rd_img_pause: ["` + pause1 + `"],`

	} else if adu_pause1 != "" {

		_3rd_img_pause = `_3rd_img_pause: ["` + adu_pause1 + `"],`

	}

	if pause2 != "" && adu_pause2 != "" {

		_3rd_js_pause = `_3rd_js_pause: ["` + pause2 + `", "` + adu_pause2 + `"],`

	} else if pause2 != "" {

		_3rd_js_pause = `_3rd_js_pause: ["` + pause2 + `"],`

	} else if adu_pause2 != "" {

		_3rd_js_pause = `_3rd_js_pause: ["` + adu_pause2 + `"],`

	}

	if pause3 != "" && adu_pause3 != "" {

		_3rd_iframe_pause = `_3rd_iframe_pause: ["` + pause3 + `", "` + adu_pause3 + `"],`

	} else if pause3 != "" {

		_3rd_iframe_pause = `_3rd_iframe_pause: ["` + pause3 + `"],`

	} else if adu_pause3 != "" {

		_3rd_iframe_pause = `_3rd_iframe_pause: ["` + adu_pause3 + `"],`

	}

	if resume1 != "" && adu_resume1 != "" {

		_3rd_img_resume = `_3rd_img_resume: ["` + resume1 + `", "` + adu_resume1 + `"],`

	} else if resume1 != "" {

		_3rd_img_resume = `_3rd_img_resume: ["` + resume1 + `"],`

	} else if adu_resume1 != "" {

		_3rd_img_resume = `_3rd_img_resume: ["` + adu_resume1 + `"],`

	}

	if resume2 != "" && adu_resume2 != "" {

		_3rd_js_resume = `_3rd_js_resume: ["` + resume2 + `", "` + adu_resume2 + `"],`

	} else if resume2 != "" {

		_3rd_js_resume = `_3rd_js_resume: ["` + resume2 + `"],`

	} else if adu_resume2 != "" {

		_3rd_js_resume = `_3rd_js_resume: ["` + adu_resume2 + `"],`

	}

	if resume3 != "" && adu_resume3 != "" {

		_3rd_iframe_resume = `_3rd_iframe_resume: ["` + resume3 + `", "` + adu_resume3 + `"],`

	} else if resume3 != "" {

		_3rd_iframe_resume = `_3rd_iframe_resume: ["` + resume3 + `"],`

	} else if adu_resume3 != "" {

		_3rd_iframe_resume = `_3rd_iframe_resume: ["` + adu_resume3 + `"],`

	}

	if mute1 != "" && adu_mute1 != "" {

		_3rd_img_mute = `_3rd_img_mute: ["` + mute1 + `", "` + adu_mute1 + `"],`

	} else if mute1 != "" {

		_3rd_img_mute = `_3rd_img_mute: ["` + mute1 + `"],`

	} else if adu_mute1 != "" {

		_3rd_img_mute = `_3rd_img_mute: ["` + adu_mute1 + `"],`

	}

	if mute2 != "" && adu_mute2 != "" {

		_3rd_js_mute = `_3rd_js_mute: ["` + mute2 + `", "` + adu_mute2 + `"],`

	} else if mute2 != "" {

		_3rd_js_mute = `_3rd_js_mute: ["` + mute2 + `"],`

	} else if adu_mute2 != "" {

		_3rd_js_mute = `_3rd_js_mute: ["` + adu_mute2 + `"],`

	}

	if mute3 != "" && adu_mute3 != "" {

		_3rd_iframe_mute = `_3rd_iframe_mute: ["` + mute3 + `", "` + adu_mute3 + `"],`

	} else if mute3 != "" {

		_3rd_iframe_mute = `_3rd_iframe_mute: ["` + mute3 + `"],`

	} else if adu_mute3 != "" {

		_3rd_iframe_mute = `_3rd_iframe_mute: ["` + adu_mute3 + `"],`

	}

	if unmute1 != "" && adu_unmute1 != "" {

		_3rd_img_unmute = `_3rd_img_unmute: ["` + unmute1 + `", "` + adu_unmute1 + `"],`

	} else if unmute1 != "" {

		_3rd_img_unmute = `_3rd_img_unmute: ["` + unmute1 + `"],`

	} else if adu_unmute1 != "" {

		_3rd_img_unmute = `_3rd_img_unmute: ["` + adu_unmute1 + `"],`

	}

	if unmute2 != "" && adu_unmute2 != "" {

		_3rd_js_unmute = `_3rd_js_unmute: ["` + unmute2 + `", "` + adu_unmute2 + `"],`

	} else if unmute2 != "" {

		_3rd_js_unmute = `_3rd_js_unmute: ["` + unmute2 + `"],`

	} else if adu_unmute2 != "" {

		_3rd_js_unmute = `_3rd_js_unmute: ["` + adu_unmute2 + `"],`

	}

	if unmute3 != "" && adu_unmute3 != "" {

		_3rd_iframe_unmute = `_3rd_iframe_unmute: ["` + unmute3 + `", "` + adu_unmute3 + `"],`

	} else if unmute3 != "" {

		_3rd_iframe_unmute = `_3rd_iframe_unmute: ["` + unmute3 + `"],`

	} else if adu_unmute3 != "" {

		_3rd_iframe_unmute = `_3rd_iframe_unmute: ["` + adu_unmute3 + `"],`

	}

	if complete1 != "" && adu_complete1 != "" {

		_3rd_img_complete = `_3rd_img_complete: ["` + complete1 + `", "` + adu_complete1 + `"],`

	} else if complete1 != "" {

		_3rd_img_complete = `_3rd_img_complete: ["` + complete1 + `"],`

	} else if adu_complete1 != "" {

		_3rd_img_complete = `_3rd_img_complete: ["` + adu_complete1 + `"],`
	}

	if complete2 != "" && adu_complete2 != "" {

		_3rd_js_complete = `_3rd_js_complete: ["` + complete2 + `", "` + adu_complete2 + `"],`

	} else if complete2 != "" {

		_3rd_js_complete = `_3rd_js_complete: ["` + complete2 + `"],`

	} else if adu_complete2 != "" {

		_3rd_js_complete = `_3rd_js_complete: ["` + adu_complete2 + `"],`

	}

	if complete3 != "" && adu_complete3 != "" {

		_3rd_iframe_complete = `_3rd_iframe_complete: ["` + complete3 + `", "` + adu_complete3 + `"],`

	} else if complete3 != "" {

		_3rd_iframe_complete = `_3rd_iframe_complete: ["` + complete3 + `"],`

	} else if adu_complete3 != "" {

		_3rd_iframe_complete = `_3rd_iframe_complete: ["` + adu_complete3 + `"],`

	}

	if start1 != "" && adu_start1 != "" {

		_3rd_img_start = `_3rd_img_start: ["` + start1 + `", "` + adu_start1 + `"],`

	} else if start1 != "" {

		_3rd_img_start = `_3rd_img_start: ["` + start1 + `"],`

	} else if adu_start1 != "" {

		_3rd_img_start = `_3rd_img_start: ["` + adu_start1 + `"],`

	}

	if start2 != "" && adu_start2 != "" {

		_3rd_js_start = `_3rd_js_start: ["` + start2 + `", "` + adu_start2 + `"],`

	} else if start2 != "" {

		_3rd_js_start = `_3rd_js_start: ["` + start2 + `"],`

	} else if adu_start2 != "" {

		_3rd_js_start = `_3rd_js_start: ["` + adu_start2 + `"],`

	}

	if start3 != "" && adu_start3 != "" {

		_3rd_iframe_start = `_3rd_iframe_start: ["` + start3 + `", "` + adu_start3 + `"],`

	} else if start3 != "" {

		_3rd_iframe_start = `_3rd_iframe_start: ["` + start3 + `"],`

	} else if adu_start3 != "" {

		_3rd_iframe_start = `_3rd_iframe_start: ["` + adu_start3 + `"],`

	}

	if impression1 != "" && adu_impression1 != "" {

		_3rd_img_impression = `_3rd_img_impression: ["` + impression1 + `", "` + adu_impression1 + `"],`

	} else if impression1 != "" {

		_3rd_img_impression = `_3rd_img_impression: ["` + impression1 + `"],`

	} else if adu_impression1 != "" {

		_3rd_img_impression = `_3rd_img_impression: ["` + adu_impression1 + `"],`

	}

	if impression2 != "" && adu_impression2 != "" {

		_3rd_js_impression = `_3rd_js_impression: ["` + impression2 + `", "` + adu_impression2 + `"],`

	} else if impression2 != "" {

		_3rd_js_impression = `_3rd_js_impression: ["` + impression2 + `"],`

	} else if adu_impression2 != "" {

		_3rd_js_impression = `_3rd_js_impression: ["` + adu_impression2 + `"],`

	}

	if impression3 != "" && adu_impression3 != "" {

		_3rd_iframe_impression = `_3rd_iframe_impression: ["` + impression3 + `", "` + adu_impression3 + `"],`

	} else if impression3 != "" {

		_3rd_iframe_impression = `_3rd_iframe_impression: ["` + impression3 + `"],`

	} else if adu_impression3 != "" {

		_3rd_iframe_impression = `_3rd_iframe_impression: ["` + adu_impression3 + `"],`

	}

	if viewimpression1 != "" && adu_viewimpression1 != "" {

		_3rd_img_viewableImpression = `_3rd_img_viewableImpression: ["` + viewimpression1 + `", "` + adu_viewimpression1 + `"],`

	} else if viewimpression1 != "" {

		_3rd_img_viewableImpression = `_3rd_img_viewableImpression: ["` + viewimpression1 + `"],`

	} else if adu_viewimpression1 != "" {

		_3rd_img_viewableImpression = `_3rd_img_viewableImpression: ["` + adu_viewimpression1 + `"],`

	}

	if viewimpression2 != "" && adu_viewimpression2 != "" {

		_3rd_js_viewableImpression = `_3rd_js_viewableImpression: ["` + viewimpression2 + `", "` + adu_viewimpression2 + `"],`

	} else if viewimpression2 != "" {

		_3rd_js_viewableImpression = `_3rd_js_viewableImpression: ["` + viewimpression2 + `"],`

	} else if adu_viewimpression2 != "" {

		_3rd_js_viewableImpression = `_3rd_js_viewableImpression: ["` + adu_viewimpression2 + `"],`

	}

	if viewimpression3 != "" && adu_viewimpression3 != "" {

		_3rd_iframe_viewableImpression = `_3rd_iframe_viewableImpression: ["` + viewimpression3 + `", "` + adu_viewimpression3 + `"],`

	} else if viewimpression3 != "" {

		_3rd_iframe_viewableImpression = `_3rd_iframe_viewableImpression: ["` + viewimpression3 + `"],`

	} else if adu_viewimpression3 != "" {

		_3rd_iframe_viewableImpression = `_3rd_iframe_viewableImpression: ["` + adu_viewimpression3 + `"],`

	}

	if clicks1 != "" && adu_clicks1 != "" {

		_3rd_img_click = `_3rd_img_click: ["` + clicks1 + `", "` + adu_clicks1 + `"],`

	} else if clicks1 != "" {

		_3rd_img_click = `_3rd_img_click: ["` + clicks1 + `"],`

	} else if adu_clicks1 != "" {

		_3rd_img_click = `_3rd_img_click: ["` + adu_clicks1 + `"],`

	}

	if clicks2 != "" && adu_clicks2 != "" {

		_3rd_js_click = `_3rd_js_click: ["` + clicks2 + `", "` + adu_clicks2 + `"],`

	} else if clicks2 != "" {

		_3rd_js_click = `_3rd_js_click: ["` + clicks2 + `"],`

	} else if adu_clicks2 != "" {

		_3rd_js_click = `_3rd_js_click: ["` + adu_clicks2 + `"],`
	}

	if clicks3 != "" && adu_clicks3 != "" {

		_3rd_iframe_click = `_3rd_iframe_click: ["` + clicks3 + `", "` + adu_clicks3 + `"],`

	} else if clicks3 != "" {

		_3rd_iframe_click = `_3rd_iframe_click: ["` + clicks3 + `"],`

	} else if adu_clicks3 != "" {

		_3rd_iframe_click = `_3rd_iframe_click: ["` + adu_clicks3 + `"],`
	}

	if close1 != "" && adu_close1 != "" {

		_3rd_img_close = `_3rd_img_close: ["` + close1 + `", "` + adu_close1 + `"],`

	} else if close1 != "" {

		_3rd_img_close = `_3rd_img_close: ["` + close1 + `"],`

	} else if adu_close1 != "" {

		_3rd_img_close = `_3rd_img_close: ["` + adu_close1 + `"],`
	}

	if close2 != "" && adu_close2 != "" {

		_3rd_js_close = `_3rd_js_close: ["` + close2 + `", "` + adu_close2 + `"],`

	} else if close2 != "" {

		_3rd_js_close = `_3rd_js_close: ["` + close2 + `"],`

	} else if adu_close2 != "" {

		_3rd_js_close = `_3rd_js_close: ["` + adu_close2 + `"],`
	}

	if close3 != "" && adu_close3 != "" {

		_3rd_iframe_close = `_3rd_iframe_close: ["` + close3 + `", "` + adu_close3 + `"],`

	} else if close3 != "" {

		_3rd_iframe_close = `_3rd_iframe_close: ["` + close3 + `"],`

	} else if adu_close3 != "" {

		_3rd_iframe_close = `_3rd_iframe_close: ["` + adu_close3 + `"],`
	}

	/**********Third Party Tracker Start**********/

	var size []int

	var BidderArray []string
	Biddderjsonmap := make(map[string]interface{})
	Biddermap := make(map[string]interface{})
	for _, v := range adsource {
		err := json.Unmarshal([]byte(v.Src_Obj), &Biddermap)
		if err != nil {
			fmt.Println(err)
		}
		PrebidTracking(Biddermap, admaruoutput, v, rand)

		Bidderjson, err := json.Marshal(Biddermap)
		if err != nil {
			fmt.Println(err)
		}

		BidderArray = append(BidderArray, string(Bidderjson))

	}

	BiddermapJson, err := json.Marshal(BidderArray)
	if err != nil {
		fmt.Println(err)
	}

	if admaruoutput.Adunit_type != "PrebidPriority" {
		Biddderjsonmap["Addelivery_Tag"] = "no"
	}
	Biddderjsonmap["Bidder_Details"] = string(BiddermapJson)
	if admaruoutput.MultiAdFormat == true {
		Biddderjsonmap["MarketPlace"] = "yes"
		Biddderjsonmap["MultiAdformatPriority"] = admaruoutput.MultiAdformatPriority
	} else {
		Biddderjsonmap["MarketPlace"] = "no"
	}
	Biddderjsonmapp, err := json.Marshal(Biddderjsonmap)
	if err != nil {
		fmt.Println(err)
	}
	template_settings := structure.Outstream_Template{}

	err1 := json.Unmarshal([]byte(admaruoutput.Temp_Generation.Settings), &template_settings)
	if err1 != nil {
		fmt.Println(err)
	}

	if template_settings.MaxWidth == 0 {
		template_settings.MaxWidth = 300
	}
	if template_settings.MinWidth == 0 {
		template_settings.MinWidth = 298
	}

	size = append(size, template_settings.MaxWidth, template_settings.MinWidth)

	tagid := "Prebid_" + rand

	TagType := admaruoutput.Tag_Generation.Tag_Type

	Inline_Content := admaruoutput.Temp_Generation.Inline_Content

	var Inlineontent []InlineContent

	err2 := json.Unmarshal([]byte(Inline_Content), &Inlineontent)
	if err2 != nil {
		fmt.Println(err2)
	}
	var InlineontentVideo_Url string
	InlineontentVideo_Url = config.GetConfig("source", "video")
	if len(Inlineontent) > 0 {
		InlineontentVideo_Url = Inlineontent[0].Video_Url
	}

	Instream_settings := structure.Instream_Template{}

	err11 := json.Unmarshal([]byte(admaruoutput.Temp_Generation.Settings), &Instream_settings)
	if err11 != nil {
		fmt.Println(err1)
	}

	/**********In Stream End**********/
	if template_settings.MaxWidth == 0 {
		template_settings.MaxWidth = 300
	}
	if template_settings.MinWidth == 0 {
		template_settings.MinWidth = 300
	}

	var InstreamOrOutStream string
	if admaruoutput.Temp_Generation.Template_type == "2" {
		InstreamOrOutStream = "instream"
	} else if admaruoutput.Temp_Generation.Template_type == "3" || admaruoutput.Temp_Generation.Template_type == "1" {
		InstreamOrOutStream = "outstream"
	}

	admaruoutput.Video_Temp.Height = template_settings.MinWidth
	admaruoutput.Video_Temp.Width = template_settings.MaxWidth
	// Newplayer changes start
	var closeEnable string
	var localEnable string
	var playOnview string
	var thresholdVal string = "0"
	var sideStreamEnable string
	var skipEnable string
	var floatLocation string
	var returntopage string
	var replayEnable string
	var iniframeEnable string
	var responsive string
	var responsivereminder string
	if template_settings.Responsive.ResponsiveSize != false {
		responsive = "true"
	} else {
		responsive = "false"
	}

	if template_settings.Responsive.ResponsiveRemSize != false {
		responsivereminder = "true"
	} else {
		responsivereminder = "false"
	}

	if template_settings.InIframe != false {
		iniframeEnable = "true"
	} else {
		iniframeEnable = "false"
	}

	if template_settings.PlayerInterface.ReplayButton != false {
		replayEnable = "true"
	} else {
		replayEnable = "false"
	}

	if template_settings.PlayerInterface.CloseButton != false {
		closeEnable = "true"
	} else {
		closeEnable = "false"
	}
	if template_settings.LogoVideo.LogoVideo != false {
		localEnable = "true"
	} else {
		localEnable = "false"
	}
	if template_settings.PlayerMode.PlayOnview == true {
		playOnview = "autoplay"
		if template_settings.PlayerMode.InView != 0 {
			thresholdVal = helper.IntToString(template_settings.PlayerMode.InView)
		} else if template_settings.PlayerMode.PlayModeView != 0 {
			thresholdVal = helper.IntToString(template_settings.PlayerMode.PlayModeView)
		}

	} else if template_settings.AutoPlay == true {
		if template_settings.PlayerMode.InView != 0 {
			thresholdVal = helper.IntToString(template_settings.PlayerMode.InView)
		} else if template_settings.PlayerMode.PlayModeView != 0 {
			thresholdVal = helper.IntToString(template_settings.PlayerMode.PlayModeView)
		}

		playOnview = "autoplay_muted"
	} else {
		playOnview = "mouseover"
		if template_settings.PlayerMode.InView != 0 {
			thresholdVal = helper.IntToString(template_settings.PlayerMode.InView)
		} else if template_settings.PlayerMode.PlayModeView != 0 {
			thresholdVal = helper.IntToString(template_settings.PlayerMode.PlayModeView)
		}

	}

	if template_settings.Skip.Skip == true {
		skipEnable = "true"
	} else {
		skipEnable = "false"
	}
	if template_settings.PlayerMode.PlayerMode == "2" {
		returntopage = "true"
	} else {
		returntopage = "false"
	}

	if template_settings.PlayerMode.PlayerMode == "2" || template_settings.PlayerMode.PlayerMode == "3" {
		sideStreamEnable = "true"
		if (template_settings.PlayerMode.FloatType == "impression") && template_settings.AutoPlay == true {

			playOnview = "autoplay"
		} else if (template_settings.PlayerMode.FloatType == "bottom" || template_settings.PlayerMode.PlayerMode == "3") && template_settings.AutoPlay == true {

			playOnview = "autoplay_muted"
		} else if (template_settings.PlayerMode.FloatType == "impression" || template_settings.PlayerMode.PlayerMode == "3") && template_settings.AutoPlay == false {
			playOnview = "mouseover"
		} else if template_settings.PlayerMode.FloatType == "bottom" && template_settings.AutoPlay == false {
			playOnview = "mouseover2"
		}

	} else {
		sideStreamEnable = "false"
	}
	if template_settings.PlayerMode.Location != "" {
		floatLocation = "bottom-" + template_settings.PlayerMode.Location

	} else {
		floatLocation = "bottom-left"
	}

	var sideviewwidth string
	var sideviewheight string

	switch {
	case template_settings.PlayerMode.SideViewWidth != "":
		sideviewwidth = template_settings.PlayerMode.SideViewWidth

	case template_settings.PlayerMode.RemainderWidth != 0:
		sideviewwidth = helper.IntToString(template_settings.PlayerMode.RemainderWidth)

	}
	switch {
	case template_settings.PlayerMode.SideViewHeight != "":
		sideviewheight = template_settings.PlayerMode.SideViewHeight
	case template_settings.PlayerMode.RemainderHeight != 0:
		sideviewheight = helper.IntToString(template_settings.PlayerMode.RemainderHeight)
	}

	var passbackenable string
	var passbackscriptorlink string
	if template_settings.TempPassback.LinkOrTag != "" {
		passbackenable = "true"
	} else {
		passbackenable = "false"
	}
	if admaruoutput.Temp_Generation.Template_type == "2" {
		passbackenable = "false"
	}
	if admaruoutput.Adunit_type != "VideoVast" {

		if template_settings.TempPassback.DFP.DFP == true && admaruoutput.DFP_Delivery == "true" {

			template_settings.TempPassback.URL = `<div id="` + template_settings.TempPassback.DFP.Div_id + `">  <script>    window.googletag = window.googletag || {cmd: []};    
			googletag.cmd.push(function() { googletag.pubads().refresh([` + template_settings.TempPassback.DFP.Slot_id + `]);
			googletag.pubads().addEventListener('slotRenderEnded', function(event) {
				if (event.slot.getSlotElementId() == "` + template_settings.TempPassback.DFP.Div_id + `") {
					localStorage.setItem('DFP_Delivery_` + rand + `','true');
				}
			});
			});
			<\/script></div>`
		}
		if template_settings.TempPassback.LinkOrTag == "js" || template_settings.TempPassback.LinkOrTag == "tag" {
			template_settings.TempPassback.URL = strings.Replace(template_settings.TempPassback.URL, "\n", "", -1)
			template_settings.TempPassback.URL = strings.Replace(template_settings.TempPassback.URL, `"`, `\"`, -1)
			template_settings.TempPassback.URL = strings.Replace(template_settings.TempPassback.URL, `</script>`, `<\/script>`, -1)
		} else if template_settings.TempPassback.LinkOrTag == "iframe" {
			// template_settings.TempPassback.URL = strings.Replace(template_settings.TempPassback.URL, `"`, `\"`, -1)
			template_settings.TempPassback.URL = strings.Replace(template_settings.TempPassback.URL, "\n", "", -1)
			template_settings.TempPassback.URL = strings.Replace(template_settings.TempPassback.URL, `</script>`, `<\/script>`, -1)

		} else if template_settings.TempPassback.LinkOrTag == "link" {
			clickurl := template_settings.TempPassback.DestinationUrl
			ImgTag := template_settings.TempPassback.URL
			clickTag_start := `<a href='` + clickurl + `' target='_blank'>`
			clickTag_end := `</a>`
			template_settings.TempPassback.URL = clickTag_start + `<img src='` + ImgTag + `' alt='' title='' border='0' />` + clickTag_end
		}
	} else {

		if template_settings.TempPassback.DFP.DFP == true {

			template_settings.TempPassback.URL = `<div id="` + template_settings.TempPassback.DFP.Div_id + `">  <script>    window.googletag = window.googletag || {cmd: []};    googletag.cmd.push(function() { 
				googletag.pubads().refresh([` + template_settings.TempPassback.DFP.Slot_id + `]); 
				googletag.pubads().addEventListener('slotRenderEnded', function(event) {
					if (event.slot.getSlotElementId() == "` + template_settings.TempPassback.DFP.Div_id + `") {
						localStorage.setItem('DFP_Delivery_` + rand + `','true');
					}
				});
				}); 
				<\/script></div>`

		}
		template_settings.TempPassback.URL = strings.Replace(template_settings.TempPassback.URL, "\n", "", -1)

	}

	var dfppassback string = "false"
	if template_settings.TempPassback.DFP.DFP == true {

		dfppassback = "true"

	}

	passbackscriptorlink = template_settings.TempPassback.URL
	passbackscriptorlink = url.PathEscape(passbackscriptorlink)

	var videoSource string
	if TagType == "2" {

		videoSource = InlineontentVideo_Url

	} else {

		videoSource = config.GetConfig("source", "video")
	}

	var ZIndexBoolStr string
	if template_settings.ReminderZindex.ZIndexBool != false {
		ZIndexBoolStr = "true"
	} else {
		ZIndexBoolStr = "false"
	}

	var Track_Req_Resvideo string = `
pbjs.onEvent('bidRequested', bidderRequest => {
		
		if(bidderRequest.auctionId != localStorage.getItem("bid_AuctionId_"+bidderRequest['bids'][count]['bidId']) )
		{
		localStorage.setItem("bid_AuctionId_"+bidderRequest['bids'][count]['bidId'], bidderRequest.auctionId);
			bidderRequest['bids'].forEach(function(v,k){
				if(v!=""){
					
					Request_bids[bidderRequest['bids'][count]['bidId']]=v;count++;
					var Reqcounter = 0;
					if(v['adUnitCode'] == '` + tagid + `' && Reqcounter == 0){
							var Request_URL=v['Request_URL'];
							let myPromise = new Promise(function(myResolve, myReject) {
								myResolve(Request_URL);
							});
							myPromise.then(
							function(value) {GetApiCalling(value);}
							);
					}
					Reqcounter++;		
				}
			});count=0;
		}
		});

	
	pbjs.onEvent('bidResponse', bid => {
		
		if(bid.auctionId == localStorage.getItem("bid_AuctionId_"+bid.requestId) && localStorage.getItem("bid_AuctionId_"+bid.requestId) != "Bidder_done" )
		{
			if(localStorage.getItem("bid_adid_"+bid.requestId) == bid.adId)
			{
				localStorage.setItem("bid_AuctionId_"+bid.requestId, "Bidder_done");
			}else
			{
				var counter = 0;
				if(bid.adUnitCode == '` + tagid + `'){
					localStorage.setItem("bid_adid_"+bid.requestId, bid.adId);
					Res_status="&res_count=1";
					Bidder_Response=bid;
					if(counter == 0){
						var Response_URL=Request_bids[bid['requestId']]['Response_URL'] !="" ? Request_bids[bid['requestId']]['Response_URL']+Res_status :"";
						let myPromise1 = new Promise(function(myResolve, myReject) {
							myResolve(Response_URL);
						});
						myPromise1.then(
						function(value) {GetApiCalling(value);}
						);
					}
					counter++;
				}
			}
		}	
	});`

	var Track_Win_Nobidvideo string = ` 
	if(WonBid!="" && WonBid!=null){ 
		var localstorage_keys=Object.keys(localStorage); var term="bid_"; 
  		let b = localstorage_keys.filter(item => {if(item.toLowerCase().indexOf(term) > -1){ 
		localStorage.removeItem(item) }});
		var Adwon_URL=WonBid['Adwon_URL'] !="" ? WonBid['Adwon_URL'] :"";
		var AdImpression_URL=WonBid['AdImpression_URL'] !="" ? WonBid['AdImpression_URL']+'&won_price='+highestCpmBids` + randasd + `[0]['cpm'] :"";
		let myPromise2 = new Promise(function(myResolve, myReject) {
			myResolve(Adwon_URL);
		});
		myPromise2.then(
		function(value) {GetApiCalling(value);}
		);
	}`

	var VideoRefresh string
	var PassbackVideoRefresh string
	admaruoutput.Viewable_Tagid = tagid
	Template_id := admaruoutput.Tag_id
	var GPT_Delivery string
	if dfppassback == "true" {
		GPT_Delivery = `googletag.cmd.push(function() { googletag.pubads().refresh([` + template_settings.TempPassback.DFP.Slot_id + `]);
			googletag.pubads().addEventListener('slotRenderEnded', function(event) {
				if (event.slot.getSlotElementId() == "` + template_settings.TempPassback.DFP.Div_id + `") {
					localStorage.setItem('DFP_Delivery_` + rand + `','true');
				}
			});
			});`
	}
	if template_settings.VastRetry > 0 && admaruoutput.Temp_Generation.Template_type != "2" {
		passrand := helper.IntToString(helper.RandNumber(5))
		PassbackVideoRefresh = `var adpassTimeout="";
		adpassTimeout=setTimeout(maxset` + passrand + `, 5000);
		` + GPT_Delivery + `
				
		function maxset` + passrand + `()
		{
			var MaxImp` + passrand + `='` + helper.IntToString(template_settings.VastRetry) + `';
			if(localStorage.getItem('TEMPTAG_` + Template_id + rand + `')== null){
				localStorage.setItem('TEMPTAG_` + Template_id + rand + `','` + rand + "_" + `'+MaxImp` + passrand + `);
			}
			var Imp_details` + passrand + `=localStorage.getItem('TEMPTAG_` + Template_id + rand + `');
			var Imp_array` + passrand + `=Imp_details` + passrand + `.split("_");
			var Remainig_Imp` + passrand + `=Imp_array` + passrand + `[1]; 
			var Randnum` + passrand + `=Imp_array` + passrand + `[0];
			var TagId` + passrand + `='` + Template_id + `';
			
			if (Remainig_Imp` + passrand + ` !== null){
				if (Remainig_Imp` + passrand + ` > 0)
				{
					Remainig_Imp` + passrand + `--;
					localStorage.setItem('TEMPTAG_'+TagId` + passrand + `+Randnum` + passrand + `,Randnum` + passrand + `+"_"+Remainig_Imp` + passrand + `);
					var Test_Div=document.getElementById('` + admaruoutput.Viewable_Tagid + `');
					if(Test_Div!="" && Test_Div!=null){
						Test_Div.innerHTML="";
					}
					var DFP_Delivery` + rand + `="false";
					if(localStorage.getItem('DFP_Delivery_` + rand + `')!= null){
						DFP_Delivery` + rand + `="true";
					}	
					var m3_u1 = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid=` + Template_id + `&loc='+escape(window.location)+'&auto=yes&trackingloc='+escape(window.location)+'&Is_Libload=no&passbackcall=true&rand='+Randnum` + passrand + `+'&DFP_Delivery='+DFP_Delivery` + rand + `;
					fetch(m3_u1) 
								.then(response => {       
									return response.text(); 
								})
								.then(htmlContent => {
									var mainDIV` + passrand + ` = document.getElementById('` + admaruoutput.Viewable_Tagid + `');
									var childDiv` + passrand + ` = document.createElement("div");       
									childDiv` + passrand + `.innerHTML = htmlContent;
									mainDIV` + passrand + `.appendChild(childDiv` + passrand + `);

									var mainscript` + passrand + ` = mainDIV` + passrand + `.getElementsByTagName("script");
									for (var scriptTags` + passrand + ` of mainscript` + passrand + `) {
									  var scriptContent` + passrand + ` = scriptTags` + passrand + `.textContent;
									  eval(scriptContent` + passrand + `);
									  if (scriptTags` + passrand + `.src) {
										var scriptElement` + passrand + ` = document.createElement("script");
										scriptElement` + passrand + `.src = scriptTags` + passrand + `.src;
										document.head.appendChild(scriptElement` + passrand + `);
									  }
									}
								
								})
								.catch(error => {
								});

				} else{
					localStorage.removeItem('TEMPTAG_'+TagId` + passrand + `+Randnum` + passrand + `);
					localStorage.removeItem('DFP_Delivery_` + rand + `');
					clearTimeout(adpassTimeout);

				}
			}
	
		}`
		VideoRefresh = `
var PrebidResponse=[];	
	var adEndTimeout="",adSkipTimeout="",adErrorTimeout="";
	var elem=document.getElementById('` + tagid + `'); 
	player` + rand + `.on('vast.adEnd', function () {
		adEndTimeout = setTimeout(maxset` + rand + `, 5000);
		` + GPT_Delivery + `
		player` + rand + `.dispose();
	});
	player` + rand + `.on('vast.adSkip', function () {
		adSkipTimeout = setTimeout(maxset` + rand + `, 5000);
		` + GPT_Delivery + `
		player` + rand + `.dispose();
	});
	player` + rand + `.on('vast.adError', function () {
		adErrorTimeout = setTimeout(maxset` + rand + `, 5000);
		` + GPT_Delivery + `
		player` + rand + `.dispose();
	});
player` + rand + `.on('error', function () {
		adErrorTimeout = setTimeout(maxset` + rand + `, 5000);
		` + GPT_Delivery + `
		player` + rand + `.dispose();
	});

		function maxset` + rand + `()
		{ 
Bids= [];
			 Bidders_Info=[]; 
			 Priority_level=[];
			 tag_id=[];
			 count=0;
					var MaxImp` + rand + `='` + helper.IntToString(template_settings.VastRetry) + `';
						if(localStorage.getItem('TEMPTAG_` + Template_id + rand + `')== null){
							localStorage.setItem('TEMPTAG_` + Template_id + rand + `','` + rand + "_" + `'+MaxImp` + rand + `);
						}
						var Imp_details` + rand + `=localStorage.getItem('TEMPTAG_` + Template_id + rand + `');
						var Imp_array` + rand + `=Imp_details` + rand + `.split("_");
						var Remainig_Imp` + rand + `=Imp_array` + rand + `[1]; 
						Randnum` + rand + `=Imp_array` + rand + `[0];
						var TagId` + rand + `='` + Template_id + `';
						if (Remainig_Imp` + rand + ` !== null){
							if (Remainig_Imp` + rand + ` >0)
							{
								Remainig_Imp` + rand + `--;
								localStorage.setItem('TEMPTAG_'+TagId` + rand + `+Randnum` + rand + `,Randnum` + rand + `+"_"+Remainig_Imp` + rand + `);
								RefreshCall` + rand + `(TagId` + rand + `,Randnum` + rand + `,Remainig_Imp` + rand + `);
							} else{
								localStorage.removeItem('TEMPTAG_'+TagId` + rand + `+Randnum` + rand + `);
								clearTimeout(adEndTimeout);
								clearTimeout(adSkipTimeout);
								clearTimeout(adErrorTimeout);
							}
						}
				
					}

					function RefreshCall` + rand + `(TagId,RandNo,Imp){ 
						var VideoDiv=document.getElementById('` + tagid + `');
						VideoDiv.innerHTML="";
											var xhrmk = new XMLHttpRequest();
					xhrmk.onreadystatechange = function() {
						if (xhrmk.readyState === 4) {
							
							var data = "";
							var closeEnable;
							var localEnable;
							var playOnview ="";
							var thresholdVal = "0";
							var sideStreamEnable;
							var skipEnable;
							var floatLocation ="";
							var returntopage;
							var replayEnable;
							var iniframeEnable;
							var responsive;
							var responsivereminder;
							var zIndexBoolStr;
							var sideviewwidth="";
							var sideviewheight="";
							var passbackenable;
							var passbackscriptorlink ="";
							var passbackcheck ="";
							var div_id="";
							var slot_id;
							var adsParams` + randasd + `;

								 data = JSON.parse(xhrmk.response);

								 if (data.template_settings.reminderZindex.ZIndexBool != false) {
									zIndexBoolStr = true;
								} else {
									zIndexBoolStr = false;
								}

								 if (data.template_settings.mobileView.responsiveSize != false) {
									responsive = true;
								} else {
									responsive = false;
								}

								if (data.template_settings.mobileView.responsiveRemSize != false) {
									responsivereminder = true;
								} else {
									responsivereminder = false;
								}
							
								if (data.template_settings.inIframe != false) {
									iniframeEnable = true;
								} else {
									iniframeEnable = false;
								}
							
								if (data.template_settings.playerInterface.replayButton != false) {
									replayEnable = true;
								} else {
									replayEnable = false;
								}
								if (data.template_settings.playerInterface.closeButton != false) {
									closeEnable = true;
								} else {
									closeEnable = false;
								}

								if (data.template_settings.skip.skip == true) {
									skipEnable = true;
								} else {
									skipEnable = false;
								}
								if (data.template_settings.playerMode.playerMode == "2"){
									returntopage = true;
								} else {
									returntopage = false;
								}

								if ((data.template_settings.playerMode.playerMode == "2") || (data.template_settings.playerMode.playerMode == "3")) {
									sideStreamEnable = "true";
									if ((data.template_settings.playerMode.floatType == "impression" ) && (data.template_settings.autoPlay == true)) {

										playOnview = "autoplay";
									} else if ((data.template_settings.playerMode.floatType == "bottom" || data.template_settings.playerMode.playerMode == "3") && data.template_settings.autoPlay == true) {

										playOnview = "autoplay_muted";
									} else if ((data.template_settings.playerMode.floatType == "impression" || data.template_settings.playerMode.playerMode == "3") && (data.template_settings.autoPlay == false)) {
										playOnview = "mouseover";
									}else if (data.template_settings.playerMode.floatType == "bottom" && data.template_settings.autoPlay == false)
									{
										playOnview = "mouseover2";
									}

								} else {
									sideStreamEnable = false;
								}

								if (data.template_settings.playerMode.location != "") {
									floatLocation = "bottom-" + data.template_settings.playerMode.location;
								} else {
									floatLocation = "bottom-left";
								}
								
								 if (data.template_settings.LogoVideo.LogoVideo != false) {
									localEnable = true;
								} else {
									localEnable = false;
								}
								
								if (data.template_settings.playerMode.playOnview == true) {
									playOnview = "autoplay";
									if (data.template_settings.playerMode.inView != 0) {
										thresholdVal = String(data.template_settings.playerMode.inView);
									} else if (data.template_settings.playerMode.playModeView != 0) {
										thresholdVal = String(data.template_settings.playerMode.playModeView);
									}
							
								} else if (data.template_settings.autoPlay == true) {
									if (data.template_settings.playerMode.inView != 0) {
										thresholdVal = String(data.template_settings.playerMode.inView);
									} else if (data.template_settings.playerMode.playModeView != 0) {
										thresholdVal = String(data.template_settings.playerMode.playModeView);
									}
							
									playOnview = "autoplay_muted";
								} else {
									playOnview = "mouseover";
									if (data.template_settings.playerMode.inView != 0) {
										thresholdVal = String(data.template_settings.playerMode.inView);
									} else if (data.template_settings.playerMode.playModeView != 0) {
										thresholdVal = String(data.template_settings.playerMode.playModeView);
									}
							
								}

								if (data.template_settings.playerMode.sideviewWidth != ""){
									sideviewwidth = data.template_settings.playerMode.sideviewWidth;
								}else if(data.template_settings.playerMode.remainderWidth != 0){
									sideviewwidth = data.template_settings.playerMode.remainderWidth;
								}

								if (data.template_settings.playerMode.sideviewHeight != ""){
									sideviewheight = data.template_settings.playerMode.sideviewHeight;
								}else if(data.template_settings.playerMode.sideviewHeight != 0){
									sideviewheight = data.template_settings.playerMode.sideviewHeight;
								}


								if (data.template_settings.Passback.LinkOrTag != "") {
									passbackenable = true;
								} else {
									passbackenable = false;
								}
								passbackscriptorlink = decodeURIComponent(data.template_settings.Passback.url);
							
		
															
								PrebidResponse.push(JSON.parse(data.bidder_details));
								 Bids= PrebidResponse;
								 Bidders_Info=Bids[0]; 
								 Priority_level=Bids[0]['Bidder_Details'][0]['priority'];
								 Bidders_Info['Bidder_Details'][0]['Request_Id']=data.Request_Id;
								 tag_id=Bids[0]['Bidder_Details'][0]['tag_id'];
								 adsParams` + randasd + ` = {
									playerId:  "` + tagid + `",
									useReminderZindex: zIndexBoolStr,
									reminderIdClass : data.template_settings.reminderZindex.ZIndexId,
									reminderZindex : data.template_settings.reminderZindex.ZindexValue,
									sources: [
									{
										src: "` + videoSource + `",
										type: "video/mp4"
									}
									],
									logo: {
									  image: data.template_settings.LogoVideo.logoLink,
									  url: data.template_settings.LogoVideo.logoClickthrough, 
									  position: 'top-left',
									  enabled: localEnable,
									  width: String(data.template_settings.LogoVideo.logoWidth),
									  height:  String(data.template_settings.LogoVideo.logoHeight),
									  offsetH: 0,
									  offsetV: 0,
									  opacity: 1
									},
									threshold: thresholdVal,
									context: 'outstream', 
									nonViewableBehavior: true, 
									sideStream : {
										enabled: sideStreamEnable,
										returnToPage: returntopage,
										position: floatLocation, 
										width: sideviewwidth,
										height: sideviewheight,
										offsetL: String(data.template_settings.playerMode.leftMargin),
										offsetR: String(data.template_settings.playerMode.rightMargin),
										offsetB: String(data.template_settings.playerMode.bottomMargin)
									},
									width: String(data.template_settings.maxWidth),
									height: String(data.template_settings.minHeight),
									Ui: {
											enabled : true,
											closeButton :closeEnable,
											replayButton : replayEnable,   
											playBigButton : false, 
											allowFullscreen : false              
									},
									playbackMethod: playOnview, 
									inIframe:iniframeEnable,
									isIbh: false,
									responsiveSize:responsive,
									responsiveReminderSize:responsivereminder,
									usePassback:passbackenable,
									passBackScript: [passbackscriptorlink],
									ads: {
									  adTagUrl: ad,
									  showSkipButton : skipEnable,
									  skipButtonLocation: "bottom-right",
									  skipOffSet:String(data.template_settings.skip.skip_time),
									  skipText: "Skip %%TIME%% ..",
									  skipButtonText: String(data.template_settings.skip.skip_text),
									  style: {
										zIndex: 1
										},
										viewableEventTime: 5,
										eventUrls:{
											viewable:[
													
												],
										}
									}
								};
								function parseStringToKeyValuePairs(str) {
									const keyValuePairs = {};
									const pairs = str.split('],');
									pairs.pop();
									for (const pair of pairs) {
									  const [key, value] = pair.split(': ');
									  
									 
									  keyValuePairs[key] =JSON.parse(value+"]");
									}
								  
									return keyValuePairs;
								  }
								  const keyValuePairs = parseStringToKeyValuePairs(data.third_part_trackers);
								mergeKeyValuePairsIntoObject(keyValuePairs, adsParams` + randasd + `.ads.eventUrls);

								function mergeKeyValuePairsIntoObject(keyValuePairs, targetObject) {
									for (const key in keyValuePairs) {
									  if (keyValuePairs.hasOwnProperty(key)) 
									  {
										targetObject[key] = keyValuePairs[key];
									   }
									}
							  	};
									Bidders_Info["adsParams` + randasd + `"]=adsParams` + randasd + `;
									pbjs.que.push(function() { 
									pbjs.removeAdUnit('` + tagid + `');
								  });
								  pbjs.adserverRequestSent = false;
								  adUnits="";
								  VideoadUnits = "";
								  VastRetry=true;
								 var VideoadUnits = [{
									code: '` + tagid + `',
									mediaTypes: {
									  video: {
										  context: "outstream",   
										  playerSize: [` + helper.ArrayOfInttoString(size, ",") + `],
										  mimes: ["video/mp4","video/x-ms-wmv","video/webm","application/javascript"],
										  protocols: [1, 2, 3, 4, 5, 6, 7, 8],
										  playbackmethod: [2],
										  api: [2],
										skip:1,
										placement:3,
										  linearity: 1,
										  renderer: {
											  render,
											  url:  "` + config.GetConfig("path", "library") + `/admaru-player.js", 
										  }
									  }
								  },
								  renderer: {
									  render,
									  url:  "` + config.GetConfig("path", "library") + `/admaru-player.js", 
								  },
									bids:Bidders_Info['Bidder_Details']
								  }];
								  pbjs.que.push(function() {
									  pbjs.removeAdUnit('` + tagid + `');
									  pbjs.addAdUnits(VideoadUnits);` + Track_Req_Resvideo + `
										pbjs.setConfig({
										debug: false,
										useBidCache: false,
										"currency": {
										  "adServerCurrency": Bidders_Info['Bidder_Details'][0]['BiddingCurrency'],
										  "granularityMultiplier": 1,
										},
										"schain": {
										  "validation": "strict",
										  "config": {
											"ver":"1.0",
											"complete": 1,
											"nodes": [
											  {
												"asi":"` + admaruoutput.PublisherDetails.Publisher_Seller.Domain + `",
												"sid":"` + admaruoutput.PublisherDetails.Publisher_Seller.Seller_id + `",
												"hp":1
											  }
											]
										  }
										},
										gdpr: {
										  cmpApi: 'iab',
										  timeout: 8000,
										  defaultGdprScope: true 
										},
										usp: {
										  cmpApi: 'iab',  
										  timeout: 8000
										},
										priceGranularity:"dense",
									  });
									  pbjs.requestBids({
										  timeout: PREBID_TIMEOUT,
										  adUnitCodes: ['` + tagid + `'],
										  bidsBackHandler: sendAdserverRequest 
									  });
								  });
							}
					};
					xhrmk.open('GET', '` + config.GetConfig("commonpath", "file") + `VideoVast?tagid=` + admaruoutput.Tag_id + `&loc='+escape(window.location)+'&auto=yes&trackingloc='+escape(window.location)+'&rand='+ Randnum` + rand + `+'&tagidRand=` + admaruoutput.Tag_id + `', true);
					xhrmk.send(null);
					}
				`
	} else {
		VideoRefresh = `
		var PrebidResponse=[];	
		var adEndTimeout="",adSkipTimeout="",adErrorTimeout="";
		var elem=document.getElementById('` + tagid + `'); 
		player` + rand + `.on('vast.adEnd', function () {
			if(dfppassback=="true"){
				elem.style.transition="none";
				elem.style.height="auto";
				
			}
			player` + rand + `.dispose();
		});
		player` + rand + `.on('vast.adSkip', function () {
			if(dfppassback=="true"){
				elem.style.transition="none";
				elem.style.height="auto";
				
			}
			player` + rand + `.dispose();
		});
		player` + rand + `.on('vast.adError', function () {
			if(dfppassback=="true"){
				elem.style.transition="none";
				elem.style.height="auto";
				
			}
			player` + rand + `.dispose();
		});
		player` + rand + `.on('error', function () {
			if(dfppassback=="true"){
				elem.style.transition="none";
				elem.style.height="auto";
				
			}
			player` + rand + `.dispose();
		});`
	}

	switch {
	// If Winning Bid is Prebid for bidding to gather cases
	case admaruoutput.Is_Prebidwon == "Yes":
		admaruoutput.External_ad = true
		tagid = "Prebid_" + admaruoutput.Autorefreshrand
		admaruoutput.Html =
			`Prebidwon`

	case admaruoutput.Adunit_type == "PrebidPriority":
		if TagType == "3" || TagType == "2" {

			admaruoutput.Html = `			
			<script type="text/javascript" >
			var passsbacktest = "` + passbackscriptorlink + `";
passsbacktest=decodeURIComponent(passsbacktest);
passsbacktest=passsbacktest.replaceAll("\n","");

			Bids=[` + helper.ConvertStrJsonToRawJson(Biddderjsonmapp) + `];
			Bidders_Info=Bids[0];
			Request_bids ={}; 
			Res_status="&res_count=0"; 
			Bidder_Response={}; count=0;  
			Priority_level=Bids[0]['Bidder_Details'][0]['priority'];
			tag_id=Bids[0]['Bidder_Details'][0]['tag_id'];
			adsParams` + randasd + `=""; WonBid="";
			highestCpmBids` + randasd + ` =""; adUnits=[];
			VastRetry=false; Randnum` + rand + `="";
			
			` + GetAPICall + `
			Test_Div=document.getElementById('` + tagid + `');
			if(Test_Div!="" && Test_Div!=null){
				Test_Div.innerHTML="";
			}	

			  pbjs.adserverRequestSent = false;
			  pbjs.que.push(function() { 
				pbjs.removeAdUnit('` + tagid + `');
			  });
			  adUnits="";
				adUnits = [{
					code: '` + tagid + `',
					mediaTypes: {
					  video: {
						  context: "` + InstreamOrOutStream + `",   
						  playerSize: [` + helper.ArrayOfInttoString(size, ",") + `],
						  mimes: ["video/mp4","video/x-ms-wmv","video/webm","application/javascript"],
						  protocols: [1, 2, 3, 4, 5, 6, 7, 8],
						  playbackmethod: [2],
						  api: [2],
						  skip:0,
						  placement:2,
						  linearity: 1,
						  minduration:5,
						  maxduration:60,
						  renderer: {
							  render,
							  url:  "` + config.GetConfig("path", "player") + `/admaru-player.js", 
						  }
					  }
				  },
				  renderer: {
					  render,
					  url:  "` + config.GetConfig("path", "player") + `/admaru-player.js", 
				  },
					bids:Bidders_Info['Bidder_Details']
				  }];
				  pbjs.que.push(function() { 
				 	 pbjs.removeAdUnit('` + tagid + `');
					  pbjs.addAdUnits(adUnits);
					  ` + Track_Req_Resvideo + `
					  pbjs.setConfig({
						debug: false,
						useBidCache: false,
						"currency": {
						  "adServerCurrency": Bidders_Info['Bidder_Details'][0]['BiddingCurrency'],
						  "granularityMultiplier": 1,
					   },
					   "schain": {
						  "validation": "strict",
						  "config": {
							"ver":"1.0",
							"complete": 1,
							"nodes": [
							  {
									"asi":"` + admaruoutput.PublisherDetails.Publisher_Seller.Domain + `",
								"sid":"` + admaruoutput.PublisherDetails.Publisher_Seller.Seller_id + `",
								"hp":1
							  }
							]
						  }
						},
						gdpr: {
						  cmpApi: 'iab',
						  timeout: 8000,
						  defaultGdprScope: true 
						},
						usp: {
						  cmpApi: 'iab',  
						  timeout: 8000
						},
						priceGranularity:"dense",
					  });
					  pbjs.requestBids({
						  timeout: PREBID_TIMEOUT,
						  adUnitCodes: ['` + tagid + `'],
						  bidsBackHandler: sendAdserverRequest
					  });
				  });
			function callAdmaruRenderer(bid, ad, Is_VastRetry) {
				if(ad.search(/<VAST/ig) !== -1){
				  var xmlBlob = new Blob([ad], {type: "application/xml"});
				  ad = URL.createObjectURL(xmlBlob);
				}
				if(Is_VastRetry==true){
								bid.renderer.push(() => {
							Bidders_Info["adsParams` + randasd + `"]["ads"]["defaultEventUrl"]=[WonBid['AdTrack']];
							Bidders_Info["adsParams` + randasd + `"]["ads"]["eventUrls"]={"viewable" : [WonBid['AdViewableEvent_URL']]};
									player` + rand + `= adMaru.load(Bidders_Info["adsParams` + randasd + `"]);
									player` + rand + `.on('click', function(event) { 
										if(event.target.className == 'vast-blocker')
										{
											var ClickD = WonBid['AdClick_URL'];
											xmlHttp.open('GET', ClickD, true);
											xmlHttp.send();
										}			
									});
									player` + rand + `.on('vast.admShow', function () {
										var impressionImp =WonBid['AdImpression_URL'] !="" ? WonBid['AdImpression_URL']+'&won_price='+highestCpmBids` + randasd + `[0]['cpm'] :"";
										let myPromise = new Promise(function(myResolve, myReject) {
											myResolve(impressionImp);
										});
										myPromise.then(
										function(value) {GetApiCalling(value);}
										);
										

										var viewableImpression =WonBid['AdViewImpression_URL'];
										var xmlHttp = new XMLHttpRequest();
											xmlHttp.open( "GET", viewableImpression, true );
													xmlHttp.send();
									});
									` + VideoRefresh + `
								});

											}else{
					adsParams` + randasd + ` = {
						playerId: '` + tagid + `',
						useReminderZindex: ` + ZIndexBoolStr + `,
						reminderIdClass : "` + template_settings.ReminderZindex.ZIndexId + `",
						reminderZindex : "` + template_settings.ReminderZindex.ZindexValue + `",
						sources: [
						{
							src: "` + videoSource + `",
							type: "video/mp4"
						}
						],
						logo: {
							image: '` + template_settings.LogoVideo.LogoLink + `',
							url: '` + template_settings.LogoVideo.LogoClickthrough + `', 
							position: 'top-left',
							enabled: ` + localEnable + `,
							width: '` + helper.IntToString(template_settings.LogoVideo.LogoWidth) + `',
							height: '` + helper.IntToString(template_settings.LogoVideo.LogoHeight) + `',
							offsetH: 0,
							offsetV: 0,
							opacity: 1
						},
						threshold: ` + thresholdVal + `,
						context: '` + InstreamOrOutStream + `', 
						nonViewableBehavior: false, 
						sideStream : {
							enabled: ` + sideStreamEnable + `,
							returnToPage: ` + returntopage + `,
							position: "` + floatLocation + `", 
							width: "` + sideviewwidth + `",
							height: "` + sideviewheight + `",
							offsetL: "` + helper.IntToString(template_settings.PlayerMode.LeftMargin) + `",
							offsetR: "` + helper.IntToString(template_settings.PlayerMode.RightMargin) + `",
							offsetB: "` + helper.IntToString(template_settings.PlayerMode.BottomMargin) + `"
						},
						width: ` + helper.IntToString(template_settings.MaxWidth) + `,
						height: ` + helper.IntToString(template_settings.MinWidth) + `,
						Ui: {
								enabled : true,
								closeButton : ` + closeEnable + `,
								replayButton : ` + replayEnable + `,     
								playBigButton : false, 
								allowFullscreen : false              
						},
						playbackMethod: "` + playOnview + `", 
						inIframe: ` + iniframeEnable + `,
						isIbh: false,
						responsiveSize:` + responsive + `,
						responsiveReminderSize:` + responsivereminder + `,
						usePassback: ` + passbackenable + `,
						passBackScript: [passsbacktest],
						ads: {
							adTagUrl: ad,
							showSkipButton : ` + skipEnable + `,
							skipButtonLocation: "bottom-right",
							skipOffSet: ` + helper.IntToString(template_settings.Skip.SkipTime) + `,
							skipText: "Skip %%TIME%% ..",
							skipButtonText: "` + template_settings.Skip.SkipText + `",
						style: {
							zIndex: 1
						},
						viewableEventTime: 5,
						defaultEventUrl:[WonBid['AdTrack']],
						eventUrls:{
							viewable:[WonBid['AdViewableEvent_URL']],
							` + _3rd_img_firstQuartile + `
							` + _3rd_js_firstQuartile + `
							` + _3rd_iframe_firstQuartile + `

							` + _3rd_img_midpoint + `
							` + _3rd_js_midpoint + `
							` + _3rd_iframe_midpoint + `

							` + _3rd_img_thirdQuartile + `
							` + _3rd_js_thirdQuartile + `
							` + _3rd_iframe_thirdQuartile + `

							` + _3rd_img_pause + `
							` + _3rd_js_pause + `
							` + _3rd_iframe_pause + `

							` + _3rd_img_resume + `
							` + _3rd_js_resume + `
							` + _3rd_iframe_resume + `

							` + _3rd_img_mute + `
							` + _3rd_js_mute + `
							` + _3rd_iframe_mute + `

							` + _3rd_img_unmute + `
							` + _3rd_js_unmute + `
							` + _3rd_iframe_unmute + `

							` + _3rd_img_skip + `
							` + _3rd_js_skip + `
							` + _3rd_iframe_skip + `

							` + _3rd_img_impression + `
							` + _3rd_js_impression + `
							` + _3rd_iframe_impression + `

							` + _3rd_img_viewableImpression + `
							` + _3rd_js_viewableImpression + `
							` + _3rd_iframe_viewableImpression + `

							` + _3rd_img_click + `
							` + _3rd_js_click + `
							` + _3rd_iframe_click + `

							` + _3rd_img_start + `
							` + _3rd_js_start + `
							` + _3rd_iframe_start + `

							` + _3rd_img_complete + `
							` + _3rd_js_complete + `
							` + _3rd_iframe_complete + `

							` + _3rd_img_close + `
							` + _3rd_js_close + `
							` + _3rd_iframe_close + `
						}
						}
					};
					bid.renderer.push(() => {
						player` + rand + `= adMaru.load(adsParams` + randasd + `);
						player` + rand + `.on('click', function(event) { 
							if(event.target.className == 'vast-blocker')
							{
								var ClickD = WonBid['AdClick_URL'];
								xmlHttp.open('GET', ClickD, true);
								xmlHttp.send();
							}			
						});
						player` + rand + `.on('vast.admShow', function () {
							var impressionImp =WonBid['AdImpression_URL'] !="" ? WonBid['AdImpression_URL']+'&won_price='+highestCpmBids` + randasd + `[0]['cpm'] :"";
							let myPromise = new Promise(function(myResolve, myReject) {
								myResolve(impressionImp);
							});
							myPromise.then(
							function(value) {GetApiCalling(value);}
							);
							

							var viewableImpression =WonBid['AdViewImpression_URL'];
							var xmlHttp = new XMLHttpRequest();
								xmlHttp.open( "GET", viewableImpression, true );
										xmlHttp.send();
						});
						` + VideoRefresh + `
					});
				}
			  }
			  function render(bid) {
				  let ad = bid.ad || bid.vastXml;
				  if (ad) {
					  callAdmaruRenderer(bid, ad, VastRetry)
				  } else {
					  if (bid.vastUrl) {
						callAdmaruRenderer(bid, bid.vastUrl, VastRetry);
					  } else {
					  }
				  }
			  }
			
				function sendAdserverRequest(){
					if(pbjs.adserverRequestSent) return;
					pbjs.adserverRequestSent = true;
					highestCpmBids` + randasd + ` = pbjs.getHighestCpmBids('` + tagid + `'); 
					var Prebid_cpm=highestCpmBids` + randasd + `!="" ? highestCpmBids` + randasd + `[0]['cpm'] : "";
					var Direct_cpm=Bidders_Info["Bidder_Details"][0]["Bidding_cpm"]!="" ? Bidders_Info["Bidder_Details"][0]["Bidding_cpm"] : "";
					var Multi_Ad=Bidders_Info["MarketPlace"];
   
							if(highestCpmBids` + randasd + `=="" && Multi_Ad=="no" ){ 

						if (Bidders_Info['Bidder_Details'][0]['priority_next'] != 0 ) {
									var apicall = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&priority='+Bidders_Info['Bidder_Details'][0]['priority']+'&priority_next='+Bidders_Info['Bidder_Details'][0]['priority_next']+'&rand=` + rand + `&trackingloc=` + config.GetConfig("commonpath", "file") + `&adtype=PrebidPriority&requestId=` + admaruoutput.Request_Id + `&Is_MultiAd=yes';
										fetch(apicall) 
									.then(response => {       
										return response.text(); 
									})
									.then(htmlContent => {
															
										var mainDIV` + randasd + ` = document.getElementById('` + tagid + `');
										var childDiv` + randasd + ` = document.createElement("div");       
										childDiv` + randasd + `.innerHTML = htmlContent;
										mainDIV` + randasd + `.appendChild(childDiv` + randasd + `);

										var mainscript` + randasd + ` = mainDIV` + randasd + `.getElementsByTagName("script");
										if(mainscript` + randasd + `){
										for (var scriptTags` + randasd + ` of mainscript` + randasd + `) {
										  var scriptContent` + randasd + ` = scriptTags` + randasd + `.textContent;
										  eval(scriptContent` + randasd + `);
										  if (scriptTags` + randasd + `.src) {
											var scriptElement` + randasd + ` = document.createElement("script");
											scriptElement` + randasd + `.src = scriptTags` + randasd + `.src;
											document.head.appendChild(scriptElement` + randasd + `);
										  }
										}
										}
									})
									.catch(error => {
									});
					}else{
									var	htmlContent = passsbacktest;
									
											var mainDIV` + randasd + ` = document.getElementById('` + tagid + `');
										var childDiv` + randasd + ` = document.createElement("div");       
										childDiv` + randasd + `.innerHTML = htmlContent;
									mainDIV` + randasd + `.innerHTML = "";
										mainDIV` + randasd + `.appendChild(childDiv` + randasd + `);

										var mainscript` + randasd + ` = mainDIV` + randasd + `.getElementsByTagName("script");
										for (var scriptTags` + randasd + ` of mainscript` + randasd + `) {
										  var scriptContent` + randasd + ` = scriptTags` + randasd + `.textContent;
										  eval(scriptContent` + randasd + `);
										  if (scriptTags` + randasd + `.src) {
											var scriptElement` + randasd + ` = document.createElement("script");
											scriptElement` + randasd + `.src = scriptTags` + randasd + `.src;
											document.head.appendChild(scriptElement` + randasd + `);
										  }
										}
				` + PassbackVideoRefresh + `
										}
										
						}else{
									if(Multi_Ad=="yes"){ 
													
										var highestCPM` + rand + `= highestCpmBids` + randasd + `!="" ? highestCpmBids` + randasd + `[0]['cpm'] : "";
										if(highestCpmBids` + randasd + `!=""){
											
						WonBid = Request_bids[highestCpmBids` + randasd + `[0]['requestId']] != "" ? Request_bids[highestCpmBids` + randasd + `[0]['requestId']] : "";
						
										if(WonBid.floorprice>highestCPM` + rand + `){
											highestCPM` + rand + `=0;
										}
										var DFP_Delivery` + rand + `="false";
										if(localStorage.getItem('DFP_Delivery_` + rand + `')!= null){
											DFP_Delivery` + rand + `="true";
										}
										var BidderResponse=[{"Adwon_URL" : WonBid['Adwon_URL'],
										"cpm" : highestCpmBids` + randasd + `[0]['cpm'],
										"AdViewImpression_URL" : WonBid['AdViewImpression_URL'],"AdClick_URL" : WonBid['AdClick_URL'],"ad" : highestCpmBids` + randasd + `[0].ad,"AdImpression_URL" : WonBid['AdImpression_URL']}];
										var apicall = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&MultiAdformatPriority='+Bidders_Info['Bidder_Details'][0]['priority']+'&highestBidCpm='+highestCPM` + rand + `+'&Is_MultiAd='+Multi_Ad+'&tagidRand=` + tagid + `&loc=` + admaruoutput.CORSDomain + `&rand=` + rand + `&requestId=` + admaruoutput.Request_Id + `&Is_Libload=no&DFP_Delivery='+DFP_Delivery` + rand + `;
						
										fetch(apicall) 
										.then(response => {       
											return response.text(); 
										})
										.then(htmlContent => {

													if(htmlContent!="Prebidwon")
													{													
											var mainDIV` + randasd + ` = document.getElementById('` + tagid + `');
											var childDiv` + randasd + ` = document.createElement("div");       
											childDiv` + randasd + `.innerHTML = htmlContent;
											mainDIV` + randasd + `.appendChild(childDiv` + randasd + `);
	
											var mainscript` + randasd + ` = mainDIV` + randasd + `.getElementsByTagName("script");
											if(mainscript` + randasd + `){
											for (var scriptTags` + randasd + ` of mainscript` + randasd + `) {
											  var scriptContent` + randasd + ` = scriptTags` + randasd + `.textContent;
											  eval(scriptContent` + randasd + `);
											  if (scriptTags` + randasd + `.src) {
												var scriptElement` + randasd + ` = document.createElement("script");
												scriptElement` + randasd + `.src = scriptTags` + randasd + `.src;
												document.head.appendChild(scriptElement` + randasd + `);
											  }
											}
											}
												}else
												{
													var Nobids=pbjs.getNoBidsForAdUnitCode('` + tagid + `');				
													var AdViewImpression_URL=WonBid['AdViewImpression_URL'];
													pbjs.renderAd(document, highestCpmBids` + randasd + `[0].adId);
													` + Track_Win_Nobidvideo + `
												}

										})
										.catch(error => {
										});
											  }
										else{
											highestCPM` + rand + `=0;
											var DFP_Delivery` + rand + `="false";
											if(localStorage.getItem('DFP_Delivery_` + rand + `')!= null){
												DFP_Delivery` + rand + `="true";
											}
											var apicall = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&MultiAdformatPriority='+Bidders_Info['Bidder_Details'][0]['priority']+'&highestBidCpm='+highestCPM` + rand + `+'&Is_MultiAd='+Multi_Ad+'&tagidRand=` + tagid + `&loc=` + admaruoutput.CORSDomain + `&rand=` + rand + `&requestId=` + admaruoutput.Request_Id + `&Is_Libload=no&DFP_Delivery='+DFP_Delivery` + rand + `;
								fetch(apicall) 
								.then(response => {       
									return response.text(); 
										})
								.then(htmlContent => {
															
																var mainDIV` + randasd + ` = document.getElementById('` + tagid + `');
																var childDiv` + randasd + ` = document.createElement("div");       
																childDiv` + randasd + `.innerHTML = htmlContent;
																mainDIV` + randasd + `.appendChild(childDiv` + randasd + `);
																
																var mainscript` + randasd + ` = mainDIV` + randasd + `.getElementsByTagName("script");
									if(mainscript` + randasd + `){
																for (var scriptTags` + randasd + ` of mainscript` + randasd + `) {
																var scriptContent` + randasd + ` = scriptTags` + randasd + `.textContent;
																eval(scriptContent` + randasd + `);
																if (scriptTags` + randasd + `.src) {
																var scriptElement` + randasd + ` = document.createElement("script");
																scriptElement` + randasd + `.src = scriptTags` + randasd + `.src;
																document.head.appendChild(scriptElement` + randasd + `);
																}
																}
																}
								})
								.catch(error => {
								});
							}
										}else{
													
											WonBid = Request_bids[highestCpmBids` + randasd + `[0]['requestId']] != "" ? Request_bids[highestCpmBids` + randasd + `[0]['requestId']] : "";
											
														var Nobids=pbjs.getNoBidsForAdUnitCode('` + tagid + `');
						var AdViewImpression_URL=WonBid['AdViewImpression_URL'];

						pbjs.renderAd(document, highestCpmBids` + randasd + `[0].adId);
						` + Track_Win_Nobidvideo + `
					}
				}
					
				}
							</script>
			`
		}
		admaruoutput.External_ad = true
	case admaruoutput.Adunit_type == "async":
		admaruoutput.External_ad = true
		if TagType == "3" || TagType == "2" {
			admaruoutput.Viewable_Tagid = tagid

			PlayerJS := `<div id='` + tagid + `' class='.rm_videowrapper_` + tagid + `'></div><div id='Prebidtrack_` + rand + `'></div><div id="gpt-passback"></div>
			<script src="` + config.GetConfig("path", "player") + `/admaru-player.js"></script>
			<script async src="` + config.GetConfig("path", "library") + `/Admaru.js"></script>
			<link rel="stylesheet" href="` + config.GetConfig("path", "player") + `/admaru-player.css">
			<script src="https://code.jquery.com/jquery-1.12.1.min.js"></script>
			<script type='text/javascript' src='` + config.GetConfig("path", "library") + `/viewability.js'></script>
			<script async src="https://securepubads.g.doubleclick.net/tag/js/gpt.js"></script>`
			pbjs := `var pbjs = pbjs || {};`
			if admaruoutput.Impcap == "yes" {
				pbjs = `pbjs = pbjs || {};`
			}
			Prebidvar := pbjs + `
			pbjs.que = pbjs.que || [];
			var Bids=[` + helper.ConvertStrJsonToRawJson(Biddderjsonmapp) + `];
			var Bidders_Info=Bids[0];
			var Request_bids ={}; 
			var Res_status="&res_count=0"; 
			var Bidder_Response={}; var count=0;  
			var xmlHttp = new XMLHttpRequest();
			var Priority_level=Bids[0]['Bidder_Details'][0]['priority'];
			var tag_id=Bids[0]['Bidder_Details'][0]['tag_id'];
			var adsParams` + randasd + `=""; var WonBid="";
			var highestCpmBids` + randasd + ` ="";
			var player` + rand + `=""; var adUnits=[];
			var VastRetry=false; var Randnum` + rand + `="";
			var PREBID_TIMEOUT = 8000;var dfppassback="` + dfppassback + `"; var display_refresh;`
			if admaruoutput.Is_Libload == "no" {
				PlayerJS = ""
				Prebidvar = `
				Bids=[` + helper.ConvertStrJsonToRawJson(Biddderjsonmapp) + `];
				Bidders_Info=Bids[0];
				Request_bids ={}; 
				Res_status="&res_count=0"; 
				Bidder_Response={}; count=0;  
				Priority_level=Bids[0]['Bidder_Details'][0]['priority'];
				tag_id=Bids[0]['Bidder_Details'][0]['tag_id'];
				adsParams` + randasd + `=""; WonBid="";
				highestCpmBids` + randasd + ` =""; adUnits=[];
				 VastRetry=false; Randnum` + rand + `="";
				 PREBID_TIMEOUT = 8000;dfppassback="` + dfppassback + `";`
			}
			admaruoutput.Html = PlayerJS + `
			
			<script type="text/javascript" > 
			var passsbacktest = "` + passbackscriptorlink + `";
			passsbacktest=decodeURIComponent(passsbacktest);
			passsbacktest=passsbacktest.replaceAll("\n","");
			
			` + Prebidvar + `
			` + GetAPICall + `
			var Test_Div=document.getElementById('` + tagid + `');
			if(Test_Div!="" && Test_Div!=null){
				Test_Div.innerHTML="";
			}

			pbjs.que.push(function() { 
				pbjs.removeAdUnit('` + tagid + `');
			});
				pbjs.adserverRequestSent = false;
				adUnits = [{
					code: '` + tagid + `',
					mediaTypes: {
					  video: {
						  context: "` + InstreamOrOutStream + `",   
						  playerSize: [` + helper.ArrayOfInttoString(size, ",") + `],
						  mimes: ["video/mp4","video/x-ms-wmv","video/webm","application/javascript"],
						  protocols: [1, 2, 3, 4, 5, 6, 7, 8],
						  playbackmethod: [2],
						  api: [2],
						  skip:0,
						  placement:2,
						  linearity: 1,
						  minduration:5,
						  maxduration:60,
						  renderer: {
							  render,
							  url:  "` + config.GetConfig("path", "player") + `/admaru-player.js", 
						  }
					  }
				  },
				  renderer: {
					  render,
					  url:  "` + config.GetConfig("path", "player") + `/admaru-player.js", 
				  },
					bids:Bidders_Info['Bidder_Details']
				  }];
				  pbjs.que.push(function() { 
					  pbjs.removeAdUnit('` + tagid + `');
					  pbjs.addAdUnits(adUnits);
					  ` + Track_Req_Resvideo + `
					  pbjs.setConfig({
						debug: false,
						useBidCache: false,
						"currency": {
						  "adServerCurrency": Bidders_Info['Bidder_Details'][0]['BiddingCurrency'],
						  "granularityMultiplier": 1,
					   },
					   "schain": {
						  "validation": "strict",
						  "config": {
							"ver":"1.0",
							"complete": 1,
							"nodes": [
							  {
									"asi":"` + admaruoutput.PublisherDetails.Publisher_Seller.Domain + `",
								"sid":"` + admaruoutput.PublisherDetails.Publisher_Seller.Seller_id + `",
								"hp":1
							  }
							]
						  }
						},
						gdpr: {
						  cmpApi: 'iab',
						  timeout: 8000,
						  defaultGdprScope: true 
						},
						usp: {
						  cmpApi: 'iab',  
						  timeout: 8000
						},
						priceGranularity:"dense",
					  });
					  pbjs.requestBids({
						  timeout: PREBID_TIMEOUT,
						  adUnitCodes: ['` + tagid + `'],
						  bidsBackHandler: sendAdserverRequest
					  });
				  });
						function callAdmaruRenderer(bid, ad, Is_VastRetry) {
				if(ad.search(/<VAST/ig) !== -1){
				  var xmlBlob = new Blob([ad], {type: "application/xml"});
				  ad = URL.createObjectURL(xmlBlob);
				}
				if(Is_VastRetry==true){
													bid.renderer.push(() => {
						Bidders_Info["adsParams` + randasd + `"]["ads"]["defaultEventUrl"]=[WonBid['AdTrack']];
						Bidders_Info["adsParams` + randasd + `"]["ads"]["eventUrls"]["viewable"]=WonBid['AdViewableEvent_URL'];
						
						
									player` + rand + `= adMaru.load(Bidders_Info["adsParams` + randasd + `"]);
									player` + rand + `.on('click', function(event) { 
										if(event.target.className == 'vast-blocker')
										{
											var ClickD = WonBid['AdClick_URL'];
											xmlHttp.open('GET', ClickD, true);
											xmlHttp.send();
										}			
									});
									player` + rand + `.on('vast.admShow', function () {
										var impressionImp =WonBid['AdImpression_URL'] !="" ? WonBid['AdImpression_URL']+'&won_price='+highestCpmBids` + randasd + `[0]['cpm'] :"";
										let myPromise = new Promise(function(myResolve, myReject) {
											myResolve(impressionImp);
										});
										myPromise.then(
										function(value) {GetApiCalling(value);}
										);
										

										var viewableImpression =WonBid['AdViewImpression_URL'];
										var xmlHttp = new XMLHttpRequest();
											xmlHttp.open( "GET", viewableImpression, true );
													xmlHttp.send();
										
									});
									` + VideoRefresh + `
								});

											}else{
					adsParams` + randasd + ` = {
						playerId: '` + tagid + `',
						useReminderZindex: ` + ZIndexBoolStr + `,
						reminderIdClass : "` + template_settings.ReminderZindex.ZIndexId + `",
						reminderZindex : "` + template_settings.ReminderZindex.ZindexValue + `",
						sources: [
						{
							src: "` + videoSource + `",
							type: "video/mp4"
						}
						],
						logo: {
							image: '` + template_settings.LogoVideo.LogoLink + `',
							url: '` + template_settings.LogoVideo.LogoClickthrough + `', 
							position: 'top-left',
							enabled: ` + localEnable + `,
							width: '` + helper.IntToString(template_settings.LogoVideo.LogoWidth) + `',
							height: '` + helper.IntToString(template_settings.LogoVideo.LogoHeight) + `',
							offsetH: 0,
							offsetV: 0,
							opacity: 1
						},
						threshold: ` + thresholdVal + `,
						context: '` + InstreamOrOutStream + `', 
						nonViewableBehavior: false, 
						sideStream : {
							enabled: ` + sideStreamEnable + `,
							returnToPage: ` + returntopage + `,
							position: "` + floatLocation + `", 
							width: "` + sideviewwidth + `",
							height: "` + sideviewheight + `",
							offsetL: "` + helper.IntToString(template_settings.PlayerMode.LeftMargin) + `",
							offsetR: "` + helper.IntToString(template_settings.PlayerMode.RightMargin) + `",
							offsetB: "` + helper.IntToString(template_settings.PlayerMode.BottomMargin) + `"
						},
						width: ` + helper.IntToString(template_settings.MaxWidth) + `,
						height: ` + helper.IntToString(template_settings.MinWidth) + `,
						Ui: {
								enabled : true,
								closeButton : ` + closeEnable + `,
								replayButton : ` + replayEnable + `,     
								playBigButton : false, 
								allowFullscreen : false              
						},
						playbackMethod: "` + playOnview + `", 
						inIframe: ` + iniframeEnable + `,
						isIbh: false,
						responsiveSize:` + responsive + `,
						responsiveReminderSize:` + responsivereminder + `,
						usePassback: ` + passbackenable + `,
						passBackScript: [passsbacktest],
						ads: {
							adTagUrl: ad,
							showSkipButton : ` + skipEnable + `,
							skipButtonLocation: "bottom-right",
							skipOffSet: ` + helper.IntToString(template_settings.Skip.SkipTime) + `,
							skipText: "Skip %%TIME%% ..",
							skipButtonText: "` + template_settings.Skip.SkipText + `",
						style: {
							zIndex: 1
						},
						viewableEventTime: 5,
						defaultEventUrl:[WonBid['AdTrack']],
						eventUrls:{
							viewable:[WonBid['AdViewableEvent_URL']],
							` + _3rd_img_firstQuartile + `
							` + _3rd_js_firstQuartile + `
							` + _3rd_iframe_firstQuartile + `

							` + _3rd_img_midpoint + `
							` + _3rd_js_midpoint + `
							` + _3rd_iframe_midpoint + `

							` + _3rd_img_thirdQuartile + `
							` + _3rd_js_thirdQuartile + `
							` + _3rd_iframe_thirdQuartile + `

							` + _3rd_img_pause + `
							` + _3rd_js_pause + `
							` + _3rd_iframe_pause + `

							` + _3rd_img_resume + `
							` + _3rd_js_resume + `
							` + _3rd_iframe_resume + `

							` + _3rd_img_mute + `
							` + _3rd_js_mute + `
							` + _3rd_iframe_mute + `

							` + _3rd_img_unmute + `
							` + _3rd_js_unmute + `
							` + _3rd_iframe_unmute + `

							` + _3rd_img_skip + `
							` + _3rd_js_skip + `
							` + _3rd_iframe_skip + `

							` + _3rd_img_impression + `
							` + _3rd_js_impression + `
							` + _3rd_iframe_impression + `

							` + _3rd_img_viewableImpression + `
							` + _3rd_js_viewableImpression + `
							` + _3rd_iframe_viewableImpression + `

							` + _3rd_img_click + `
							` + _3rd_js_click + `
							` + _3rd_iframe_click + `

							` + _3rd_img_start + `
							` + _3rd_js_start + `
							` + _3rd_iframe_start + `

							` + _3rd_img_complete + `
							` + _3rd_js_complete + `
							` + _3rd_iframe_complete + `

							` + _3rd_img_close + `
							` + _3rd_js_close + `
							` + _3rd_iframe_close + `
						}
						}
					};
					
					bid.renderer.push(() => {
						player` + rand + `= adMaru.load(adsParams` + randasd + `);
						player` + rand + `.on('click', function(event) { 
							if(event.target.className == 'vast-blocker')
							{
								var ClickD = WonBid['AdClick_URL'];
								xmlHttp.open('GET', ClickD, true);
								xmlHttp.send();
							}			
						});
						player` + rand + `.on('vast.admShow', function () {
							var impressionImp =WonBid['AdImpression_URL'] !="" ? WonBid['AdImpression_URL']+'&won_price='+highestCpmBids` + randasd + `[0]['cpm'] :"";
							let myPromise = new Promise(function(myResolve, myReject) {
								myResolve(impressionImp);
							});
							myPromise.then(
							function(value) {GetApiCalling(value);}
							);
							

										var viewableImpression =WonBid['AdViewImpression_URL'];
										var xmlHttp = new XMLHttpRequest();
											xmlHttp.open( "GET", viewableImpression, true );
													xmlHttp.send();
										
						});
						` + VideoRefresh + `
					});
				}
			}
			  function render(bid) {
				  let ad = bid.ad || bid.vastXml;
				  if (ad) {
					  callAdmaruRenderer(bid, ad, VastRetry)
				  } else {
					  if (bid.vastUrl) {
						callAdmaruRenderer(bid, bid.vastUrl, VastRetry);
					  } else {
						 
					  }
				  }
			  }
			
				function sendAdserverRequest(){
					if(pbjs.adserverRequestSent) return;
							pbjs.adserverRequestSent = true;
							highestCpmBids` + randasd + ` = pbjs.getHighestCpmBids('` + tagid + `'); 
							var Prebid_cpm=highestCpmBids` + randasd + `!="" ? highestCpmBids` + randasd + `[0]['cpm'] : "";
							var Direct_cpm=Bidders_Info["Bidder_Details"][0]["Bidding_cpm"]!="" ? Bidders_Info["Bidder_Details"][0]["Bidding_cpm"] : "";
							var Multi_Ad=Bidders_Info["MarketPlace"];
					
							if(highestCpmBids` + randasd + `=="" && Multi_Ad=="no" ){ 
								
								if (Bidders_Info['Bidder_Details'][0]['priority_next'] != 0 ) {
									var apicall = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&priority='+Bidders_Info['Bidder_Details'][0]['priority']+'&priority_next='+Bidders_Info['Bidder_Details'][0]['priority_next']+'&rand=` + rand + `&trackingloc=` + config.GetConfig("commonpath", "file") + `&adtype=PrebidPriority&requestId=` + admaruoutput.Request_Id + `&Is_MultiAd=yes';
										fetch(apicall) 
									.then(response => {       
										return response.text(); 
									})
									.then(htmlContent => {
												
										var mainDIV` + randasd + ` = document.getElementById('` + tagid + `');
										var childDiv` + randasd + ` = document.createElement("div");       
										childDiv` + randasd + `.innerHTML = htmlContent;
										mainDIV` + randasd + `.appendChild(childDiv` + randasd + `);

										var mainscript` + randasd + ` = mainDIV` + randasd + `.getElementsByTagName("script");
										if(mainscript` + randasd + `){
										for (var scriptTags` + randasd + ` of mainscript` + randasd + `) {
										  var scriptContent` + randasd + ` = scriptTags` + randasd + `.textContent;
										  eval(scriptContent` + randasd + `);
										  if (scriptTags` + randasd + `.src) {
											var scriptElement` + randasd + ` = document.createElement("script");
											scriptElement` + randasd + `.src = scriptTags` + randasd + `.src;
											document.head.appendChild(scriptElement` + randasd + `);
										  }
										}
										}
									})
									.catch(error => {
									});
								}else{
											var	htmlContent = passsbacktest;
											htmlContent=htmlContent.replaceAll('\\"','"');
											htmlContent=htmlContent.replaceAll("<'+'","<");
											htmlContent=htmlContent.replaceAll('<\\','<');
											var mainDIV` + randasd + ` = document.getElementById('Prebid_` + rand + `');
											var childDiv` + randasd + ` = document.createElement("div");       
											childDiv` + randasd + `.innerHTML = htmlContent;
											mainDIV` + randasd + `.innerHTML = "";
											mainDIV` + randasd + `.appendChild(childDiv` + randasd + `);
											var mainscript` + randasd + ` = mainDIV` + randasd + `.getElementsByTagName("script");
											for (var scriptTags` + randasd + ` of mainscript` + randasd + `) {
												var scriptContent` + randasd + ` = scriptTags` + randasd + `.textContent;
												eval(scriptContent` + randasd + `);
												if (scriptTags` + randasd + `.src) {
													var scriptElement` + randasd + ` = document.createElement("script");
													scriptElement` + randasd + `.src = scriptTags` + randasd + `.src;
													document.head.appendChild(scriptElement` + randasd + `);
												}
											}	
											
										}
								` + PassbackVideoRefresh + `
										
											}else{
									if(Multi_Ad=="yes"){ 

										var highestCPM` + rand + `= highestCpmBids` + randasd + `!="" ? highestCpmBids` + randasd + `[0]['cpm'] : "";
										if(highestCpmBids` + randasd + `!=""){
											
										WonBid = Request_bids[highestCpmBids` + randasd + `[0]['requestId']] != "" ? Request_bids[highestCpmBids` + randasd + `[0]['requestId']] : "";
										
										if(WonBid.floorprice>highestCPM` + rand + `){
											highestCPM` + rand + `=0;
										}
										var DFP_Delivery` + rand + `="false";
										if(localStorage.getItem('DFP_Delivery_` + rand + `')!= null){
											DFP_Delivery` + rand + `="true";
										}
										var BidderResponse=[{"Adwon_URL" : WonBid['Adwon_URL'],
										"cpm" : highestCpmBids` + randasd + `[0]['cpm'],
										"AdViewImpression_URL" : WonBid['AdViewImpression_URL'],"AdClick_URL" : WonBid['AdClick_URL'],"ad" : highestCpmBids` + randasd + `[0].ad,"AdImpression_URL" : WonBid['AdImpression_URL']}];
										var apicall = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&MultiAdformatPriority='+Bidders_Info['Bidder_Details'][0]['priority']+'&highestBidCpm='+highestCPM` + rand + `+'&Is_MultiAd='+Multi_Ad+'&tagidRand=` + tagid + `&loc=` + admaruoutput.CORSDomain + `&rand=` + rand + `&requestId=` + admaruoutput.Request_Id + `&Is_Libload=no&DFP_Delivery='+DFP_Delivery` + rand + `;
																	
												fetch(apicall) 
												.then(response => {       
													return response.text(); 
									})
												.then(htmlContent => {
													
													if(htmlContent!="Prebidwon")
													{													
								var mainDIV` + randasd + ` = document.getElementById('` + tagid + `');
								var childDiv` + randasd + ` = document.createElement("div");       
								childDiv` + randasd + `.innerHTML = htmlContent;
								mainDIV` + randasd + `.appendChild(childDiv` + randasd + `);
								
								var mainscript` + randasd + ` = mainDIV` + randasd + `.getElementsByTagName("script");
													if(mainscript` + randasd + `){
								for (var scriptTags` + randasd + ` of mainscript` + randasd + `) {
								var scriptContent` + randasd + ` = scriptTags` + randasd + `.textContent;
								eval(scriptContent` + randasd + `);
								if (scriptTags` + randasd + `.src) {
								var scriptElement` + randasd + ` = document.createElement("script");
								scriptElement` + randasd + `.src = scriptTags` + randasd + `.src;
								document.head.appendChild(scriptElement` + randasd + `);
								}
								}
								}
												}else
												{
													var Nobids=pbjs.getNoBidsForAdUnitCode('` + tagid + `');				
													var AdViewImpression_URL=WonBid['AdViewImpression_URL'];
													pbjs.renderAd(document, highestCpmBids` + randasd + `[0].adId);
													` + Track_Win_Nobidvideo + `
											}
									
										})
										.catch(error => {
										});
											  }
										else{
											highestCPM` + rand + `=0;
											var DFP_Delivery` + rand + `="false";
											if(localStorage.getItem('DFP_Delivery_` + rand + `')!= null){
												DFP_Delivery` + rand + `="true";
											}
											var apicall = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+Bidders_Info['Bidder_Details'][0]['tagid']+'&MultiAdformatPriority='+Bidders_Info['Bidder_Details'][0]['priority']+'&highestBidCpm='+highestCPM` + rand + `+'&Is_MultiAd='+Multi_Ad+'&tagidRand=` + tagid + `&loc=` + admaruoutput.CORSDomain + `&rand=` + rand + `&requestId=` + admaruoutput.Request_Id + `&Is_Libload=no&DFP_Delivery='+DFP_Delivery` + rand + `;
													fetch(apicall) 
													.then(response => {       
														return response.text(); 
										})
													.then(htmlContent => {
															
																var mainDIV` + randasd + ` = document.getElementById('` + tagid + `');
																var childDiv` + randasd + ` = document.createElement("div");       
																childDiv` + randasd + `.innerHTML = htmlContent;
																mainDIV` + randasd + `.appendChild(childDiv` + randasd + `);
																
																var mainscript` + randasd + ` = mainDIV` + randasd + `.getElementsByTagName("script");
														if(mainscript` + randasd + `){
														for (var scriptTags` + randasd + ` of mainscript` + randasd + `) {
																var scriptContent` + randasd + ` = scriptTags` + randasd + `.textContent;
																eval(scriptContent` + randasd + `);
																if (scriptTags` + randasd + `.src) {
																var scriptElement` + randasd + ` = document.createElement("script");
																scriptElement` + randasd + `.src = scriptTags` + randasd + `.src;
																document.head.appendChild(scriptElement` + randasd + `);
																}
																}
																}
													
													})
													.catch(error => {
													});
												}
										}else{
																	  
											WonBid = Request_bids[highestCpmBids` + randasd + `[0]['requestId']] != "" ? Request_bids[highestCpmBids` + randasd + `[0]['requestId']] : "";
											
								var Nobids=pbjs.getNoBidsForAdUnitCode('` + tagid + `');				
								var AdViewImpression_URL=WonBid['AdViewImpression_URL'];

								pbjs.renderAd(document, highestCpmBids` + randasd + `[0].adId);
								` + Track_Win_Nobidvideo + `
							}
															}
						
				}
			</script>
			`

		}

	}
	admaruoutput.Videovastresponsetype = "html"
	if admaruoutput.Adunit_type == "VideoVast" && admaruoutput.Videovastadtype == "" {
		admaruoutput.Videovastresponsetype = "json"
		admaruoutput.External_ad = true

		VideoVast := VideoVast{}
		VideoVast.Template_Settings = template_settings
		VideoVast.Bidder_Details = helper.ConvertStrJsonToRawJson(Biddderjsonmapp)
		VideoVast.Request_Id = admaruoutput.Request_Id
		VideoVast.ThirdPartyTrackers = _3rd_img_firstQuartile + _3rd_js_firstQuartile + _3rd_iframe_firstQuartile + _3rd_img_midpoint + _3rd_js_midpoint + _3rd_iframe_midpoint + _3rd_img_thirdQuartile + _3rd_js_thirdQuartile + _3rd_iframe_thirdQuartile + _3rd_img_pause +
			_3rd_js_pause + _3rd_iframe_pause + _3rd_img_resume + _3rd_js_resume + _3rd_iframe_resume + _3rd_img_mute + _3rd_js_mute + _3rd_iframe_mute + _3rd_img_unmute + _3rd_js_unmute + _3rd_iframe_unmute + _3rd_img_skip + _3rd_js_skip + _3rd_iframe_skip + _3rd_img_impression +
			_3rd_js_impression + _3rd_iframe_impression + _3rd_img_viewableImpression + _3rd_js_viewableImpression + _3rd_iframe_viewableImpression + _3rd_img_click + _3rd_js_click + _3rd_iframe_click + _3rd_img_start + _3rd_js_start + _3rd_iframe_start + _3rd_img_complete +
			_3rd_js_complete + _3rd_iframe_complete + _3rd_img_close + _3rd_js_close + _3rd_iframe_close

		vastjson, err := json.Marshal(VideoVast)
		if err != nil {
			fmt.Println(err)
		}
		admaruoutput.Html = string(vastjson)
	}
}

func PrebidTracking(Biddermap map[string]interface{}, admaruoutput *structure.AdmaruOutput, v structure.AdSourceDetails, rand string) {

	Biddermap["Request_URL"] = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Ad_Request?req_id=" + v.Request_id + "&publisher_id=" + v.Publisher + "&adunit_id=" + admaruoutput.Adunit_details.Adunit_id + "&provider_id=" + v.Provider + "&adsource_id=" + v.Adsourceid + "&tagid=" + admaruoutput.Tag_id + "&tagtempid=" + admaruoutput.Tag_Generation.Template_id + "&pro_src_id=" + v.Provider_Src_id + "&req_count=1&loc=" + admaruoutput.CORSDomain

	Biddermap["Response_URL"] = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Ad_Response?req_id=" + v.Request_id + "&publisher_id=" + v.Publisher + "&adunit_id=" + admaruoutput.Adunit_details.Adunit_id + "&provider_id=" + v.Provider + "&adsource_id=" + v.Adsourceid + "&tagid=" + admaruoutput.Tag_id + "&tagtempid=" + admaruoutput.Tag_Generation.Template_id + "&pro_src_id=" + v.Provider_Src_id + "&loc=" + admaruoutput.CORSDomain

	Biddermap["Adwon_URL"] = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Ad_Win?req_id=" + v.Request_id + "&publisher_id=" + v.Publisher + "&adunit_id=" + admaruoutput.Adunit_details.Adunit_id + "&provider_id=" + v.Provider + "&adsource_id=" + v.Adsourceid + "&tagid=" + admaruoutput.Tag_id + "&tagtempid=" + admaruoutput.Tag_Generation.Template_id + "&pro_src_id=" + v.Provider_Src_id + "&won_count=1&loc=" + admaruoutput.CORSDomain

	Biddermap["AdImpression_URL"] = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Impression?req_id=" + v.Request_id + "&publisher_id=" + v.Publisher + "&adunit_id=" + admaruoutput.Adunit_details.Adunit_id + "&provider_id=" + v.Provider + "&adsource_id=" + v.Adsourceid + "&tagid=" + admaruoutput.Tag_id + "&tagtempid=" + admaruoutput.Tag_Generation.Template_id + "&pro_src_id=" + v.Provider_Src_id + "&loc=" + admaruoutput.CORSDomain + "&res_cur=" + admaruoutput.Bidding_currency + "&owned_by=" + v.Owned_by

	Biddermap["AdTrack"] = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Event_Track?req_id=" + v.Request_id + "&adsource_id=" + v.Adsourceid + "&adunitid=" + admaruoutput.Adunit_details.Adunit_id + "&provider_id=" + v.Provider + "&publisher_id=" + v.Publisher + "&tagid=" + admaruoutput.Tag_id + "&tagtempid=" + admaruoutput.Tag_Generation.Template_id + "&pro_src_id=" + v.Provider_Src_id

	Biddermap["AdClick_URL"] = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Click?requestid=" + v.Request_id + "&adsourceid=" + v.Adsourceid + "&adunitid=" + admaruoutput.Adunit_details.Adunit_id + "&Providerid=" + v.Provider + "&Publisherid=" + v.Publisher + "&tagid=" + admaruoutput.Tag_id + "&tagtempid=" + admaruoutput.Tag_Generation.Template_id + "&pro_src_id=" + v.Provider_Src_id + "&loc=" + admaruoutput.CORSDomain

	Biddermap["AdViewImpression_URL"] = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Viewable_Imp?req_id=" + v.Request_id + "&publisher_id=" + v.Publisher + "&adunit_id=" + admaruoutput.Adunit_details.Adunit_id + "&provider_id=" + v.Provider + "&adsource_id=" + v.Adsourceid + "&tag_id=" + admaruoutput.Tag_id + "&tagtemp_id=" + admaruoutput.Tag_Generation.Template_id + "&pro_src_id=" + v.Provider_Src_id + "&loc=" + admaruoutput.CORSDomain

	Biddermap["AdViewableEvent_URL"] = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Event_Track?req_id=" + v.Request_id + "&adsource_id=" + v.Adsourceid + "&adunitid=" + admaruoutput.Adunit_details.Adunit_id + "&provider_id=" + v.Provider + "&publisher_id=" + v.Publisher + "&tagid=" + admaruoutput.Tag_id + "&tagtempid=" + admaruoutput.Tag_Generation.Template_id + "&pro_src_id=" + v.Provider_Src_id + "&event=5sView"

	admaruoutput.Viewable_Imp = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Viewable_Imp?req_id=" + v.Request_id + "&publisher_id=" + v.Publisher + "&adunit_id=" + admaruoutput.Adunit_details.Adunit_id + "&provider_id=" + v.Provider + "&adsource_id=" + v.Adsourceid + "&tag_id=" + admaruoutput.Tag_id + "&tagtemp_id=" + admaruoutput.Tag_Generation.Template_id + "&pro_src_id=" + v.Provider_Src_id + "&loc=" + admaruoutput.CORSDomain

	Biddermap["Request_Id"] = v.Request_id
	Biddermap["AdunitId"] = admaruoutput.Adunit_details.Adunit_id

	Biddermap["AdunitName"] = admaruoutput.Adunit_details.Name

	Biddermap["tagid"] = admaruoutput.Tag_id

	Biddermap["priority"] = admaruoutput.Priority_Level
	Biddermap["priority_next"] = admaruoutput.Priority_Next

	if admaruoutput.Adunit_details.Adunit_type == "2" {

		if len(admaruoutput.MultiAdFinalRTB.Ads.Response.Seatbid) != 0 && len(admaruoutput.MultiAdFinalRTB.Ads.Response.Seatbid[0].Bid) != 0 {
			DirectCPM, err := strconv.ParseFloat(admaruoutput.MultiAdFinalDir.Bidprice, 64)
			if err != nil {
				fmt.Println("Error:", err)

			}
			if DirectCPM < admaruoutput.MultiAdFinalRTB.Ads.Response.Seatbid[0].Bid[0].Price {

				Biddermap["Bidding_cpm"] = admaruoutput.MultiAdFinalRTB.Ads.Response.Seatbid[0].Bid[0].Price
				Biddermap["Bidding_Adtype"] = "RTB"
				Biddermap["Bidding_adsourceID"] = admaruoutput.MultiAdFinalRTB.Ads.Response.Tracking.Adsource_Id
			} else {

				Biddermap["Bidding_cpm"] = admaruoutput.MultiAdFinalDir.Bidprice
				Biddermap["Bidding_Adtype"] = "Direct"
				Biddermap["Bidding_adsourceID"] = admaruoutput.MultiAdFinalDir.Adsourceid
			}

		} else {

			Biddermap["Bidding_cpm"] = admaruoutput.MultiAdFinalDir.Bidprice
			Biddermap["Bidding_Adtype"] = "Direct"
			Biddermap["Bidding_adsourceID"] = admaruoutput.MultiAdFinalDir.Adsourceid
		}

		Biddermap["Bidding_tagID"] = admaruoutput.Tag_Generation.Tag_id
		Biddermap["Bidding_adunitID"] = admaruoutput.Adunit_details.Adunit_id
		Biddermap["Bidding_requestID"] = admaruoutput.Request_Id
		Biddermap["Bidding_providerSrcID"] = admaruoutput.MultiAdFinalDir.Provider_Src_id
	}

	floor_price := v.Bidprice
	floor_price_float := helper.StringToFloat(floor_price)
	req_cur := multiCurrency.Convert_currency(floor_price_float, admaruoutput.Bidding_currency, admaruoutput.Account_currency)
	Biddermap["floorprice"] = req_cur

	Biddermap["BiddingCurrency"] = admaruoutput.Bidding_currency

}

func RequestStats(Adsource structure.AdSourceDetails, admaruoutput *structure.AdmaruOutput) {

	requeststats, err := http.NewRequest("GET", config.GetConfig("protocol", "webpath")+config.GetConfig("delivery", "webpath")+"/Ad_Request?req_id="+Adsource.Request_id+"&publisher_id="+admaruoutput.Adunit_details.Publisher+"&adunit_id="+admaruoutput.Adunit_details.Adunit_id+"&provider_id="+Adsource.Provider+"&adsource_id="+Adsource.Adsourceid+"&tagid="+admaruoutput.Tag_Generation.Tag_id+"&tagtempid="+admaruoutput.Tag_Generation.Template_id+"&pro_src_id="+Adsource.Provider_Src_id+"&req_count=1", nil)
	if err != nil {
		fmt.Println(err)
	}

	clientstates := &http.Client{Timeout: time.Duration(0) * time.Millisecond}
	respstats, err := clientstates.Do(requeststats)
	if err != nil {
		fmt.Println(err)
	}
	defer respstats.Body.Close()

}

func RequestStats_N(Adsource structure.AdSourceDetails, admaruoutput *structure.AdmaruOutput) {
	clickClient.Track_request(admaruoutput.Adunit_details.Publisher, admaruoutput.Adunit_details.Adunit_id, Adsource.Provider, Adsource.Adsourceid, Adsource.Request_id, admaruoutput.Tag_Generation.Tag_id, admaruoutput.Tag_Generation.Template_id, Adsource.Provider_Src_id, 1)
}

func ResponseStats(Adsource structure.AdSourceDetails, admaruoutput *structure.AdmaruOutput) {
	res_count := "1"
	adresponse1, _ := http.NewRequest("GET", config.GetConfig("protocol", "webpath")+config.GetConfig("delivery", "webpath")+"/Ad_Response?req_id="+Adsource.Request_id+"&publisher_id="+admaruoutput.Adunit_details.Publisher+"&adunit_id="+admaruoutput.Adunit_details.Adunit_id+"&provider_id="+Adsource.Provider+"&adsource_id="+Adsource.Adsourceid+"&tagid="+admaruoutput.Tag_Generation.Tag_id+"&tagtempid="+admaruoutput.Tag_Generation.Template_id+"&pro_src_id="+Adsource.Provider_Src_id+"&res_count="+res_count+"", nil)
	clientres1 := &http.Client{Timeout: time.Duration(0) * time.Millisecond}
	clientres1.Do(adresponse1)
}

func ResponseStats_N(Adsource structure.AdSourceDetails, admaruoutput *structure.AdmaruOutput) {

	clickClient.Track_response(admaruoutput.Adunit_details.Publisher, admaruoutput.Adunit_details.Adunit_id, Adsource.Provider, Adsource.Adsourceid, Adsource.Request_id, admaruoutput.Tag_Generation.Tag_id, admaruoutput.Tag_Generation.Template_id, Adsource.Provider_Src_id, 1)
}

func Passback(admaruoutput *structure.AdmaruOutput, rand string) string {
	var passbackStart string
	var passbackEnd string
	var Adtype string
	var adTag string
	var finalpassback string
	passbackStart = `<div id='test-ad` + rand + `'>`
	passbackEnd = `</div>`

	switch {
	case admaruoutput.Temp_Generation.Template_type == "1":
		template_settings11 := structure.Tagsettings{}
		err := json.Unmarshal([]byte(admaruoutput.Temp_Generation.Settings), &template_settings11)
		if err != nil {
			fmt.Println(err)
		}
		Adtype = template_settings11.Passback.LinkOrTag
		if Adtype == "tag" {

			TagParty := template_settings11.Passback.URL
			Thirdpartytag := strings.Replace(TagParty, `<!--//<![CDATA[`, ``, -1)
			ThirdpartytagF := strings.Replace(Thirdpartytag, `//]]>-->`, ``, -1)
			adTag = `<div>` + ThirdpartytagF + `</div>`
		} else if Adtype == "link" {
			clickurl := template_settings11.Passback.DestinationUrl
			ImgTag := template_settings11.Passback.URL
			clickTag_start := `<a href='` + clickurl + `' target='_blank'>`
			clickTag_end := `</a>`
			adTag = clickTag_start + `<img src='` + ImgTag + `' width='` + helper.IntToString(admaruoutput.Banner_Template.Width) + `' height='` + helper.IntToString(admaruoutput.Banner_Template.Height) + `' alt='' title='' border='0' />` + clickTag_end
		}

	case admaruoutput.Temp_Generation.Template_type == "2" || admaruoutput.Temp_Generation.Template_type == "3":
		template_settings11 := structure.Outstream_Template{}
		err := json.Unmarshal([]byte(admaruoutput.Temp_Generation.Settings), &template_settings11)
		if err != nil {
			fmt.Println(err)
		}

		admaruoutput.Viewable_Tagid = "test-ad" + rand
		Adtype = template_settings11.TempPassback.LinkOrTag
		if Adtype == "tag" {

			TagParty := template_settings11.TempPassback.URL
			Thirdpartytag := strings.Replace(TagParty, `<!--//<![CDATA[`, ``, -1)
			ThirdpartytagF := strings.Replace(Thirdpartytag, `//]]>-->`, ``, -1)
			adTag = `<div>` + ThirdpartytagF + `</div>`
		} else if Adtype == "link" {
			clickurl := template_settings11.TempPassback.DestinationUrl
			ImgTag := template_settings11.TempPassback.URL
			clickTag_start := `<a href='` + clickurl + `' target='_blank'>`
			clickTag_end := `</a>`
			adTag = clickTag_start + `<img src='` + ImgTag + `' width='300' height='250' alt='' title='' border='0' />` + clickTag_end
		} else if Adtype == "img" {

			TagParty := template_settings11.TempPassback.URL

			Thirdpartytag := strings.Replace(TagParty, "\n", "", -1)
			Thirdpartytag = strings.Replace(Thirdpartytag, "  ", " ", -1)
			adTag = `<img src='` + Thirdpartytag + `' width='300' height='250' alt='' style='width: 0px; height: 0px;' />`
		} else if Adtype == "iframe" {

			TagParty := template_settings11.TempPassback.URL
			Thirdpartytag := strings.Replace(TagParty, "\n", "", -1)
			Thirdpartytag = strings.Replace(Thirdpartytag, `\`, ``, -1)
			Thirdpartytag = strings.Replace(Thirdpartytag, "  ", " ", -1)
			adTag = `<div>` + Thirdpartytag + `</div>`
		} else if Adtype == "js" {
			TagParty := template_settings11.TempPassback.URL
			Thirdpartytag := strings.Replace(TagParty, `<!--//<![CDATA[`, ``, -1)
			ThirdpartytagF := strings.Replace(Thirdpartytag, `//]]>-->`, ``, -1)
			ThirdpartytagF = strings.Replace(ThirdpartytagF, `</script>`, `<\/script>`, -1)
			ThirdpartytagF = strings.Replace(ThirdpartytagF, "  ", " ", -1)
			ThirdpartytagF = strings.Replace(ThirdpartytagF, `</scr"+"ipt>`, `<\/script>`, -1)
			ThirdpartytagF = strings.Replace(ThirdpartytagF, "\n", "", -1)
			ThirdpartytagF = strings.Replace(ThirdpartytagF, `\`, ``, -1)
			ThirdpartytagF = strings.Replace(ThirdpartytagF, "  ", " ", -1)
			//newly added
			ThirdpartytagF = strings.Replace(ThirdpartytagF, "<", "<'+'", -1)
			ThirdpartytagF = strings.Replace(ThirdpartytagF, "\\", "\\\\", -1)
			ThirdpartytagF = strings.Replace(ThirdpartytagF, "\r", "", -1)
			ThirdpartytagF = strings.Replace(ThirdpartytagF, "'", "\\'", -1)
			ThirdpartytagF = strings.Replace(ThirdpartytagF, `"`, `\"`, -1)
			ThirdpartytagF = strings.Replace(ThirdpartytagF, `""`, `''`, -1)

			adTag = `<div>` + ThirdpartytagF + `</div>`
		}
	}

	if adTag != "" {
		finalpassback = passbackStart + adTag + passbackEnd
	} else {
		finalpassback = passbackStart + passbackEnd
	}
	finalpassback = url.PathEscape(finalpassback)

	return finalpassback
}
