package addelivery

import (
	"alpha/addelivery/ad"
	"alpha/addelivery/adunit"
	"alpha/addelivery/delivery"
	"alpha/addelivery/fetching"
	"alpha/addelivery/globalvariaables"
	"alpha/addelivery/helper"
	"alpha/addelivery/multiCurrency"
	"alpha/addelivery/structure"
	"alpha/addelivery/validation"
	"io/ioutil"
	"log"
	"regexp"
	"sync"
	"time"

	config "alpha/configuration"
	"encoding/base64"
	"encoding/json"
	"math"
	"strings"

	"fmt"
	"net/http"
	"net/url"
	"strconv"

	"github.com/gofrs/uuid"
)

var rand = helper.IntToString(helper.RandNumber(5))

func AdAsyncTag(w http.ResponseWriter, r *http.Request) string {
	rand = helper.IntToString(helper.RandNumber(5))
	admaruOutput := structure.AdmaruOutput{}
	admaruOutput.R = r
	admaruOutput.Is_vastretry = helper.GetUrlParam(r, "Is_vastretry")
	admaruOutput.Adunit_type = "async"
	var CORSDomain string
	u, err := url.Parse(helper.GetUrlParam(r, "loc"))
	if err == nil {
		CORSDomain = u.Scheme + "://" + u.Host
	}
	admaruOutput.Tag_id = helper.GetUrlParam(r, "tagid")
	admaruOutput.ScreenRes = helper.GetUrlParam(r, "scrSize")
	admaruOutput.Autorefresh = helper.GetUrlParam(r, "auto")
	admaruOutput.Viewable_Tagid = helper.GetUrlParam(r, "tagidRand")
	admaruOutput.Is_Libload = helper.GetUrlParam(r, "Is_Libload")
	admaruOutput.DFP_Delivery = helper.GetUrlParam(r, "DFP_Delivery")
	admaruOutput.Passbackcall = helper.GetUrlParam(r, "passbackcall")
	m, _ := url.Parse(helper.GetUrlParam(r, "trackingloc"))
	if admaruOutput.Autorefresh == "yes" || helper.GetUrlParam(r, "trackingloc") != "" {
		admaruOutput.CORSDomain = m.Scheme + "://" + m.Host
	} else {

		admaruOutput.CORSDomain = CORSDomain
	}
	admaruOutput.Autorefreshrand = helper.GetUrlParam(r, "rand")
	/************priority api***************/
	adtype := helper.GetUrlParam(r, "adtype")
	if adtype == "PrebidPriority" {
		admaruOutput.Adunit_type = "PrebidPriority"
	} else {
		admaruOutput.Adunit_type = "async"
	}
	admaruOutput.Priority_Call = helper.StringToInt(helper.GetUrlParam(r, "priority_next"))
	/************priority api***************/
	var finalHTML string
	var AutoRefresh string

	/******************/
	bidadsourceid := helper.GetUrlParam(r, "Bid_AdSource")
	bidadunitid := helper.GetUrlParam(r, "Bid_adunitid")
	bidrequestid := helper.GetUrlParam(r, "Bid_Req")
	bidproviderid := helper.GetUrlParam(r, "Bid_providerid")
	admaruOutput.MultiadPrebidCal = helper.GetUrlParam(r, "Is_MultiAd")

	if bidadsourceid != "" {
		admaruOutput.VastRetry_Enable = helper.GetUrlParam(r, "vast_retry")
		admaruOutput.Tag_id = helper.GetUrlParam(r, "Bid_Tag")
		admaruOutput.Bidding_currency = helper.GetUrlParam(r, "res_cur")
		admaruOutput.Request_Id = bidrequestid
		admaruOutput.Bidding_price = helper.GetUrlParam(r, "Bid_CPM")
		GetDirectVideo(bidadsourceid, bidadunitid, bidproviderid, &admaruOutput, r, w)

		if admaruOutput.Html != "" {

			finalHTML = admaruOutput.Html
		} else {
			var Adtype string
			var videoUrl string
			var src_url string
			template_settings1 := structure.Outstream_Template{}
			err := json.Unmarshal([]byte(admaruOutput.Temp_Generation.Settings), &template_settings1)
			if err != nil {
				fmt.Println(err)
			}
			Adtype = template_settings1.TempPassback.LinkOrTag
			src_url = config.GetConfig("source", "video")
			if Adtype == "tag" {
				videoUrl = template_settings1.TempPassback.URL
				finalHTML = VideoPlayer(&admaruOutput, videoUrl, src_url)
			} else if Adtype == "link" {
				video := template_settings1.TempPassback.URL
				clickurl := template_settings1.TempPassback.DestinationUrl
				videoSrc := base64.StdEncoding.EncodeToString([]byte(video))
				videoUrl = config.GetConfig("commonpath", "file") + `VastGen?video=` + videoSrc + `&passback=passback` + `&passback_url=` + clickurl
				finalHTML = VideoPlayer(&admaruOutput, videoUrl, src_url)
			}
		}
		return finalHTML

	} else {
		/******************/

		admaruOutput.Prebid_Resonse = helper.GetUrlParam(r, "bid_res")

		admaruOutput.MultiadPrebidCPM = helper.GetUrlParam(r, "highestBidCpm")

		admaruOutput.Globalvariable = globalvariaables.SetAllGrobalVariables(r)
		adunit.GetTagDetails(&admaruOutput)
		admaruOutput.Temp_Generation = fetching.FetchTemplates(admaruOutput.Tag_Generation.Template_id)
		publisherShareDetails := fetching.FetchingPublisher_share(admaruOutput.Temp_Generation.Publisher_id)
		publisher_bid_cur := fetching.FetchPub_settings(admaruOutput.Temp_Generation.Publisher_id)
		admaruOutput.Bidding_currency = publisher_bid_cur.Bidding_currency
		admaruOutput.Account_currency = publisher_bid_cur.Account_currency

		if publisherShareDetails.Revenue_share != "" && publisherShareDetails.Revenue_share != "0" && validation.TagValidation(admaruOutput.Tag_Generation.Tag_Type, admaruOutput.Tag_Generation.Template_id, admaruOutput.Tag_Generation.Status, admaruOutput.Tag_Generation.Is_Deleted) && validation.TemplateValidation(admaruOutput.Temp_Generation.Settings, admaruOutput.Temp_Generation.Status, admaruOutput.Temp_Generation.Is_Deleted) {
			switch {
			case admaruOutput.Temp_Generation.Template_type == "1": //banner ad delivery
				/********template bannser size***********/

				if admaruOutput.Temp_Generation.Settings != "" {

					err1 := json.Unmarshal([]byte(admaruOutput.Temp_Generation.Settings), &admaruOutput.Banner_Template)
					if err1 != nil {
						fmt.Println(err1)
					}

					//banner size
					Height, Width := fetching.FetchBannerSize(admaruOutput.Banner_Template.Size)
					admaruOutput.Banner_Template.Height = Height
					admaruOutput.Banner_Template.Width = Width
				}
				/********template bannser size***********/
				admaruOutput.Adunit_details = adunit.GetAdunitDetails(admaruOutput.Tag_Generation.Banner_Adunit_id)
				admaruOutput.PublisherDetails = fetching.GetPublisherDetails(admaruOutput.Adunit_details.Publisher)
				if validation.AdunitValidation(admaruOutput.Adunit_details.Adunit_type, admaruOutput.Adunit_details.Envtype, admaruOutput.Adunit_details.Width, admaruOutput.Adunit_details.Height, admaruOutput.Adunit_details.Status, admaruOutput.Adunit_details.Is_Deleted, admaruOutput.Globalvariable.Environment) && validation.PublisherValidation(admaruOutput.PublisherDetails.Publisher_Seller.Domain, admaruOutput.PublisherDetails.Publisher_Seller.Publisher_seller_id, admaruOutput.PublisherDetails.Status, admaruOutput.PublisherDetails.Is_Deleted) {
					if admaruOutput.MultiadPrebidCal != "yes" {
						u1 := uuid.Must(uuid.NewV4())
						admaruOutput.Request_Id = u1.String()
						// adunit.TrackAdReq(&admaruOutput)
						go adunit.TrackAdReq_N(&admaruOutput)
					} else {
						admaruOutput.Request_Id = helper.GetUrlParam(r, "requestId")
					}
					adunit.GetAdsourceDetails(&admaruOutput, admaruOutput.Tag_Generation.Banner_Adunit_id, w, r)

					/**********Auto Refresh Start**********/

					Template_id := admaruOutput.Tag_id
					Templates := admaruOutput.Temp_Generation
					if admaruOutput.DeliveryAdType != "Prebid" {
						AutoRefresh = `<script type='text/javascript'>var i` + rand + ` = 0;</script>`
					}

					if Templates.Settings != "" {

						err1 := json.Unmarshal([]byte(Templates.Settings), &admaruOutput.Banner_Template)
						if err1 != nil {
							fmt.Println(err1)
						}

						Enabled := admaruOutput.Banner_Template.Refresh.Enabled
						MaxImp := admaruOutput.Banner_Template.Refresh.MaxImp
						Rate := admaruOutput.Banner_Template.Refresh.Rate

						RateVal := helper.StringToInt(Rate)
						checkMax := helper.StringToInt(MaxImp)

						var FinalAdType string
						// if admaruOutput.Autorefresh == "yes" {
						FinalAdType = admaruOutput.FinalAdsourceType
						// }

						if Enabled == true && RateVal != 0 && checkMax != 0 {

							finalVal := RateVal * 1000
							Refresh_Interval := helper.IntToString(finalVal)
							if admaruOutput.Autorefreshrand != "" {
								rand = admaruOutput.Autorefreshrand
							}

							AutoRefresh = `<script type='text/javascript'>
							if(localStorage.getItem('TEMPTAG_` + Template_id + rand + `')== null){
								localStorage.setItem('TEMPTAG_` + Template_id + rand + `','` + rand + "_" + MaxImp + `');
							}
							var Imp_details` + rand + `=localStorage.getItem('TEMPTAG_` + Template_id + rand + `');
							var Imp_array` + rand + `=Imp_details` + rand + `.split("_");
							var Remainig_Imp` + rand + `=Imp_array` + rand + `[1]; 
							var Randnum` + rand + `=Imp_array` + rand + `[0];
							var Interval` + rand + `=setInterval(function() { autoRefresh` + rand + `('` + Template_id + `','` + rand + `'); },` + Refresh_Interval + `);
							var AdType='` + admaruOutput.DeliveryAdType + `'; 
							function autoRefresh` + rand + `(tag_id,rand) {
								var Tracker_Div=document.getElementById('track_'+rand);								
								if(Tracker_Div!="" && Tracker_Div!=null){
									Tracker_Div.innrHTML="";
								}
								Imp_details` + rand + `=localStorage.getItem('TEMPTAG_'+tag_id+rand);
									Imp_array` + rand + `=Imp_details` + rand + `.split("_");
								Remainig_Imp` + rand + `=Imp_array` + rand + `[1];  
								Randnum=Imp_array` + rand + `[0];
								if (Remainig_Imp` + rand + ` !== null){
									if (Remainig_Imp` + rand + ` > 0)
									{	
										Remainig_Imp` + rand + `--;
										localStorage.setItem('TEMPTAG_'+tag_id+rand,rand+"_"+Remainig_Imp` + rand + `);
										AutoRef_Req(rand,tag_id);
									}else{
										Remainig_Imp` + rand + `--;
										localStorage.removeItem('TEMPTAG_'+tag_id+rand);
										localStorage.removeItem('autoenabled');
										clearInterval(Interval` + rand + `);
										setTimeout(Interval` + rand + `);
									}
								}else{
									AutoRef_Req(rand,tag_id);
									localStorage.setItem('TEMPTAG_'+tag_id+rand,rand+"_"+Remainig_Imp` + rand + `);
								}
							}
							function AutoRef_Req(Randno,tagid){ 
								
							
								var ViewDiv =document.getElementById('viewImp_'+Randno);
								if(ViewDiv!="" && ViewDiv!=null){
									ViewDiv.outerHTML="";
								}
								var Test_Div=document.getElementById('test-ad'+Randno);
								if(Test_Div!="" && Test_Div!=null){
									Test_Div.innerHTML="";
								}					
								localStorage.setItem('autoenabled',"yes");
								var m3_u1 = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+tagid+'&loc=` + admaruOutput.CORSDomain + `&auto=yes&trackingloc=` + config.GetConfig("commonpath", "file") + `&rand='+Randno;
								iDiv = document.createElement('div');
								iDiv.setAttribute("id", "viewImp_"+Randno);
								Test_Div.appendChild(iDiv);


								fetch(m3_u1) 
						.then(response => {       
							return response.text(); 
						})
						.then(htmlContent => {

							
							
							var FinalAdType="` + FinalAdType + `";
						
						
								FinalAdType="";
								
								var Response="<html>"+htmlContent+"</html>";
								var mainDIV` + rand + ` = document.getElementById('viewImp_'+Randno);
								var iframe` + rand + ` = document.createElement("iframe");
								iframe` + rand + `.srcdoc=Response;
								iframe` + rand + `.id="Autoref_` + rand + `";
								iframe` + rand + `.frameBorder="0";
								iframe` + rand + `.scrolling="no";
								iframe` + rand + `.marginHeight="0";
								iframe` + rand + `.marginWidth="0";
								iframe` + rand + `.topMorgin="0";
								iframe` + rand + `.leftMargin="0";
								iframe` + rand + `.allowTransparency="true";
								iframe` + rand + `.width="` + helper.IntToString(admaruOutput.Banner_Template.Width) + `";
								iframe` + rand + `.height="` + helper.IntToString(admaruOutput.Banner_Template.Height) + `";

								mainDIV` + rand + `.appendChild(iframe` + rand + `);
						
								
						})
						.catch(error => {
							console.error('Fetch error:', error);
						});
					
															
							}
							</script>`
						}
					}
					/**********Auto Refresh End**********/

					/******************Passback Start*********************/

					/******************Passback adasync End*********************/
				}
				if admaruOutput.Html != "" && admaruOutput.External_ad == true || admaruOutput.Internal_ad == true {

					finalHTML = admaruOutput.Html
				} else {
					finalHTML = Passback(&admaruOutput, rand)
				}

			case (admaruOutput.Temp_Generation.Template_type == "3" || admaruOutput.Temp_Generation.Template_type == "2"): //video ad delivery

				admaruOutput.Adunit_details = adunit.GetAdunitDetails(admaruOutput.Tag_Generation.Video_Adunit_id)
				admaruOutput.PublisherDetails = fetching.GetPublisherDetails(admaruOutput.Adunit_details.Publisher)
				if (admaruOutput.Adunit_details.Status == "1" && admaruOutput.Adunit_details.Is_Deleted == "" && admaruOutput.Adunit_details.Envtype == admaruOutput.Globalvariable.Environment) && (admaruOutput.PublisherDetails.Status == "1" && admaruOutput.PublisherDetails.Is_Deleted == "") {
					if admaruOutput.MultiadPrebidCal != "yes" {
						u1 := uuid.Must(uuid.NewV4())
						admaruOutput.Request_Id = u1.String()

						go adunit.TrackAdReq_N(&admaruOutput)
					} else {
						admaruOutput.Request_Id = helper.GetUrlParam(r, "requestId")
					}
					adunit.GetAdsourceDetails(&admaruOutput, admaruOutput.Tag_Generation.Video_Adunit_id, w, r)

				}
				if admaruOutput.Html != "" {

					finalHTML = admaruOutput.Html
				} else {
					if admaruOutput.Autorefreshrand != "" {
						rand = admaruOutput.Autorefreshrand
					}
					finalHTML = Passback(&admaruOutput, rand)
				}

			}

			if admaruOutput.MultiadPrebidCal != "" || admaruOutput.Autorefresh == "yes" {
				if admaruOutput.Temp_Generation.Template_type == "1" {

					return finalHTML
				} else {

					return finalHTML
				}
			} else {
				if admaruOutput.Temp_Generation.Template_type == "1" && finalHTML != "" {
					if admaruOutput.Html == "" && finalHTML != "" {
						finalHTML = finalHTML + AutoRefresh
					} else {
						finalHTML = finalHTML + AutoRefresh

					}
				}

				return fetching.ConvertJs(finalHTML)
			}
		}

	}
	return strconv.ErrSyntax.Error()
}

func VideoPlayer(admaruout *structure.AdmaruOutput, videoUrl string, src_url string) string {

	type InlineContent struct {
		Video_Url        string `json:"video_url"`
		ClickThrough_Url string `json:"ClickThrough_url"`
	}

	rand = helper.IntToString(helper.RandNumber(5))

	TagType := admaruout.Tag_Generation.Tag_Type

	Inline_Content := admaruout.Temp_Generation.Inline_Content

	var Inlineontent []InlineContent

	err2 := json.Unmarshal([]byte(Inline_Content), &Inlineontent)
	if err2 != nil {
		fmt.Println(err2)
	}
	var InlineontentVideo_Url string

	InlineontentVideo_Url = config.GetConfig("source", "video")
	if len(Inlineontent) > 0 {

		InlineontentVideo_Url = Inlineontent[0].Video_Url

	}
	var videoSource string
	if TagType == "2" {

		videoSource = InlineontentVideo_Url

	} else {

		videoSource = config.GetConfig("source", "video")
	}

	Instream_settings := structure.Instream_Template{}

	err1 := json.Unmarshal([]byte(admaruout.Temp_Generation.Settings), &Instream_settings)
	if err1 != nil {
		fmt.Println(err1)
	}

	/**********In Stream End**********/

	template_settings := structure.Outstream_Template{}

	err := json.Unmarshal([]byte(admaruout.Temp_Generation.Settings), &template_settings)
	if err != nil {
		fmt.Println(err)
	}

	if template_settings.MaxWidth == 0 {
		template_settings.MaxWidth = 300
	}
	if template_settings.MinWidth == 0 {
		template_settings.MinWidth = 300
	}

	admaruout.Video_Temp.Height = template_settings.MinWidth
	admaruout.Video_Temp.Width = template_settings.MaxWidth
	// Newplayer changes start
	var closeEnable string
	var localEnable string
	var playOnview string
	var thresholdVal string
	var sideStreamEnable string
	var skipEnable string
	var floatLocation string
	var returntopage string
	var replayEnable string

	var iniframeEnable string

	if template_settings.InIframe != false {
		iniframeEnable = "true"
	} else {
		iniframeEnable = "false"
	}

	if template_settings.PlayerInterface.ReplayButton != false {
		replayEnable = "true"
	} else {
		replayEnable = "false"
	}

	if template_settings.PlayerInterface.CloseButton != false {
		closeEnable = "true"
	} else {
		closeEnable = "false"
	}
	if template_settings.LogoVideo.LogoVideo != false {
		localEnable = "true"
	} else {
		localEnable = "false"
	}
	if template_settings.PlayerMode.PlayOnview == true {
		playOnview = "autoplay"
		if template_settings.PlayerMode.InView != 0 {
			thresholdVal = helper.IntToString(template_settings.PlayerMode.InView)
		} else {
			thresholdVal = helper.IntToString(template_settings.PlayerMode.PlayModeView)
		}

	} else if template_settings.AutoPlay == true {

		playOnview = "autoplay_muted"
		thresholdVal = "0"
	} else {
		playOnview = "mouseover"
		thresholdVal = "0"
	}

	if template_settings.Skip.Skip == true {
		skipEnable = "true"
	} else {
		skipEnable = "false"
	}
	if template_settings.PlayerMode.PlayerMode == "2" {
		returntopage = "true"
	} else {
		returntopage = "false"
	}

	if template_settings.PlayerMode.PlayerMode == "2" || template_settings.PlayerMode.PlayerMode == "3" {
		sideStreamEnable = "true"
		if (template_settings.PlayerMode.FloatType == "impression" || template_settings.PlayerMode.FloatType == "bottom" || template_settings.PlayerMode.PlayerMode == "3") && template_settings.AutoPlay == true {

			playOnview = "autoplay_muted"
		} else if (template_settings.PlayerMode.FloatType == "impression" || template_settings.PlayerMode.FloatType == "bottom" || template_settings.PlayerMode.PlayerMode == "3") && template_settings.AutoPlay == false {
			playOnview = "mouseover"
		}

	} else {
		sideStreamEnable = "false"
	}
	if template_settings.PlayerMode.Location != "" {
		floatLocation = "bottom-" + template_settings.PlayerMode.Location

	} else {
		floatLocation = "bottom-left"
	}

	if template_settings.PlayerMode.SideViewWidth == "" {
		template_settings.PlayerMode.SideViewWidth = "200"
	}

	if template_settings.PlayerMode.SideViewHeight == "" {
		template_settings.PlayerMode.SideViewHeight = "140"
	}

	Html := `
	<div class="rm_videowrapper_` + rand + `" id="rm_videowrapper_` + rand + `">
	</div>
	<link rel="stylesheet" href="` + config.GetConfig("path", "player") + `/admaru-player.css">
	<script src="` + config.GetConfig("path", "player") + `/admaru-player.js"></script>
	<script src="https://code.jquery.com/jquery-1.12.1.min.js"></script>
	<script type="text/javascript">
	  let adsParams` + rand + ` = {
		  playerId: "rm_videowrapper_` + rand + `",
		  sources: [
		  {
			  src: "` + videoSource + `",
			  type: "video/mp4"
		  }
		  ],
		  logo: {
			image: '` + template_settings.LogoVideo.LogoLink + `',
			url: '` + template_settings.LogoVideo.LogoClickthrough + `', 
			position: 'top-left',
			enabled: ` + localEnable + `,
			width: '` + helper.IntToString(template_settings.LogoVideo.LogoWidth) + `',
			height: '` + helper.IntToString(template_settings.LogoVideo.LogoHeight) + `',
			offsetH: 0,
			offsetV: 0,
			opacity: 1
		  },
		  threshold: ` + thresholdVal + `,
		  context: 'outstream', 
		  nonViewableBehavior: true, 
		  sideStream : {
			enabled: ` + sideStreamEnable + `,
			returnToPage: ` + returntopage + `,
			position: "` + floatLocation + `", 
			width: "` + template_settings.PlayerMode.SideViewWidth + `",
			height: "` + template_settings.PlayerMode.SideViewHeight + `",
			offsetL: "` + helper.IntToString(template_settings.PlayerMode.LeftMargin) + `",
			offsetR: "` + helper.IntToString(template_settings.PlayerMode.RightMargin) + `",
			offsetB: "` + helper.IntToString(template_settings.PlayerMode.BottomMargin) + `"
		},
		width: ` + helper.IntToString(template_settings.MaxWidth) + `,
		height: ` + helper.IntToString(template_settings.MinWidth) + `,
		Ui: {
				enabled : true,
				closeButton : ` + closeEnable + `,
				replayButton : ` + replayEnable + `,    
				playBigButton : false, 
				allowFullscreen : false              
		},
		playbackMethod: "` + playOnview + `", 
		inIframe: ` + iniframeEnable + `,
		isIbh: false,
		  ads: {
			adTagUrl: '` + videoUrl + `',
			showSkipButton : ` + skipEnable + `,
			skipButtonLocation: "bottom-right",
			skipOffSet: ` + helper.IntToString(template_settings.Skip.SkipTime) + `,
			skipText: "Skip %%TIME%% ..",
			skipButtonText: "` + template_settings.Skip.SkipText + `",
			style: {
				zIndex: 1
			},
			viewableEventTime: 5,			
		  }
	  };
	  var player = adMaru.load(adsParams` + rand + `);
	</script>`

	return Html
}

func VastGenerator(w http.ResponseWriter, r *http.Request) string {

	passback := helper.GetUrlParam(r, "passback")
	passback_clickurl := helper.GetUrlParam(r, "passback_url")
	videosrc := helper.GetUrlParam(r, "video")

	videosrc1, _ := base64.StdEncoding.DecodeString(videosrc)
	vidSrc := string(videosrc1)
	var vasttag string
	adunitid := helper.RandToken(5)

	var name string
	var impFinal1 string

	if passback == "passback" {

		vasttag = `<?xml version="1.0" encoding="UTF-8"?>
			<VAST version="3.0">
			   <Ad id="` + adunitid + `">
				  <InLine>
					 <AdSystem><![CDATA[admaru.com]]></AdSystem>
					 <AdTitle><![CDATA[` + name + `]]></AdTitle>
					 <Pricing>
						<model><![CDATA[CPM]]></model>
						<currency><![CDATA[USD]]></currency>
					 </Pricing>
					 <Impression>
					 <![CDATA[` + impFinal1 + `]]>
					</Impression>
					 <Creatives>
						<Creative>
						   <Linear>
							  <Duration>00:00:30</Duration>
							  <TrackingEvents>
							</TrackingEvents>
							  <VideoClicks>
							  <ClickThrough><![CDATA[` + passback_clickurl + `]]></ClickThrough>
							  </VideoClicks>
							  <MediaFiles>
								 <MediaFile delivery="progressive" bitrate="400" width="640" height="480" type="video/mp4" scalable="true" maintainAspectRatio="true"><![CDATA[` + vidSrc + `]]></MediaFile>
							  </MediaFiles>
						   </Linear>
						</Creative>
					 </Creatives>
				  </InLine>
			   </Ad>
			</VAST>`

	} else {
		name := helper.GetUrlParam(r, "name")

		adunitid := helper.GetUrlParam(r, "adunitid")
		clickurl := helper.GetUrlParam(r, "clickurl")

		track := helper.GetUrlParam(r, "track")
		duration := helper.GetUrlParam(r, "duration")
		skip := helper.GetUrlParam(r, "skipoftime")
		Duration := SecoundHHMMSS(duration)
		Skip := SecoundHHMMSS(skip)
		var clickFinal1 string
		if clickurl != "" {

			clickFinal, _ := base64.StdEncoding.DecodeString(clickurl)
			clickFinal1 = string(clickFinal)
		}

		trackFinal, _ := base64.StdEncoding.DecodeString(track)
		trackFinal1 := string(trackFinal)
		vasttag = `<?xml version="1.0" encoding="UTF-8"?>
			<VAST version="3.0">
			   <Ad id="` + adunitid + `">
				  <InLine>
					 <AdSystem><![CDATA[admaru.com]]></AdSystem>
					 <AdTitle><![CDATA[` + name + `]]></AdTitle>
					 <Pricing>
						<model><![CDATA[CPM]]></model>
						<currency><![CDATA[USD]]></currency>
					 </Pricing>
					 <Creatives>
						<Creative>
						<Linear skipoffset="` + Skip + `">
						<Duration>` + Duration + `</Duration>
							  <TrackingEvents>
								<Tracking event="start"><![CDATA[` + trackFinal1 + `&event=start]]></Tracking>
								<Tracking event="firstQuartile"><![CDATA[` + trackFinal1 + `&event=firstQuartile]]></Tracking>
								<Tracking event="midpoint"><![CDATA[` + trackFinal1 + `&event=midpoint]]></Tracking>
								<Tracking event="thirdQuartile"><![CDATA[` + trackFinal1 + `&event=thirdQuartile]]></Tracking>
								<Tracking event="complete"><![CDATA[` + trackFinal1 + `&event=complete]]></Tracking>
								<Tracking event="spause"><![CDATA[` + trackFinal1 + `&event=pause]]></Tracking>
								<Tracking event="smute"><![CDATA[` + trackFinal1 + `&event=mute]]></Tracking>
								<Tracking event="sfullscreen"><![CDATA[` + trackFinal1 + `&event=fullscreen]]></Tracking>
								<Tracking event="sunmute"><![CDATA[` + trackFinal1 + `&event=unmute]]></Tracking>
								<Tracking event="screativeView"><![CDATA[` + trackFinal1 + `&event=creativeView]]></Tracking>
								<Tracking event="sacceptInvitation"><![CDATA[` + trackFinal1 + `&event=acceptInvitation]]></Tracking>
								<Tracking event="srewind"><![CDATA[` + trackFinal1 + `&event=rewind]]></Tracking>
								<Tracking event="rsesume"><![CDATA[` + trackFinal1 + `&event=resume]]> </Tracking>
								<Tracking event="sexitFullscreen"><![CDATA[` + trackFinal1 + `&event=exitfullscreen]]> </Tracking>
								<Tracking event="serror"><![CDATA[` + trackFinal1 + `&event=error]]> </Tracking>
								<Tracking event="sreplay"><![CDATA[` + trackFinal1 + `&event=replay]]> </Tracking>
								<Tracking event="sexpand"><![CDATA[` + trackFinal1 + `&event=expand]]> </Tracking>
								<Tracking event="scollapse"><![CDATA[` + trackFinal1 + `&event=collapse]]> </Tracking>
								<Tracking event="rseplay"><![CDATA[` + trackFinal1 + `&event=replay]]> </Tracking>
								<Tracking event="sstop"><![CDATA[` + trackFinal1 + `&event=stop]]> </Tracking>
								<Tracking event="sloaded"><![CDATA[` + trackFinal1 + `&event=loaded]]> </Tracking>
								<Tracking event="sclose"><![CDATA[` + trackFinal1 + `&event=close]]> </Tracking>
								<Tracking event="sprogress" offset="00:00:10"><![CDATA[` + trackFinal1 + `&event=progress]]> </Tracking>
								<Tracking event="sskip"><![CDATA[` + trackFinal1 + `&event=skip]]> </Tracking>
								<Tracking event="scloseLinear"><![CDATA[` + trackFinal1 + `&event=closeLinear]]> </Tracking>
								<Tracking event="sbreakStart"><![CDATA[` + trackFinal1 + `&event=breakStart]]> </Tracking>
								<Tracking event="snotUsed"><![CDATA[` + trackFinal1 + `&event=notUsed]]> </Tracking>
								<Tracking event="ascceptInvitationLinear"><![CDATA[` + trackFinal1 + `&event=acceptInvitationLinear]]> </Tracking>
								<Tracking event="sbreakEnd"><![CDATA[` + trackFinal1 + `&event=breakEnd]]> </Tracking>
								<Tracking event="sviewable"><![CDATA[` + trackFinal1 + `&event=viewable]]> </Tracking>
								<Tracking event="snotviewable"><![CDATA[` + trackFinal1 + `&event=notviewable]]> </Tracking>
								<Tracking event="sviewundetermined"><![CDATA[` + trackFinal1 + `&event=viewundetermined]]> </Tracking>
								<Tracking event="sautoplayed"><![CDATA[` + trackFinal1 + `&event=autoplayed]]> </Tracking>
							</TrackingEvents>
							  <VideoClicks>
							  <ClickThrough><![CDATA[` + clickFinal1 + `]]></ClickThrough>
							  </VideoClicks>
							  <MediaFiles>
								 <MediaFile delivery="progressive"   type="video/mp4" scalable="true" maintainAspectRatio="true"><![CDATA[` + vidSrc + `]]></MediaFile>
							  </MediaFiles>
						   </Linear>
						</Creative>
					 </Creatives>
				  </InLine>
			   </Ad>
			</VAST>`

	}
	return vasttag
}

func AdapterAdunit(w http.ResponseWriter, r *http.Request) string {
	rand = helper.IntToString(helper.RandNumber(5))
	admaruOutput := structure.AdmaruOutput{}
	admaruOutput.R = r

	requestID := helper.GetUrlParam(r, "id")

	impId := helper.GetUrlParam(r, "imp")

	final_res := []map[string]interface{}{}
	res1 := make(map[string][]map[string]interface{})
	res2 := []map[string]interface{}{}
	if err := json.Unmarshal([]byte(impId), &final_res); err != nil {
		fmt.Println(err)
	}

	var impIdStr string
	impIdStr = final_res[0]["bidId"].(string)
	if final_res[0]["banner"] != nil {
		req_json, err := json.Marshal(final_res[0]["banner"])
		if err != nil {
			fmt.Println(err)
		}

		if err := json.Unmarshal(req_json, &res1); err != nil {
			fmt.Println(err)
		}
		req_json1, err := json.Marshal(res1["format"])
		if err != nil {
			fmt.Println(err)
		}

		if err := json.Unmarshal(req_json1, &res2); err != nil {
			fmt.Println(err)
		}

	} else if final_res[0]["video"] != nil {
		req_json, err := json.Marshal(final_res[0]["video"])
		if err != nil {
			fmt.Println(err)
		}

		if err := json.Unmarshal(req_json, &res1); err != nil {
			fmt.Println(err)
		}
		var vidmap map[string]interface{}
		req_json3, err := json.Marshal(final_res[0]["video"])
		if err != nil {
			fmt.Println(err)
		}
		if err := json.Unmarshal(req_json3, &vidmap); err != nil {
			log.Fatal(err)
		}
	}

	admaruOutput.Adunit_type = "Adapter"

	u, err := url.Parse(helper.GetUrlParam(r, "loc"))
	if err == nil {
		admaruOutput.CORSDomain = u.Scheme + "://" + u.Host
	}

	admaruOutput.Tag_id = helper.GetUrlParam(r, "tag_id")
	admaruOutput.ScreenRes = helper.GetUrlParam(r, "scrSize")
	admaruOutput.Autorefresh = helper.GetUrlParam(r, "auto")
	admaruOutput.Autorefreshrand = helper.GetUrlParam(r, "rand")
	admaruOutput.MultiadPrebidCal = helper.GetUrlParam(r, "Is_MultiAd")
	admaruOutput.MultiadPrebidCPM = helper.GetUrlParam(r, "highestBidCpm")

	globalvar := structure.GlobalVariables{}
	globalvar = globalvariaables.SetAllGrobalVariables(r)
	admaruOutput.Globalvariable = globalvar
	adunit.GetTagDetails(&admaruOutput)
	admaruOutput.Temp_Generation = fetching.FetchTemplates(admaruOutput.Tag_Generation.Template_id)
	publisherShareDetails := fetching.FetchingPublisher_share(admaruOutput.Temp_Generation.Publisher_id)
	publisher_bid_cur := fetching.FetchPub_settings(admaruOutput.Temp_Generation.Publisher_id)
	admaruOutput.Bidding_currency = publisher_bid_cur.Bidding_currency
	admaruOutput.Account_currency = publisher_bid_cur.Account_currency

	var finalJson string
	if publisherShareDetails.Revenue_share != "" && publisherShareDetails.Revenue_share != "0" && validation.TagValidation(admaruOutput.Tag_Generation.Tag_Type, admaruOutput.Tag_Generation.Template_id, admaruOutput.Tag_Generation.Status, admaruOutput.Tag_Generation.Is_Deleted) && validation.TemplateValidation(admaruOutput.Temp_Generation.Settings, admaruOutput.Temp_Generation.Status, admaruOutput.Temp_Generation.Is_Deleted) {
		switch {
		case admaruOutput.Temp_Generation.Template_type == "1": //banner ad delivery
			if admaruOutput.Temp_Generation.Settings != "" {
				err1 := json.Unmarshal([]byte(admaruOutput.Temp_Generation.Settings), &admaruOutput.Banner_Template)
				if err1 != nil {
					fmt.Println(err1)
				}

				//banner size
				Height, Width := fetching.FetchBannerSize(admaruOutput.Banner_Template.Size)
				admaruOutput.Banner_Template.Height = Height
				admaruOutput.Banner_Template.Width = Width
			}
			admaruOutput.Adunit_details = adunit.GetAdunitDetails(admaruOutput.Tag_Generation.Banner_Adunit_id)
			admaruOutput.PublisherDetails = fetching.GetPublisherDetails(admaruOutput.Adunit_details.Publisher)
			if admaruOutput.MultiadPrebidCal != "yes" {
				u1 := uuid.Must(uuid.NewV4())
				admaruOutput.Request_Id = u1.String()

				go adunit.TrackAdReq_N(&admaruOutput)
			} else {
				admaruOutput.Request_Id = helper.GetUrlParam(r, "requestId")
			}

			if admaruOutput.Globalvariable.Environment == "" {
				admaruOutput.Globalvariable.Environment = "1"
			}
			if (admaruOutput.Adunit_details.Status == "1" && admaruOutput.Adunit_details.Is_Deleted == "" && admaruOutput.Adunit_details.Envtype == admaruOutput.Globalvariable.Environment) && (admaruOutput.PublisherDetails.Status == "1" && admaruOutput.PublisherDetails.Is_Deleted == "") {

				adunit.GetAdsourceDetails(&admaruOutput, admaruOutput.Tag_Generation.Banner_Adunit_id, w, r)

				price := admaruOutput.AdapterPrice
				price_float := helper.StringToFloat(price)
				FinalPrice := multiCurrency.Convert_USD(price_float, admaruOutput.Account_currency)
				FinalPrice_str := fmt.Sprintf("%v", FinalPrice)
				if admaruOutput.AdapterAdtype == "RTB_VIDEO" || admaruOutput.AdapterAdtype == "Direct" {

					//Direct Video
					var Adapter_ADM string

					if admaruOutput.AdapterAdtype == "Direct" {
						Adapter_ADM = AdapterJs(admaruOutput.AdapterVASTtag)
						adrequest1, _ := http.NewRequest("GET", Adapter_ADM, nil)
						client2 := &http.Client{Timeout: time.Duration(0) * time.Millisecond}
						resp, err2 := client2.Do(adrequest1)
						if err2 != nil {
							fmt.Println(err2)
						}
						body, _ := ioutil.ReadAll(resp.Body)

						Adapter_ADM = AdapterJs(string(body))
						if admaruOutput.AdapterDeliverAdType == "V_VAST" {
							VASTTracking := TrackingGen(admaruOutput.AdapterTrackingURL)

							Adapter_ADM = strings.Replace(Adapter_ADM, "</Impression>", "</Impression> <Impression><![CDATA["+admaruOutput.AdapterVASTImpression+"]]></Impression><ViewableImpression> <Viewable> <![CDATA["+admaruOutput.AdapterVastTracking+"]]> </Viewable> </ViewableImpression>", 1)
							Adapter_ADM = strings.Replace(Adapter_ADM, "</TrackingEvents>", "</TrackingEvents>"+VASTTracking+"<VideoClicks><ClickTracking> <![CDATA["+admaruOutput.AdapterVASTClick+"]]> </ClickTracking></VideoClicks> ", 1)
							Adapter_ADM = strings.Replace(Adapter_ADM, "</ClickThrough>", "</ClickThrough><ClickTracking> <![CDATA["+admaruOutput.AdapterVASTClick+"]]> </ClickTracking> ", 1)
						} else {
							Adapter_ADM = strings.Replace(Adapter_ADM, "</Impression>", "</Impression> <ViewableImpression> <Viewable> <![CDATA["+admaruOutput.AdapterVastTracking+"]]> </Viewable> </ViewableImpression>", 1)
							Adapter_ADM = strings.Replace(Adapter_ADM, "</ClickThrough>", "</ClickThrough><ClickTracking> <![CDATA["+admaruOutput.AdapterVASTClick+"]]> </ClickTracking> ", 1)
						}

					} else if admaruOutput.AdapterAdtype == "RTB_VIDEO" {

						//RTB Video
						VASTTracking := TrackingGen(admaruOutput.AdapterTrackingURL)
						Adapter_ADM = AdapterJs(admaruOutput.AdapterVastTracking)
						Adapter_ADM = strings.Replace(Adapter_ADM, "</Duration>", "</Duration>"+VASTTracking, 1)

					}
					Adapter_ADM = strings.Replace(Adapter_ADM, "\n", "", -1)
					re := regexp.MustCompile(`\s+`)
					out := re.ReplaceAllString(Adapter_ADM, " ")
					Adapter_ADM = strings.TrimSpace(out)

					if admaruOutput.AdapterAdtype == "Direct" {

						finalJson = `{"id":"` + requestID + `","bidderCode":"admaru","bidder":"admaru","seatbid":[{"bid":[{"id":"` + requestID + `","w":` + helper.IntToString(admaruOutput.Video_Temp.Width) + `,"h":` + helper.IntToString(admaruOutput.Video_Temp.Height) + `,"price":` + FinalPrice_str + `,"adm":"` + strings.Replace(Adapter_ADM, "'<span", "`<span", -1) + `","adomain":["app.admaru.com"],"adid":"` + admaruOutput.AdapterFinalAdsource.Adsourceid + `","impid":"` + impIdStr + `","crid":"` + admaruOutput.AdapterFinalAdsource.Adsourceid + `"}],"seat":"1"}],"cur":"USD"}`

					} else if admaruOutput.AdapterAdtype == "RTB_VIDEO" {
						finalJson = `{"id":"` + requestID + `","bidderCode":"admaru","bidder":"admaru","seatbid":[{"bid":[{"id":"` + requestID + `","w":` + helper.IntToString(admaruOutput.Video_Temp.Width) + `,"h":` + helper.IntToString(admaruOutput.Video_Temp.Height) + `,"price":` + FinalPrice_str + `,"nurl":"` + admaruOutput.MultiAdFinalRTB.Ads.Response.Seatbid[0].Bid[0].Nurl + `","adm":"` + Adapter_ADM + `","adomain":["app.admaru.com"],"adid":"` + admaruOutput.AdapterFinalAdsource.Adsourceid + `","impid":"` + impIdStr + `","crid":"` + admaruOutput.AdapterFinalAdsource.Adsourceid + `","nhnck": ""}],"seat":"1"}],"cur":"USD"}`
					}

				} else {

					Adapter_ADM := admaruOutput.AdapterHTML
					if admaruOutput.AdapterHTML != "" {
						Adapter_ADM = Adapter_ADM
					}
					Adapter_ADM = strings.Replace(Adapter_ADM, "\n", "", -1)
					re := regexp.MustCompile(`\s+`)
					out := re.ReplaceAllString(Adapter_ADM, " ")
					Adapter_ADM = strings.TrimSpace(out)

					finalJson = `{"id":"` + requestID + `","bidderCode":"admaru","bidder":"admaru","seatbid":[{"bid":[{"id":"` + requestID + `","w":` + helper.IntToString(admaruOutput.Banner_Template.Width) + `,"h":` + helper.IntToString(admaruOutput.Banner_Template.Height) + `,"price":` + FinalPrice_str + `,"adm":"` + Adapter_ADM + `","adid":"` + admaruOutput.AdapterFinalAdsource.Adsourceid + `","impid":"` + impIdStr + `","crid":"` + admaruOutput.AdapterFinalAdsource.Adsourceid + `"}],"seat":"1"}],"cur":"USD"}`
				}

			}
		case (admaruOutput.Temp_Generation.Template_type == "3" || admaruOutput.Temp_Generation.Template_type == "2"): //video ad delivery

			admaruOutput.Adunit_details = adunit.GetAdunitDetails(admaruOutput.Tag_Generation.Video_Adunit_id)
			admaruOutput.PublisherDetails = fetching.GetPublisherDetails(admaruOutput.Adunit_details.Publisher)
			if admaruOutput.MultiadPrebidCal != "yes" {
				u1 := uuid.Must(uuid.NewV4())
				admaruOutput.Request_Id = u1.String()

				go adunit.TrackAdReq_N(&admaruOutput)
			} else {
				admaruOutput.Request_Id = helper.GetUrlParam(r, "requestId")
			}
			if (admaruOutput.Adunit_details.Status == "1" && admaruOutput.Adunit_details.Is_Deleted == "" && admaruOutput.Adunit_details.Envtype == admaruOutput.Globalvariable.Environment) && (admaruOutput.PublisherDetails.Status == "1" && admaruOutput.PublisherDetails.Is_Deleted == "") {
				adunit.GetAdsourceDetails(&admaruOutput, admaruOutput.Tag_Generation.Video_Adunit_id, w, r)

				price := admaruOutput.AdapterPrice
				price_float := helper.StringToFloat(price)
				FinalPrice := multiCurrency.Convert_USD(price_float, admaruOutput.Account_currency)
				FinalPrice_str := fmt.Sprintf("%v", FinalPrice)

				//Direct Video
				var Adapter_ADM string

				if admaruOutput.AdapterAdtype == "Direct" {
					Adapter_ADM = AdapterJs(admaruOutput.AdapterVASTtag)
					adrequest1, _ := http.NewRequest("GET", Adapter_ADM, nil)
					client2 := &http.Client{Timeout: time.Duration(0) * time.Millisecond}
					resp, err2 := client2.Do(adrequest1)
					if err2 != nil {
						fmt.Println(err2)
					}
					body, _ := ioutil.ReadAll(resp.Body)

					Adapter_ADM = AdapterJs(string(body))
					if admaruOutput.AdapterDeliverAdType == "V_VAST" {
						VASTTracking := TrackingGen(admaruOutput.AdapterTrackingURL)

						Adapter_ADM = strings.Replace(Adapter_ADM, "</Impression>", "</Impression> <Impression><![CDATA["+admaruOutput.AdapterVASTImpression+"]]></Impression><ViewableImpression> <Viewable> <![CDATA["+admaruOutput.AdapterVastTracking+"]]> </Viewable> </ViewableImpression>", 1)
						Adapter_ADM = strings.Replace(Adapter_ADM, "</TrackingEvents>", "</TrackingEvents>"+VASTTracking+"<VideoClicks><ClickTracking> <![CDATA["+admaruOutput.AdapterVASTClick+"]]> </ClickTracking></VideoClicks> ", 1)
						Adapter_ADM = strings.Replace(Adapter_ADM, "</ClickThrough>", "</ClickThrough><ClickTracking> <![CDATA["+admaruOutput.AdapterVASTClick+"]]> </ClickTracking> ", 1)
					} else {
						Adapter_ADM = strings.Replace(Adapter_ADM, "</Impression>", "</Impression> <ViewableImpression> <Viewable> <![CDATA["+admaruOutput.AdapterVastTracking+"]]> </Viewable> </ViewableImpression>", 1)
						Adapter_ADM = strings.Replace(Adapter_ADM, "</ClickThrough>", "</ClickThrough><ClickTracking> <![CDATA["+admaruOutput.AdapterVASTClick+"]]> </ClickTracking> ", 1)
					}

				} else if admaruOutput.AdapterAdtype == "RTB_VIDEO" {

					//RTB Video
					VASTTracking := TrackingGen(admaruOutput.AdapterTrackingURL)
					Adapter_ADM = AdapterJs(admaruOutput.AdapterVastTracking)
					Adapter_ADM = strings.Replace(Adapter_ADM, "</Duration>", "</Duration>"+VASTTracking, 1)

				}
				Adapter_ADM = strings.Replace(Adapter_ADM, "\n", "", -1)
				re := regexp.MustCompile(`\s+`)
				out := re.ReplaceAllString(Adapter_ADM, " ")
				Adapter_ADM = strings.TrimSpace(out)

				if admaruOutput.AdapterAdtype == "Direct" {

					finalJson = `{"id":"` + requestID + `","bidderCode":"admaru","bidder":"admaru","seatbid":[{"bid":[{"id":"` + requestID + `","w":` + helper.IntToString(admaruOutput.Video_Temp.Width) + `,"h":` + helper.IntToString(admaruOutput.Video_Temp.Height) + `,"price":` + FinalPrice_str + `,"adm":"` + strings.Replace(Adapter_ADM, "'<span", "`<span", -1) + `","adomain":["app.admaru.com"],"adid":"` + admaruOutput.AdapterFinalAdsource.Adsourceid + `","impid":"` + impIdStr + `","crid":"` + admaruOutput.AdapterFinalAdsource.Adsourceid + `"}],"seat":"1"}],"cur":"USD"}`

				} else if admaruOutput.AdapterAdtype == "RTB_VIDEO" {
					finalJson = `{"id":"` + requestID + `","bidderCode":"admaru","bidder":"admaru","seatbid":[{"bid":[{"id":"` + requestID + `","w":` + helper.IntToString(admaruOutput.Video_Temp.Width) + `,"h":` + helper.IntToString(admaruOutput.Video_Temp.Height) + `,"price":` + FinalPrice_str + `,"nurl":"` + admaruOutput.MultiAdFinalRTB.Ads.Response.Seatbid[0].Bid[0].Nurl + `","adm":"` + Adapter_ADM + `","adomain":["app.admaru.com"],"adid":"` + admaruOutput.AdapterFinalAdsource.Adsourceid + `","impid":"` + impIdStr + `","crid":"` + admaruOutput.AdapterFinalAdsource.Adsourceid + `","nhnck": ""}],"seat":"1"}],"cur":"USD"}`
				}

			}

		}

	}

	return finalJson
}

//trackingevent generate Function

func TrackingGen(trackingRequestDetails string) string {

	//Video events Tracking for both video and banner (multiadformat video)
	VASTTracking := `<TrackingEvents>
	<Tracking event='start'><![CDATA[` + trackingRequestDetails + `&event=start]]></Tracking>
	<Tracking event='firstQuartile'><![CDATA[` + trackingRequestDetails + `&event=firstQuartile]]></Tracking>
	<Tracking event='midpoint'><![CDATA[` + trackingRequestDetails + `&event=midpoint]]></Tracking>
	<Tracking event='thirdQuartile'><![CDATA[` + trackingRequestDetails + `&event=thirdQuartile]]></Tracking>
	<Tracking event='complete'><![CDATA[` + trackingRequestDetails + `&event=complete]]></Tracking>
	<Tracking event='spause'><![CDATA[` + trackingRequestDetails + `&event=pause]]></Tracking>
	<Tracking event='smute'><![CDATA[` + trackingRequestDetails + `&event=mute]]></Tracking>
	<Tracking event='sfullscreen'><![CDATA[` + trackingRequestDetails + `&event=fullscreen]]></Tracking>
	<Tracking event='sunmute'><![CDATA[` + trackingRequestDetails + `&event=unmute]]></Tracking>
	<Tracking event='screativeView'><![CDATA[` + trackingRequestDetails + `&event=creativeView]]></Tracking>
	<Tracking event='sacceptInvitation'><![CDATA[` + trackingRequestDetails + `&event=acceptInvitation]]></Tracking>
	<Tracking event='srewind'><![CDATA[` + trackingRequestDetails + `&event=rewind]]></Tracking>
	<Tracking event='rsesume'><![CDATA[` + trackingRequestDetails + `&event=resume]]> </Tracking>
	<Tracking event='sexitFullscreen'><![CDATA[` + trackingRequestDetails + `&event=exitfullscreen]]> </Tracking>
	<Tracking event='serror'><![CDATA[` + trackingRequestDetails + `&event=error]]> </Tracking>
	<Tracking event='sreplay'><![CDATA[` + trackingRequestDetails + `&event=replay]]> </Tracking>
	<Tracking event='sexpand'><![CDATA[` + trackingRequestDetails + `&event=expand]]> </Tracking>
	<Tracking event='scollapse'><![CDATA[` + trackingRequestDetails + `&event=collapse]]> </Tracking>
	<Tracking event='rseplay'><![CDATA[` + trackingRequestDetails + `&event=replay]]> </Tracking>
	<Tracking event='sstop'><![CDATA[` + trackingRequestDetails + `&event=stop]]> </Tracking>
	<Tracking event='sloaded'><![CDATA[` + trackingRequestDetails + `&event=loaded]]> </Tracking>
	<Tracking event='sclose'><![CDATA[` + trackingRequestDetails + `&event=close]]> </Tracking>
	<Tracking event='sprogress' offset='00:00:10'><![CDATA[` + trackingRequestDetails + `&event=progress]]> </Tracking>
	<Tracking event='sskip'><![CDATA[` + trackingRequestDetails + `&event=skip]]> </Tracking>
	<Tracking event='scloseLinear'><![CDATA[` + trackingRequestDetails + `&event=closeLinear]]> </Tracking>
	<Tracking event='sbreakStart'><![CDATA[` + trackingRequestDetails + `&event=breakStart]]> </Tracking>
	<Tracking event='snotUsed'><![CDATA[` + trackingRequestDetails + `&event=notUsed]]> </Tracking>
	<Tracking event='ascceptInvitationLinear'><![CDATA[` + trackingRequestDetails + `&event=acceptInvitationLinear]]> </Tracking>
	<Tracking event='sbreakEnd'><![CDATA[` + trackingRequestDetails + `&event=breakEnd]]> </Tracking>
	<Tracking event='sviewable'><![CDATA[` + trackingRequestDetails + `&event=viewable]]> </Tracking>
	<Tracking event='snotviewable'><![CDATA[` + trackingRequestDetails + `&event=notviewable]]> </Tracking>
	<Tracking event='sviewundetermined'><![CDATA[` + trackingRequestDetails + `&event=viewundetermined]]> </Tracking>
	<Tracking event='sautoplayed'><![CDATA[` + trackingRequestDetails + `&event=autoplayed]]> </Tracking>
</TrackingEvents>`
	return VASTTracking

}

func AdapterJs(str string) string {

	k := strings.Replace((strings.Replace(str, `"`, "'", -1)), "span>'", "span>`", -1)
	k = strings.Replace(k, "'<span", "`<span", -1)
	k = strings.Replace(k, "${", "$`+`{", -1)
	k = strings.Replace(k, "callback(null, '<VAST", "callback(null, `<VAST", -1)
	k = strings.Replace(k, "InLine></Ad></VAST>'", "InLine></Ad></VAST>`", -1)
	return k
}

func SecoundHHMMSS(duration string) string {
	var f float64
	var err error
	if strings.Contains(duration, ".") {
		f, err = strconv.ParseFloat(duration, 1)
		if err != nil {
			fmt.Println(err)
		}
	} else {
		f = float64(helper.StringToInt(duration))
	}
	n := int(math.Round(f))

	var t time.Time // Zero time
	t = t.Add(time.Duration(n) * time.Second)
	secs := t.Format("15:04:05")
	return secs
}

func ConvertJss(html string) string {

	var jsLines []string
	var search []string
	var replace []string

	search = append(search, "\\")
	search = append(search, "\r")
	search = append(search, "'")
	search = append(search, "<")

	replace = append(replace, "\\\\")
	replace = append(replace, "")
	replace = append(replace, "\\'")
	replace = append(replace, "<'+'")

	for i, element := range search {

		html = strings.ReplaceAll(html, element, replace[i])
	}

	lines := strings.Split(html, "\n")

	for _, e := range lines {

		if strings.Trim(e, "") != "" {

			jsLines = append(jsLines, strings.Trim(e, ""))

		}

	}

	return strings.Join(jsLines, "")

}
func GetDirectVideo(adsourceid string, adunitid string, provider_src_id string, admaruoutput *structure.AdmaruOutput, r *http.Request, w http.ResponseWriter) {
	adunitdetails := fetching.FetchAdunitModel(adunitid)
	admaruoutput.Adunit_details = adunitdetails
	adsourcedetails := fetching.FetchAdsourceModel(adsourceid)
	admaruoutput.Adsource_details = append(admaruoutput.Adsource_details, adsourcedetails)
	admaruoutput.Provider_id = adsourcedetails.Provider
	admaruoutput.Adsource_details[0].Provider_Src_id = provider_src_id
	admaruoutput.Adsource_details[0].Request_id = admaruoutput.Request_Id
	admaruoutput.Adsource_details[0].Bidprice = admaruoutput.Bidding_price
	adsourcedetails.Request_id = admaruoutput.Request_Id
	adsourcedetails.Provider_Src_id = provider_src_id
	adsourcedetails.Bidprice = admaruoutput.Bidding_price
	adunit.GetTagDetails(admaruoutput)
	admaruoutput.Temp_Generation = fetching.FetchTemplates(admaruoutput.Tag_Generation.Template_id)

	if adsourcedetails.Adtype == "V_RTB" {
		var wg sync.WaitGroup
		wg.Add(1)
		delivery.ProgrammaticAd(admaruoutput, admaruoutput.Adsource_details, &wg, r, w)
		wg.Wait()
	} else {

		ad.VideoAdRander(adsourcedetails, admaruoutput)
	}

}

func Passback(admaruoutput *structure.AdmaruOutput, rand string) string {
	var passbackStart string
	var passbackEnd string
	var Adtype string
	var adTag string
	var finalpassback string
	var VideoRefresh string
	var passrand = helper.IntToString(helper.RandNumber(5))
	passbackStart = `<div id='test-ad` + rand + `'>`
	passbackEnd = `</div>`

	switch {
	case admaruoutput.Temp_Generation.Template_type == "1":
		template_settings11 := structure.Tagsettings{}
		err := json.Unmarshal([]byte(admaruoutput.Temp_Generation.Settings), &template_settings11)
		if err != nil {
			fmt.Println(err)
		}
		Adtype = template_settings11.Passback.LinkOrTag
		if Adtype == "tag" {

			TagParty := template_settings11.Passback.URL
			Thirdpartytag := strings.Replace(TagParty, `<!--//<![CDATA[`, ``, -1)
			ThirdpartytagF := strings.Replace(Thirdpartytag, `//]]>-->`, ``, -1)
			adTag = `<div>` + ThirdpartytagF + `</div>`
		} else if Adtype == "link" {
			clickurl := template_settings11.Passback.DestinationUrl
			ImgTag := template_settings11.Passback.URL
			clickTag_start := `<a href='` + clickurl + `' target='_blank'>`
			clickTag_end := `</a>`
			adTag = clickTag_start + `<img src='` + ImgTag + `' width='` + helper.IntToString(admaruoutput.Banner_Template.Width) + `' height='` + helper.IntToString(admaruoutput.Banner_Template.Height) + `' alt='' title='' border='0' />` + clickTag_end
		}

	case admaruoutput.Temp_Generation.Template_type == "2" || admaruoutput.Temp_Generation.Template_type == "3":
		template_settings11 := structure.Outstream_Template{}
		err := json.Unmarshal([]byte(admaruoutput.Temp_Generation.Settings), &template_settings11)
		if err != nil {
			fmt.Println(err)
		}

		if template_settings11.TempPassback.DFP.DFP == true && admaruoutput.DFP_Delivery == "true" {

			template_settings11.TempPassback.URL = `<div id="` + template_settings11.TempPassback.DFP.Div_id + `">  <script>    window.googletag = window.googletag || {cmd: []};    
			googletag.cmd.push(function() { 
				googletag.pubads().refresh([` + template_settings11.TempPassback.DFP.Slot_id + `]);
				googletag.pubads().addEventListener('slotRenderEnded', function(event) {
					if (event.slot.getSlotElementId() == "` + template_settings11.TempPassback.DFP.Div_id + `") {
						
						localStorage.setItem('DFP_Delivery_` + rand + `','true');
					}
				}); 
			});  </script></div>`

		}

		admaruoutput.Viewable_Tagid = "test-ad" + rand
		Template_id := admaruoutput.Tag_id
		if template_settings11.VastRetry > 0 {
			VideoRefresh = `<script type="text/javascript" >
		var adpassTimeout="";
		adpassTimeout=setTimeout(maxset` + passrand + `, 5000);
				
		function maxset` + passrand + `()
		{
			var MaxImp` + passrand + `='` + helper.IntToString(template_settings11.VastRetry) + `';
			
			if(localStorage.getItem('TEMPTAG_` + Template_id + rand + `')== null){
				localStorage.setItem('TEMPTAG_` + Template_id + rand + `','` + rand + "_" + `'+MaxImp` + passrand + `);
			}
			var Imp_details` + passrand + `=localStorage.getItem('TEMPTAG_` + Template_id + rand + `');
			var Imp_array` + passrand + `=Imp_details` + passrand + `.split("_");
			var Remainig_Imp` + passrand + `=Imp_array` + passrand + `[1]; 
			var Randnum` + passrand + `=Imp_array` + passrand + `[0];
			var TagId` + passrand + `='` + Template_id + `';
			
			if (Remainig_Imp` + passrand + ` !== null){
				if (Remainig_Imp` + passrand + ` > 0)
				{
					Remainig_Imp` + passrand + `--;
					localStorage.setItem('TEMPTAG_'+TagId` + passrand + `+Randnum` + passrand + `,Randnum` + passrand + `+"_"+Remainig_Imp` + passrand + `);
					var Test_Div=document.getElementById('` + admaruoutput.Viewable_Tagid + `');
					if(Test_Div!="" && Test_Div!=null){
						Test_Div.innerHTML="";
					}	
					var DFP_Delivery` + rand + `="true";
					window.googletag = window.googletag || {cmd: []};    
					googletag.cmd.push(function() { 
						googletag.pubads().addEventListener('slotRenderEnded', function(event) {
							if (event.slot.getSlotElementId() == "` + template_settings11.TempPassback.DFP.Div_id + `") {
								
								localStorage.setItem('DFP_Delivery_` + rand + `','true');
							}
						}); 
					});
					if(localStorage.getItem('DFP_Delivery_` + rand + `')!= null){
						DFP_Delivery` + rand + `="true";
					}
					var m3_u1 = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid=` + Template_id + `&loc='+escape(window.location)+'&auto=yes&trackingloc='+escape(window.location)+'&Is_Libload=no&Is_vastretry=yes&rand='+Randnum` + passrand + `+'&DFP_Delivery='+DFP_Delivery` + rand + `;
					fetch(m3_u1) 
								.then(response => {       
									return response.text(); 
								})
								.then(htmlContent => {
									var mainDIV` + passrand + ` = document.getElementById('` + admaruoutput.Viewable_Tagid + `');
									var childDiv` + passrand + ` = document.createElement("div");       
									childDiv` + passrand + `.innerHTML = htmlContent;
									mainDIV` + passrand + `.appendChild(childDiv` + passrand + `);

									var mainscript` + passrand + ` = mainDIV` + passrand + `.getElementsByTagName("script");
									for (var scriptTags` + passrand + ` of mainscript` + passrand + `) {
									  var scriptContent` + passrand + ` = scriptTags` + passrand + `.textContent;
									  eval(scriptContent` + passrand + `);
									  if (scriptTags` + passrand + `.src) {
										var scriptElement` + passrand + ` = document.createElement("script");
										scriptElement` + passrand + `.src = scriptTags` + passrand + `.src;
										document.head.appendChild(scriptElement` + passrand + `);
									  }
									}
								
								})
								.catch(error => {
									console.error('Fetch error:', error);
								});

				} else{
					localStorage.removeItem('TEMPTAG_'+TagId` + passrand + `+Randnum` + passrand + `);
					clearTimeout(adpassTimeout);

				}
			}
	
		}</script>`
		}
		Adtype = template_settings11.TempPassback.LinkOrTag
		if Adtype == "tag" {

			TagParty := template_settings11.TempPassback.URL
			Thirdpartytag := strings.Replace(TagParty, `<!--//<![CDATA[`, ``, -1)
			ThirdpartytagF := strings.Replace(Thirdpartytag, `//]]>-->`, ``, -1)
			adTag = `<div>` + ThirdpartytagF + `</div>`
		} else if Adtype == "link" {
			clickurl := template_settings11.TempPassback.DestinationUrl
			ImgTag := template_settings11.TempPassback.URL
			clickTag_start := `<a href='` + clickurl + `' target='_blank'>`
			clickTag_end := `</a>`
			adTag = clickTag_start + `<img src='` + ImgTag + `' width='300' height='250' alt='' title='' border='0' />` + clickTag_end
		} else if Adtype == "img" {

			TagParty := template_settings11.TempPassback.URL

			Thirdpartytag := strings.Replace(TagParty, "\n", "", -1)
			Thirdpartytag = strings.Replace(Thirdpartytag, "  ", " ", -1)
			adTag = `<img src='` + Thirdpartytag + `' width='300' height='250' alt='' style='width: 0px; height: 0px;' />`
		} else if Adtype == "iframe" {

			TagParty := template_settings11.TempPassback.URL
			Thirdpartytag := strings.Replace(TagParty, "\n", "", -1)
			Thirdpartytag = strings.Replace(Thirdpartytag, `\`, ``, -1)
			Thirdpartytag = strings.Replace(Thirdpartytag, "  ", " ", -1)
			adTag = `<div>` + Thirdpartytag + `</div>`
		} else if Adtype == "js" {
			TagParty := template_settings11.TempPassback.URL
			Thirdpartytag := strings.Replace(TagParty, `<!--//<![CDATA[`, ``, -1)
			ThirdpartytagF := strings.Replace(Thirdpartytag, `//]]>-->`, ``, -1)
			ThirdpartytagF = strings.Replace(ThirdpartytagF, `</script>`, `<\/script>`, -1)
			ThirdpartytagF = strings.Replace(ThirdpartytagF, "  ", " ", -1)
			ThirdpartytagF = strings.Replace(ThirdpartytagF, `</scr"+"ipt>`, `<\/script>`, -1)
			ThirdpartytagF = strings.Replace(ThirdpartytagF, "\n", "", -1)
			ThirdpartytagF = strings.Replace(ThirdpartytagF, `\`, ``, -1)
			ThirdpartytagF = strings.Replace(ThirdpartytagF, "  ", " ", -1)
			adTag = `<div>` + ThirdpartytagF + `</div>`
		}
	}

	if adTag != "" {
		finalpassback = passbackStart + adTag + passbackEnd
	} else {
		finalpassback = passbackStart + passbackEnd
	}
	return finalpassback + VideoRefresh
}

func VideoVastTag(w http.ResponseWriter, r *http.Request) (string, string) {
	rand = helper.IntToString(helper.RandNumber(5))
	admaruOutput := structure.AdmaruOutput{}
	admaruOutput.R = r

	admaruOutput.VastRetry_Enable = "yes"
	var CORSDomain string
	u, err := url.Parse(helper.GetUrlParam(r, "loc"))
	if err == nil {
		CORSDomain = u.Scheme + "://" + u.Host
	}
	admaruOutput.Tag_id = helper.GetUrlParam(r, "tagid")
	admaruOutput.ScreenRes = helper.GetUrlParam(r, "scrSize")
	admaruOutput.Autorefresh = helper.GetUrlParam(r, "auto")
	admaruOutput.Viewable_Tagid = helper.GetUrlParam(r, "tagidRand")
	admaruOutput.Videovastadtype = helper.GetUrlParam(r, "vastretryadtype")

	admaruOutput.Impcap = helper.GetUrlParam(r, "Impcap")
	if admaruOutput.Videovastadtype == "" {
		admaruOutput.Adunit_type = "VideoVast"
	} else {
		admaruOutput.Adunit_type = "VideoVast"
	}
	m, _ := url.Parse(helper.GetUrlParam(r, "trackingloc"))
	if admaruOutput.Autorefresh == "yes" || helper.GetUrlParam(r, "trackingloc") != "" {
		admaruOutput.CORSDomain = m.Scheme + "://" + m.Host
	} else {
		admaruOutput.CORSDomain = CORSDomain
	}
	admaruOutput.Autorefreshrand = helper.GetUrlParam(r, "rand")
	/************priority api***************/

	admaruOutput.Priority_Call = helper.StringToInt(helper.GetUrlParam(r, "priority_next"))
	/************priority api***************/
	var finalHTML string
	var AutoRefresh string

	var vastretrytype string
	/******************/
	bidadsourceid := helper.GetUrlParam(r, "Bid_AdSource")
	bidadunitid := helper.GetUrlParam(r, "Bid_adunitid")
	bidrequestid := helper.GetUrlParam(r, "Bid_Req")
	bidproviderid := helper.GetUrlParam(r, "Bid_providerid")
	if bidadsourceid != "" {

		admaruOutput.Tag_id = helper.GetUrlParam(r, "Bid_Tag")
		admaruOutput.Bidding_currency = helper.GetUrlParam(r, "res_cur")
		admaruOutput.Request_Id = bidrequestid
		admaruOutput.Bidding_price = helper.GetUrlParam(r, "Bid_CPM")
		GetDirectVideo(bidadsourceid, bidadunitid, bidproviderid, &admaruOutput, r, w)

		if admaruOutput.Html != "" {

			finalHTML = admaruOutput.Html
		} else {
			var Adtype string
			var videoUrl string
			var src_url string
			template_settings1 := structure.Outstream_Template{}
			err := json.Unmarshal([]byte(admaruOutput.Temp_Generation.Settings), &template_settings1)
			if err != nil {
				fmt.Println(err)
			}
			Adtype = template_settings1.TempPassback.LinkOrTag
			src_url = config.GetConfig("source", "video")
			if Adtype == "tag" {
				videoUrl = template_settings1.TempPassback.URL
				finalHTML = VideoPlayer(&admaruOutput, videoUrl, src_url)
			} else if Adtype == "link" {
				video := template_settings1.TempPassback.URL
				clickurl := template_settings1.TempPassback.DestinationUrl
				videoSrc := base64.StdEncoding.EncodeToString([]byte(video))
				videoUrl = config.GetConfig("commonpath", "file") + `VastGen?video=` + videoSrc + `&passback=passback` + `&passback_url=` + clickurl
				finalHTML = VideoPlayer(&admaruOutput, videoUrl, src_url)
			}
		}
		return finalHTML, ""

	} else {
		/******************/

		admaruOutput.Prebid_Resonse = helper.GetUrlParam(r, "bid_res")
		admaruOutput.MultiadPrebidCal = helper.GetUrlParam(r, "Is_MultiAd")
		admaruOutput.MultiadPrebidCPM = helper.GetUrlParam(r, "highestBidCpm")

		admaruOutput.Globalvariable = globalvariaables.SetAllGrobalVariables(r)
		adunit.GetTagDetails(&admaruOutput)
		admaruOutput.Temp_Generation = fetching.FetchTemplates(admaruOutput.Tag_Generation.Template_id)
		publisherShareDetails := fetching.FetchingPublisher_share(admaruOutput.Temp_Generation.Publisher_id)
		publisher_bid_cur := fetching.FetchPub_settings(admaruOutput.Temp_Generation.Publisher_id)
		admaruOutput.Bidding_currency = publisher_bid_cur.Bidding_currency
		admaruOutput.Account_currency = publisher_bid_cur.Account_currency

		if publisherShareDetails.Revenue_share != "" && publisherShareDetails.Revenue_share != "0" && validation.TagValidation(admaruOutput.Tag_Generation.Tag_Type, admaruOutput.Tag_Generation.Template_id, admaruOutput.Tag_Generation.Status, admaruOutput.Tag_Generation.Is_Deleted) && validation.TemplateValidation(admaruOutput.Temp_Generation.Settings, admaruOutput.Temp_Generation.Status, admaruOutput.Temp_Generation.Is_Deleted) {
			switch {
			case admaruOutput.Temp_Generation.Template_type == "1": //banner ad delivery
				/********template bannser size***********/

				if admaruOutput.Temp_Generation.Settings != "" {

					err1 := json.Unmarshal([]byte(admaruOutput.Temp_Generation.Settings), &admaruOutput.Banner_Template)
					if err1 != nil {
						fmt.Println(err1)
					}

					//banner size
					Height, Width := fetching.FetchBannerSize(admaruOutput.Banner_Template.Size)
					admaruOutput.Banner_Template.Height = Height
					admaruOutput.Banner_Template.Width = Width
				}
				/********template bannser size***********/
				admaruOutput.Adunit_details = adunit.GetAdunitDetails(admaruOutput.Tag_Generation.Banner_Adunit_id)
				admaruOutput.PublisherDetails = fetching.GetPublisherDetails(admaruOutput.Adunit_details.Publisher)
				if validation.AdunitValidation(admaruOutput.Adunit_details.Adunit_type, admaruOutput.Adunit_details.Envtype, admaruOutput.Adunit_details.Width, admaruOutput.Adunit_details.Height, admaruOutput.Adunit_details.Status, admaruOutput.Adunit_details.Is_Deleted, admaruOutput.Globalvariable.Environment) && validation.PublisherValidation(admaruOutput.PublisherDetails.Publisher_Seller.Domain, admaruOutput.PublisherDetails.Publisher_Seller.Publisher_seller_id, admaruOutput.PublisherDetails.Status, admaruOutput.PublisherDetails.Is_Deleted) {
					if admaruOutput.MultiadPrebidCal != "yes" {
						u1 := uuid.Must(uuid.NewV4())
						admaruOutput.Request_Id = u1.String()
						go adunit.TrackAdReq_N(&admaruOutput)
					} else {
						admaruOutput.Request_Id = helper.GetUrlParam(r, "requestId")
					}
					adunit.GetAdsourceDetails(&admaruOutput, admaruOutput.Tag_Generation.Banner_Adunit_id, w, r)

					/**********Auto Refresh Start**********/

					Template_id := admaruOutput.Tag_id
					Templates := admaruOutput.Temp_Generation
					if admaruOutput.DeliveryAdType != "Prebid" {
						AutoRefresh = `<script type='text/javascript'>var i` + rand + ` = 0;</script>`
					}

					if Templates.Settings != "" {

						err1 := json.Unmarshal([]byte(Templates.Settings), &admaruOutput.Banner_Template)
						if err1 != nil {
							fmt.Println(err1)
						}

						Enabled := admaruOutput.Banner_Template.Refresh.Enabled
						MaxImp := admaruOutput.Banner_Template.Refresh.MaxImp
						Rate := admaruOutput.Banner_Template.Refresh.Rate

						RateVal := helper.StringToInt(Rate)
						checkMax := helper.StringToInt(MaxImp)

						if Enabled == true && RateVal != 0 && checkMax != 0 {

							finalVal := RateVal * 1000
							Refresh_Interval := helper.IntToString(finalVal)
							if admaruOutput.Autorefreshrand != "" {
								rand = admaruOutput.Autorefreshrand
							}

							AutoRefresh = `<script type='text/javascript'>
							if(localStorage.getItem('TEMPTAG_` + Template_id + rand + `')== null){
								localStorage.setItem('TEMPTAG_` + Template_id + rand + `','` + rand + "_" + MaxImp + `');
							}
							var Imp_details` + rand + `=localStorage.getItem('TEMPTAG_` + Template_id + rand + `');
							var Imp_array` + rand + `=Imp_details` + rand + `.split("_");
							var Remainig_Imp` + rand + `=Imp_array` + rand + `[1]; 
							var Randnum` + rand + `=Imp_array` + rand + `[0];
							var Interval` + rand + `=setInterval(function() { autoRefresh` + rand + `('` + Template_id + `','` + rand + `'); },` + Refresh_Interval + `);
							var AdType='` + admaruOutput.DeliveryAdType + `';
							function autoRefresh` + rand + `(tag_id,rand) {
								
								var Tracker_Div=document.getElementById('track_'+rand);
																
								if(Tracker_Div!="" && Tracker_Div!=null){
									Tracker_Div.innrHTML="";
								}
								Imp_details` + rand + `=localStorage.getItem('TEMPTAG_'+tag_id+rand);
									Imp_array` + rand + `=Imp_details` + rand + `.split("_");
								Remainig_Imp` + rand + `=Imp_array` + rand + `[1];  
								Randnum=Imp_array` + rand + `[0];
								if (Remainig_Imp` + rand + ` !== null){
									if (Remainig_Imp` + rand + ` > 0)
									{	
										Remainig_Imp` + rand + `--;
										localStorage.setItem('TEMPTAG_'+tag_id+rand,rand+"_"+Remainig_Imp` + rand + `);
										AutoRef_Req(rand,tag_id);
									}else{
										Remainig_Imp` + rand + `--;
										localStorage.removeItem('TEMPTAG_'+tag_id+rand);
										localStorage.removeItem('autoenabled');
										clearInterval(Interval` + rand + `);
										setTimeout(Interval` + rand + `);
									}
								}else{
									AutoRef_Req(rand,tag_id);
									localStorage.setItem('TEMPTAG_'+tag_id+rand,rand+"_"+Remainig_Imp` + rand + `);
								}
							}
							function AutoRef_Req(Randno,tagid){ 
							
								var Ad_Div=document.getElementById('autoref-ad'+Randno);
								
								if(Ad_Div!="" && Ad_Div!=null){
									Ad_Div.innerHTML="";
								}
								var ViewDiv =document.getElementById('viewImp_'+Randno);
								if(ViewDiv!="" && ViewDiv!=null){
									ViewDiv.outerHTML="";
								}
								var Test_Div=document.getElementById('test-ad'+Randno);
								if(Test_Div!="" && Test_Div!=null){
									Test_Div.innerHTML="";
								}					
								localStorage.setItem('autoenabled',"yes");
								var m3_u1 = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid='+tagid+'&loc=` + admaruOutput.CORSDomain + `&auto=yes&trackingloc=` + config.GetConfig("commonpath", "file") + `&rand='+Randno;
								iDiv = document.createElement('div');
								iDiv.setAttribute("id", "viewImp_"+Randno);
								Test_Div.appendChild(iDiv);
								
						fetch(m3_u1) 
						.then(response => {       
							return response.text(); 
						})
						.then(htmlContent => {
							var mainDIV` + rand + ` = document.getElementById('viewImp_` + rand + `');
							var childDiv` + rand + ` = document.createElement("div");       
							childDiv` + rand + `.innerHTML = htmlContent;
							mainDIV` + rand + `.appendChild(childDiv` + rand + `);

							var mainscript` + rand + ` = mainDIV` + rand + `.getElementsByTagName("script");
							for (var scriptTags` + rand + ` of mainscript` + rand + `) {
							  var scriptContent` + rand + ` = scriptTags` + rand + `.textContent;
							  eval(scriptContent` + rand + `);
							  if (scriptTags` + rand + `.src) {
								var scriptElement` + rand + ` = document.createElement("script");
								scriptElement` + rand + `.src = scriptTags` + rand + `.src;
								document.head.appendChild(scriptElement` + rand + `);
							  }
							}
						
						})
						.catch(error => {
							console.error('Fetch error:', error);
						});
					
									
							}
							</script>`
						}
					}
					/**********Auto Refresh End**********/

					/******************Passback Start*********************/

					if admaruOutput.Html != "" {

						finalHTML = admaruOutput.Html
					} else {
						finalHTML = Passback(&admaruOutput, rand)
					}

					/******************Passback adasync End*********************/
				}

			case (admaruOutput.Temp_Generation.Template_type == "3" || admaruOutput.Temp_Generation.Template_type == "2"): //video ad delivery

				admaruOutput.Adunit_details = adunit.GetAdunitDetails(admaruOutput.Tag_Generation.Video_Adunit_id)
				admaruOutput.PublisherDetails = fetching.GetPublisherDetails(admaruOutput.Adunit_details.Publisher)
				if (admaruOutput.Adunit_details.Status == "1" && admaruOutput.Adunit_details.Is_Deleted == "" && admaruOutput.Adunit_details.Envtype == admaruOutput.Globalvariable.Environment) && (admaruOutput.PublisherDetails.Status == "1" && admaruOutput.PublisherDetails.Is_Deleted == "") {
					if admaruOutput.MultiadPrebidCal != "yes" {
						u1 := uuid.Must(uuid.NewV4())
						admaruOutput.Request_Id = u1.String()
						go adunit.TrackAdReq_N(&admaruOutput)
					} else {
						admaruOutput.Request_Id = helper.GetUrlParam(r, "requestId")
					}
					adunit.GetAdsourceDetails(&admaruOutput, admaruOutput.Tag_Generation.Video_Adunit_id, w, r)

					vastretrytype = admaruOutput.Videovastresponsetype
					if admaruOutput.Html != "" {

						finalHTML = admaruOutput.Html
					} else {

						finalHTML = Passback(&admaruOutput, rand)
					}

				}

			}

			if admaruOutput.MultiadPrebidCal != "" || admaruOutput.Autorefresh == "yes" {
				return finalHTML, vastretrytype

			} else {
				if admaruOutput.Temp_Generation.Template_type == "1" && finalHTML != "" {
					if admaruOutput.Html == "" && finalHTML != "" {
						finalHTML = finalHTML + AutoRefresh
					} else {
						finalHTML = finalHTML + AutoRefresh

					}
				}
				return finalHTML, vastretrytype
			}
		}

	}
	return strconv.ErrSyntax.Error(), vastretrytype
}
