package ad

import (
	"alpha/addelivery/fetching"
	"alpha/addelivery/helper"
	"alpha/addelivery/structure"
	config "alpha/configuration"
	"encoding/base64"
	"encoding/json"
	"fmt"
	"net/url"
	"strings"
)

type VClickThrough struct {
	Bidder       string  `json:"bidder"`
	ClickThrough string  `json:"clickthrough"`
	Duration     float64 `json:"duration"`
}

type VPlatform struct {
	Bidder        string  `json:"bidder"`
	Platform_link string  `json:"platform_link"`
	Duration      float64 `json:"duration"`
}

type VastLink struct {
	Bidder    string `json:"bidder"`
	Vast_link string `json:"vast_url"`
}

type InlineContent struct {
	Video_Url        string `json:"video_url"`
	ClickThrough_Url string `json:"ClickThrough_url"`
}

type VideoVast struct {
	Template_Settings  structure.Outstream_Template `json:"template_settings"`
	Vast_URL           string                       `json:"vast_url"`
	Click_URL          string                       `json:"click_url"`
	Impression_URL     string                       `json:"imp_url"`
	ViewableImp_URL    string                       `json:"viewable_url"`
	Event_URL          string                       `json:"event_url"`
	ThirdPartyTrackers string                       `json:"third_part_trackers"`
	Deliveryadtype     string                       `json:"deliveryadtype"`
	Adtype             string                       `json:"adtype"`
	Viewimpression     string                       `json:"viewimpression"`
}

func VideoAdRander(adDetails structure.AdSourceDetails, admaruout *structure.AdmaruOutput) {

	WinStats(adDetails, admaruout)
	/**********In Stream Start**********/
	Inline_Content := admaruout.Temp_Generation.Inline_Content

	var Inlineontent []InlineContent

	err2 := json.Unmarshal([]byte(Inline_Content), &Inlineontent)
	if err2 != nil {
		fmt.Println(err2)
	}

	/**********In Stream End**********/

	/******************Skip Code*********************/
	template_settings := structure.Outstream_Template{}
	err := json.Unmarshal([]byte(admaruout.Temp_Generation.Settings), &template_settings)
	if err != nil {
		fmt.Println(err)
	}

	if template_settings.Skip.Skip != true {
		template_settings.Skip.SkipTime = 0
	}

	clickThrough := VClickThrough{}
	err = json.Unmarshal([]byte(adDetails.Src_Obj), &clickThrough)
	if err != nil {
		fmt.Println(err)
	}
	vplatformLink := VPlatform{}
	err = json.Unmarshal([]byte(adDetails.Src_Obj), &vplatformLink)
	if err != nil {
		fmt.Println(err)
	}
	vastUrl := VastLink{}
	err = json.Unmarshal([]byte(adDetails.Src_Obj), &vastUrl)
	if err != nil {
		fmt.Println(err)
	}
	var clickTag string
	if clickThrough.ClickThrough != "" {
		clickurl := config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Click?requestid=" + adDetails.Request_id + "&adsourceid=" + adDetails.Adsourceid + "&adunitid=" + admaruout.Adunit_details.Adunit_id + "&Providerid=" + admaruout.Provider_id + "&Publisherid=" + admaruout.Adunit_details.Publisher + "&url=" + clickThrough.ClickThrough + "&tagid=" + admaruout.Tag_Generation.Tag_id + "&tagtempid=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + adDetails.Provider_Src_id
		clickTag = base64.StdEncoding.EncodeToString([]byte(clickurl))
	}
	//var Adtype string
	var clickTrack string
	impurl := config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Impression?req_id=" + adDetails.Request_id + "&adsource_id=" + adDetails.Adsourceid + "&adunit_id=" + admaruout.Adunit_details.Adunit_id + "&provider_id=" + admaruout.Provider_id + "&publisher_id=" + admaruout.Adunit_details.Publisher + "&tagid=" + admaruout.Tag_Generation.Tag_id + "&tagtempid=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + adDetails.Provider_Src_id + "&won_price=" + adDetails.Bidprice + "&res_cur=" + admaruout.Bidding_currency + "&owned_by=" + adDetails.Owned_by

	track := config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Event_Track?req_id=" + adDetails.Request_id + "&adsource_id=" + adDetails.Adsourceid + "&adunitid=" + admaruout.Adunit_details.Adunit_id + "&provider_id=" + admaruout.Provider_id + "&publisher_id=" + admaruout.Adunit_details.Publisher + "&tagid=" + admaruout.Tag_Generation.Tag_id + "&tagtempid=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + adDetails.Provider_Src_id

	viewimpression := config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Viewable_Imp?req_id=" + adDetails.Request_id + "&adsource_id=" + adDetails.Adsourceid + "&adunit_id=" + admaruout.Adunit_details.Adunit_id + "&provider_id=" + admaruout.Provider_id + "&publisher_id=" + admaruout.Adunit_details.Publisher + "&tag_id=" + admaruout.Tag_Generation.Tag_id + "&tagtemp_id=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + adDetails.Provider_Src_id + "&loc=" + admaruout.R.Header.Get("Referer")

	_5sView := config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Event_Track?req_id=" + adDetails.Request_id + "&adsource_id=" + adDetails.Adsourceid + "&adunitid=" + admaruout.Adunit_details.Adunit_id + "&provider_id=" + admaruout.Provider_id + "&publisher_id=" + admaruout.Adunit_details.Publisher + "&tagid=" + admaruout.Tag_Generation.Tag_id + "&tagtempid=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + adDetails.Provider_Src_id + "&event=5sView"

	var videoUrl string
	if adDetails.Adtype == "V_LINK" {
		video := vplatformLink.Platform_link
		videoSrc := base64.StdEncoding.EncodeToString([]byte(video))

		videoUrl = config.GetConfig("commonpath", "file") + `VastGen?adunitid=` + admaruout.Adsource_id + `&video=` + videoSrc + `&name=` + adDetails.Name + `&clickurl=` + clickTag + `&impurl=` + base64.StdEncoding.EncodeToString([]byte(impurl)) + `&track=` + base64.StdEncoding.EncodeToString([]byte(track)) + `&duration=` + fmt.Sprintf("%f", vplatformLink.Duration) + "&loc=" + admaruout.R.Header.Get("Referer") + "&skipoftime=" + helper.IntToString(template_settings.Skip.SkipTime)
		clickTrack = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Click?requestid=" + adDetails.Request_id + "&adsourceid=" + adDetails.Adsourceid + "&adunitid=" + admaruout.Adunit_details.Adunit_id + "&Providerid=" + admaruout.Provider_id + "&Publisherid=" + admaruout.Adunit_details.Publisher + "&tagid=" + admaruout.Tag_Generation.Tag_id + "&tagtempid=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + adDetails.Provider_Src_id + "&loc=" + admaruout.R.Header.Get("Referer") + `&duration=` + fmt.Sprintf("%f", vplatformLink.Duration)

	} else if adDetails.Adtype == "V_VAST" {

		videoUrl = vastUrl.Vast_link

		clickTrack = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Click?requestid=" + adDetails.Request_id + "&adsourceid=" + adDetails.Adsourceid + "&adunitid=" + admaruout.Adunit_details.Adunit_id + "&Providerid=" + admaruout.Provider_id + "&Publisherid=" + admaruout.Adunit_details.Publisher + "&tagid=" + admaruout.Tag_Generation.Tag_id + "&tagtempid=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + adDetails.Provider_Src_id + "&loc=" + admaruout.R.Header.Get("Referer")

	} else if adDetails.Adtype == "V_LINEAR" {
		video1 := config.GetConfig("protocol", "webpath") + config.GetConfig("images", "webpath") + `/` + adDetails.FileName
		videoSrc1 := base64.StdEncoding.EncodeToString([]byte(video1))
		if admaruout.Adunit_type == "Adapter" && clickThrough.ClickThrough != "" {
			clickTag = base64.StdEncoding.EncodeToString([]byte(clickThrough.ClickThrough))
			clickTrack = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Click?requestid=" + adDetails.Request_id + "&adsourceid=" + adDetails.Adsourceid + "&adunitid=" + admaruout.Adunit_details.Adunit_id + "&Providerid=" + admaruout.Provider_id + "&Publisherid=" + admaruout.Adunit_details.Publisher + "&tagid=" + admaruout.Tag_Generation.Tag_id + "&tagtempid=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + adDetails.Provider_Src_id + "&loc=" + admaruout.R.Header.Get("Referer")
		}
		videoUrl = config.GetConfig("commonpath", "file") + `VastGen?adunitid=` + admaruout.Adsource_id + `&video=` + videoSrc1 + `&name=` + adDetails.Name + `&clickurl=` + clickTag + `&impurl=` + base64.StdEncoding.EncodeToString([]byte(impurl)) + `&track=` + base64.StdEncoding.EncodeToString([]byte(track)) + "&loc=" + admaruout.R.Header.Get("Referer") + `&duration=` + fmt.Sprintf("%f", clickThrough.Duration) + "&skipoftime=" + helper.IntToString(template_settings.Skip.SkipTime)

	}
	if admaruout.Adunit_type == "Adapter" {

		admaruout.AdapterFinalAdsource = adDetails

		admaruout.AdapterPrice = adDetails.Bidprice
		admaruout.AdapterAdtype = "Direct"

	}
	video_url := config.GetConfig("source", "video")
	var imptest string
	imptest = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Impression?req_id=" + adDetails.Request_id + "&adsource_id=" + adDetails.Adsourceid + "&adunit_id=" + admaruout.Adunit_details.Adunit_id + "&provider_id=" + admaruout.Provider_id + "&publisher_id=" + admaruout.Adunit_details.Publisher + "&tagid=" + admaruout.Tag_Generation.Tag_id + "&tagtempid=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + adDetails.Provider_Src_id + "&won_price=" + adDetails.Bidprice + "&loc=" + admaruout.R.Header.Get("Referer") + "&res_cur=" + admaruout.Bidding_currency + "&owned_by=" + adDetails.Owned_by

	if adDetails.Adtype != "V_VAST" {

		track = ""
	}
	VideoJsPlayer(admaruout, adDetails.Adsourceid, videoUrl, video_url, clickTrack, adDetails.Adtype, viewimpression, imptest, "", track, _5sView, "Direct")
	admaruout.Internal_ad = true

	if admaruout.Adunit_type == "Adapter" {
		admaruout.AdapterVASTtag = videoUrl
		admaruout.AdapterVastTracking = _5sView
		admaruout.AdapterVASTClick = clickTrack
		admaruout.AdapterVASTImpression = imptest
		admaruout.AdapterDeliverAdType = adDetails.Adtype
		admaruout.AdapterTrackingURL = track
	}
}
func VideoJsPlayer(admaruout *structure.AdmaruOutput, adsource_id string, videoUrl string, src_url string, clickTrack string, Adtype string, viewimpression string, impression string, cookiesync string, track string, _5sView string, Deliveryadtype string) {

	var RTBvideosrc string
	if Deliveryadtype == "RTB" {
		clickssrc22 := strings.Replace(videoUrl, "\n", "", -1)
		clickssrc22 = strings.Replace(clickssrc22, "\t", "", -1)
		clickssrc22 = strings.Replace(clickssrc22, "\"", "'", -1)
		RTBvideosrc = strings.Replace(clickssrc22, "  ", " ", -1)
		videoUrl = ""
	}

	rand := helper.RandToken(5)
	max_impCount := 0

	if admaruout.Autorefreshrand != "" {
		rand = admaruout.Autorefreshrand
		max_impCount++
	} else if admaruout.Autorefreshrand == "" {
		admaruout.Autorefreshrand = rand
	}

	/**********Third Party Tracker Start**********/

	var first1 string
	var first2 string
	var first3 string

	var mid1 string
	var mid2 string
	var mid3 string

	var third1 string
	var third2 string
	var third3 string

	var start1 string
	var start2 string
	var start3 string

	var mute1 string
	var mute2 string
	var mute3 string

	var unmute1 string
	var unmute2 string
	var unmute3 string

	var pause1 string
	var pause2 string
	var pause3 string

	var resume1 string
	var resume2 string
	var resume3 string

	var complete1 string
	var complete2 string
	var complete3 string

	var close1 string
	var close2 string
	var close3 string

	var impression1 string
	var impression2 string
	var impression3 string

	var viewimpression1 string
	var viewimpression2 string
	var viewimpression3 string

	var clicks1 string
	var clicks2 string
	var clicks3 string

	adsoure := fetching.FetchAdsourceTracker(adsource_id)

	if len(adsoure.Data) > 0 {

		for _, v := range adsoure.Data {

			Event := v.Event

			if Event == "1" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					firstimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					firstimg = strings.Replace(firstimg, `\`, ``, -1)

					first1 = firstimg
				} else if Tracker_type == "2" {

					firstsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					firstsrc2 = strings.Replace(firstsrc2, `\`, ``, -1)
					first2 = strings.Replace(firstsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					firstsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					firstsrc3 = strings.Replace(firstsrc3, `\`, ``, -1)
					first3 = strings.Replace(firstsrc3, "  ", " ", -1)
				}
			}

			if Event == "2" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					midimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					midimg = strings.Replace(midimg, `\`, ``, -1)

					mid1 = midimg
				} else if Tracker_type == "2" {

					midsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					midsrc2 = strings.Replace(midsrc2, `\`, ``, -1)
					mid2 = strings.Replace(midsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					midsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					midsrc3 = strings.Replace(midsrc3, `\`, ``, -1)
					mid3 = strings.Replace(midsrc3, "  ", " ", -1)
				}
			}

			if Event == "3" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					thirdimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					thirdimg = strings.Replace(thirdimg, `\`, ``, -1)

					third1 = thirdimg
				} else if Tracker_type == "2" {

					thirdsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					thirdsrc2 = strings.Replace(thirdsrc2, `\`, ``, -1)
					third2 = strings.Replace(thirdsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					thirdsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					thirdsrc3 = strings.Replace(thirdsrc3, `\`, ``, -1)
					third3 = strings.Replace(thirdsrc3, "  ", " ", -1)
				}
			}

			if Event == "5" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					startimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					startimg = strings.Replace(startimg, `\`, ``, -1)

					start1 = startimg
				} else if Tracker_type == "2" {

					startsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					startsrc2 = strings.Replace(startsrc2, `\`, ``, -1)
					start2 = strings.Replace(startsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					startsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					startsrc3 = strings.Replace(startsrc3, `\`, ``, -1)
					start3 = strings.Replace(startsrc3, "  ", " ", -1)
				}
			}

			if Event == "6" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					muteimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					muteimg = strings.Replace(muteimg, `\`, ``, -1)

					mute1 = muteimg
				} else if Tracker_type == "2" {

					mutesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					mutesrc2 = strings.Replace(mutesrc2, `\`, ``, -1)
					mute2 = strings.Replace(mutesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					mutesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					mutesrc3 = strings.Replace(mutesrc3, `\`, ``, -1)
					mute3 = strings.Replace(mutesrc3, "  ", " ", -1)
				}
			}

			if Event == "7" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					unmuteimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					unmuteimg = strings.Replace(unmuteimg, `\`, ``, -1)

					unmute1 = unmuteimg
				} else if Tracker_type == "2" {

					unmutesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					unmutesrc2 = strings.Replace(unmutesrc2, `\`, ``, -1)
					unmute2 = strings.Replace(unmutesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					unmutesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					unmutesrc3 = strings.Replace(unmutesrc3, `\`, ``, -1)
					unmute3 = strings.Replace(unmutesrc3, "  ", " ", -1)
				}
			}

			if Event == "8" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					pauseimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					pauseimg = strings.Replace(pauseimg, `\`, ``, -1)

					pause1 = pauseimg
				} else if Tracker_type == "2" {

					pausesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					pausesrc2 = strings.Replace(pausesrc2, `\`, ``, -1)
					pause2 = strings.Replace(pausesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					pausesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					pausesrc3 = strings.Replace(pausesrc3, `\`, ``, -1)
					pause3 = strings.Replace(pausesrc3, "  ", " ", -1)
				}
			}

			if Event == "9" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					resumeimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					resumeimg = strings.Replace(resumeimg, `\`, ``, -1)

					resume1 = resumeimg
				} else if Tracker_type == "2" {

					resumesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					resumesrc2 = strings.Replace(resumesrc2, `\`, ``, -1)
					resume2 = strings.Replace(resumesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					resumesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					resumesrc3 = strings.Replace(resumesrc3, `\`, ``, -1)
					resume3 = strings.Replace(resumesrc3, "  ", " ", -1)
				}
			}

			if Event == "13" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					closeimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					closeimg = strings.Replace(closeimg, `\`, ``, -1)

					close1 = closeimg
				} else if Tracker_type == "2" {

					closesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					closesrc2 = strings.Replace(closesrc2, `\`, ``, -1)
					close2 = strings.Replace(closesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					closesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					closesrc3 = strings.Replace(closesrc3, `\`, ``, -1)
					close3 = strings.Replace(closesrc3, "  ", " ", -1)
				}
			}

			if Event == "4" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					completeimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					completeimg = strings.Replace(completeimg, `\`, ``, -1)

					complete1 = completeimg
				} else if Tracker_type == "2" {

					completesrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					completesrc2 = strings.Replace(completesrc2, `\`, ``, -1)
					complete2 = strings.Replace(completesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					completesrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					completesrc3 = strings.Replace(completesrc3, `\`, ``, -1)
					complete3 = strings.Replace(completesrc3, "  ", " ", -1)
				}
			}

			if Event == "10" {

				Trackertype := v.Tracker_type

				if Trackertype == "1" {

					impimgu := strings.Replace(v.Tracker_src, "\n", "", -1)
					impimgu = strings.Replace(impimgu, `\`, ``, -1)

					impression1 = impimgu
				} else if Trackertype == "2" {

					impsrcu := strings.Replace(v.Tracker_src, "\n", "", -1)
					impsrcu = strings.Replace(impsrcu, `\`, ``, -1)
					impression2 = strings.Replace(impsrcu, "  ", " ", -1)

				} else if Trackertype == "3" {

					impsrcf := strings.Replace(v.Tracker_src, "\n", "", -1)
					impsrcf = strings.Replace(impsrcf, `\`, ``, -1)
					impression3 = strings.Replace(impsrcf, "  ", " ", -1)
				}
			}

			if Event == "11" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					viewimpimgi := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpimgi = strings.Replace(viewimpimgi, `\`, ``, -1)

					viewimpression1 = viewimpimgi
				} else if Tracker_type == "2" {

					viewimpsrc2i := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpsrc2i = strings.Replace(viewimpsrc2i, `\`, ``, -1)
					viewimpression2 = strings.Replace(viewimpsrc2i, "  ", " ", -1)

				} else if Tracker_type == "3" {

					viewimpsrc3i := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpsrc3i = strings.Replace(viewimpsrc3i, `\`, ``, -1)
					viewimpression3 = strings.Replace(viewimpsrc3i, "  ", " ", -1)
				}
			}

			if Event == "12" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					clicksimg1 := strings.Replace(v.Tracker_src, "\n", "", -1)
					clicksimg1 = strings.Replace(clicksimg1, `\`, ``, -1)

					clicks1 = clicksimg1
				} else if Tracker_type == "2" {

					clickssrcu2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					clickssrcu2 = strings.Replace(clickssrcu2, `\`, ``, -1)
					clicks2 = strings.Replace(clickssrcu2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					clickssrcu3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					clickssrcu3 = strings.Replace(clickssrcu3, `\`, ``, -1)
					clicks3 = strings.Replace(clickssrcu3, "  ", " ", -1)
				}
			}
		}
	}

	var adu_first1 string
	var adu_first2 string
	var adu_first3 string

	var adu_mid1 string
	var adu_mid2 string
	var adu_mid3 string

	var adu_third1 string
	var adu_third2 string
	var adu_third3 string

	var adu_start1 string
	var adu_start2 string
	var adu_start3 string

	var adu_mute1 string
	var adu_mute2 string
	var adu_mute3 string

	var adu_unmute1 string
	var adu_unmute2 string
	var adu_unmute3 string

	var adu_pause1 string
	var adu_pause2 string
	var adu_pause3 string

	var adu_resume1 string
	var adu_resume2 string
	var adu_resume3 string

	var adu_complete1 string
	var adu_complete2 string
	var adu_complete3 string

	var adu_close1 string
	var adu_close2 string
	var adu_close3 string

	var adu_impression1 string
	var adu_impression2 string
	var adu_impression3 string

	var adu_viewimpression1 string
	var adu_viewimpression2 string
	var adu_viewimpression3 string

	var adu_clicks1 string
	var adu_clicks2 string
	var adu_clicks3 string

	adunit := fetching.FetchAdunitTracker(admaruout.Adunit_details.Adunit_id)

	if len(adunit.Data) > 0 {

		for _, val := range adunit.Data {

			Event1 := val.Event

			if Event1 == "1" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					firstimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					firstimg = strings.Replace(firstimg, `\`, ``, -1)

					adu_first1 = firstimg
				} else if Tracker_type == "2" {

					firstsrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					firstsrc2 = strings.Replace(firstsrc2, `\`, ``, -1)
					adu_first2 = strings.Replace(firstsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					firstsrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					firstsrc3 = strings.Replace(firstsrc3, `\`, ``, -1)
					adu_first3 = strings.Replace(firstsrc3, "  ", " ", -1)
				}
			}

			if Event1 == "2" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					midimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					midimg = strings.Replace(midimg, `\`, ``, -1)

					adu_mid1 = midimg
				} else if Tracker_type == "2" {

					midsrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					midsrc2 = strings.Replace(midsrc2, `\`, ``, -1)
					adu_mid2 = strings.Replace(midsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					midsrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					midsrc3 = strings.Replace(midsrc3, `\`, ``, -1)
					adu_mid3 = strings.Replace(midsrc3, "  ", " ", -1)
				}
			}

			if Event1 == "3" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					thirdimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					thirdimg = strings.Replace(thirdimg, `\`, ``, -1)

					adu_third1 = thirdimg
				} else if Tracker_type == "2" {

					thirdsrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					thirdsrc2 = strings.Replace(thirdsrc2, `\`, ``, -1)
					adu_third2 = strings.Replace(thirdsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					thirdsrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					thirdsrc3 = strings.Replace(thirdsrc3, `\`, ``, -1)
					adu_third3 = strings.Replace(thirdsrc3, "  ", " ", -1)
				}
			}

			if Event1 == "5" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					startimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					startimg = strings.Replace(startimg, `\`, ``, -1)

					adu_start1 = startimg
				} else if Tracker_type == "2" {

					startsrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					startsrc2 = strings.Replace(startsrc2, `\`, ``, -1)
					adu_start2 = strings.Replace(startsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					startsrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					startsrc3 = strings.Replace(startsrc3, `\`, ``, -1)
					adu_start3 = strings.Replace(startsrc3, "  ", " ", -1)
				}
			}

			if Event1 == "6" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					muteimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					muteimg = strings.Replace(muteimg, `\`, ``, -1)

					adu_mute1 = muteimg
				} else if Tracker_type == "2" {

					mutesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					mutesrc2 = strings.Replace(mutesrc2, `\`, ``, -1)
					adu_mute2 = strings.Replace(mutesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					mutesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					mutesrc3 = strings.Replace(mutesrc3, `\`, ``, -1)
					adu_mute3 = strings.Replace(mutesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "7" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					unmuteimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					unmuteimg = strings.Replace(unmuteimg, `\`, ``, -1)

					adu_unmute1 = unmuteimg
				} else if Tracker_type == "2" {

					unmutesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					unmutesrc2 = strings.Replace(unmutesrc2, `\`, ``, -1)
					adu_unmute2 = strings.Replace(unmutesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					unmutesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					unmutesrc3 = strings.Replace(unmutesrc3, `\`, ``, -1)
					adu_unmute3 = strings.Replace(unmutesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "8" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					pauseimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					pauseimg = strings.Replace(pauseimg, `\`, ``, -1)

					adu_pause1 = pauseimg
				} else if Tracker_type == "2" {

					pausesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					pausesrc2 = strings.Replace(pausesrc2, `\`, ``, -1)
					adu_pause2 = strings.Replace(pausesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					pausesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					pausesrc3 = strings.Replace(pausesrc3, `\`, ``, -1)
					adu_pause3 = strings.Replace(pausesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "9" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					resumeimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					resumeimg = strings.Replace(resumeimg, `\`, ``, -1)

					adu_resume1 = resumeimg
				} else if Tracker_type == "2" {

					resumesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					resumesrc2 = strings.Replace(resumesrc2, `\`, ``, -1)
					adu_resume2 = strings.Replace(resumesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					resumesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					resumesrc3 = strings.Replace(resumesrc3, `\`, ``, -1)
					adu_resume3 = strings.Replace(resumesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "13" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					closeimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					closeimg = strings.Replace(closeimg, `\`, ``, -1)

					adu_close1 = closeimg
				} else if Tracker_type == "2" {

					closesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					closesrc2 = strings.Replace(closesrc2, `\`, ``, -1)
					adu_close2 = strings.Replace(closesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					closesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					closesrc3 = strings.Replace(closesrc3, `\`, ``, -1)
					adu_close3 = strings.Replace(closesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "4" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					completeimg := strings.Replace(val.Tracker_src, "\n", "", -1)
					completeimg = strings.Replace(completeimg, `\`, ``, -1)

					adu_complete1 = completeimg
				} else if Tracker_type == "2" {

					completesrc2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					completesrc2 = strings.Replace(completesrc2, `\`, ``, -1)
					adu_complete2 = strings.Replace(completesrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					completesrc3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					completesrc3 = strings.Replace(completesrc3, `\`, ``, -1)
					adu_complete3 = strings.Replace(completesrc3, "  ", " ", -1)
				}
			}

			if Event1 == "10" {

				Trackertype := val.Tracker_type

				if Trackertype == "1" {

					impimgu := strings.Replace(val.Tracker_src, "\n", "", -1)
					impimgu = strings.Replace(impimgu, `\`, ``, -1)

					adu_impression1 = impimgu
				} else if Trackertype == "2" {

					impsrcu := strings.Replace(val.Tracker_src, "\n", "", -1)
					impsrcu = strings.Replace(impsrcu, `\`, ``, -1)
					adu_impression2 = strings.Replace(impsrcu, "  ", " ", -1)

				} else if Trackertype == "3" {

					impsrcf := strings.Replace(val.Tracker_src, "\n", "", -1)
					impsrcf = strings.Replace(impsrcf, `\`, ``, -1)
					adu_impression3 = strings.Replace(impsrcf, "  ", " ", -1)
				}
			}

			if Event1 == "11" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					viewimpimgi := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpimgi = strings.Replace(viewimpimgi, `\`, ``, -1)

					adu_viewimpression1 = viewimpimgi
				} else if Tracker_type == "2" {

					viewimpsrc2i := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpsrc2i = strings.Replace(viewimpsrc2i, `\`, ``, -1)
					adu_viewimpression2 = strings.Replace(viewimpsrc2i, "  ", " ", -1)

				} else if Tracker_type == "3" {

					viewimpsrc3i := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpsrc3i = strings.Replace(viewimpsrc3i, `\`, ``, -1)
					adu_viewimpression3 = strings.Replace(viewimpsrc3i, "  ", " ", -1)
				}
			}

			if Event1 == "12" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					clicksimg1 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clicksimg1 = strings.Replace(clicksimg1, `\`, ``, -1)

					adu_clicks1 = clicksimg1
				} else if Tracker_type == "2" {

					clickssrcu2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clickssrcu2 = strings.Replace(clickssrcu2, `\`, ``, -1)
					adu_clicks2 = strings.Replace(clickssrcu2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					clickssrcu3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clickssrcu3 = strings.Replace(clickssrcu3, `\`, ``, -1)
					adu_clicks3 = strings.Replace(clickssrcu3, "  ", " ", -1)
				}
			}
		}
	}

	if impression1 != "" || impression2 != "" || impression3 != "" {

		if impression2 != "" {
			impression2 = strings.Replace(impression2, "\n", "", -1)
			impression2 = strings.Replace(impression2, `</script>`, `<\/script>`, -1)
		}
		if impression3 != "" {
			impression3 = strings.Replace(impression3, `</script>`, `<\/script>`, -1)
			impression3 = strings.Replace(impression3, "\n", "", -1)
		}
	}
	if clicks1 != "" || clicks2 != "" || clicks3 != "" {

		if clicks2 != "" {
			clicks2 = strings.Replace(clicks2, "\n", "", -1)
			clicks2 = strings.Replace(clicks2, `</script>`, `<\/script>`, -1)
		}
		if clicks3 != "" {
			clicks3 = strings.Replace(clicks3, `</script>`, `<\/script>`, -1)
			clicks3 = strings.Replace(clicks3, "\n", "", -1)
		}
	}
	if viewimpression1 != "" || viewimpression2 != "" || viewimpression3 != "" {

		if viewimpression2 != "" {
			viewimpression2 = strings.Replace(viewimpression2, "\n", "", -1)
			viewimpression2 = strings.Replace(viewimpression2, `</script>`, `<\/script>`, -1)
		}
		if viewimpression3 != "" {
			viewimpression3 = strings.Replace(viewimpression3, `</script>`, `<\/script>`, -1)
			viewimpression3 = strings.Replace(viewimpression3, "\n", "", -1)
		}
	}

	if first1 != "" || first2 != "" || first3 != "" {

		if first2 != "" {
			first2 = strings.Replace(first2, "\n", "", -1)
			first2 = strings.Replace(first2, `</script>`, `<\/script>`, -1)
		}
		if first3 != "" {
			first3 = strings.Replace(first3, `</script>`, `<\/script>`, -1)
			first3 = strings.Replace(first3, "\n", "", -1)
		}
	}
	if mid1 != "" || mid2 != "" || mid3 != "" {

		if mid2 != "" {
			mid2 = strings.Replace(mid2, "\n", "", -1)
			mid2 = strings.Replace(mid2, `</script>`, `<\/script>`, -1)
		}
		if mid3 != "" {
			mid3 = strings.Replace(mid3, `</script>`, `<\/script>`, -1)
			mid3 = strings.Replace(mid3, "\n", "", -1)
		}
	}
	if third1 != "" || third2 != "" || third3 != "" {

		if third2 != "" {
			third2 = strings.Replace(third2, "\n", "", -1)
			third2 = strings.Replace(third2, `</script>`, `<\/script>`, -1)
		}
		if third3 != "" {
			third3 = strings.Replace(third3, `</script>`, `<\/script>`, -1)
			third3 = strings.Replace(third3, "\n", "", -1)
		}
	}

	if start1 != "" || start2 != "" || start3 != "" {

		if start2 != "" {
			start2 = strings.Replace(start2, "\n", "", -1)
			start2 = strings.Replace(start2, `</script>`, `<\/script>`, -1)
		}
		if start3 != "" {
			start3 = strings.Replace(start3, `</script>`, `<\/script>`, -1)
			start3 = strings.Replace(start3, "\n", "", -1)
		}
	}
	if mute1 != "" || mute2 != "" || mute3 != "" {

		if mute2 != "" {
			mute2 = strings.Replace(mute2, "\n", "", -1)
			mute2 = strings.Replace(mute2, `</script>`, `<\/script>`, -1)
		}
		if mute3 != "" {
			mute3 = strings.Replace(mute3, `</script>`, `<\/script>`, -1)
			mute3 = strings.Replace(mute3, "\n", "", -1)
		}
	}
	if unmute1 != "" || unmute2 != "" || unmute3 != "" {

		if unmute2 != "" {
			unmute2 = strings.Replace(unmute2, "\n", "", -1)
			unmute2 = strings.Replace(unmute2, `</script>`, `<\/script>`, -1)
		}
		if unmute3 != "" {
			unmute3 = strings.Replace(unmute3, `</script>`, `<\/script>`, -1)
			unmute3 = strings.Replace(unmute3, "\n", "", -1)
		}
	}

	if pause1 != "" || pause2 != "" || pause3 != "" {

		if pause2 != "" {
			pause2 = strings.Replace(pause2, "\n", "", -1)
			pause2 = strings.Replace(pause2, `</script>`, `<\/script>`, -1)
		}
		if pause3 != "" {
			pause3 = strings.Replace(pause3, `</script>`, `<\/script>`, -1)
			pause3 = strings.Replace(pause3, "\n", "", -1)
		}
	}
	if complete1 != "" || complete2 != "" || complete3 != "" {

		if complete2 != "" {
			complete2 = strings.Replace(complete2, "\n", "", -1)
			complete2 = strings.Replace(complete2, `</script>`, `<\/script>`, -1)
		}
		if complete3 != "" {
			complete3 = strings.Replace(complete3, `</script>`, `<\/script>`, -1)
			complete3 = strings.Replace(complete3, "\n", "", -1)
		}
	}

	if resume1 != "" || resume2 != "" || resume3 != "" {

		if resume2 != "" {
			resume2 = strings.Replace(resume2, "\n", "", -1)
			resume2 = strings.Replace(resume2, `</script>`, `<\/script>`, -1)
		}
		if resume3 != "" {
			resume3 = strings.Replace(resume3, `</script>`, `<\/script>`, -1)
			resume3 = strings.Replace(resume3, "\n", "", -1)
		}
	}
	if close1 != "" || close2 != "" || close3 != "" {

		if close2 != "" {
			close2 = strings.Replace(close2, "\n", "", -1)
			close2 = strings.Replace(close2, `</script>`, `<\/script>`, -1)
		}
		if close3 != "" {
			close3 = strings.Replace(close3, `</script>`, `<\/script>`, -1)
			close3 = strings.Replace(close3, "\n", "", -1)
		}
	}

	if adu_impression1 != "" || adu_impression2 != "" || adu_impression3 != "" {

		if adu_impression2 != "" {
			adu_impression2 = strings.Replace(adu_impression2, "\n", "", -1)
			adu_impression2 = strings.Replace(adu_impression2, `</script>`, `<\/script>`, -1)
		}
		if adu_impression3 != "" {
			adu_impression3 = strings.Replace(adu_impression3, `</script>`, `<\/script>`, -1)
			adu_impression3 = strings.Replace(adu_impression3, "\n", "", -1)
		}
	}
	if adu_clicks1 != "" || adu_clicks2 != "" || adu_clicks3 != "" {

		if adu_clicks2 != "" {
			adu_clicks2 = strings.Replace(adu_clicks2, "\n", "", -1)
			adu_clicks2 = strings.Replace(adu_clicks2, `</script>`, `<\/script>`, -1)
		}
		if adu_clicks3 != "" {
			adu_clicks3 = strings.Replace(adu_clicks3, `</script>`, `<\/script>`, -1)
			adu_clicks3 = strings.Replace(adu_clicks3, "\n", "", -1)
		}
	}
	if adu_viewimpression1 != "" || adu_viewimpression2 != "" || adu_viewimpression3 != "" {

		if adu_viewimpression2 != "" {
			adu_viewimpression2 = strings.Replace(adu_viewimpression2, "\n", "", -1)
			adu_viewimpression2 = strings.Replace(adu_viewimpression2, `</script>`, `<\/script>`, -1)
		}
		if adu_viewimpression3 != "" {
			adu_viewimpression3 = strings.Replace(adu_viewimpression3, `</script>`, `<\/script>`, -1)
			adu_viewimpression3 = strings.Replace(adu_viewimpression3, "\n", "", -1)
		}
	}

	if adu_first1 != "" || adu_first2 != "" || adu_first3 != "" {

		if adu_first2 != "" {
			adu_first2 = strings.Replace(adu_first2, "\n", "", -1)
			adu_first2 = strings.Replace(adu_first2, `</script>`, `<\/script>`, -1)
		}
		if adu_first3 != "" {
			adu_first3 = strings.Replace(adu_first3, `</script>`, `<\/script>`, -1)
			adu_first3 = strings.Replace(adu_first3, "\n", "", -1)
		}
	}
	if adu_mid1 != "" || adu_mid2 != "" || adu_mid3 != "" {

		if adu_mid2 != "" {
			adu_mid2 = strings.Replace(adu_mid2, "\n", "", -1)
			adu_mid2 = strings.Replace(adu_mid2, `</script>`, `<\/script>`, -1)
		}
		if adu_mid3 != "" {
			adu_mid3 = strings.Replace(adu_mid3, `</script>`, `<\/script>`, -1)
			adu_mid3 = strings.Replace(adu_mid3, "\n", "", -1)
		}
	}
	if adu_third1 != "" || adu_third2 != "" || adu_third3 != "" {

		if adu_third2 != "" {
			adu_third2 = strings.Replace(adu_third2, "\n", "", -1)
			adu_third2 = strings.Replace(adu_third2, `</script>`, `<\/script>`, -1)
		}
		if adu_third3 != "" {
			adu_third3 = strings.Replace(adu_third3, `</script>`, `<\/script>`, -1)
			adu_third3 = strings.Replace(adu_third3, "\n", "", -1)
		}
	}

	if adu_start1 != "" || adu_start2 != "" || adu_start3 != "" {

		if adu_start2 != "" {
			adu_start2 = strings.Replace(adu_start2, "\n", "", -1)
			adu_start2 = strings.Replace(adu_start2, `</script>`, `<\/script>`, -1)
		}
		if adu_start3 != "" {
			adu_start3 = strings.Replace(adu_start3, `</script>`, `<\/script>`, -1)
			adu_start3 = strings.Replace(adu_start3, "\n", "", -1)
		}
	}
	if adu_mute1 != "" || adu_mute2 != "" || adu_mute3 != "" {

		if adu_mute2 != "" {
			adu_mute2 = strings.Replace(adu_mute2, "\n", "", -1)
			adu_mute2 = strings.Replace(adu_mute2, `</script>`, `<\/script>`, -1)
		}
		if adu_mute3 != "" {
			adu_mute3 = strings.Replace(adu_mute3, `</script>`, `<\/script>`, -1)
			adu_mute3 = strings.Replace(adu_mute3, "\n", "", -1)
		}
	}
	if adu_unmute1 != "" || adu_unmute2 != "" || adu_unmute3 != "" {

		if adu_unmute2 != "" {
			adu_unmute2 = strings.Replace(adu_unmute2, "\n", "", -1)
			adu_unmute2 = strings.Replace(adu_unmute2, `</script>`, `<\/script>`, -1)
		}
		if adu_unmute3 != "" {
			adu_unmute3 = strings.Replace(adu_unmute3, `</script>`, `<\/script>`, -1)
			adu_unmute3 = strings.Replace(adu_unmute3, "\n", "", -1)
		}
	}

	if adu_pause1 != "" || adu_pause2 != "" || adu_pause3 != "" {

		if adu_pause2 != "" {
			adu_pause2 = strings.Replace(adu_pause2, "\n", "", -1)
			adu_pause2 = strings.Replace(adu_pause2, `</script>`, `<\/script>`, -1)
		}
		if adu_pause3 != "" {
			adu_pause3 = strings.Replace(adu_pause3, `</script>`, `<\/script>`, -1)
			adu_pause3 = strings.Replace(adu_pause3, "\n", "", -1)
		}
	}
	if adu_complete1 != "" || adu_complete2 != "" || adu_complete3 != "" {

		if adu_complete2 != "" {
			adu_complete2 = strings.Replace(adu_complete2, "\n", "", -1)
			adu_complete2 = strings.Replace(adu_complete2, `</script>`, `<\/script>`, -1)
		}
		if adu_complete3 != "" {
			adu_complete3 = strings.Replace(adu_complete3, `</script>`, `<\/script>`, -1)
			adu_complete3 = strings.Replace(adu_complete3, "\n", "", -1)
		}
	}

	if adu_resume1 != "" || adu_resume2 != "" || adu_resume3 != "" {

		if adu_resume2 != "" {
			adu_resume2 = strings.Replace(adu_resume2, "\n", "", -1)
			adu_resume2 = strings.Replace(adu_resume2, `</script>`, `<\/script>`, -1)
		}
		if adu_resume3 != "" {
			adu_resume3 = strings.Replace(adu_resume3, `</script>`, `<\/script>`, -1)
			adu_resume3 = strings.Replace(adu_resume3, "\n", "", -1)
		}
	}
	if adu_close1 != "" || adu_close2 != "" || adu_close3 != "" {

		if adu_close2 != "" {
			adu_close2 = strings.Replace(adu_close2, "\n", "", -1)
			adu_close2 = strings.Replace(adu_close2, `</script>`, `<\/script>`, -1)
		}
		if adu_close3 != "" {
			adu_close3 = strings.Replace(adu_close3, `</script>`, `<\/script>`, -1)
			adu_close3 = strings.Replace(adu_close3, "\n", "", -1)
		}
	}

	var _3rd_img_firstQuartile string
	var _3rd_js_firstQuartile string
	var _3rd_iframe_firstQuartile string

	var _3rd_img_midpoint string
	var _3rd_js_midpoint string
	var _3rd_iframe_midpoint string

	var _3rd_img_thirdQuartile string
	var _3rd_js_thirdQuartile string
	var _3rd_iframe_thirdQuartile string

	var _3rd_img_pause string
	var _3rd_js_pause string
	var _3rd_iframe_pause string

	var _3rd_img_resume string
	var _3rd_js_resume string
	var _3rd_iframe_resume string

	var _3rd_img_mute string
	var _3rd_js_mute string
	var _3rd_iframe_mute string

	var _3rd_img_unmute string
	var _3rd_js_unmute string
	var _3rd_iframe_unmute string

	var _3rd_img_skip string
	var _3rd_js_skip string
	var _3rd_iframe_skip string

	var _3rd_img_impression string
	var _3rd_js_impression string
	var _3rd_iframe_impression string

	var _3rd_img_viewableImpression string
	var _3rd_js_viewableImpression string
	var _3rd_iframe_viewableImpression string

	var _3rd_img_click string
	var _3rd_js_click string
	var _3rd_iframe_click string

	var _3rd_img_start string
	var _3rd_js_start string
	var _3rd_iframe_start string

	var _3rd_img_complete string
	var _3rd_js_complete string
	var _3rd_iframe_complete string

	var _3rd_img_close string
	var _3rd_js_close string
	var _3rd_iframe_close string

	if first1 != "" && adu_first1 != "" {

		_3rd_img_firstQuartile = `_3rd_img_firstQuartile: ["` + first1 + `", "` + adu_first1 + `"],`
	} else if first1 != "" {

		_3rd_img_firstQuartile = `_3rd_img_firstQuartile: ["` + first1 + `"],`

	} else if adu_first1 != "" {

		_3rd_img_firstQuartile = `_3rd_img_firstQuartile: ["` + adu_first1 + `"],`
	}

	if first2 != "" && adu_first2 != "" {

		_3rd_js_firstQuartile = `_3rd_js_firstQuartile: ["` + first2 + `", "` + adu_first2 + `"],`
	} else if first2 != "" {

		_3rd_js_firstQuartile = `_3rd_js_firstQuartile: ["` + first2 + `"],`

	} else if adu_first2 != "" {

		_3rd_js_firstQuartile = `_3rd_js_firstQuartile: ["` + adu_first2 + `"],`

	}

	if first3 != "" && adu_first3 != "" {

		_3rd_iframe_firstQuartile = `_3rd_iframe_firstQuartile: ["` + first3 + `", "` + adu_first3 + `"],`
	} else if first3 != "" {

		_3rd_iframe_firstQuartile = `_3rd_iframe_firstQuartile: ["` + first3 + `"],`

	} else if adu_first3 != "" {

		_3rd_iframe_firstQuartile = `_3rd_iframe_firstQuartile: ["` + adu_first3 + `"],`

	}

	if mid1 != "" && adu_mid1 != "" {

		_3rd_img_midpoint = `_3rd_img_midpoint: ["` + mid1 + `", "` + adu_mid1 + `"],`
	} else if mid1 != "" {

		_3rd_img_midpoint = `_3rd_img_midpoint: ["` + mid1 + `"],`

	} else if adu_mid1 != "" {

		_3rd_img_midpoint = `_3rd_img_midpoint: ["` + adu_mid1 + `"],`

	}

	if mid2 != "" && adu_mid2 != "" {

		_3rd_js_midpoint = `_3rd_js_midpoint: ["` + mid2 + `", "` + adu_mid2 + `"],`
	} else if mid2 != "" {

		_3rd_js_midpoint = `_3rd_js_midpoint: ["` + mid2 + `"],`

	} else if adu_mid2 != "" {

		_3rd_js_midpoint = `_3rd_js_midpoint: ["` + adu_mid2 + `"],`

	}

	if mid3 != "" && adu_mid3 != "" {
		_3rd_iframe_midpoint = `_3rd_iframe_midpoint: ["` + mid3 + `", "` + adu_mid3 + `"],`
	} else if mid3 != "" {
		_3rd_iframe_midpoint = `_3rd_iframe_midpoint: ["` + mid3 + `"],`
	} else if adu_mid3 != "" {
		_3rd_iframe_midpoint = `_3rd_iframe_midpoint: ["` + adu_mid3 + `"],`
	}

	if third1 != "" && adu_third1 != "" {

		_3rd_img_thirdQuartile = `_3rd_img_thirdQuartile: ["` + third1 + `", "` + adu_third1 + `"],`

	} else if third1 != "" {

		_3rd_img_thirdQuartile = `_3rd_img_thirdQuartile: ["` + third1 + `"],`

	} else if adu_third1 != "" {

		_3rd_img_thirdQuartile = `_3rd_img_thirdQuartile: ["` + adu_third1 + `"],`

	}

	if third2 != "" && adu_third2 != "" {

		_3rd_js_thirdQuartile = `_3rd_js_thirdQuartile: ["` + third2 + `", "` + adu_third2 + `"],`

	} else if third2 != "" {

		_3rd_js_thirdQuartile = `_3rd_js_thirdQuartile: ["` + third2 + `"],`

	} else if adu_third2 != "" {

		_3rd_js_thirdQuartile = `_3rd_js_thirdQuartile: ["` + adu_third2 + `"],`

	}

	if third3 != "" && adu_third3 != "" {

		_3rd_iframe_thirdQuartile = `_3rd_iframe_thirdQuartile: ["` + third3 + `", "` + adu_third3 + `"],`

	} else if third3 != "" {

		_3rd_iframe_thirdQuartile = `_3rd_iframe_thirdQuartile: ["` + third3 + `"],`

	} else if adu_third3 != "" {

		_3rd_iframe_thirdQuartile = `_3rd_iframe_thirdQuartile: ["` + adu_third3 + `"],`

	}

	if pause1 != "" && adu_pause1 != "" {

		_3rd_img_pause = `_3rd_img_pause: ["` + pause1 + `", "` + adu_pause1 + `"],`

	} else if pause1 != "" {

		_3rd_img_pause = `_3rd_img_pause: ["` + pause1 + `"],`

	} else if adu_pause1 != "" {

		_3rd_img_pause = `_3rd_img_pause: ["` + adu_pause1 + `"],`

	}

	if pause2 != "" && adu_pause2 != "" {

		_3rd_js_pause = `_3rd_js_pause: ["` + pause2 + `", "` + adu_pause2 + `"],`

	} else if pause2 != "" {

		_3rd_js_pause = `_3rd_js_pause: ["` + pause2 + `"],`

	} else if adu_pause2 != "" {

		_3rd_js_pause = `_3rd_js_pause: ["` + adu_pause2 + `"],`

	}

	if pause3 != "" && adu_pause3 != "" {

		_3rd_iframe_pause = `_3rd_iframe_pause: ["` + pause3 + `", "` + adu_pause3 + `"],`

	} else if pause3 != "" {

		_3rd_iframe_pause = `_3rd_iframe_pause: ["` + pause3 + `"],`

	} else if adu_pause3 != "" {

		_3rd_iframe_pause = `_3rd_iframe_pause: ["` + adu_pause3 + `"],`

	}

	if resume1 != "" && adu_resume1 != "" {

		_3rd_img_resume = `_3rd_img_resume: ["` + resume1 + `", "` + adu_resume1 + `"],`

	} else if resume1 != "" {

		_3rd_img_resume = `_3rd_img_resume: ["` + resume1 + `"],`

	} else if adu_resume1 != "" {

		_3rd_img_resume = `_3rd_img_resume: ["` + adu_resume1 + `"],`

	}

	if resume2 != "" && adu_resume2 != "" {

		_3rd_js_resume = `_3rd_js_resume: ["` + resume2 + `", "` + adu_resume2 + `"],`

	} else if resume2 != "" {

		_3rd_js_resume = `_3rd_js_resume: ["` + resume2 + `"],`

	} else if adu_resume2 != "" {

		_3rd_js_resume = `_3rd_js_resume: ["` + adu_resume2 + `"],`

	}

	if resume3 != "" && adu_resume3 != "" {

		_3rd_iframe_resume = `_3rd_iframe_resume: ["` + resume3 + `", "` + adu_resume3 + `"],`

	} else if resume3 != "" {

		_3rd_iframe_resume = `_3rd_iframe_resume: ["` + resume3 + `"],`

	} else if adu_resume3 != "" {

		_3rd_iframe_resume = `_3rd_iframe_resume: ["` + adu_resume3 + `"],`

	}

	if mute1 != "" && adu_mute1 != "" {

		_3rd_img_mute = `_3rd_img_mute: ["` + mute1 + `", "` + adu_mute1 + `"],`

	} else if mute1 != "" {

		_3rd_img_mute = `_3rd_img_mute: ["` + mute1 + `"],`

	} else if adu_mute1 != "" {

		_3rd_img_mute = `_3rd_img_mute: ["` + adu_mute1 + `"],`

	}

	if mute2 != "" && adu_mute2 != "" {

		_3rd_js_mute = `_3rd_js_mute: ["` + mute2 + `", "` + adu_mute2 + `"],`

	} else if mute2 != "" {

		_3rd_js_mute = `_3rd_js_mute: ["` + mute2 + `"],`

	} else if adu_mute2 != "" {

		_3rd_js_mute = `_3rd_js_mute: ["` + adu_mute2 + `"],`

	}

	if mute3 != "" && adu_mute3 != "" {

		_3rd_iframe_mute = `_3rd_iframe_mute: ["` + mute3 + `", "` + adu_mute3 + `"],`

	} else if mute3 != "" {

		_3rd_iframe_mute = `_3rd_iframe_mute: ["` + mute3 + `"],`

	} else if adu_mute3 != "" {

		_3rd_iframe_mute = `_3rd_iframe_mute: ["` + adu_mute3 + `"],`

	}

	if unmute1 != "" && adu_unmute1 != "" {

		_3rd_img_unmute = `_3rd_img_unmute: ["` + unmute1 + `", "` + adu_unmute1 + `"],`

	} else if unmute1 != "" {

		_3rd_img_unmute = `_3rd_img_unmute: ["` + unmute1 + `"],`

	} else if adu_unmute1 != "" {

		_3rd_img_unmute = `_3rd_img_unmute: ["` + adu_unmute1 + `"],`

	}

	if unmute2 != "" && adu_unmute2 != "" {

		_3rd_js_unmute = `_3rd_js_unmute: ["` + unmute2 + `", "` + adu_unmute2 + `"],`

	} else if unmute2 != "" {

		_3rd_js_unmute = `_3rd_js_unmute: ["` + unmute2 + `"],`

	} else if adu_unmute2 != "" {

		_3rd_js_unmute = `_3rd_js_unmute: ["` + adu_unmute2 + `"],`

	}

	if unmute3 != "" && adu_unmute3 != "" {

		_3rd_iframe_unmute = `_3rd_iframe_unmute: ["` + unmute3 + `", "` + adu_unmute3 + `"],`

	} else if unmute3 != "" {

		_3rd_iframe_unmute = `_3rd_iframe_unmute: ["` + unmute3 + `"],`

	} else if adu_unmute3 != "" {

		_3rd_iframe_unmute = `_3rd_iframe_unmute: ["` + adu_unmute3 + `"],`

	}

	if complete1 != "" && adu_complete1 != "" {

		_3rd_img_complete = `_3rd_img_complete: ["` + complete1 + `", "` + adu_complete1 + `"],`

	} else if complete1 != "" {

		_3rd_img_complete = `_3rd_img_complete: ["` + complete1 + `"],`

	} else if adu_complete1 != "" {

		_3rd_img_complete = `_3rd_img_complete: ["` + adu_complete1 + `"],`
	}

	if complete2 != "" && adu_complete2 != "" {

		_3rd_js_complete = `_3rd_js_complete: ["` + complete2 + `", "` + adu_complete2 + `"],`

	} else if complete2 != "" {

		_3rd_js_complete = `_3rd_js_complete: ["` + complete2 + `"],`

	} else if adu_complete2 != "" {

		_3rd_js_complete = `_3rd_js_complete: ["` + adu_complete2 + `"],`

	}

	if complete3 != "" && adu_complete3 != "" {

		_3rd_iframe_complete = `_3rd_iframe_complete: ["` + complete3 + `", "` + adu_complete3 + `"],`

	} else if complete3 != "" {

		_3rd_iframe_complete = `_3rd_iframe_complete: ["` + complete3 + `"],`

	} else if adu_complete3 != "" {

		_3rd_iframe_complete = `_3rd_iframe_complete: ["` + adu_complete3 + `"],`

	}

	if start1 != "" && adu_start1 != "" {

		_3rd_img_start = `_3rd_img_start: ["` + start1 + `", "` + adu_start1 + `"],`

	} else if start1 != "" {

		_3rd_img_start = `_3rd_img_start: ["` + start1 + `"],`

	} else if adu_start1 != "" {

		_3rd_img_start = `_3rd_img_start: ["` + adu_start1 + `"],`

	}

	if start2 != "" && adu_start2 != "" {

		_3rd_js_start = `_3rd_js_start: ["` + start2 + `", "` + adu_start2 + `"],`

	} else if start2 != "" {

		_3rd_js_start = `_3rd_js_start: ["` + start2 + `"],`

	} else if adu_start2 != "" {

		_3rd_js_start = `_3rd_js_start: ["` + adu_start2 + `"],`

	}

	if start3 != "" && adu_start3 != "" {

		_3rd_iframe_start = `_3rd_iframe_start: ["` + start3 + `", "` + adu_start3 + `"],`

	} else if start3 != "" {

		_3rd_iframe_start = `_3rd_iframe_start: ["` + start3 + `"],`

	} else if adu_start3 != "" {

		_3rd_iframe_start = `_3rd_iframe_start: ["` + adu_start3 + `"],`

	}

	if impression1 != "" && adu_impression1 != "" {

		_3rd_img_impression = `_3rd_img_impression: ["` + impression1 + `", "` + adu_impression1 + `"],`

	} else if impression1 != "" {

		_3rd_img_impression = `_3rd_img_impression: ["` + impression1 + `"],`

	} else if adu_impression1 != "" {

		_3rd_img_impression = `_3rd_img_impression: ["` + adu_impression1 + `"],`

	}

	if impression2 != "" && adu_impression2 != "" {

		_3rd_js_impression = `_3rd_js_impression: ["` + impression2 + `", "` + adu_impression2 + `"],`

	} else if impression2 != "" {

		_3rd_js_impression = `_3rd_js_impression: ["` + impression2 + `"],`

	} else if adu_impression2 != "" {

		_3rd_js_impression = `_3rd_js_impression: ["` + adu_impression2 + `"],`

	}

	if impression3 != "" && adu_impression3 != "" {

		_3rd_iframe_impression = `_3rd_iframe_impression: ["` + impression3 + `", "` + adu_impression3 + `"],`

	} else if impression3 != "" {

		_3rd_iframe_impression = `_3rd_iframe_impression: ["` + impression3 + `"],`

	} else if adu_impression3 != "" {

		_3rd_iframe_impression = `_3rd_iframe_impression: ["` + adu_impression3 + `"],`

	}

	if viewimpression1 != "" && adu_viewimpression1 != "" {

		_3rd_img_viewableImpression = `_3rd_img_viewableImpression: ["` + viewimpression1 + `", "` + adu_viewimpression1 + `"],`

	} else if viewimpression1 != "" {

		_3rd_img_viewableImpression = `_3rd_img_viewableImpression: ["` + viewimpression1 + `"],`

	} else if adu_viewimpression1 != "" {

		_3rd_img_viewableImpression = `_3rd_img_viewableImpression: ["` + adu_viewimpression1 + `"],`

	}

	if viewimpression2 != "" && adu_viewimpression2 != "" {

		_3rd_js_viewableImpression = `_3rd_js_viewableImpression: ["` + viewimpression2 + `", "` + adu_viewimpression2 + `"],`

	} else if viewimpression2 != "" {

		_3rd_js_viewableImpression = `_3rd_js_viewableImpression: ["` + viewimpression2 + `"],`

	} else if adu_viewimpression2 != "" {

		_3rd_js_viewableImpression = `_3rd_js_viewableImpression: ["` + adu_viewimpression2 + `"],`

	}

	if viewimpression3 != "" && adu_viewimpression3 != "" {

		_3rd_iframe_viewableImpression = `_3rd_iframe_viewableImpression: ["` + viewimpression3 + `", "` + adu_viewimpression3 + `"],`

	} else if viewimpression3 != "" {

		_3rd_iframe_viewableImpression = `_3rd_iframe_viewableImpression: ["` + viewimpression3 + `"],`

	} else if adu_viewimpression3 != "" {

		_3rd_iframe_viewableImpression = `_3rd_iframe_viewableImpression: ["` + adu_viewimpression3 + `"],`

	}

	if clicks1 != "" && adu_clicks1 != "" {

		_3rd_img_click = `_3rd_img_click: ["` + clicks1 + `", "` + adu_clicks1 + `"],`

	} else if clicks1 != "" {

		_3rd_img_click = `_3rd_img_click: ["` + clicks1 + `"],`

	} else if adu_clicks1 != "" {

		_3rd_img_click = `_3rd_img_click: ["` + adu_clicks1 + `"],`

	}

	if clicks2 != "" && adu_clicks2 != "" {

		_3rd_js_click = `_3rd_js_click: ["` + clicks2 + `", "` + adu_clicks2 + `"],`

	} else if clicks2 != "" {

		_3rd_js_click = `_3rd_js_click: ["` + clicks2 + `"],`

	} else if adu_clicks2 != "" {

		_3rd_js_click = `_3rd_js_click: ["` + adu_clicks2 + `"],`
	}

	if clicks3 != "" && adu_clicks3 != "" {

		_3rd_iframe_click = `_3rd_iframe_click: ["` + clicks3 + `", "` + adu_clicks3 + `"],`

	} else if clicks3 != "" {

		_3rd_iframe_click = `_3rd_iframe_click: ["` + clicks3 + `"],`

	} else if adu_clicks3 != "" {

		_3rd_iframe_click = `_3rd_iframe_click: ["` + adu_clicks3 + `"],`
	}

	if close1 != "" && adu_close1 != "" {

		_3rd_img_close = `_3rd_img_close: ["` + close1 + `", "` + adu_close1 + `"],`

	} else if close1 != "" {

		_3rd_img_close = `_3rd_img_close: ["` + close1 + `"],`

	} else if adu_close1 != "" {

		_3rd_img_close = `_3rd_img_close: ["` + adu_close1 + `"],`
	}

	if close2 != "" && adu_close2 != "" {

		_3rd_js_close = `_3rd_js_close: ["` + close2 + `", "` + adu_close2 + `"],`

	} else if close2 != "" {

		_3rd_js_close = `_3rd_js_close: ["` + close2 + `"],`

	} else if adu_close2 != "" {

		_3rd_js_close = `_3rd_js_close: ["` + adu_close2 + `"],`
	}

	if close3 != "" && adu_close3 != "" {

		_3rd_iframe_close = `_3rd_iframe_close: ["` + close3 + `", "` + adu_close3 + `"],`

	} else if close3 != "" {

		_3rd_iframe_close = `_3rd_iframe_close: ["` + close3 + `"],`

	} else if adu_close3 != "" {

		_3rd_iframe_close = `_3rd_iframe_close: ["` + adu_close3 + `"],`
	}

	/**********Third Party Tracker End**********/

	/**********In Stream Start**********/

	TagType := admaruout.Tag_Generation.Tag_Type

	Inline_Content := admaruout.Temp_Generation.Inline_Content

	var Inlineontent []InlineContent

	err2 := json.Unmarshal([]byte(Inline_Content), &Inlineontent)
	if err2 != nil {
		fmt.Println(err2)
	}
	var InlineontentVideo_Url string

	InlineontentVideo_Url = config.GetConfig("source", "video")
	if len(Inlineontent) > 0 {
		InlineontentVideo_Url = Inlineontent[0].Video_Url

	}
	var videoSource string
	if TagType == "2" {

		videoSource = InlineontentVideo_Url

	} else {

		videoSource = config.GetConfig("source", "video")
	}

	Instream_settings := structure.Instream_Template{}

	err1 := json.Unmarshal([]byte(admaruout.Temp_Generation.Settings), &Instream_settings)
	if err1 != nil {
		fmt.Println(err1)
	}

	/**********In Stream End**********/

	template_settings := structure.Outstream_Template{}

	err := json.Unmarshal([]byte(admaruout.Temp_Generation.Settings), &template_settings)
	if err != nil {
		fmt.Println(err)
	}

	if template_settings.MaxWidth == 0 {
		template_settings.MaxWidth = 300
	}
	if template_settings.MinWidth == 0 {
		template_settings.MinWidth = 300
	}

	admaruout.Video_Temp.Height = template_settings.MinWidth
	admaruout.Video_Temp.Width = template_settings.MaxWidth
	// Newplayer changes start
	var closeEnable string
	var localEnable string
	var playOnview string
	var thresholdVal string = "0"
	var sideStreamEnable string
	var skipEnable string
	var floatLocation string
	var returntopage string
	var replayEnable string
	var iniframeEnable string
	var responsive string
	var responsivereminder string
	if template_settings.Responsive.ResponsiveSize != false {
		responsive = "true"
	} else {
		responsive = "false"
	}

	if template_settings.Responsive.ResponsiveRemSize != false {
		responsivereminder = "true"
	} else {
		responsivereminder = "false"
	}

	if template_settings.InIframe != false {
		iniframeEnable = "true"
	} else {
		iniframeEnable = "false"
	}

	if template_settings.PlayerInterface.ReplayButton != false {
		replayEnable = "true"
	} else {
		replayEnable = "false"
	}

	if template_settings.PlayerInterface.CloseButton != false {
		closeEnable = "true"
	} else {
		closeEnable = "false"
	}
	if template_settings.LogoVideo.LogoVideo != false {
		localEnable = "true"
	} else {
		localEnable = "false"
	}
	if template_settings.PlayerMode.PlayOnview == true {
		playOnview = "autoplay"
		if template_settings.PlayerMode.InView != 0 {
			thresholdVal = helper.IntToString(template_settings.PlayerMode.InView)
		} else if template_settings.PlayerMode.PlayModeView != 0 {
			thresholdVal = helper.IntToString(template_settings.PlayerMode.PlayModeView)
		}

	} else if template_settings.AutoPlay == true {
		if template_settings.PlayerMode.InView != 0 {
			thresholdVal = helper.IntToString(template_settings.PlayerMode.InView)
		} else if template_settings.PlayerMode.PlayModeView != 0 {
			thresholdVal = helper.IntToString(template_settings.PlayerMode.PlayModeView)
		}

		playOnview = "autoplay_muted"
	} else {
		playOnview = "mouseover"
		if template_settings.PlayerMode.InView != 0 {
			thresholdVal = helper.IntToString(template_settings.PlayerMode.InView)
		} else if template_settings.PlayerMode.PlayModeView != 0 {
			thresholdVal = helper.IntToString(template_settings.PlayerMode.PlayModeView)
		}

	}

	if template_settings.Skip.Skip == true {
		skipEnable = "true"
	} else {
		skipEnable = "false"
	}
	if template_settings.PlayerMode.PlayerMode == "2" {
		returntopage = "true"
	} else {
		returntopage = "false"
	}

	if template_settings.PlayerMode.PlayerMode == "2" || template_settings.PlayerMode.PlayerMode == "3" {
		sideStreamEnable = "true"
		if (template_settings.PlayerMode.FloatType == "impression") && template_settings.AutoPlay == true {

			playOnview = "autoplay"
		} else if (template_settings.PlayerMode.FloatType == "bottom" || template_settings.PlayerMode.PlayerMode == "3") && template_settings.AutoPlay == true {

			playOnview = "autoplay_muted"
		} else if (template_settings.PlayerMode.FloatType == "impression" || template_settings.PlayerMode.PlayerMode == "3") && template_settings.AutoPlay == false {
			playOnview = "mouseover"
		} else if template_settings.PlayerMode.FloatType == "bottom" && template_settings.AutoPlay == false {
			playOnview = "mouseover2"
		}

	} else {
		sideStreamEnable = "false"
	}
	if template_settings.PlayerMode.Location != "" {
		floatLocation = "bottom-" + template_settings.PlayerMode.Location

	} else {
		floatLocation = "bottom-left"
	}

	var sideviewwidth string
	var sideviewheight string

	switch {
	case template_settings.PlayerMode.SideViewWidth != "":
		sideviewwidth = template_settings.PlayerMode.SideViewWidth

	case template_settings.PlayerMode.RemainderWidth != 0:
		sideviewwidth = helper.IntToString(template_settings.PlayerMode.RemainderWidth)

	}
	switch {
	case template_settings.PlayerMode.SideViewHeight != "":
		sideviewheight = template_settings.PlayerMode.SideViewHeight
	case template_settings.PlayerMode.RemainderHeight != 0:
		sideviewheight = helper.IntToString(template_settings.PlayerMode.RemainderHeight)
	}

	var passbackenable string
	var passbackscriptorlink string
	if template_settings.TempPassback.LinkOrTag != "" {
		passbackenable = "true"
	} else {
		passbackenable = "false"
	}

	var ZIndexBoolStr string
	if template_settings.ReminderZindex.ZIndexBool != false {
		ZIndexBoolStr = "true"
	} else {
		ZIndexBoolStr = "false"
	}

	if admaruout.Adunit_type != "VideoVast" && admaruout.Adunit_type != "PrebidPriority" {
		if template_settings.TempPassback.DFP.DFP == true && admaruout.DFP_Delivery == "true" {

			template_settings.TempPassback.URL = `<div id="` + template_settings.TempPassback.DFP.Div_id + `">  <script>    window.googletag = window.googletag || {cmd: []};    googletag.cmd.push(function() { googletag.pubads().refresh([` + template_settings.TempPassback.DFP.Slot_id + `]); });  </script></div>`

		}
		if template_settings.TempPassback.LinkOrTag == "js" || template_settings.TempPassback.LinkOrTag == "tag" {
			template_settings.TempPassback.URL = url.PathEscape(template_settings.TempPassback.URL)

		} else if template_settings.TempPassback.LinkOrTag == "iframe" {
			template_settings.TempPassback.URL = url.PathEscape(template_settings.TempPassback.URL)

		} else if template_settings.TempPassback.LinkOrTag == "link" {
			clickurl := template_settings.TempPassback.DestinationUrl
			ImgTag := template_settings.TempPassback.URL
			clickTag_start := `<a href='` + clickurl + `' target='_blank'>`
			clickTag_end := `</a>`
			template_settings.TempPassback.URL = clickTag_start + `<img src='` + ImgTag + `' alt='' title='' border='0' />` + clickTag_end
			template_settings.TempPassback.URL = url.PathEscape(template_settings.TempPassback.URL)

		}
	} else {

		if template_settings.TempPassback.DFP.DFP == true {

			template_settings.TempPassback.URL = `<div id="` + template_settings.TempPassback.DFP.Div_id + `">  <script>    window.googletag = window.googletag || {cmd: []};    googletag.cmd.push(function() { googletag.pubads().refresh([` + template_settings.TempPassback.DFP.Slot_id + `]); });  </script></div>`

		}
		template_settings.TempPassback.URL = url.PathEscape(template_settings.TempPassback.URL)

	}
	passbackscriptorlink = template_settings.TempPassback.URL
	var InstreamOrOutStream string
	if admaruout.Temp_Generation.Template_type == "2" {
		InstreamOrOutStream = "instream"
	} else if admaruout.Temp_Generation.Template_type == "3" || admaruout.Temp_Generation.Template_type == "1" {
		InstreamOrOutStream = "outstream"
	}
	var VideoRefresh string
	MainDiv_Start := ""
	MainDiv_End := ""
	Template_id := admaruout.Tag_id
	var NextPriority string = "no"
	if admaruout.Priority_Next > admaruout.Priority_Level {
		NextPriority = "yes"
	}
	if admaruout.Viewable_Tagid == "" {
		admaruout.Viewable_Tagid = "main_div_" + rand
	}

	var GPT_Delivery string

	if template_settings.TempPassback.DFP.DFP == true {
		GPT_Delivery = `googletag.cmd.push(function() { googletag.pubads().refresh([` + template_settings.TempPassback.DFP.Slot_id + `]);
			googletag.pubads().addEventListener('slotRenderEnded', function(event) {
				if (event.slot.getSlotElementId() == "` + template_settings.TempPassback.DFP.Div_id + `") {
					localStorage.setItem('DFP_Delivery_` + rand + `','true');
				}
			});
			});`
	}
	if template_settings.VastRetry > 0 && admaruout.MultiadPrebidCal == "yes" && admaruout.Temp_Generation.Template_type != "2" {
		VideoRefresh = `
		var adEndTimeout="",adSkipTimeout="",adErrorTimeout="";
			player` + rand + `.on('vast.adEnd', function () {

				 adEndTimeout = setTimeout(maxset` + rand + `, 5000);
				 ` + GPT_Delivery + `
				player` + rand + `.dispose();
			});
			player` + rand + `.on('vast.adSkip', function () {
				 adSkipTimeout = setTimeout(maxset` + rand + `, 5000);
				 ` + GPT_Delivery + `
				player` + rand + `.dispose();
			});
			player` + rand + `.on('vast.adError', function () {
				var PrebidRes` + rand + `=pbjs.getHighestCpmBids('` + admaruout.Viewable_Tagid + `');
				if(PrebidRes` + rand + `!=""){
				 Prebidmaxset` + rand + `();
				}
				else if(NextPriority=="yes"){
					Prioritycall();
					player` + rand + `.dispose();
				}
				else{
				 adErrorTimeout = setTimeout(maxset` + rand + `, 5000);
				 ` + GPT_Delivery + `		
				}
				player` + rand + `.dispose();	
			});
			player` + rand + `.on('error', function () {
				var PrebidRes` + rand + `=pbjs.getHighestCpmBids('` + admaruout.Viewable_Tagid + `');
				if(PrebidRes` + rand + `!=""){
				 Prebidmaxset` + rand + `();
				}
				else if(NextPriority=="yes"){
					Prioritycall();
					player` + rand + `.dispose();
				}
				else{
				 adErrorTimeout = setTimeout(maxset` + rand + `, 5000);
				 ` + GPT_Delivery + `
				}
				player` + rand + `.dispose();
			});


			function maxset` + rand + `()
			{
				var MaxImp` + rand + `='` + helper.IntToString(template_settings.VastRetry) + `';
				if(localStorage.getItem('TEMPTAG_` + Template_id + rand + `')== null){
					localStorage.setItem('TEMPTAG_` + Template_id + rand + `','` + rand + "_" + `'+MaxImp` + rand + `);
				}
				var Imp_details` + rand + `=localStorage.getItem('TEMPTAG_` + Template_id + rand + `');
				var Imp_array` + rand + `=Imp_details` + rand + `.split("_");
				var Remainig_Imp` + rand + `=Imp_array` + rand + `[1]; 
				var Randnum` + rand + `=Imp_array` + rand + `[0];
				var TagId` + rand + `='` + Template_id + `';
				
				if (Remainig_Imp` + rand + ` !== null){
					if (Remainig_Imp` + rand + ` > 0)
					{
						Remainig_Imp` + rand + `--;
						localStorage.setItem('TEMPTAG_'+TagId` + rand + `+Randnum` + rand + `,Randnum` + rand + `+"_"+Remainig_Imp` + rand + `);
						var Test_Div=document.getElementById('` + admaruout.Viewable_Tagid + `');
						if(Test_Div!="" && Test_Div!=null){
							Test_Div.innerHTML="";
						}
						var DFP_Delivery` + rand + `="false";
						if(localStorage.getItem('DFP_Delivery_` + rand + `')!= null){
							DFP_Delivery` + rand + `="true";
						}	
						var m3_u1 = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid=` + Template_id + `&loc='+escape(window.location)+'&auto=yes&trackingloc='+escape(window.location)+'&Is_Libload=no&rand='+Randnum` + rand + `+'&DFP_Delivery='+DFP_Delivery` + rand + `;
						fetch(m3_u1) 
									.then(response => {       
										return response.text(); 
									})
									.then(htmlContent => {
										var mainDIV` + rand + ` = document.getElementById('` + admaruout.Viewable_Tagid + `');
										var childDiv` + rand + ` = document.createElement("div");       
										childDiv` + rand + `.innerHTML = htmlContent;
										mainDIV` + rand + `.appendChild(childDiv` + rand + `);

										var mainscript` + rand + ` = mainDIV` + rand + `.getElementsByTagName("script");
										for (var scriptTags` + rand + ` of mainscript` + rand + `) {
										  var scriptContent` + rand + ` = scriptTags` + rand + `.textContent;
										  eval(scriptContent` + rand + `);
										  if (scriptTags` + rand + `.src) {
											var scriptElement` + rand + ` = document.createElement("script");
											scriptElement` + rand + `.src = scriptTags` + rand + `.src;
											document.head.appendChild(scriptElement` + rand + `);
										  }
										}
									
									})
									.catch(error => {
										console.error('Fetch error:', error);
									});

					} else{
						localStorage.removeItem('TEMPTAG_'+TagId` + rand + `+Randnum` + rand + `);
						localStorage.removeItem('DFP_Delivery_` + rand + `');
						clearTimeout(adEndTimeout);
						clearTimeout(adSkipTimeout);
						clearTimeout(adErrorTimeout);
					}
				}
		
			}
						`
	} else if template_settings.VastRetry > 0 && admaruout.MultiadPrebidCal != "yes" && admaruout.Temp_Generation.Template_type != "2" {
		admaruout.Viewable_Tagid = "main_div_" + rand
		max_impCount++
		VideoRefresh = `
		var adEndTimeout="",adSkipTimeout="",adErrorTimeout="";
	player` + rand + `.on('vast.adEnd', function () {
		 adEndTimeout = setTimeout(maxset` + rand + `, 5000);
		player` + rand + `.dispose();
	});
	player` + rand + `.on('vast.adSkip', function () {
		 adSkipTimeout = setTimeout(maxset` + rand + `, 5000);
		player` + rand + `.dispose();
	});
	player` + rand + `.on('vast.adError', function () {
		if(NextPriority=="yes"){
			Prioritycall();
			player` + rand + `.dispose();
		}else{
		 adErrorTimeout = setTimeout(maxset` + rand + `, 5000);
		}
		player` + rand + `.dispose();
	});
player` + rand + `.on('error', function () {
		if(NextPriority=="yes"){
			Prioritycall();
			player` + rand + `.dispose();
		}else{
		adErrorTimeout = setTimeout(maxset` + rand + `, 5000);
		}
		player` + rand + `.dispose();
	});

		function maxset` + rand + `()
		{
			var MaxImp` + rand + `='` + helper.IntToString(template_settings.VastRetry) + `';
						if(localStorage.getItem('TEMPTAG_` + Template_id + rand + `')== null){
							localStorage.setItem('TEMPTAG_` + Template_id + rand + `','` + rand + "_" + `'+MaxImp` + rand + `);
						}
						var Imp_details` + rand + `=localStorage.getItem('TEMPTAG_` + Template_id + rand + `');
						var Imp_array` + rand + `=Imp_details` + rand + `.split("_");
						var Remainig_Imp` + rand + `=Imp_array` + rand + `[1]; 
						var Randnum` + rand + `=Imp_array` + rand + `[0];
						var TagId` + rand + `='` + Template_id + `';
						
						if (Remainig_Imp` + rand + ` !== null){
							if (Remainig_Imp` + rand + ` > 0)
							{
								Remainig_Imp` + rand + `--;
								localStorage.setItem('TEMPTAG_'+TagId` + rand + `+Randnum` + rand + `,Randnum` + rand + `+"_"+Remainig_Imp` + rand + `);
								RefreshCall` + rand + `(TagId` + rand + `,Randnum` + rand + `,Remainig_Imp` + rand + `);
							} else{
								localStorage.removeItem('TEMPTAG_'+TagId` + rand + `+Randnum` + rand + `);
								clearTimeout(adEndTimeout);
								clearTimeout(adSkipTimeout);
								clearTimeout(adErrorTimeout);
							}
						}
				
					}

					function RefreshCall` + rand + `(TagId,RandNo,Imp){
					var apicall = '` + config.GetConfig("commonpath", "file") + `VideoVast?tagid='+TagId+'&loc='+escape(window.location)+'&auto=yes&Is_Libload=yes&Impcap=yes&trackingloc='+escape(window.location)+'&rand='+RandNo+'&tagidRand=` + admaruout.Tag_id + `&vastretryadtype=` + Adtype + `';
					var contentmk = ""; var contentType ="";
					fetch(apicall)

  .then(function(response) {
						var VideoDiv=document.getElementById('rm_videowrapper_` + rand + `');
						VideoDiv.innerHTML="";
     contentType = response.headers.get('Content-Type');

    if (contentType && contentType.includes('application/json')) {
	  contentType="application/json";
      return response.json();
	  
    } else if (contentType && contentType.includes('text/html')) {
		contentType="text/html";
      
      return response.text();
    } else {
     
      throw new Error('Unsupported Content-Type: ' + contentType);
    }
  })

  .then(function(data) {

	if (contentType == "application/json"){
								var closeEnable;
								var localEnable;
								var playOnview ="";
								var thresholdVal = "0";
								var sideStreamEnable;
								var skipEnable;
								var floatLocation ="";
								var returntopage;
								var replayEnable;
								var iniframeEnable;
								var responsive;
								var responsivereminder;
								var zIndexBoolStr;
								var sideviewwidth="";
								var sideviewheight="";
								var passbackenable;
								var passbackscriptorlink ="";
								var passbackcheck ="";

		
			
								 if (data.template_settings.reminderZindex.ZIndexBool != false) {
									zIndexBoolStr = true;
								} else {
									zIndexBoolStr = false;
								}

								 if (data.template_settings.mobileView.responsiveSize != false) {
									responsive = true;
								} else {
									responsive = false;
								}
							
								if (data.template_settings.mobileView.responsiveRemSize != false) {
									responsivereminder =true;
								} else {
									responsivereminder = false;
								}
							
								if (data.template_settings.inIframe != false) {
									iniframeEnable =true;
								} else {
									iniframeEnable = false;
								}
							
								if (data.template_settings.playerInterface.replayButton != false) {
									replayEnable = true;
								} else {
									replayEnable = false;
								}
								if (data.template_settings.playerInterface.closeButton != false) {
									closeEnable = true;
								} else {
									closeEnable = false;
								}
								if (data.template_settings.skip.skip == true) {
									skipEnable = true;
								} else {
									skipEnable = false;
								}
								if (data.template_settings.playerMode.playerMode == "2"){
									returntopage = true;
								} else {
									returntopage = false;
								}


								if ((data.template_settings.playerMode.playerMode == "2") || (data.template_settings.playerMode.playerMode == "3")) {
										sideStreamEnable = true;
									if ((data.template_settings.playerMode.floatType == "impression") && (data.template_settings.autoPlay == true)) {

										playOnview = "autoplay";
									} else if ((data.template_settings.playerMode.floatType == "bottom" || data.template_settings.playerMode.playerMode == "3") && data.template_settings.autoPlay == true) {

										playOnview = "autoplay_muted";
									} else if ((data.template_settings.playerMode.floatType == "impression" || data.template_settings.playerMode.playerMode == "3") && (data.template_settings.autoPlay == false)) {
										playOnview = "mouseover";
									}else if (data.template_settings.playerMode.floatType == "bottom" && data.template_settings.autoPlay == false)
									{
										playOnview = "mouseover2";
									}

								} else {
									sideStreamEnable = false;
								}

								if (data.template_settings.playerMode.location != "") {
									floatLocation = "bottom-" + data.template_settings.playerMode.location;
								} else {
									floatLocation = "bottom-left";
								}
								 if (data.template_settings.LogoVideo.LogoVideo != false) {
									localEnable = true;
								} else {
									localEnable = false;
								}
								if (data.template_settings.playerMode.playOnview == true) {
									playOnview = "autoplay";
									if (data.template_settings.playerMode.inView != 0) {
										thresholdVal = String(data.template_settings.playerMode.inView);
									} else if (data.template_settings.playerMode.playModeView != 0) {
										thresholdVal = String(data.template_settings.playerMode.playModeView);
									}
							
								} else if (data.template_settings.autoPlay == true) {
									if (data.template_settings.playerMode.inView != 0) {
										thresholdVal = String(data.template_settings.playerMode.inView);
									} else if (data.template_settings.playerMode.playModeView != 0) {
										thresholdVal = String(data.template_settings.playerMode.playModeView);
									}
							
									playOnview = "autoplay_muted";
								} else {
									playOnview = "mouseover";
									if (data.template_settings.playerMode.inView != 0) {
										thresholdVal = String(data.template_settings.playerMode.inView);
									} else if (data.template_settings.playerMode.playModeView != 0) {
										thresholdVal = String(data.template_settings.playerMode.playModeView);
									}
							
								}
								if (data.template_settings.playerMode.sideviewWidth != ""){
									sideviewwidth = data.template_settings.playerMode.sideviewWidth;
								}else if(data.template_settings.playerMode.remainderWidth != 0){
									sideviewwidth = data.template_settings.playerMode.remainderWidth;
								}

								if (data.template_settings.playerMode.sideviewHeight != ""){
									sideviewheight = data.template_settings.playerMode.sideviewHeight;
								}else if(data.template_settings.playerMode.sideviewHeight != 0){
									sideviewheight = data.template_settings.playerMode.sideviewHeight;
								}
								if (data.template_settings.Passback.LinkOrTag != "") {
									passbackenable = true
								} else {
									passbackenable = false
								}

								passbackscriptorlink = decodeURIComponent(data.template_settings.Passback.url);

								if (data.deliveryadtype == "Direct"){
								 adsParams` + rand + ` = {
									playerId: "rm_videowrapper_` + rand + `",
									useReminderZindex: zIndexBoolStr,
									reminderIdClass : data.template_settings.reminderZindex.ZIndexId,
									reminderZindex : data.template_settings.reminderZindex.ZindexValue,
									sources: [
									{
										src: "` + videoSource + `",
										type: "video/mp4"
									}
									],
									logo: {
									  image: data.template_settings.LogoVideo.logoLink,
									  url: data.template_settings.LogoVideo.logoClickthrough, 
									  position: 'top-left',
									  enabled: localEnable,
									  width: String(data.template_settings.LogoVideo.logoWidth),
									  height:  String(data.template_settings.LogoVideo.logoHeight),
									  offsetH: 0,
									  offsetV: 0,
									  opacity: 1
									},
									threshold: thresholdVal,
									context: 'outstream', 
									nonViewableBehavior: true, 
									sideStream : {
										enabled: sideStreamEnable,
										returnToPage: returntopage,
										position: floatLocation, 
										width: sideviewwidth,
										height: sideviewheight,
										offsetL: String(data.template_settings.playerMode.leftMargin),
										offsetR: String(data.template_settings.playerMode.rightMargin),
										offsetB: String(data.template_settings.playerMode.bottomMargin)
									},
									width: String(data.template_settings.maxWidth),
									height: String(data.template_settings.minHeight),
									Ui: {
											enabled : true,
											closeButton :closeEnable,
											replayButton : replayEnable,   
											playBigButton : false, 
											allowFullscreen : false              
									},
									playbackMethod: playOnview, 
									inIframe:iniframeEnable,
									isIbh: false,
									responsiveSize:responsive,
									responsiveReminderSize:responsivereminder,
									usePassback:passbackenable,
									passBackScript: [passbackscriptorlink],
									
									ads: {
									  adTagUrl: String(data.vast_url),
									  
									  showSkipButton : skipEnable,
									  skipButtonLocation: "bottom-right",
									  skipOffSet:String(data.template_settings.skip.skip_time),
									  skipText: "Skip %%TIME%% ..",
									  skipButtonText: String(data.template_settings.skip.skip_text),
						  
									  
									  style: {
										  zIndex: data.template_settings.zIndex
									  },
									  
									  viewableEventTime: 5,
									  defaultEventUrl:String(data.event_url),
									  eventUrls:{
										  viewable:[
											String(data.viewable_url)
										  ],
										 
									  }
									}
								};
								}else{
									adsParams` + rand + ` = {
										playerId: "rm_videowrapper_` + rand + `",
										useReminderZindex: zIndexBoolStr,
										reminderIdClass : data.template_settings.reminderZindex.ZIndexId,
										reminderZindex : data.template_settings.reminderZindex.ZindexValue,
										sources: [
										{
											src: "` + videoSource + `",
											type: "video/mp4"
										}
										],
										logo: {
										  image: data.template_settings.LogoVideo.logoLink,
										  url: data.template_settings.LogoVideo.logoClickthrough, 
										  position: 'top-left',
										  enabled: localEnable,
										  width: String(data.template_settings.LogoVideo.logoWidth),
										  height:  String(data.template_settings.LogoVideo.logoHeight),
										  offsetH: 0,
										  offsetV: 0,
										  opacity: 1
										},
										threshold: thresholdVal,
										context: 'outstream', 
										nonViewableBehavior: true, 
										sideStream : {
											enabled: sideStreamEnable,
											returnToPage: returntopage,
											position: floatLocation, 
											width: sideviewwidth,
											height: sideviewheight,
											offsetL: String(data.template_settings.playerMode.leftMargin),
											offsetR: String(data.template_settings.playerMode.rightMargin),
											offsetB: String(data.template_settings.playerMode.bottomMargin)
										},
										width: String(data.template_settings.maxWidth),
										height: String(data.template_settings.minHeight),
										Ui: {
												enabled : true,
												closeButton :closeEnable,
												replayButton : replayEnable,   
												playBigButton : false, 
												allowFullscreen : false              
										},
										playbackMethod: playOnview, 
										inIframe:iniframeEnable,
										isIbh: false,
										responsiveSize:responsive,
										responsiveReminderSize:responsivereminder,
										usePassback:passbackenable,
										passBackScript: [passbackscriptorlink],
										
										ads: {
												adTagXML: requestVASTXML,
										
										  
										  showSkipButton : skipEnable,
										  skipButtonLocation: "bottom-right",
										  skipOffSet:String(data.template_settings.skip.skip_time),
										  skipText: "Skip %%TIME%% ..",
										  skipButtonText: String(data.template_settings.skip.skip_text),
							  
										  
										  style: {
											  zIndex: data.template_settings.zIndex
										  },
										  
										  viewableEventTime: 5,
										  defaultEventUrl:String(data.event_url),
										  eventUrls:{
											  viewable:[
												String(data.viewable_url)
											  ],
											 
										  }
										}
									};
									function requestVASTXML(callback) {
										setTimeout(function(){
										callback(null, "` + RTBvideosrc + `");
										}, 0);
									 }
								}

								function parseStringToKeyValuePairs(str) {
									const keyValuePairs = {};
									const pairs = str.split('],');
									pairs.pop();
									for (const pair of pairs) {
									  const [key, value] = pair.split(': ');
									  
									 
									  keyValuePairs[key] =JSON.parse(value+"]");
									}
								  
									return keyValuePairs;
								  }

								  const keyValuePairs = parseStringToKeyValuePairs(data.third_part_trackers);
								mergeKeyValuePairsIntoObject(keyValuePairs, adsParams` + rand + `.ads.eventUrls);

								function mergeKeyValuePairsIntoObject(keyValuePairs, targetObject) {
									for (const key in keyValuePairs) {
									  if (keyValuePairs.hasOwnProperty(key)) 
									  {
										targetObject[key] = keyValuePairs[key];
									   }
									}
							  	}

								player` + rand + ` = adMaru.load(adsParams` + rand + `);
								player` + rand + `.on('vast.adEnd', function () {
									adEndTimeout = setTimeout(maxset` + rand + `, 5000);
								   player` + rand + `.dispose();
								});
								player` + rand + `.on('vast.adSkip', function () {
									adSkipTimeout = setTimeout(maxset` + rand + `, 5000);
								   player` + rand + `.dispose();
								});
								console.log("data.adtype");
								console.log(data.adtype);

								
									player` + rand + `.on('vast.admShow', function () { console.log("Ad Start Vast retry");
									var impressionImp = data.imp_url;
									var xhr = new XMLHttpRequest();
									xhr.open('GET', impressionImp, true);
									xhr.send();
									var viewableimpression = data.viewimpression;

									var ad_elem` + rand + ` = document.getElementById('` + admaruout.Viewable_Tagid + `');
									var ViewableImp = viewableimpression;	 
									var url = new URL(ViewableImp);  
									var percent = 75;
									oav` + rand + ` = new OpenAdViewability();
									oav` + rand + `.DEBUG_MODE = false;
									var j` + rand + ` = 0;
									oav` + rand + `.checkViewability(ad_elem` + rand + `, function(check) {
										if(check.percentViewable >=percent){
											if(j` + rand + `==0){	
												console.log("viewable imp2619");
												console.log(check.percentViewable);
												var xhttp = new XMLHttpRequest();
												xhttp.open( "GET", viewableimpression, true );
												xhttp.send();	            	
												j` + rand + `++;		
											}
										}
									});
									});
								
								player` + rand + `.on('vast.adError', function () {
									adErrorTimeout = setTimeout(maxset` + rand + `, 5000);
								   player` + rand + `.dispose();
								});
		
	}else{
		var mainDIV` + rand + ` = document.getElementById('` + admaruout.Viewable_Tagid + `');
		
		mainDIV` + rand + `.setAttribute("id", "Prebid_` + rand + `");
		mainDIV` + rand + `.setAttribute("class", ".rm_videowrapper_Prebid_` + rand + `"); 
		if(mainDIV` + rand + `!="" && mainDIV` + rand + `!=null){
			mainDIV` + rand + `.innerHTML="";
			}
		var childDiv` + rand + ` = document.createElement("div");       
		childDiv` + rand + `.innerHTML = data;
		mainDIV` + rand + `.appendChild(childDiv` + rand + `);
						
		var mainscript` + rand + ` = mainDIV` + rand + `.getElementsByTagName("script");
	if(mainscript` + rand + `){
	for (var scriptTags` + rand + ` of mainscript` + rand + `) {
		var scriptContent` + rand + ` = scriptTags` + rand + `.textContent;
		eval(scriptContent` + rand + `);
		if (scriptTags` + rand + `.src) {
		var scriptElement` + rand + ` = document.createElement("script");
		scriptElement` + rand + `.src = scriptTags` + rand + `.src;
		mainDIV` + rand + `.appendChild(scriptElement` + rand + `);
		}
		}
		}
	}
    
  })

  .catch(function(error) {
    console.error('Fetch error:', error);
  });
					}
				`
	} else {
		VideoRefresh = `
		var adEndTimeout="",adSkipTimeout="",adErrorTimeout="";
		player` + rand + `.on('vast.adSkip', function () {
			player` + rand + `.dispose();
		});
		player` + rand + `.on('vast.adEnd', function () {
			player` + rand + `.dispose();
		});
		player` + rand + `.on('vast.adError', function () {
			var PrebidRes` + rand + `=pbjs.getHighestCpmBids('` + admaruout.Viewable_Tagid + `');
			if(PrebidRes` + rand + `!=""){
			 Prebidmaxset` + rand + `();
			}
			else if(NextPriority=="yes"){
				Prioritycall();
				player` + rand + `.dispose();
			}
		});
		player` + rand + `.on('error', function () {
			var PrebidRes` + rand + `=pbjs.getHighestCpmBids('` + admaruout.Viewable_Tagid + `');
			if(PrebidRes` + rand + `!=""){
			 Prebidmaxset` + rand + `();
			}
			else if(NextPriority=="yes"){
				Prioritycall();
				player` + rand + `.dispose();
			}
		});		
		`
	}
	MainDiv_Start = `<div id="main_div_` + rand + `">`
	MainDiv_End = `</div>`

	var playerfiles string
	if admaruout.Adunit_type == "async" {
		playerfiles = `<script async src="` + config.GetConfig("path", "library") + `/Admaru.js"></script>
		<link rel="stylesheet" href="` + config.GetConfig("path", "player") + `/admaru-player.css">
		<script src="` + config.GetConfig("path", "player") + `/admaru-player.js"></script>
		<script src="https://code.jquery.com/jquery-1.12.1.min.js"></script>
		<script type='text/javascript' src='` + config.GetConfig("path", "library") + `/viewability.js'></script>`
	}

	videohtmlres := playerfiles + `
	` + MainDiv_Start + `
	<div class="rm_videowrapper_` + rand + `" id="rm_videowrapper_` + rand + `" style="width:` + helper.IntToString(template_settings.MaxWidth) + `px;height:` + helper.IntToString(template_settings.MinWidth) + `px;">
	</div>
	
	<script type='text/javascript'>
	var player` + rand + `="";
	var NextPriority ="` + NextPriority + `";
	var Adtype='` + Adtype + `';
	
var deliverysrc = "";
var deliveryadtype = '` + Deliveryadtype + `';
if (deliveryadtype == "Direct"){
	deliverysrc = '` + videoUrl + `';
}
var adsParams` + rand + ` = "";
var passsbacktest = "` + passbackscriptorlink + `";
passsbacktest=decodeURIComponent(passsbacktest);
passsbacktest=passsbacktest.replaceAll("\n","");


if (deliveryadtype == "Direct") {
	adsParams` + rand + ` = {
		  playerId: "rm_videowrapper_` + rand + `",
		  useReminderZindex: ` + ZIndexBoolStr + `,
		  reminderIdClass : "` + template_settings.ReminderZindex.ZIndexId + `",
		  reminderZindex : "` + template_settings.ReminderZindex.ZindexValue + `",
		  sources: [
		  {
			  src: "` + videoSource + `",
			  type: "video/mp4"
		  }
		  ],
		  logo: {
			image: '` + template_settings.LogoVideo.LogoLink + `',
			url: '` + template_settings.LogoVideo.LogoClickthrough + `', 
			position: 'top-left',
			enabled: ` + localEnable + `,
			width: '` + helper.IntToString(template_settings.LogoVideo.LogoWidth) + `',
			height: '` + helper.IntToString(template_settings.LogoVideo.LogoHeight) + `',
			offsetH: 0,
			offsetV: 0,
			opacity: 1
		  },
		  threshold: ` + thresholdVal + `,
		  context: '` + InstreamOrOutStream + `', 
		  nonViewableBehavior: true, 
		  sideStream : {
			  enabled: ` + sideStreamEnable + `,
			  returnToPage: ` + returntopage + `,
			  position: "` + floatLocation + `", 
			  width: "` + sideviewwidth + `",
			  height: "` + sideviewheight + `",
			  offsetL: "` + helper.IntToString(template_settings.PlayerMode.LeftMargin) + `",
			  offsetR: "` + helper.IntToString(template_settings.PlayerMode.RightMargin) + `",
			  offsetB: "` + helper.IntToString(template_settings.PlayerMode.BottomMargin) + `"
		  },
		  width: ` + helper.IntToString(template_settings.MaxWidth) + `,
		  height: ` + helper.IntToString(template_settings.MinWidth) + `,
		  Ui: {
				  enabled : true,
				  closeButton : ` + closeEnable + `,
				  replayButton : ` + replayEnable + `,   
				  playBigButton : false, 
				  allowFullscreen : false              
		  },
		  playbackMethod: "` + playOnview + `", 
		  inIframe: ` + iniframeEnable + `,
		  isIbh: false,
		  responsiveSize:` + responsive + `,
		  responsiveReminderSize:` + responsivereminder + `,
		  usePassback: ` + passbackenable + `,
		  passBackScript: [passsbacktest],
		  ads: {
		  adTagUrl: deliverysrc,
			
			showSkipButton : ` + skipEnable + `,
			skipButtonLocation: "bottom-right",
			skipOffSet: ` + helper.IntToString(template_settings.Skip.SkipTime) + `,
			skipText: "Skip %%TIME%% ..",
			skipButtonText: "` + template_settings.Skip.SkipText + `",

			
			style: {
				zIndex: ` + helper.IntToString(template_settings.ZIndex) + `
			},
			
			viewableEventTime: 5,
			defaultEventUrl:"` + track + `",
			eventUrls:{
				viewable:[
				"` + _5sView + `"
				],
				` + _3rd_img_firstQuartile + `
				` + _3rd_js_firstQuartile + `
				` + _3rd_iframe_firstQuartile + `

				` + _3rd_img_midpoint + `
				` + _3rd_js_midpoint + `
				` + _3rd_iframe_midpoint + `

				` + _3rd_img_thirdQuartile + `
				` + _3rd_js_thirdQuartile + `
				` + _3rd_iframe_thirdQuartile + `

				` + _3rd_img_pause + `
				` + _3rd_js_pause + `
				` + _3rd_iframe_pause + `

				` + _3rd_img_resume + `
				` + _3rd_js_resume + `
				` + _3rd_iframe_resume + `

				` + _3rd_img_mute + `
				` + _3rd_js_mute + `
				` + _3rd_iframe_mute + `

				` + _3rd_img_unmute + `
				` + _3rd_js_unmute + `
				` + _3rd_iframe_unmute + `

				` + _3rd_img_skip + `
				` + _3rd_js_skip + `
				` + _3rd_iframe_skip + `

				` + _3rd_img_impression + `
				` + _3rd_js_impression + `
				` + _3rd_iframe_impression + `

				` + _3rd_img_viewableImpression + `
				` + _3rd_js_viewableImpression + `
				` + _3rd_iframe_viewableImpression + `

				` + _3rd_img_click + `
				` + _3rd_js_click + `
				` + _3rd_iframe_click + `

				` + _3rd_img_start + `
				` + _3rd_js_start + `
				` + _3rd_iframe_start + `

				` + _3rd_img_complete + `
				` + _3rd_js_complete + `
				` + _3rd_iframe_complete + `

				` + _3rd_img_close + `
				` + _3rd_js_close + `
				` + _3rd_iframe_close + `
			}
		  }
	  };
		}else{

								 adsParams` + rand + ` = {
		  playerId: "rm_videowrapper_` + rand + `",
		  useReminderZindex: ` + ZIndexBoolStr + `,
		  reminderIdClass : "` + template_settings.ReminderZindex.ZIndexId + `",
		reminderZindex : "` + template_settings.ReminderZindex.ZindexValue + `",
		  sources: [
		  {
			  src: "` + videoSource + `",
			  type: "video/mp4"
		  }
		  ],
		  logo: {
			image: '` + template_settings.LogoVideo.LogoLink + `',
			url: '` + template_settings.LogoVideo.LogoClickthrough + `', 
			position: 'top-left',
			enabled: ` + localEnable + `,
			width: '` + helper.IntToString(template_settings.LogoVideo.LogoWidth) + `',
			height: '` + helper.IntToString(template_settings.LogoVideo.LogoHeight) + `',
			offsetH: 0,
			offsetV: 0,
			opacity: 1
		  },
		  threshold: ` + thresholdVal + `,
		  context: '` + InstreamOrOutStream + `', 
		  nonViewableBehavior: true, 
		  sideStream : {
			enabled: ` + sideStreamEnable + `,
			returnToPage: ` + returntopage + `,
			position: "` + floatLocation + `", 
			width: "` + sideviewwidth + `",
			height: "` + sideviewheight + `",
			offsetL: "` + helper.IntToString(template_settings.PlayerMode.LeftMargin) + `",
			offsetR: "` + helper.IntToString(template_settings.PlayerMode.RightMargin) + `",
			offsetB: "` + helper.IntToString(template_settings.PlayerMode.BottomMargin) + `"
		},
		width: ` + helper.IntToString(template_settings.MaxWidth) + `,
		height: ` + helper.IntToString(template_settings.MinWidth) + `,
		Ui: {
				enabled : true,
				closeButton : ` + closeEnable + `,
				replayButton : ` + replayEnable + `,  
				playBigButton : false, 
				allowFullscreen : false              
		},
		playbackMethod: "` + playOnview + `", 
		inIframe: ` + iniframeEnable + `,
		isIbh: false,
	 responsiveSize:` + responsive + `,
		  responsiveReminderSize:` + responsivereminder + `,
		  usePassback: ` + passbackenable + `,
		  passBackScript: [passsbacktest],
		  ads: {
			adTagXML: requestVASTXML,
		  
			showSkipButton : ` + skipEnable + `,
			skipButtonLocation: "bottom-right",
			skipOffSet: ` + helper.IntToString(template_settings.Skip.SkipTime) + `,
			skipText: "Skip %%TIME%% ..",
			skipButtonText: "` + template_settings.Skip.SkipText + `",			

		  
			style: {
				zIndex: ` + helper.IntToString(template_settings.ZIndex) + `
			},			
		  
			viewableEventTime: 5,
			defaultEventUrl:"` + track + `",
			eventUrls:{
				viewable:[
				"` + _5sView + `"
				],
				` + _3rd_img_firstQuartile + `
				` + _3rd_js_firstQuartile + `
				` + _3rd_iframe_firstQuartile + `

				` + _3rd_img_midpoint + `
				` + _3rd_js_midpoint + `
				` + _3rd_iframe_midpoint + `

				` + _3rd_img_thirdQuartile + `
				` + _3rd_js_thirdQuartile + `
				` + _3rd_iframe_thirdQuartile + `

				` + _3rd_img_pause + `
				` + _3rd_js_pause + `
				` + _3rd_iframe_pause + `

				` + _3rd_img_resume + `
				` + _3rd_js_resume + `
				` + _3rd_iframe_resume + `

				` + _3rd_img_mute + `
				` + _3rd_js_mute + `
				` + _3rd_iframe_mute + `

				` + _3rd_img_unmute + `
				` + _3rd_js_unmute + `
				` + _3rd_iframe_unmute + `

				` + _3rd_img_skip + `
				` + _3rd_js_skip + `
				` + _3rd_iframe_skip + `

				` + _3rd_img_impression + `
				` + _3rd_js_impression + `
				` + _3rd_iframe_impression + `

				` + _3rd_img_viewableImpression + `
				` + _3rd_js_viewableImpression + `
				` + _3rd_iframe_viewableImpression + `

				` + _3rd_img_click + `
				` + _3rd_js_click + `
				` + _3rd_iframe_click + `

				` + _3rd_img_start + `
				` + _3rd_js_start + `
				` + _3rd_iframe_start + `

				` + _3rd_img_complete + `
				` + _3rd_js_complete + `
				` + _3rd_iframe_complete + `

				` + _3rd_img_close + `
				` + _3rd_js_close + `
				` + _3rd_iframe_close + `
			}
		  }
	  };
	  function requestVASTXML(callback) {
		setTimeout(function(){
		callback(null, "` + RTBvideosrc + `");
		}, 0);
	 }
}


	 
	  
	  player` + rand + ` = adMaru.load(adsParams` + rand + `);
	  player` + rand + `.on('click', function(event) {

		if(event.target.className == 'vast-blocker')
		{
			var ClickD = "` + clickTrack + `";
			var xhr = new XMLHttpRequest();
			xhr.open('GET', ClickD, true);
			xhr.send();
		}			
	});
	
	player` + rand + `.on('vast.admShow', function () { console.log("Ad Start");
		var impressionImp = "` + impression + `";
		var xhr = new XMLHttpRequest();
		xhr.open('GET', impressionImp, true);
		xhr.send();
		var viewableimpression = "` + viewimpression + `";
		var ad_elem` + rand + ` = document.getElementById('` + admaruout.Viewable_Tagid + `');
		var ViewableImp = viewableimpression;	 
		var url = new URL(ViewableImp);  
		var percent = 75;
		oav` + rand + ` = new OpenAdViewability();
		oav` + rand + `.DEBUG_MODE = false;
		var j` + rand + ` = 0;
		oav` + rand + `.checkViewability(ad_elem` + rand + `, function(check) {
			if(check.percentViewable >=percent){
				if(j` + rand + `==0){	
					console.log("viewable imp3029");
					console.log(check.percentViewable);

					var xhttp = new XMLHttpRequest();
					xhttp.open( "GET", viewableimpression, true );
					xhttp.send();	            	
					j` + rand + `++;		
				}
			}
		});

		});
	

			

` + VideoRefresh + `

	function Prebidmaxset` + rand + `()
	{	
		var PrebidRes` + rand + `=pbjs.getHighestCpmBids('` + admaruout.Viewable_Tagid + `');
		var Prebid_cpm=PrebidRes` + rand + `!="" ? PrebidRes` + rand + `[0]['cpm'] : "";
			WonBid = Request_bids_` + rand + `[ PrebidRes` + rand + `[0]['requestId']] != "" ? Request_bids_` + rand + `[ PrebidRes` + rand + `[0]['requestId']] : "";
			if(WonBid.floorprice < Prebid_cpm ){
			pbjs.renderAd(document, PrebidRes` + rand + `[0].adId);
			if(WonBid!="" && WonBid!=null){ 
				var localstorage_keys=Object.keys(localStorage); var term="bid_"; 
				let b = localstorage_keys.filter(item => {if(item.toLowerCase().indexOf(term) > -1){ 
				localStorage.removeItem(item) }});
				var Adwon_URL=WonBid['Adwon_URL'] !="" ? WonBid['Adwon_URL'] :"";
				var AdImpression_URL=WonBid['AdImpression_URL'] !="" ? WonBid['AdImpression_URL']+'&won_price='+ PrebidRes` + rand + `[0]['cpm'] :"";
				let myPromise2 = new Promise(function(myResolve, myReject) {
					myResolve(Adwon_URL);
	});
				myPromise2.then(
				function(value) {GetApiCalling(value);}
				);
			}
		}else{
			Prioritycall();	
		}
	}

	function Prioritycall(){ 
	var Test_Div=document.getElementById('` + admaruout.Viewable_Tagid + `');
		if(Test_Div!="" && Test_Div!=null){
			Test_Div.innerHTML="";
		}	
		var m3_u = '` + config.GetConfig("commonpath", "file") + `AdAsync?tagid=` + Template_id + `&priority=` + helper.IntToString(admaruout.MultiAdformatPriority) + `&rand=` + rand + `&requestId=` + admaruout.Request_Id + `&loc='+escape(window.location)+'&adtype=PrebidPriority&priority_next=` + helper.IntToString(admaruout.Priority_Next) + `&Is_MultiAd=yes&tagidRand=` + admaruout.Viewable_Tagid + `';
		fetch(m3_u) 
		.then(response => {       
			return response.text(); 
		})
		.then(htmlContent => {
			var mainDIV` + rand + ` = document.getElementById('` + admaruout.Viewable_Tagid + `');
			var childDiv` + rand + ` = document.createElement("div");       
			childDiv` + rand + `.innerHTML = htmlContent;
			mainDIV` + rand + `.appendChild(childDiv` + rand + `);
	
			var mainscript` + rand + ` = mainDIV` + rand + `.getElementsByTagName("script");
			if(mainscript` + rand + `){
			for (var scriptTags` + rand + ` of mainscript` + rand + `) {
				var scriptContent` + rand + ` = scriptTags` + rand + `.textContent;
				eval(scriptContent` + rand + `);
				if (scriptTags` + rand + `.src) {
				var scriptElement` + rand + ` = document.createElement("script");
				scriptElement` + rand + `.src = scriptTags` + rand + `.src;
				document.head.appendChild(scriptElement` + rand + `);
				}
			}
			}
		})
		.catch(error => {
			console.error('Fetch error:', error);
		});
	}

	</script>` + MainDiv_End

	if admaruout.Adunit_type == "VideoVast" || admaruout.VastRetry_Enable == "yes" {
		VideoVast := VideoVast{}
		VideoVast.Template_Settings = template_settings
		VideoVast.Vast_URL = videoUrl
		VideoVast.Click_URL = clickTrack
		VideoVast.Impression_URL = impression
		VideoVast.ViewableImp_URL = _5sView
		VideoVast.Viewimpression = viewimpression
		VideoVast.Event_URL = track
		VideoVast.ThirdPartyTrackers = _3rd_img_firstQuartile + _3rd_js_firstQuartile + _3rd_iframe_firstQuartile + _3rd_img_midpoint + _3rd_js_midpoint + _3rd_iframe_midpoint + _3rd_img_thirdQuartile + _3rd_js_thirdQuartile + _3rd_iframe_thirdQuartile + _3rd_img_pause +
			_3rd_js_pause + _3rd_iframe_pause + _3rd_img_resume + _3rd_js_resume + _3rd_iframe_resume + _3rd_img_mute + _3rd_js_mute + _3rd_iframe_mute + _3rd_img_unmute + _3rd_js_unmute + _3rd_iframe_unmute + _3rd_img_skip + _3rd_js_skip + _3rd_iframe_skip + _3rd_img_impression +
			_3rd_js_impression + _3rd_iframe_impression + _3rd_img_viewableImpression + _3rd_js_viewableImpression + _3rd_iframe_viewableImpression + _3rd_img_click + _3rd_js_click + _3rd_iframe_click + _3rd_img_start + _3rd_js_start + _3rd_iframe_start + _3rd_img_complete +
			_3rd_js_complete + _3rd_iframe_complete + _3rd_img_close + _3rd_js_close + _3rd_iframe_close
		VideoVast.Deliveryadtype = Deliveryadtype
		VideoVast.Adtype = Adtype
		vastjson, err := json.Marshal(VideoVast)
		if err != nil {
			fmt.Println(err)
		}
		admaruout.Html = string(vastjson)
	} else {
		admaruout.Html = videohtmlres
	}

}
