package ad

import (
	"alpha/addelivery/fetching"
	"alpha/addelivery/helper"
	"alpha/addelivery/structure"
	config "alpha/configuration"
	"analytics/clickClient"
	"encoding/base64"
	"encoding/json"
	"fmt"
	"net/http"
	"strings"
	"time"
)

type ClickThrough struct {
	Bidder       string `json:"bidder"`
	ClickThrough string `json:"clickthrough"`
}

type Platform struct {
	Bidder        string `json:"bidder"`
	Platform_link string `json:"platform_link"`
}

func AdRender(adDetails structure.AdSourceDetails, admaruout *structure.AdmaruOutput) {
	admaruout.DeliveryAdType = "Direct"
	go WinStats_N(adDetails, admaruout)
	clickThrough := ClickThrough{}
	err := json.Unmarshal([]byte(adDetails.Src_Obj), &clickThrough)
	if err != nil {
		fmt.Println(err)
	}
	platformLink := Platform{}
	err = json.Unmarshal([]byte(adDetails.Src_Obj), &platformLink)
	if err != nil {
		fmt.Println(err)
	}

	ReqID := admaruout.R

	adsource_details := adDetails
	clickurl := ""
	clickTag_start := ""
	clickTag_end := ""
	ImgTag := ""
	clickurl = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Click?requestid=" + adDetails.Request_id + "&adsourceid=" + adDetails.Adsourceid + "&adunitid=" + admaruout.Adunit_details.Adunit_id + "&Providerid=" + admaruout.Provider_id + "&Publisherid=" + admaruout.Adunit_details.Publisher + "&url=" + clickThrough.ClickThrough + "&tagid=" + admaruout.Tag_Generation.Tag_id + "&tagtempid=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + adDetails.Provider_Src_id

	clickTag_start = `<a href='` + clickurl + `' target='_blank'>`
	clickTag_end = `</a>`

	impurl := config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Impression?req_id=" + adDetails.Request_id + "&adsource_id=" + adDetails.Adsourceid + "&adunit_id=" + admaruout.Adunit_details.Adunit_id + "&provider_id=" + admaruout.Provider_id + "&publisher_id=" + admaruout.Adunit_details.Publisher + "&tagid=" + admaruout.Tag_Generation.Tag_id + "&tagtempid=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + adDetails.Provider_Src_id + "&won_price=" + adDetails.Bidprice + "&res_cur=" + admaruout.Bidding_currency + "&owned_by=" + adDetails.Owned_by

	ViewableImp := config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Viewable_Imp?req_id=" + adDetails.Request_id + "&adsource_id=" + adDetails.Adsourceid + "&adunit_id=" + admaruout.Adunit_details.Adunit_id + "&provider_id=" + admaruout.Provider_id + "&publisher_id=" + admaruout.Adunit_details.Publisher + "&tag_id=" + admaruout.Tag_Generation.Tag_id + "&tagtemp_id=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + adDetails.Provider_Src_id + "&loc=" + ReqID.Header.Get("Referer")
	admaruout.Viewable_Imp = ViewableImp

	ImgTag = `<img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
	rand1 := helper.RandToken(5)
	if admaruout.Autorefreshrand != "" {
		rand1 = admaruout.Autorefreshrand
	} else {
		admaruout.Autorefreshrand = rand1
	}

	admaruout.ImpUrl = impurl

	/**********Third Party Tracker Start**********/
	var impression1 string
	var impression2 string
	var impression3 string

	var viewimpression1 string
	var viewimpression2 string
	var viewimpression3 string

	var clicks1 string
	var clicks2 string
	var clicks3 string

	adsoure := fetching.FetchAdsourceTracker(adDetails.Adsourceid)

	if len(adsoure.Data) > 0 {

		for _, v := range adsoure.Data {

			Event := v.Event
			if Event == "1" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					impimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					impimg = strings.Replace(impimg, `\`, ``, -1)

					impression1 += `<img src='` + impimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					impsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					impsrc2 = strings.Replace(impsrc2, `\`, ``, -1)
					impression2 += strings.Replace(impsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					impsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					impsrc3 = strings.Replace(impsrc3, `\`, ``, -1)
					impression3 += strings.Replace(impsrc3, "  ", " ", -1)
				}
			}

			if Event == "2" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					viewimpimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpimg = strings.Replace(viewimpimg, `\`, ``, -1)

					viewimpression1 += `<img src='` + viewimpimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					viewimpsrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpsrc2 = strings.Replace(viewimpsrc2, `\`, ``, -1)
					viewimpression2 += strings.Replace(viewimpsrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					viewimpsrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					viewimpsrc3 = strings.Replace(viewimpsrc3, `\`, ``, -1)
					viewimpression3 += strings.Replace(viewimpsrc3, "  ", " ", -1)
				}
			}

			if Event == "3" {

				Tracker_type := v.Tracker_type

				if Tracker_type == "1" {

					clicksimg := strings.Replace(v.Tracker_src, "\n", "", -1)
					clicksimg = strings.Replace(clicksimg, `\`, ``, -1)

					clicks1 += `<img src='` + clicksimg + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					clickssrc2 := strings.Replace(v.Tracker_src, "\n", "", -1)
					clickssrc2 = strings.Replace(clickssrc2, `\`, ``, -1)
					clicks2 += strings.Replace(clickssrc2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					clickssrc3 := strings.Replace(v.Tracker_src, "\n", "", -1)
					clickssrc3 = strings.Replace(clickssrc3, `\`, ``, -1)
					clicks3 += strings.Replace(clickssrc3, "  ", " ", -1)
				}
			}
		}
	}

	adunit := fetching.FetchAdunitTracker(admaruout.Adunit_details.Adunit_id)

	if len(adunit.Data) > 0 {

		for _, val := range adunit.Data {

			Event1 := val.Event

			if Event1 == "1" {

				Trackertype := val.Tracker_type

				if Trackertype == "1" {

					impimgu := strings.Replace(val.Tracker_src, "\n", "", -1)
					impimgu = strings.Replace(impimgu, `\`, ``, -1)

					impression1 += `<img src='` + impimgu + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Trackertype == "2" {

					impsrcu := strings.Replace(val.Tracker_src, "\n", "", -1)
					impsrcu = strings.Replace(impsrcu, `\`, ``, -1)
					impression2 += strings.Replace(impsrcu, "  ", " ", -1)

				} else if Trackertype == "3" {

					impsrcf := strings.Replace(val.Tracker_src, "\n", "", -1)
					impsrcf = strings.Replace(impsrcf, `\`, ``, -1)
					impression3 += strings.Replace(impsrcf, "  ", " ", -1)
				}
			}

			if Event1 == "2" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					viewimpimgi := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpimgi = strings.Replace(viewimpimgi, `\`, ``, -1)

					viewimpression1 += `<img src='` + viewimpimgi + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					viewimpsrc2i := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpsrc2i = strings.Replace(viewimpsrc2i, `\`, ``, -1)
					viewimpression2 += strings.Replace(viewimpsrc2i, "  ", " ", -1)

				} else if Tracker_type == "3" {

					viewimpsrc3i := strings.Replace(val.Tracker_src, "\n", "", -1)
					viewimpsrc3i = strings.Replace(viewimpsrc3i, `\`, ``, -1)
					viewimpression3 += strings.Replace(viewimpsrc3i, "  ", " ", -1)
				}
			}

			if Event1 == "3" {

				Tracker_type := val.Tracker_type

				if Tracker_type == "1" {

					clicksimg1 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clicksimg1 = strings.Replace(clicksimg1, `\`, ``, -1)

					clicks1 += `<img src='` + clicksimg1 + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
				} else if Tracker_type == "2" {

					clickssrcu2 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clickssrcu2 = strings.Replace(clickssrcu2, `\`, ``, -1)
					clicks2 += strings.Replace(clickssrcu2, "  ", " ", -1)

				} else if Tracker_type == "3" {

					clickssrcu3 := strings.Replace(val.Tracker_src, "\n", "", -1)
					clickssrcu3 = strings.Replace(clickssrcu3, `\`, ``, -1)
					clicks3 += strings.Replace(clickssrcu3, "  ", " ", -1)
				}
			}
		}
	}

	var viewbleStart string
	var viewbleEnd string
	var viewbleDiv string

	var innerHTML string

	if viewimpression1 != "" || viewimpression2 != "" || viewimpression3 != "" {

		if viewimpression2 != "" {
			viewimpression2 = strings.Replace(viewimpression2, "\n", "", -1)
			viewimpression2 = strings.Replace(viewimpression2, `</script>`, `<\/script>`, -1)
		}
		if viewimpression3 != "" {
			viewimpression3 = strings.Replace(viewimpression3, `</script>`, `<\/script>`, -1)
			viewimpression3 = strings.Replace(viewimpression3, "\n", "", -1)
		}

		viewbleDiv = `<div id='viewble_` + rand1 + `'></div>`

		innerHTML = `var mainDIVview` + rand1 + ` = document.getElementById('viewble_` + rand1 + `');
		var childDivview` + rand1 + ` = document.createElement("div");       
		childDivview` + rand1 + `.innerHTML = "` + viewimpression1 + viewimpression2 + viewimpression3 + `";
		mainDIVview` + rand1 + `.appendChild(childDivview` + rand1 + `);

		var mainscriptview` + rand1 + ` = mainDIVview` + rand1 + `.getElementsByTagName("script");
		for (var scriptTagsview` + rand1 + ` of mainscriptview` + rand1 + `) {
		  var scriptContentview` + rand1 + ` = scriptTagsview` + rand1 + `.textContent;
		  eval(scriptContentview` + rand1 + `);
		  if (scriptTagsview` + rand1 + `.src) {
			var scriptElementview` + rand1 + ` = document.createElement("script");
			scriptElementview` + rand1 + `.src = scriptTagsview` + rand1 + `.src;
			document.head.appendChild(scriptElementview` + rand1 + `);
		  }
		}`

		admaruout.Viewable_Html = innerHTML
	}
	var viewbleJS string
	Height := admaruout.Banner_Template.Height
	var percent string
	if Height < 1000 {
		percent = "75"
	} else {
		percent = "30"
	}
	if admaruout.Autorefresh != "yes" && admaruout.MultiadPrebidCal != "yes" && admaruout.Adunit_type != "PrebidPriority" {
		viewbleStart = `<div id='test-ad` + rand1 + `'> <div id='viewImp_` + rand1 + `'>`
		viewbleEnd = `</div> </div>`
	} else if admaruout.Autorefresh == "yes" {
		viewbleStart = `<div id='test-ad` + rand1 + `'>`
		viewbleEnd = `</div>`
	}
	viewbleJS = `
	<script type='text/javascript' src='https://dn2m2ku6gzfcq.cloudfront.net/static/viewability.js'></script>
	<script type='text/javascript'>var ad_elem` + rand1 + ` = document.getElementById('test-ad` + rand1 + `');
	var ViewableImp = '` + ViewableImp + `';
	localStorage.setItem('reqIDAuto` + rand1 + `',"` + adDetails.Request_id + `");
	var url = new URL(ViewableImp);
	var time 	= 1 * 1000;
	var percent = ` + percent + `;
	oav` + rand1 + ` = new OpenAdViewability();
	oav` + rand1 + `.DEBUG_MODE = true;
		var j` + rand1 + ` = 0;	 
	oav` + rand1 + `.checkViewability(ad_elem` + rand1 + `, function(check) {
	if(check.percentViewable >=percent){		
	if(j` + rand1 + `==0 && url.searchParams.get("req_id")==localStorage.getItem('reqIDAuto` + rand1 + `' )){	
		` + admaruout.Viewable_Html + `
		var xhttp = new XMLHttpRequest();
		xhttp.open('GET', ViewableImp, true);		
		xhttp.send();
		localStorage.removeItem('reqIDAuto` + rand1 + `' );
		j` + rand1 + `++;		
	}
	}
	});			 
	</script>`
	var JSscript string
	var Clickdiv string
	var divStart string
	var divEnd string
	var innerHTMLClk string
	var JSscriptHTML string
	var ClicktrackJSimg string

	if clicks1 != "" || clicks2 != "" || clicks3 != "" {

		if clicks2 != "" {
			clicks2 = strings.Replace(clicks2, "\n", "", -1)
			clicks2 = strings.Replace(clicks2, `</script>`, `<\/script>`, -1)
		}
		if clicks3 != "" {
			clicks3 = strings.Replace(clicks3, `</script>`, `<\/script>`, -1)
			clicks3 = strings.Replace(clicks3, "\n", "", -1)
		}

		clickTag_start = `<a id='checkclimg_` + rand1 + `'  href='` + clickurl + `' target='_blank' >`
		clickTag_end = `</a>`
		innerHTMLClk = `var mainDIVclick` + rand1 + ` = document.getElementById('track_` + rand1 + `');
		var childDivclick` + rand1 + ` = document.createElement("div");       
		childDivclick` + rand1 + `.innerHTML = "` + clicks1 + clicks2 + clicks3 + `";
		mainDIVclick` + rand1 + `.appendChild(childDivclick` + rand1 + `);
		var mainscriptclick` + rand1 + ` = mainDIVclick` + rand1 + `.getElementsByTagName("script");
		for (var scriptTagsclick` + rand1 + ` of mainscriptclick` + rand1 + `) {
		  var scriptContentclick` + rand1 + ` = scriptTagsclick` + rand1 + `.textContent;
		  eval(scriptContentclick` + rand1 + `);
		  if (scriptTagsclick` + rand1 + `.src) {
			var scriptElementclick` + rand1 + ` = document.createElement("script");
			scriptElementclick` + rand1 + `.src = scriptTagsclick` + rand1 + `.src;
			document.head.appendChild(scriptElementclick` + rand1 + `);
		  }
		}`

		JSscript = `<script type='text/javascript'>
		function check_` + rand1 + `()
		{			
		      var mainDIVclick` + rand1 + ` = document.getElementById('track_` + rand1 + `');
			var childDivclick` + rand1 + ` = document.createElement("div");       
			childDivclick` + rand1 + `.innerHTML = "` + clicks1 + clicks2 + clicks3 + `";
			mainDIVclick` + rand1 + `.appendChild(childDivclick` + rand1 + `);
			var mainscriptclick` + rand1 + ` = mainDIVclick` + rand1 + `.getElementsByTagName("script");
			for (var scriptTagsclick` + rand1 + ` of mainscriptclick` + rand1 + `) {
			var scriptContentclick` + rand1 + ` = scriptTagsclick` + rand1 + `.textContent;
			eval(scriptContentclick` + rand1 + `);
			if (scriptTagsclick` + rand1 + `.src) {
				var scriptElementclick` + rand1 + ` = document.createElement("script");
				scriptElementclick` + rand1 + `.src = scriptTagsclick` + rand1 + `.src;
				document.head.appendChild(scriptElementclick` + rand1 + `);
			}
			}
		}
		</script>`

		JSscriptHTML = `<script type='text/javascript'>
		function checkHTML_` + rand1 + `()
		{			
			document.getElementById("track_` + rand1 + `").innerHTML = "` + clicks1 + clicks2 + clicks3 + `";

		}
		</script>`
		ClicktrackJSimg = `<script type='text/javascript'>
				document.getElementById('checkclimg_` + rand1 + `').onclick = function fun() {
				check_` + rand1 + `();
			}
		
			</script>`

		Clickdiv = `<div id='track_` + rand1 + `'></div>`

		divStart = `<div id='ad_` + rand1 + `' style='width:` + helper.IntToString(admaruout.Banner_Template.Width) + `px;height:` + helper.IntToString(admaruout.Banner_Template.Height) + `px;'>`
		divEnd = `</div>`
	}

	/**********Third Party Tracker End**********/

	ClickD := config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/Click?requestid=" + adDetails.Request_id + "&adsourceid=" + adDetails.Adsourceid + "&adunitid=" + admaruout.Adunit_details.Adunit_id + "&Providerid=" + admaruout.Provider_id + "&Publisherid=" + admaruout.Adunit_details.Publisher + "&url=&tagid=" + admaruout.Tag_Generation.Tag_id + "&tagtempid=" + admaruout.Tag_Generation.Template_id + "&pro_src_id=" + adDetails.Provider_Src_id + "&loc=" + ReqID.Header.Get("Referer")

	admaruout.ClickUrl = clickurl

	JSscriptclk := `<script type='text/javascript'>
			function checkclk_` + rand1 + `()
			{	
				` + innerHTMLClk + `
			    var ClickD = "` + ClickD + `";

				var xhr = new XMLHttpRequest();
		        xhr.open('GET', ClickD, true);
		        xhr.send();
			}
			</script>`
	ClicktrackJS := `<script type='text/javascript'>
	
			document.getElementById('checkclktr_` + rand1 + `').onclick = function fun() {
			checkclk_` + rand1 + `();
			}
		
			</script>`

	switch {
	case adDetails.Adtype == "B_IMG":

		admaruout.Html = viewbleStart + JSscript + clickTag_start + `<img src='` + config.GetConfig("protocol", "webpath") + config.GetConfig("images", "webpath") + `/` + adsource_details.FileName + `' width='` + helper.IntToString(admaruout.Banner_Template.Width) + `' height='` + helper.IntToString(admaruout.Banner_Template.Height) + `' alt='' title='' border='0' />` + clickTag_end + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'>` + ImgTag + `</div>` + Clickdiv + viewbleDiv + impression1 + impression2 + impression3 + viewbleEnd + ClicktrackJSimg + viewbleJS

	case adDetails.Adtype == "B_HTML":

		htmlClk := `<script type='text/javascript'>
			window.addEventListener("blur", () => {
			  setTimeout(() => {
					if (document.activeElement.id === "rv-h5-` + rand1 + `" || document.activeElement.id === "banner` + rand1 + `") {
			    	` + innerHTMLClk + `
			    	var ClickD = "` + ClickD + `";
			    	var xmlHttp = new XMLHttpRequest();
					xmlHttp.open("GET", ClickD, true ); 
					xmlHttp.send();
					window.focus();
			    }
			  });
			});
			
			</script>`

		admaruout.Html = viewbleStart + JSscriptHTML + divStart + `<iframe onclick='return checkHTML_` + rand1 + `()' id='rv-h5-` + rand1 + `' name='rv-h5-` + rand1 + `' src='` + config.GetConfig("protocol", "webpath") + config.GetConfig("image", "webpath") + "/" + adsource_details.FileName + `?clickTag=` + clickThrough.ClickThrough + `' marginwidth='0' marginheight='0' scrolling='no'  frameborder='0' width='` + helper.IntToString(admaruout.Banner_Template.Width) + `' height='` + helper.IntToString(admaruout.Banner_Template.Height) + `' style='width: ` + helper.IntToString(admaruout.Banner_Template.Width) + `px; height: ` + helper.IntToString(admaruout.Banner_Template.Height) + `px; border: 0'></iframe>` + divEnd + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'>` + ImgTag + `</div>` + Clickdiv + viewbleDiv + impression1 + impression2 + impression3 + viewbleEnd + viewbleJS + htmlClk

	case adDetails.Adtype == "B_TAG":

		admaruout.FinalAdsourceType = "ThirdPartyTag"
		Thirdpartytag := strings.Replace(adsource_details.Thirdpartytag, `<!--//<![CDATA[`, ``, -1)
		ThirdpartytagF := strings.Replace(Thirdpartytag, `//]]>-->`, ``, -1)

		admaruout.Html = viewbleStart + JSscriptclk + `<div id='checkclktr_` + rand1 + `' style='cursor: pointer;width: ` + helper.IntToString(admaruout.Banner_Template.Width) + `px; height: ` + helper.IntToString(admaruout.Banner_Template.Height) + `px;'>` + ThirdpartytagF + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'>` + ImgTag + `</div></div>` + Clickdiv + viewbleDiv + impression1 + impression2 + impression3 + viewbleEnd + ClicktrackJS + viewbleJS

	case adDetails.Adtype == "B_LINK":
		admaruout.Html = viewbleStart + JSscriptclk + `<div id='checkclktr_` + rand1 + `' style='cursor: pointer;width: ` + helper.IntToString(admaruout.Banner_Template.Width) + `px; height: ` + helper.IntToString(admaruout.Banner_Template.Height) + `px;'><img src='` + platformLink.Platform_link + `' width='` + helper.IntToString(admaruout.Banner_Template.Width) + `' height='` + helper.IntToString(admaruout.Banner_Template.Height) + `' alt='' title='' border='0' /></div> <div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'>` + ImgTag + `</div>` + Clickdiv + viewbleDiv + impression1 + impression2 + impression3 + viewbleEnd + ClicktrackJS + viewbleJS

	}

	if admaruout.Adunit_type == "Adapter" {
		s := strings.Replace(admaruout.Html, `"`, `\"`, -1)
		admaruout.AdapterFinalAdsource = adsource_details
		admaruout.AdapterHTML = s
		admaruout.AdapterPrice = adsource_details.Bidprice
	}

	/**********Client Multiad auction winning response**************/
	if admaruout.MultiadWinAdType == 2 && admaruout.MultiAdFormat && admaruout.Adunit_type != "Adapter" {
		res, _ := json.Marshal(admaruout.MultiAdFinalDir)
		admaruout.Html = admaruout.Html + `<script type='text/javascript'> var res = '` + string(res) + `';console.log("Winning Ad Type : Direct Ad"); console.log("Winning Response :"+JSON.stringify(res));</script>`
	}
	/**********Client Multiad auction winning response**************/
	admaruout.Internal_ad = true
}

func GenerateAdapterHTML(admaruout *structure.AdmaruOutput, adsource_details structure.AdSourceDetails, html, price string) {

	test := `{"id":"` + adsource_details.Request_id + `","bidderCode":"admaru","bidder":"admaru","seatbid":[{"bid":[{"id":"` + adsource_details.Request_id + `","w":` + helper.IntToString(admaruout.Banner_Template.Width) + `,"h":` + helper.IntToString(admaruout.Banner_Template.Height) + `,"price":` + price + `,"adm":"` + html + `","adid":"` + adsource_details.Adsourceid + `","impid":"` + helper.IntToString(helper.RandNumber(14)) + `","crid":"` + adsource_details.Adsourceid + `"}],"seat":"1"}],"cur":"` + admaruout.Bidding_currency + `"}`

	admaruout.Html = test
}

func GeneratePribidDeliveryResponse(admaruout *structure.AdmaruOutput, tag string) {
	res := `{"addelivery_tag":"yes","tag":"` + base64.StdEncoding.EncodeToString([]byte(tag)) + `"}`
	admaruout.Html = res
}

func MultiadPrebidResponse(admaruout *structure.AdmaruOutput, tag string) {

	/**********Client Prebid Call Multiad auction winning response**************/
	var banner string
	var adtype string
	var res string
	if admaruout.MultiadWinAdType == 1 && admaruout.MultiAdFormat {
		ress, _ := json.Marshal(admaruout.MultiAdFinalRTB)
		if admaruout.MultiAdFinalRTB.Ads.Adtype == 2 {
			banner = string(ress)
			adtype = "RTB Video"
		}
		res = `{"multiAd_Tag":"Yes","tag":"` + base64.StdEncoding.EncodeToString([]byte(tag)) + `","winningadtype" : "` + adtype + `" ,"winningresponse" :` + banner + `}`
	} else if admaruout.MultiadWinAdType == 2 && admaruout.MultiAdFormat {
		ress, _ := json.Marshal(admaruout.MultiAdFinalDir)
		banner = string(ress)
		adtype = "Direct Ad"
		res = `{"multiAd_Tag":"Yes","tag":"` + base64.StdEncoding.EncodeToString([]byte(tag)) + `","winningadtype" : "` + adtype + `" ,"winningresponse" :` + banner + `}`
	} else {
		res = `{"multiAd_Tag":"Yes","tag":"` + base64.StdEncoding.EncodeToString([]byte(tag)) + `"}`
	}
	/**********Client Prebid Call Multiad auction winning response**************/

	admaruout.Html = res
}

func WinStats(finalads structure.AdSourceDetails, admaruoutput *structure.AdmaruOutput) {
	tag_id := admaruoutput.Tag_Generation.Tag_id
	tag_temp_id := admaruoutput.Tag_Generation.Template_id
	request, err := http.NewRequest("GET", config.GetConfig("protocol", "webpath")+config.GetConfig("delivery", "webpath")+"/Ad_Win?req_id="+finalads.Request_id+"&publisher_id="+admaruoutput.Adunit_details.Publisher+"&adunit_id="+admaruoutput.Adunit_details.Adunit_id+"&provider_id="+finalads.Provider+"&adsource_id="+finalads.Adsourceid+"&tagid="+tag_id+"&tagtempid="+tag_temp_id+"&pro_src_id="+finalads.Provider_Src_id+"&won_count=1", nil)
	if err != nil {
		fmt.Println(err)
	}
	client := &http.Client{Timeout: time.Duration(0) * time.Millisecond}
	resp, err := client.Do(request)
	if err != nil {
		fmt.Println(err)
	}

	defer resp.Body.Close()
}

func WinStats_N(finalads structure.AdSourceDetails, admaruoutput *structure.AdmaruOutput) {

	clickClient.Track_win(admaruoutput.Adunit_details.Publisher, admaruoutput.Adunit_details.Adunit_id, finalads.Provider, finalads.Adsourceid, finalads.Request_id, admaruoutput.Tag_Generation.Tag_id, admaruoutput.Tag_Generation.Template_id, finalads.Provider_Src_id, 1)
}
